/*-
# X-BASED DINOSAUR CUBE
#
#  DinoU.c
#
###
#
#  Copyright (c) 1995 - 2006	David A. Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Undo algorithm */

#include "DinoP.h"

static DinoCornerLoc startLoc[MAX_FACES][MAX_ORIENT];

static void
newStack(DinoStack *s)
{
	if (s->lastMove != NULL || s->firstMove != NULL)
		return;
	if (!(s->lastMove = (MoveStack *) malloc(sizeof (MoveStack)))) {
		DISPLAY_ERROR("Not enough memory, exiting.");
	}
	if (!(s->firstMove = (MoveStack *) malloc(sizeof (MoveStack)))) {
		DISPLAY_ERROR("Not enough memory, exiting.");
	}
	s->firstMove->previous = s->lastMove->next = NULL;
	s->firstMove->next = s->lastMove;
	s->lastMove->previous = s->firstMove;
	s->count = 0;
}

static void
pushStack(DinoStack *s, MoveRecord **move)
{
	if (!(s->currMove = (MoveStack *) malloc(sizeof (MoveStack)))) {
		DISPLAY_ERROR("Not enough memory, exiting.");
	}
	s->lastMove->previous->next = s->currMove;
	s->currMove->previous = s->lastMove->previous;
	s->currMove->next = s->lastMove;
	s->lastMove->previous = s->currMove;
	*move = &(s->currMove->move);
	s->count++;
}

static void
popStack(DinoStack *s)
{
	s->currMove = s->lastMove->previous;
	s->lastMove->previous->previous->next = s->lastMove;
	s->lastMove->previous = s->lastMove->previous->previous;
	free(s->currMove);
	s->count--;
}

static MoveRecord *
topStack(DinoStack *s)
{
	return &(s->lastMove->previous->move);
}

static int
emptyStack(DinoStack *s)
{
	return (s->lastMove->previous == s->firstMove);
}

static void
flushStack(DinoStack *s)
{
	while (s->lastMove->previous != s->firstMove) {
		s->currMove = s->lastMove->previous;
		s->lastMove->previous->previous->next = s->lastMove;
		s->lastMove->previous = s->lastMove->previous->previous;
		free(s->currMove);
	}
	s->count = 0;
}

static void
deleteStack(DinoStack *s)
{
	flushStack(s);
	if (s->firstMove) {
		free(s->firstMove);
		s->firstMove = NULL;
	}
	if (s->lastMove) {
		free(s->lastMove);
		s->lastMove = NULL;
	}
}

/**********************************/

void
newMoves(DinoStack *s)
{
	newStack(s);
}

void
deleteMoves(DinoStack *s)
{
	deleteStack(s);
}

static void
writeMove(MoveRecord *move, int face, int position, int direction,
		int style, int control)
{
#if 0
	move->face = face;
	move->position = position;
	move->direction = direction;
	move->style = style;
	move->control = control;
#endif
	move->packed = ((control & 0xF) << 16) + ((style & 0xF) << 12) +
		((direction & 0xF) << 8) + ((position & 0xF) << 4) +
		(face & 0xF);
}

static void
readMove(MoveRecord *move, int *face, int *position, int *direction,
		int *style, int *control)
{
#if 0
	*face = move->face;
	*position = move->position;
	*direction = move->direction;
	*style = move->style;
	*control = move->control;
#endif
	*face = (int) (move->packed & 0xF);
	*position = (int) ((move->packed >> 4) & 0xF);
	*direction = (int) ((move->packed >> 8) & 0xF);
	*style = (int) ((move->packed >> 12) & 0xF);
	*control = (int) ((move->packed >> 16) & 0xF);
}

void
setMove(DinoStack *s, int face, int position, int direction,
		int style, int control)
{
	MoveRecord *move;

	pushStack(s, &move);
	writeMove(move, face, position, direction, style, control);
}

void
getMove(DinoStack *s, int *face, int *position, int *direction,
		int *style, int *control)
{
	readMove(topStack(s), face, position, direction, style, control);
	popStack(s);
}

int
madeMoves(DinoStack *s)
{
	return !emptyStack(s);
}

void
flushMoves(DinoWidget w, DinoStack *s, Boolean undo)
{
	int face, position;

	flushStack(s);
	if (undo) {
		for (face = 0; face < MAX_FACES; face++)
			for (position = 0; position < MAX_ORIENT; position++) {
				startLoc[face][position].face =
					w->dino.cubeLoc[face][position].face;
				startLoc[face][position].rotation =
					w->dino.cubeLoc[face][position].rotation;
			}
	}
}

int
numMoves(DinoStack *s)
{
	return s->count;
}

void
scanMoves(FILE *fp, DinoWidget w, int moves)
{
	int face, position, direction, style, control, k, c;

	for (k = 0; k < moves; k++) {
		while ((c = getc(fp)) != EOF && c != SYMBOL);
		(void) fscanf(fp, "%d %d %d %d %d",
			&face, &position, &direction, &style, &control);
		MovePuzzle(w, face, position, direction, style, control);
	}
}

void
printMoves(FILE *fp, DinoStack *s)
{
	int face, position, direction, style, control, counter = 0;

	s->currMove = s->firstMove->next;
	(void) fprintf(fp, "moves\tface\tpos\tdir\tstyle\tcon\n");
	while (s->currMove != s->lastMove) {
		readMove(&(s->currMove->move),
			&face, &position, &direction, &style, &control);
		(void) fprintf(fp, "%d%c\t%d\t%d\t%d\t%d\t%d\n",
		++counter, SYMBOL, face, position, direction, style, control);
		s->currMove = s->currMove->next;
	}
}

void
scanStartPosition(FILE *fp, DinoWidget w)
{
	int face, position, num, c;

	while ((c = getc(fp)) != EOF && c != SYMBOL);
	for (face = 0; face < MAX_FACES; face++)
		for (position = 0; position < MAX_ORIENT; position++) {
			(void) fscanf(fp, "%d ", &num);
			startLoc[face][position].face = num;
			if (w->dino.orient) {
				(void) fscanf(fp, "%d ", &num);
				startLoc[face][position].rotation = num;
			}
		}
}

void
printStartPosition(FILE *fp, DinoWidget w)
{
	int face, position;

	(void) fprintf(fp, "\nstartingPosition%c\n", SYMBOL);
	for (face = 0; face < MAX_FACES; face++) {
		for (position = 0; position < MAX_ORIENT; position++) {
			(void) fprintf(fp, "%d ", startLoc[face][position].face);
			if (w->dino.orient)
				(void) fprintf(fp, "%d  ",
					startLoc[face][position].rotation);
		}
		(void) fprintf(fp, "\n");
	}
}

void
setStartPosition(DinoWidget w)
{
	int face, position;

	for (face = 0; face < MAX_FACES; face++)
		for (position = 0; position < MAX_ORIENT; position++) {
			w->dino.cubeLoc[face][position].face =
				startLoc[face][position].face;
			if (w->dino.orient)
				w->dino.cubeLoc[face][position].rotation =
					startLoc[face][position].rotation;
		}
	DrawAllPieces(w);
}
