.\" X-BASED TRIANGLES
.\"
.\" xtriangles.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 2006	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH XTRIANGLES 6 "01 Apr 2006" "V7.2"
.SH NAME
xtriangles \- Triangles X widget
.SH SYNOPSIS
.B /usr/games/xtriangles
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-tile {color}] [-{border|bd} {color}] [-delay msecs]
[-[no]sound] [-bumpSound {filename}]
[-{font|fn} {fontname}] [-size {int}] [-base {int}]
[-userName {string}] [-scoreFile {filename}] [-scores]
[-version]
.SH DESCRIPTION
A sliding tile puzzle.  A triangular version of the 15 puzzle which was
originally made around 1879 (the 14-15 puzzle of Sam Loyd was made soon
after).   T. R. Dawson in Original Puzzles has a similar puzzle with 4
diamond- and 6 triangular-shaped pieces.  This puzzle is easier to solve
than 15 puzzle.
.SH FEATURES
Click "\fBmouse-left\fP" button to move a tile.  Clicks on spaces, or
clicks on tiles that are not in line with two spaces, will not move
tiles.  Notice, one can move more than one tile at a time by clicking on
the tile farthest from the spaces but still in line with the spaces.
.LP
Click "\fBmouse-right\fP" button, or press "\fBR\fP" or "\fBr\fP" keys,
to randomize the puzzle.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to increase the number of tiles.
.LP
Press "\fBD\fP" or "\fBd\fP" keys to decrease the number of tiles.
.LP
"\fBS\fP" or "\fBs\fP" keys reserved for the auto-solver (not implemented).
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo a move.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to write or save a puzzle.
.LP
Press "\fBC\fP" or "\fBc\fP" keys to clear a puzzle.
.LP
Press "\fB>\fP" or "\fB.\fP" keys to speed up the movement of tiles.
.LP
Press "\fB<\fP" or "\fB,\fP" keys to slow down the movement of tiles.
.LP
Press "\fB@\fP" key to toggle the sound.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad or arrow keys to move without the mouse.
.br
Key pad is defined for Triangles as:
.br
7   9   Upper Left, Upper Right
.br
  ^
.br
4< >6   Left, Right
.br
  v
.br
1   3   Lower Left, Lower Right
.LP
The title is in the following format (non-motif version):
.RS
xtriangles: <size> @ (<Number of moves>/{<Record number of moves>
<user name>|"NEVER noaccess"}) - <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the triangles window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to display the triangles window on a color screen
as if it were monochrome (resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the triangles window in reverse video
(resource name "\fIreverse\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the triangles window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the triangles window (resource name
"\fIbackground\fP").
.TP 8
.B \-tile \fIcolor\fP
This option specifies the tile color of the triangles window (resource name
"\fItileColor\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the tiles in the triangles
window (resource name "\fIborderColor\fP").
.TP 8
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move a tile or
a group of tiles one space (1-50) (resource name "\fIdelay\fP").
.TP 8
.B \-[no]sound
This option specifies if a sliding tile should make a sound or not
(resource name "\fIsound\fP").
.TP 8
.B \-bumpSound \fIfilename\fP
This option specifies the file for the bump sound (resource name
"\fIbumpSound\fP").
.TP 8
.B \-{font|fn} \ffontname\fP
This option specifies the font that will be used (resource name
"\fIfont\fP").
.TP 8
.B \-size <\fIint\fP>
This option allows you to change the number of triangles in a row (resource
name "\fIsizeA\fP").
.TP 8
.B \-base \fIint\fP
This option specifies the base used (default is base 10) (resource name
"\fIbase\fP").
.TP 8
.B \-userName \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.TP 8
.B \-scoreFile \fIfilename\fP
Specify an alternative score file (resource name "\fIscoreFile\fP").
.TP 8
.B \-scores
This option lists all the recorded scores and then exits.
.TP 8
.B \-version
This option tells you what version of xtriangles you have.
.SH RECORDS
You must randomize the puzzle before a record is set, otherwise an
assumption of cheating is made if it is solved after a get.
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp
.RS
size: 1-16 <number of tiles in a row of the same orientation as the puzzle>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <array of tile positions where 0 is the empty space for
the UP triangle and -1 is the empty space for the DOWN triangle>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <direction>
.RE
Direction is represented as 0 upper right, 1 right, 2 lower right,
3 lower left, 4 left, and 5 upper left.
.SH REFERENCES
L. E. Horden, Sliding Piece Puzzles (Recreations in Mathematics Series),
Oxford University Press 1986, pp 1, 148, 149.
.sp
Jerry Slocum & Jack Botermans, Puzzles Old & New (How to Make and Solve
Them), University of Washington Press, Seattle, 1987, pp 126, 127.
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xdino(6), xpyraminx(6), xoct(6), xmball(6),
xmlink(6), xpanex(6), xcubes(6), xhexagons(6), xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-2006, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/tux/bagleyd/xpuzzles\fP
.br
\fIftp://ibiblio.org/pub/Linux/games/strategy\fP
