/*-
# X-BASED MASTERBALL(tm)
#
#  Mball.h
#
###
#
#  Copyright (c) 1994 - 2006	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Mball */

#ifndef _XtMball_h
#define _XtMball_h

/***********************************************************************
 *
 * Mball Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNframeColor ((char *) "frameColor")
#define XtNwedgeColor0 ((char *) "wedgeColor0")
#define XtNwedgeColor1 ((char *) "wedgeColor1")
#define XtNwedgeColor2 ((char *) "wedgeColor2")
#define XtNwedgeColor3 ((char *) "wedgeColor3")
#define XtNwedgeColor4 ((char *) "wedgeColor4")
#define XtNwedgeColor5 ((char *) "wedgeColor5")
#define XtNwedgeColor6 ((char *) "wedgeColor6")
#define XtNwedgeColor7 ((char *) "wedgeColor7")
#define XtNwedgeColor8 ((char *) "wedgeColor8")
#define XtNwedgeColor9 ((char *) "wedgeColor9")
#define XtNwedgeColor10 ((char *) "wedgeColor10")
#define XtNwedgeColor11 ((char *) "wedgeColor11")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNwedges ((char *) "wedges")
#define XtNrings ((char *) "rings")
#define XtNorient ((char *) "orient")
#define XtNpractice ((char *) "practice")
#define XtNbase ((char *) "base")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCWedges ((char *) "Wedges")
#define XtCRings ((char *) "Rings")
#define XtCOrient ((char *) "Orient")
#define XtCPractice ((char *) "Practice")
#define XtCBase ((char *) "Base")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")

typedef struct _MballClassRec *MballWidgetClass;

extern WidgetClass mballWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} mballCallbackStruct;
#endif

#define MBALL_HIDE (-8)
#define MBALL_PRACTICE_QUERY (-7)
#define MBALL_RANDOMIZE_QUERY (-6)
#define MBALL_SOLVE_MESSAGE (-5)
#define MBALL_RESTORE (-4)
#define MBALL_RESET (-3)
#define MBALL_AMBIGUOUS (-2)
#define MBALL_ILLEGAL (-1)
#define MBALL_MOVED 0
#define MBALL_CONTROL 1
#define MBALL_SOLVED 2
#define MBALL_PRACTICE 3
#define MBALL_RANDOMIZE 4
#define MBALL_DEC 5
#define MBALL_ORIENT 6
#define MBALL_INC 7
#define MBALL_WEDGE2 8
#define MBALL_WEDGE4 9
#define MBALL_WEDGE6 10
#define MBALL_WEDGE8 11
#define MBALL_WEDGE10 12
#define MBALL_WEDGE12 13
#define MBALL_COMPUTED 14
#define MBALL_UNDO 15

#define MINWEDGES 2
#define MAXWEDGES 12
#define MINRINGS 1
#define DEFAULTWEDGES 8
#define DEFAULTRINGS 4
#define DEFAULTORIENT FALSE
#define DEFAULTPRACTICE FALSE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define MINBASE 2 /* Base 1 is rediculous :) */
#define MAXBASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULTBASE 16 /* works good for 12 wedges */

typedef struct _MballRec *MballWidget;

#endif /* _XtMball_h */
/* DON'T ADD STUFF AFTER THIS #endif */
