/* $Id: target.h,v 1.6 2003/07/02 07:54:28 mederchik Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef TARGET_H
#define TARGET_H

#include "xprobe.h"
#include <map>
#include <algorithm>
#include <vector>

using namespace std;

extern int h_errno;

class Target_Net {
    private:
        unsigned long addr, mask, counter;
        char *ascii_name;
        int parse_mask(char *mask);
        int parse_host(char *host);
        int resolve_host(char *host);
    public:
        int init(char *target);
        unsigned long getnext(void);
        void reset(void) { counter = addr; };
        Target_Net(void);
        Target_Net(char *target);
        ~Target_Net() { free(ascii_name); };
};


#define XPROBE_TTL_TCP_SYNACK   1
#define XPROBE_TTL_TCP_RST      2
#define XPROBE_TTL_ICMP_ECHO    3
#define XPROBE_TTL_ICMP_PUNR    4

class Port_Range {
	private:
		u_int low, high, curr;
	public:
		void set_range(u_short, u_short);
		int get_next(u_short *);
        unsigned int size() { return (high - low + 1); }
		void reset();
};

class Target {
    private:
        struct in_addr addr;
        map <int, char> tcp_ports;
        map <int, char> udp_ports;
        map <int, char> protocols;
		vector <Port_Range> tcp_toscan;
		vector <Port_Range> udp_toscan;
        map <int, int> ttls;
        int distance; /* ttl sets it */
        Xprobe::Timeval rtt; /* round-trip time */
        //void add_p(map <int, char> &, int, char);
        void add_p(map <int, char> *, int, char);
        //int find_stat_p(map <int, char> &, char);
        int find_stat_p(map <int, char> *, char);
		bool showroute;
   public:
    Target(void) { addr.s_addr = INADDR_NONE; showroute = false; distance = 0; rtt = 0.0; }
    Target(struct in_addr a) { set_addr(a); showroute = false; }
    Target(unsigned long int a) { addr.s_addr = a; showroute = false; }
    void set_addr(struct in_addr a) {
        memcpy((void *)&addr, (void *)&a, sizeof(struct in_addr));     
    }
    struct in_addr get_addr(void) { return addr; }
    /*              protocol, port, status */
    void add_port(int , int , char );
    /*                  protocol, status */
    void add_protocol(int , char );
    int get_port(int, int);
    struct in_addr get_interface_addr(void);
    char *get_interface(void);
    /* Scan_Engine interface */
    int check_alive(void);
    int os_probe(void);
    void set_distance(int d) { distance = d; }
    int get_distance(void) { return distance; }
    void set_rtt(Xprobe::Timeval& t) { rtt = t; }
    Xprobe::Timeval& get_rtt(void) { return rtt; }
    void set_ttl(int, int);
    int get_ttl(int);
   	bool show_route(void) { return showroute; } 
	void show_route(bool sr) { showroute = sr; }
	void set_tcp_ports (map <int, char> *tp);
	void set_udp_ports (map <int, char> *up);
	void set_tcp_toscan(vector<Port_Range> *tr) { tcp_toscan = *tr; }
	void set_udp_toscan(vector<Port_Range> *ur) { udp_toscan = *ur; }
	vector<Port_Range> *get_tcp_toscan() { return &tcp_toscan; }
	vector<Port_Range> *get_udp_toscan() { return &udp_toscan; }
	int gather_info(void);
};

#endif /* TARGET_H */
