/*
 *   XPP - The X Printing Panel
 *   --------------------------
 *
 *   Simple FLTK-based login/password dialog
 *
 *   See the header file (passworddialog.h) for an overview of the functions.
 *
 *   Copyright 2000 by Till Kamppeter
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of the
 *   License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *   02111-1307  USA
 *
 */

#include "passworddialog.h"
#include <string.h>
#include <FL/fl_ask.H>

const char* passworddialog(const char* prompt, const char* login) {
  const char *str;
  if (str = fl_input("%s\nLogin:",login,prompt)) {
    strcpy((char *)login,str);
    return fl_password("%s\nPassword:","",prompt);
  } else return NULL;
}
