#include "GList.h"
#include "GMutex.h"
#include "GString.h"

#define xpdfKeyCodeTab            0x1000
#define xpdfKeyCodeReturn         0x1001
#define xpdfKeyCodeEnter          0x1002
#define xpdfKeyCodeBackspace      0x1003
#define xpdfKeyCodeInsert         0x1004
#define xpdfKeyCodeDelete         0x1005
#define xpdfKeyCodeHome           0x1006
#define xpdfKeyCodeEnd            0x1007
#define xpdfKeyCodePgUp           0x1008
#define xpdfKeyCodePgDn           0x1009
#define xpdfKeyCodeLeft           0x100a
#define xpdfKeyCodeRight          0x100b
#define xpdfKeyCodeUp             0x100c
#define xpdfKeyCodeDown           0x100d
#define xpdfKeyCodeF1             0x1100
#define xpdfKeyCodeF35            0x1122
#define xpdfKeyCodeMousePress1    0x2001
#define xpdfKeyCodeMousePress2    0x2002
#define xpdfKeyCodeMousePress3    0x2003
#define xpdfKeyCodeMousePress4    0x2004
#define xpdfKeyCodeMousePress5    0x2005
#define xpdfKeyCodeMousePress6    0x2006
#define xpdfKeyCodeMousePress7    0x2007
// ...
#define xpdfKeyCodeMousePress32   0x2020
#define xpdfKeyCodeMouseRelease1  0x2101
#define xpdfKeyCodeMouseRelease2  0x2102
#define xpdfKeyCodeMouseRelease3  0x2103
#define xpdfKeyCodeMouseRelease4  0x2104
#define xpdfKeyCodeMouseRelease5  0x2105
#define xpdfKeyCodeMouseRelease6  0x2106
#define xpdfKeyCodeMouseRelease7  0x2107
// ...
#define xpdfKeyCodeMouseRelease32 0x2120
#define xpdfKeyModNone            0
#define xpdfKeyModShift           (1 << 0)
#define xpdfKeyModCtrl            (1 << 1)
#define xpdfKeyModAlt             (1 << 2)
#define xpdfKeyContextAny         0
#define xpdfKeyContextFullScreen  (1 << 0)
#define xpdfKeyContextWindow      (2 << 0)
#define xpdfKeyContextContinuous  (1 << 2)
#define xpdfKeyContextSinglePage  (2 << 2)
#define xpdfKeyContextOverLink    (1 << 4)
#define xpdfKeyContextOffLink     (2 << 4)
#define xpdfKeyContextOutline     (1 << 6)
#define xpdfKeyContextMainWin     (2 << 6)
#define xpdfKeyContextScrLockOn   (1 << 8)
#define xpdfKeyContextScrLockOff  (2 << 8)

class KeyBinding {
public:

  int code;     // 0x20 .. 0xfe = ASCII,
                //   >=0x10000 = special keys, mouse buttons,
                //   etc. (xpdfKeyCode* symbols)
  int mods;     // modifiers (xpdfKeyMod* symbols, or-ed
                //   together)
  int context;  // context (xpdfKeyContext* symbols, or-ed
                //   together)
  GList *cmds;  // list of commands [GString]

  KeyBinding(int codeA, int modsA, int contextA, const char *cmd0);
  KeyBinding(int codeA, int modsA, int contextA,
       const char *cmd0, const char *cmd1);
  KeyBinding(int codeA, int modsA, int contextA, GList *cmdsA);
  ~KeyBinding();
};

class XpdfParams {
public:

  XpdfParams(char *cfgFileName);
  ~XpdfParams();
  void createDefaultKeyBindings();
  GList *getKeyBinding(int code, int mods, int context);
  GString *getLaunchCommand() { return launchCommand; }
  GString *getURLCommand() { return urlCommand; }
  GString *getMovieCommand() { return movieCommand; }
  GString *getPSFile();
  GBool getPSCrop();
  GBool getPSDuplex();
  GString *getInitialZoom();
  GBool getContinuousView();
  int getPSPaperWidth();
  int getPSPaperHeight();

private:
  void parseCommand(const char *cmdName, GString **val,
                    GList *tokens, GString *fileName, int line);
  void parseYesNo(const char *cmdName, GBool *flag,
                  GList *tokens, GString *fileName, int line);
  GBool parseYesNo2(char *token, GBool *flag);
  void parsePSFile(GList *tokens, GString *fileName, int line);
  void parseInitialZoom(GList *tokens, GString *fileName, int line);
  void parseFile(GString *fileName, FILE *f);
  void parseLine(char *buf, GString *fileName, int line);

#if MULTITHREADED
  GMutex xpdfMutex;
#endif
  GString *baseDir;
  GString *psFile;
  int psPaperWidth;
  int psPaperHeight;
  GBool psCrop;
  GBool psDuplex;
  GString *initialZoom;
  GBool continuousView;
  GString *launchCommand;
  GString *urlCommand;
  GString *movieCommand;
  GList *keyBindings;
};

extern XpdfParams *xpdfParams;
