// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://www.xmule.org/)
//
//
//
// This file was developed for the xMule-Project by
// Copyright (c) 2004 fsch2010
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//fdtool v1.0 = Formatting- and Debuggingtool v1.0
//
//to compile this program do only:
//
//g++ fdtool.c -o fdtool
//
//to install this program do only:
//
//cp fdtool /usr/bin

#include <fcntl.h>
#include <dirent.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

void argv_analyse(int argc, char **argv);

void filelist_analyse(char *listname);

void file_formatanddebug(char *filename);

void file_searchandchange(char *filename);

void file_matchanddelete(char *filename);

char *removedefs, *listname, *debugline, *lineentry, *searchstring, *changestring, *lines[30002];

char *files[30002];

char *tabstack[102];

int stcounter[102];

int ln, filesnumber;

int deb1counter = 0;

int debugstart = 0;

int removedefspointer = 0;

int tabcount, tabind;

int normalformatting;

int function = 1;

int targetcount = 0, warningspointer = 0, debuglinespointer = 0;

char *target[101];

char *ADDS(char *s1, char *s2);

unsigned char ASC(char *s);

char *CHR(char s);

int INSTR(unsigned int startpos, char *s, char *search);

char *LEFT(char *s, unsigned int number);

unsigned int LEN(char *s);

void LETS(char *&t, char *s);

char *MID(char *s, unsigned int start, unsigned int length);

void MIDP(char *target, unsigned int start, unsigned int length, char *source);

char *RIGHT(char *s, unsigned int number);

char *SPACE(unsigned int number);

char *STR(double value, int vkz, int nkz);

char *STRING(unsigned int number, char *s);

void STRINGINIT();

char *TRIM(char *s);

double VAL(char *s);

char *ADDS(char *s1, char *s2)
{
    unsigned int i = 0, i1;
    free(target[targetcount]);
    target[targetcount] = (char *) malloc(LEN(s1) + LEN(s2) + 1);
    i1 = 0;
    while (i1 < LEN(s1)) target[targetcount][i++] = s1[i1++];
    i1 = 0;
    while (i1 < LEN(s2)) target[targetcount][i++] = s2[i1++];
    target[targetcount][i] = 0;
    return target[targetcount++];
}

unsigned char ASC(char *s)
{
    return(unsigned char) s[0];
}

char *CHR(char s)
{
    free(target[targetcount]);
    target[targetcount] = (char *) malloc(2);
    target[targetcount][0] = s;
    target[targetcount][1] = 0;
    return target[targetcount++];
}

int INSTR(unsigned int startpos, char *s, char *search)
{
    unsigned int retvalue = 0, l, i;
    i = startpos - 1;
    l = LEN(search);
    while ((!retvalue) && ((i + l) <= LEN(s)))
    {
        if (!memcmp(s + i, search, strlen(search))) retvalue = i + 1;
        else i++;
    }
    return retvalue;
}

char *LEFT(char *s, unsigned int number)
{
    unsigned int i = 0;
    free(target[targetcount]);
    target[targetcount] = (char *) malloc(number + 1);
    if (number > LEN(s)) number = LEN(s);
    while (i < number)
    {
        target[targetcount][i] = s[i];
        i++;
    }
    target[targetcount][i] = 0;
    return target[targetcount++];
}

unsigned int LEN(char *s)
{
    return(int) strlen(s);
}

void LETS(char *&t, char *s)
{
    free(t);
    t = (char *) malloc(LEN(s) + 1);
    sprintf(t, "%s", s);
    targetcount = 0;
}

char *MID(char *s, unsigned int start, unsigned int length)
{
    unsigned int is, it;
    if ((length > LEN(s)) || (!length)) length = LEN(s);
    free(target[targetcount]);
    target[targetcount] = (char *) malloc(length + 1);
    is = start - 1;
    it = 0;
    while (is < length)
    {
        target[targetcount][it++] = s[is++];
    }
    target[targetcount][it] = 0;
    return target[targetcount++];
}

void MIDP(char *target, unsigned int start, unsigned int length, char *source)
{
    unsigned int it, is = 0;
    it = start - 1;
    while (it < LEN(target))
    {
        if (is < length)
        {
            target[it++] = source[is++];
        }
        else it = LEN(target);
    }
    targetcount = 0;
}

void Ps(char *s)
{
    printf(s);
    printf("\n");
}

char *RIGHT(char *s, unsigned int number)
{
    unsigned int i;
    free(target[targetcount]);
    target[targetcount] = (char *) malloc(number + 1);
    if (number > LEN(s)) number = LEN(s);
    i = number;
    while (i)
    {
        target[targetcount][number - i] = s[LEN(s) - i];
        i--;
    }
    target[targetcount][number] = 0;
    return target[targetcount++];
}

void SAVE(char *filename, unsigned int ln)
{
    FILE *listfile;
    unsigned int lastlinelength = 0, index;
    index = 0;
    listfile = fopen(filename/*ADDS(filename,".cpp")*/
    , "w");
    if (listfile != NULL)
    {
        while (index < ln)
        {
            targetcount = 0;
            index++;
            LETS(lines[index], MID(TRIM(ADDS("*", lines[index])), 2, 0));
            if (lastlinelength)
            {
                if (index == ln)
                {
                    if (LEN(lines[index]))
                    {
                        (void) fwrite(lines[index], LEN(lines[index]), 1, listfile);
                        (void) fwrite("\n", 1, 1, listfile);
                    }
                }
                else
                {
                    (void) fwrite(lines[index], LEN(lines[index]), 1, listfile);
                    (void) fwrite("\n", 1, 1, listfile);
                }
                lastlinelength = LEN(TRIM(lines[index]));
            }
            else
            {
                lastlinelength = LEN(TRIM(lines[index]));
                if (lastlinelength)
                {
                    (void) fwrite(lines[index], LEN(lines[index]), 1, listfile);
                    (void) fwrite("\n", 1, 1, listfile);
                }
            }
            if (INSTR(1, lines[index], "}") == 1)
            {
                (void) fwrite("\n", 1, 1, listfile);
                lastlinelength = 0;
            }
        }
        fclose(listfile);
    }
}

char *SPACE(unsigned int number)
{
    unsigned int i = 0;
    free(target[targetcount]);
    target[targetcount] = (char *) malloc(number + 1);
    while (i < number)
    {
        target[targetcount][i++] = 32;
    }
    target[targetcount][i] = 0;
    return target[targetcount++];
}

char *STR(double value, int vkz, int nkz)
{
    int length;
    char mask[20];
    free(target[targetcount]);
    target[targetcount] = (char *) malloc(vkz + nkz + 10);
    length = vkz;
    if (nkz) length += (nkz + 1);
    mask[0] = '%';
    mask[1] = 48 + vkz;
    mask[2] = 'f';
    mask[3] = 0;
    sprintf(target[targetcount], mask, value);
    return target[targetcount++];
}

char *STRING(unsigned int number, char *s)
{
    unsigned int i = 0, i1 = 0, i2;
    free(target[targetcount]);
    target[targetcount] = (char *) malloc((1 + number) *strlen(s) + 1);
    while (i1 < number)
    {
        i2 = 0;
        while (i2 < LEN(s)) target[targetcount][i++] = s[i2++];
        i1++;
    }
    target[targetcount][i] = 0;
    return target[targetcount++];
}

void STRINGINIT()
{
    if (!targetcount)
    {
        int i = 0;
        while (i < 100)
        {
            target[i++] = (char *) malloc(1);
        }
        targetcount = 1;
    }
}

char *TRIM(char *s)
{
    unsigned int ti = 0, i = 0, z = 0;
    free(target[targetcount]);
    target[targetcount] = (char *) malloc(strlen(s) + 1);
    while (i < LEN(s))
    {
        if (!z)
        {
            switch (s[i])
            {
            case 0: break;
            case 9: break;
            case 10: break;
            case 13: break;
            case 32: break;
            default: z++;
                break;
            }
        }
        if (z) target[targetcount][ti++] = s[i];
        i++;
    }
    target[targetcount][ti] = 0;
    ti = LEN(target[targetcount]);
    while (ti > 0)
    {
        ti--;
        switch (target[targetcount][ti])
        {
        case 0:
        case 9:
        case 10:
        case 13:
        case 32: target[targetcount][ti] = 0;
            break;
        default: ti = 0;
            break;
        }
    }
    return target[targetcount++];
}

double VAL(char *s)
{
    double result = 0;
    unsigned int i = 0, n = 0;
    while (i < LEN(s))
    {
        if ((s[i] >= '0') && (s[i] <= '9'))
        {
            if (!n)
            {
                result = result *10 + (s[i] - '0');
            }
            else
            {
                n = n *10;
                result = result + ((s[i] - 48) /n);
            }
        }
        else
        {
            switch (s[i])
            {
            case 32:
                break;
            case '.':
            case ',':
                n = 1;
                break;
            default:
                i = LEN(s);
                break;
            }
        }
        i++;
    }
    return(double) result;
}

int main(int argc, char **argv)
{
    STRINGINIT();
    int i = 0;
    normalformatting = 1;
    //help:
    if (argc < 2)
    {
        //Ps("FDtool v1.0 (Formatting- & Debuggingtool for C/C++-programs)");
        //Ps("");
        Ps("fdtool <filename> <options>");
        Ps("");
        Ps("");
        Ps("	 <filename> This file will become formatted or (re)changed (after/)for");
        Ps("                    debugging (works only without -c and -s-options)");
        Ps("");
        Ps("    	  <options> without options, only <filename> will be formatted");
        Ps("");
        Ps("    	            -c<changestring> takes only effect with -s<searchstring>");
        Ps("    	                          all <searchstring> will be changed to this one");
        Ps("");
        Ps("    	            -d<deletematch> deletes all lines which match this");
        Ps("");
        Ps("    		    -f  	  removes debuglines");
        Ps("    		    +f  	  insert debuglines");
        Ps("");
        Ps("    		    -l<listname>  created with 'ls *.c*' >listname'");
        Ps("		      		  all files in <listname> will be formatted or");
        Ps("                                  changed for debugging");
        Ps("");
        Ps("    		    -n  	  normal formatting");
        Ps("");
        Ps("    	            -r<#if-part>  Removes all lines from '#if <#if-port>' (incl.)");
        Ps("    	                          up to the next '#endif'-line (incl. too).");
        Ps("    	                          example (this will remove all '#if 0'-parts):");
        Ps("    	                          -r0");
        Ps("");
        Ps("    	            -s<searchstring>  search for all lines with searchstring inside");
        Ps("");
        Ps("    	            -t<tabspace>  with tabspace={ 1,2,...,9 }");
        Ps("    	                          without this option, files are only formatted");
        Ps("                                  with tabspace(2)");
        Ps("");
        Ps("    		    -w  	  disables compiler-warnings");
        Ps("    		    +w  	  enables compiler-warnings");
        Ps("");
        Ps("    	            -z<debugline> first debugline in <filename> to start with");
        Ps("    	                          debugging for FDTOOL.");
        Ps("");
    }
    else
    {
        //formatanddebug:
        function = 1;
        debugline = (char *) malloc(1);
        LETS(debugline, "");
        listname = (char *) malloc(1);
        LETS(listname, "");
        lineentry = (char *) malloc(1);
        LETS(lineentry, "");
        searchstring = (char *) malloc(1);
        LETS(searchstring, "");
        changestring = (char *) malloc(1);
        LETS(changestring, "");
        removedefs = (char *) malloc(1);
        LETS(removedefs, "");
        for (i = 0 ; i < 30001 ; i++)
        {
            lines[i] = (char *) malloc(1);
            LETS(lines[i], "");
            files[i] = (char *) malloc(1);
            LETS(files[i], "");
        }
        for (i = 0 ; i < 101 ; i++)
        {
            tabstack[i] = (char *) malloc(1);
            LETS(tabstack[i], "");
        }
        argv_analyse(argc, argv);
        filesnumber = 0;
        if (listname[0] == '-' && (LEN(listname) > 2))
        {
            filelist_analyse(listname + 2);
        }
        else
        {
            LETS(files[++filesnumber], listname);
        }
        deb1counter = 0;
        i = 0;
        while (i < filesnumber)
        {
            ++i;
            printf("%d: ", i);
            printf("%d: file/listname=%s\n", filesnumber, files[filesnumber]);
            switch (function)
            {
            case 1:
                file_formatanddebug(files[i]);
                break;
            case 2:
            case 3:
                file_searchandchange(files[i]);
                break;
            case 4:
                file_matchanddelete(files[i]);
                break;
            }
        }
    }
    return 0;
}

void argv_analyse(int argc, char **argv)
{
    int i, type, c;
    //0=prgname:
    debugstart = 99999;
    tabind = 4;
    Ps(STRING(79, "="));
    warningspointer = 0;
    debuglinespointer = 0;
    LETS(searchstring, "");
    LETS(changestring, "");
    for (i = 1 ;
    i < argc ;
    i++)
    {
        printf("%d %d %s\n", i, argc, argv[i]);
        //unknown:
        type = 0;
        c = argv[i][0];
        if (c >= 'a' &&c <= 'z') type = 1;
        else if(c >= 'A' &&c <= 'Z') type = 1;
        else if(c >= '0' &&c <= '9') type = 1;
        else
        {
            switch (c)
            {
            case 32:
            case 33:
                break;
                //option:
            case '-':
                c = argv[i][1];
                switch (c)
                {
                    //listname is following:
                    //remove debuglines:
                    //changestring:
                case 'c':
                    //search&change:
                    function = 3;
                    LETS(changestring, MID(argv[i], 3, 0));
                    break;
                case 'd':
                    //deletestring (match for identification the lines to delete):
                    function = 4;
                    LETS(searchstring, MID(argv[i], 3, 0));
                    break;
                    //searchstring:
                case 's':
                    //search&change:
                    function = 2;
                    LETS(searchstring, MID(argv[i], 3, 0));
                    break;
                case 'f':
                    debuglinespointer = - 1;
                    break;
                case 'l':
                    LETS(listname, argv[i]);
                    break;
                    //remove #if...#endif-definitions:
                case 'n':
                    normalformatting = 0;
                    break;
                case 'r':
                    LETS(removedefs, TRIM(MID(argv[i], 3, 0)));
                    break;
                    //tab-indend:
                case 't':
                    tabind = (int) VAL(MID(argv[i], 3, 0));
                    break;
                    //disable warnings:
                case 'w':
                    warningspointer = - 1;
                    break;
                case 'z':
                    debugstart = (int) VAL(MID(argv[i], 3, 0));
                    printf("%d %s %s\n", debugstart, argv[i], MID(argv[i], 3, 0));
                    break;
                }
                break;
            case '+':
                c = argv[i][1];
                switch (c)
                {
                    //insert debuglines:
                case 'f':
                    debuglinespointer = 1;
                    break;
                    //enable warnings:
                case 'w':
                    warningspointer = 1;
                    break;
                }
                break;
            }
        }
        switch (type)
        {
            //filename:
        case 1:
            LETS(listname, argv[i]);
            break;
        }
    }
    Ps(STRING(79, "-"));
}

void filelist_analyse(char *listname)
{
    int c, p;
    char c0[2];
    FILE *listfile;
    listfile = fopen(listname, "r");
    if (listfile != NULL)
    {
        filesnumber = 0;
        while (!feof(listfile))
        {
            (void) fread(c0, 1, 1, listfile);
            c = c0[0];
            switch (c)
            {
            case '\r': break;
            case '\n':
                LETS(lineentry, TRIM(lineentry));
                //no directory:
                if (lineentry[0] != 'd')
                {
                    p = LEN(lineentry);
                    while (p > 1)
                    {
                        if (lineentry[p - 1] == '.') p = - p;
                        else--p;
                    }
                    if (p < 0)
                    {
                        p = - p;
                        switch (lineentry[p])
                        {
                            //allow *.c*-programs:
                        case 'c': break;
                            //allow *.h*-headerfiles:
                        case 'h': break;
                        default: LETS(lineentry, "");
                        }
                    }
                    else LETS(lineentry, "");
                    if (LEN(lineentry) > 0)
                    {
                        //only filename is needed:
                        LETS(lineentry, TRIM(MID(lineentry, 1, 0)));
                        LETS(files[++filesnumber], lineentry);
                        LETS(lineentry, "");
                    }
                }
                else LETS(lineentry, "");
                break;
                //tab==ignore:
            case 9:
                break;
                //space:
            case 32:
                //spaceignore only before the first non-space-character:
                if (LEN(lineentry) > 0)
                {
                    LETS(lineentry, ADDS(lineentry, CHR(c)));
                }
                break;
            default:
                LETS(lineentry, ADDS(lineentry, CHR(c)));
                break;
            }
        }
        fclose(listfile);
    }
}

void file_formatanddebug(char *filename)
{
    int i, c, commenttype_local, commenttype_local_last, commenttype, char35counter, char34counter, c_last;
    int posinc = 0, tabcount_last = 0, commentpos_last = 0, commentpos = 0, cpl;
    int c_last0= 0;
    char c0[2];
    FILE *listfile;
    printf("exist? ");
    Ps(filename);
    listfile = fopen(filename, "r");
    if (listfile != NULL)
    {
        printf("...format and debug - now: ");
        Ps(filename);
        for (i = 0 ; i < 100 ; i++)
        {
            stcounter[i] = 0;
        }
        ln = 0;
        LETS(lineentry, "");
        c_last = 0;
        char35counter = 0;
        char34counter = 0;
        posinc = 0;
        commenttype = 0;
        commentpos_last = 0;
        commentpos = 0;
        commenttype_local = 0;
        cpl = 0;
        commenttype_local_last = 0;
        removedefspointer = 0;
        tabcount = 0;
        while (!feof(listfile))
        {
            (void) fread(c0, 1, 1, listfile);
            c = c0[0];
            if (c == '\n')
            {
                if (ln > debugstart)
                {
                    Ps(STRING(79, "="));
                    if (ln > 2) printf("ln-2  =%d %s\n", ln - 2, lines[ln - 2]);
                    if (ln > 1) printf("ln-1  =%d %s\n", ln - 1, lines[ln - 1]);
                    if (ln > 0) printf("ln    =%d %s\n", ln, lines[ln]);
                    Ps(STRING(79, "-"));
                    printf("STZ: ");
                    printf(" c,c_last,removedefspointer=%d,%d,%d\n", c, c_last, removedefspointer);
                    Ps(STRING(79, "-"));
                    printf("ln+1=%d %s\n", ln + 1, lineentry);
                    Ps(STRING(79, "-"));
                    printf("ln+1T%d %s<<\n", ln + 1, TRIM(lineentry));
                    printf(" char34counter=%d", char34counter);
                    printf(" char35counter=%d", char35counter);
                    printf(" posinc       =%d", posinc);
                    printf(" tabcount     =%d\n", tabcount);
                    for (i = 0 ; i <= tabcount ; i++)
                    {
                        printf("%d: %s\n", i, tabstack[i]);
                    }
                    printf(" commentpos   =%d  cpl =%d\n",
                    commentpos, cpl);
                    printf(" commenttype  =%d  commenttype_local=%d\n",
                    commenttype, commenttype_local);
                    getchar();
                }
                if (debuglinespointer == - 1)
                {
                    //remove debuglines
                    if (INSTR(1, lineentry, "~~"))
                    {
                        //debugline
                        printf("-debugline: %s\n", (const char *) lineentry);
                        LETS(lineentry, "");
                        commenttype_local = 0;
                    }
                }
                if (commenttype_local == 1)
                {
                    if (!memcmp(lineentry, "#if", 3))
                    {
                        tabcount_last = tabcount;
                        if (LEN(removedefs) > 0)
                        {
                            printf("lineentry  = >%s<\n", TRIM(MID(lineentry, 4,
                            LEN(removedefs))));
                            printf("removedefs = >%s<\n", removedefs);
                            getchar();
                            if (!memcmp(TRIM(MID(lineentry, 4, LEN(removedefs))), removedefs,
                            LEN(removedefs)))
                            {
                                removedefspointer++;
                            }
                        }
                    }
                    else if(!memcmp(lineentry, "#elseif", 7))
                    {
                        tabcount = tabcount_last;
                        if (!strcmp(TRIM(MID(lineentry, 8, 0)), removedefs))
                        {
                            removedefspointer++;
                        }
                        else
                        {
                            removedefspointer = 0;
                        }
                    }
                    else if(!memcmp(lineentry, "#else", 5))
                    {
                        tabcount = tabcount_last;
                        removedefspointer = 0;
                    }
                    else if(!memcmp(lineentry, "#end", 4))
                    {
                        tabcount_last = 0;
                        removedefspointer = 0;
                    }
                }
                if (!removedefspointer &&ln < 30000)
                {
                    LETS(lineentry, TRIM(lineentry));
                    if (posinc *2 > tabcount) posinc = tabcount >> 1;
                    if (commenttype_local == 1)
                    {
                        if (LEN(lineentry)) LETS(lines[++ln], lineentry);
                        posinc = 0;
                    }
                    else if(commenttype_local == 2)
                    {
                        LETS(lineentry, TRIM(lineentry));
                        i = 0;
                        do
                        {
                            i = INSTR(i + 1, lineentry, "::");
                            if (i > cpl)
                            {
                                if (i == (int)(LEN(lineentry) - 1))
                                {
                                    LETS(lineentry, ADDS(LEFT(lineentry, i), MID(lineentry, i + 2, 0)));
                                }
                            }
                        }
                        while (i);
                        if (cpl > 1)
                        {
                            if (ASC(RIGHT(lineentry, 1)) == ':')
                            {
                                if (tabind)
                                {
                                    LETS(lines[++ln], ADDS(SPACE(tabcount *tabind + posinc), MID(lineentry, cpl, 0)));
                                }
                                else
                                {
                                    LETS(lines[++ln], ADDS(STRING(tabcount + posinc, CHR(9)), MID(lineentry, cpl, 0)));
                                }
                            }
                            else
                            {
                                if (tabind)
                                {
                                    LETS(lines[++ln], ADDS(SPACE(tabcount *tabind + posinc), ADDS(MID(lineentry, cpl, 0), CHR(':'))));
                                }
                                else
                                {
                                    LETS(lines[++ln], ADDS(STRING(tabcount + posinc, CHR(9)), ADDS(MID(lineentry, cpl, 0), CHR(':'))));
                                }
                            }
                            LETS(lineentry, TRIM(LEFT(lineentry, cpl - 1)));
                        }
                        if (tabind)
                        {
                            LETS(lines[++ln], ADDS(SPACE(tabcount *tabind + posinc), lineentry));
                        }
                        else
                        {
                            LETS(lines[++ln], ADDS(STRING(tabcount + posinc, CHR(9)), lineentry));
                        }
                        posinc = 0;
                        //globalcomment:
                    }
                    else if(commenttype)
                    {
                        if (LEN(lineentry)) LETS(lines[++ln], ADDS(SPACE(commentpos), lineentry));
                        posinc = 0;
                    }
                    else
                    {
                        if (warningspointer == - 1)
                        {
                            i = INSTR(1, lineentry, "#warnings");
                            if (i > 0)
                            {
                                MIDP(lineentry, i, 2, "//");
                            }
                        }
                        else if(warningspointer == 1)
                        {
                            i = INSTR(1, lineentry, "//arnings");
                            if (i > 0)
                            {
                                MIDP(lineentry, i, 2, "#w");
                            }
                        }
                        i = LEN(lineentry);
                        if (i)
                        {
                            if (i > 3)
                            {
                                if (tabind)
                                {
                                    LETS(lines[++ln], ADDS(SPACE(tabcount *tabind + posinc), lineentry));
                                }
                                else
                                {
                                    LETS(lines[++ln], ADDS(STRING(tabcount + posinc, CHR(9)), lineentry));
                                }
                                i = INSTR(1, lineentry, "else");
                                if (i)
                                {
                                    if (i > INSTR(1, lineentry, ";"))
                                    {
                                        if (!normalformatting)
                                        {
                                            posinc += 2;
                                        }
                                    }
                                    else
                                    {
                                        posinc = 0;
                                    }
                                }
                                else
                                {
                                    posinc = 0;
                                }
                            }
                            else
                            {
                                if (tabind)
                                {
                                    LETS(lines[++ln], ADDS(SPACE(tabcount *tabind + posinc), lineentry));
                                }
                                else
                                {
                                    LETS(lines[++ln], ADDS(STRING(tabcount + posinc, CHR(9)), lineentry));
                                }
                                posinc = 0;
                            }
                        }
                        else if(!tabcount)
                        {
                            LETS(lines[++ln], lineentry);
                            posinc = 0;
                        }
                    }
                    commenttype_local_last = commenttype_local;
                    commenttype_local = 0;
                }
                else
                {
                    commenttype_local_last = commenttype_local;
                    commenttype_local = 0;
                    posinc = 0;
                }
                c_last = 0;
                commentpos_last = cpl;
                cpl = 0;
                LETS(lineentry, "");
                //ok:all allowed after this:
            }
            else if(c_last == '\\')
            {
                LETS(lineentry, ADDS(lineentry, CHR(c)));
                c = 0;
                if (!commenttype && !commenttype_local) cpl = LEN(lineentry);
                //ok:
            }
            else if(char34counter || (c == '\"'))
            {
                if ((!commenttype_local) && (!commenttype))
                {
                    if (c == 34) char34counter = 1 - char34counter;
                }
                //all allowed between two character 34:
                LETS(lineentry, ADDS(lineentry, CHR(c)));
                if (!commenttype && !commenttype_local) cpl = LEN(lineentry);
                //ok:
            }
            else if(char35counter || (c == '\''))
            {
                if ((!commenttype_local) && (!commenttype))
                {
                    if (c == '\'') char35counter = 1 - char35counter;
                }
                //all allowed between two character 35:
                LETS(lineentry, ADDS(lineentry, CHR(c)));
                if (!commenttype && !commenttype_local) cpl = LEN(lineentry);
                //ok:globalcomment:
            }
            else if(commenttype == 1)
            {
                LETS(lineentry, ADDS(lineentry, CHR(c)));
                if ((c_last == '*') && (c == '/'))
                {
                    if (!commenttype_local)
                    {
                        LETS(lines[++ln], ADDS(SPACE(commentpos + 3), TRIM(lineentry)));
                        LETS(lineentry, "");
                        posinc = 0;
                    }
                    commenttype = 0;
                }
                //ok:linecomment:
            }
            else if(commenttype_local == 1)
            {
                LETS(lineentry, ADDS(lineentry, CHR(c)));
            }
            else if(commenttype_local == 2)
            {
                LETS(lineentry, ADDS(lineentry, CHR(c)));
            }
            else
            {
                cpl = LEN(lineentry);
                switch (c)
                {
                case 'e':
                    LETS(lineentry, ADDS(lineentry, CHR(c)));
                    if (stcounter[tabcount] == 0)
                    {
                        if ((!commenttype) && (!commenttype_local))
                        {
                            if (LEN(lineentry) == 4)
                            {
                                if (!memcmp(lineentry, "else", 4))
                                {
                                    if (ASC(RIGHT(TRIM(lines[ln]), 1)) == '}')
                                    {
                                        if (!normalformatting)
                                        {
                                            //->compressed
                                            LETS(lineentry, ADDS(" ", TRIM(lineentry)));
                                            LETS(lineentry, ADDS(TRIM(lines[ln--]), lineentry));
                                        }
                                        c_last = 32;
                                    }
                                }
                            }
                        }
                    }
                    break;
                    //tab==ignore:
                case 9:
                    c = 32;
                case 32:
                    switch (c_last)
                    {
                    case 9:
                    case ':':
                    case 32: break;
                    case '&':
                    case '*':
                    case '(':
                    case ')':
                    case '=':
                    case '<':
                    case '>': c = c_last;
                        break;
                    default:
                        //spaceignore only before the first non-space-character:
                        if (LEN(lineentry) > 0)
                        {
                            LETS(lineentry, ADDS(lineentry, CHR(c)));
                            if (LEN(lineentry) > 2)
                            {
                                if (INSTR(1, "++ -- ", RIGHT(lineentry, 3)) > 0)
                                {
                                    LETS(lineentry, TRIM(lineentry));
                                }
                            }
                        }
                    }
                    break;
                case ':':
                    LETS(lineentry, ADDS(TRIM(lineentry), ADDS(CHR(c), " ")));
                    if (tabcount)
                    {
                        if (LEN(tabstack[tabcount - 1]) > 5)
                        {
                            if (!memcmp(tabstack[tabcount - 1], "switch", 6))
                            {
                                if (LEN(lineentry) > 3)
                                {
                                    if (!memcmp(lineentry, "case", 4))
                                    {
                                        if (tabind) posinc = - tabind;
                                        else posinc = - 1;
                                        LETS(tabstack[tabcount], lineentry);
                                    }
                                    else if(!memcmp(lineentry, "defa", 4))
                                    {
                                        if (tabind) posinc = - tabind;
                                        else posinc = - 1;
                                        LETS(tabstack[tabcount], lineentry);
                                    }
                                }
                            }
                        }
                    }
                    break;
                case '#':
                    LETS(lineentry, ADDS(lineentry, CHR(c)));
                    commenttype_local = 1;
                    break;
                case '=':
                case '<':
                case '>':
                    LETS(lineentry, TRIM(lineentry));
                    if (c_last0== 32)
                    {
                        LETS(lineentry, ADDS(lineentry, " "));
                    }
                    LETS(lineentry, ADDS(lineentry, CHR(c)));
 /*
 if (INSTR(1, " +-*&/|=<>!", CHR(c_last)) > 1)
 {
 LETS(lineentry, ADDS(lineentry, CHR(c)));
 }
 else
 {
 LETS(lineentry, ADDS(lineentry, ADDS(" ", CHR(c))));
 }
    */
                    LETS(lineentry, ADDS(lineentry, " "));
                    break;
                case '!':
                    LETS(lineentry, TRIM(lineentry));
                    if (INSTR(1, " (=<>", RIGHT(lineentry, 1)) > 1)
                    {
                        LETS(lineentry, ADDS(lineentry, CHR(c)));
                    }
                    else
                    {
                        LETS(lineentry, ADDS(lineentry, ADDS(" ", CHR(c))));
                    }
                    break;
                case '|':
                case '&':
                    LETS(lineentry, TRIM(lineentry));
                    if (INSTR(1, " &|", RIGHT(lineentry, 1)) > 1)
                    {
                        LETS(lineentry, ADDS(lineentry, CHR(c)));
                    }
                    else
                    {
                        if (c_last != '*')
                        {
                            LETS(lineentry, ADDS(lineentry, ADDS(" ", CHR(c))));
                        }
                        else
                        {
                            LETS(lineentry, ADDS(lineentry, CHR(c)));
                        }
                    }
                    break;
                case ',':
                    LETS(lineentry, ADDS(TRIM(lineentry), ADDS(CHR(c), " ")));
                    c = 32;
                    break;
                case ';':
                    LETS(lineentry, TRIM(lineentry));
                    if (!stcounter[tabcount])
                    {
                        if (ASC(RIGHT(lineentry, 1)) == 32)
                        {
                            MIDP(lineentry, LEN(lineentry), 1, CHR(c));
                        }
                        else
                        {
                            LETS(lineentry, ADDS(lineentry, CHR(c)));
                        }
                        if (tabind)
                        {
                            LETS(lines[++ln], ADDS(SPACE(tabcount *tabind + posinc), lineentry));
                        }
                        else
                        {
                            LETS(lines[++ln], ADDS(STRING(tabcount + posinc, CHR(9)), lineentry));
                        }
                        LETS(lineentry, "");
                    }
                    else
                    {
                        if (ASC(RIGHT(lineentry, 1)) == 32)
                        {
                            LETS(lineentry, ADDS(lineentry, ADDS(CHR(c), " ")));
                        }
                        else
                        {
                            LETS(lineentry, ADDS(lineentry, ADDS(" ", ADDS(CHR(c), " "))));
                        }
                        c = 32;
                    }
                    posinc = 0;
                    break;
                case '(':
                    LETS(lineentry, TRIM(lineentry));
                    if (INSTR(1, " ()abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123546789_.", RIGHT(lineentry, 1)) > 1)
                    {
                        if (INSTR(1, lineentry, "if") && (LEN(lineentry) == 2))
                        {
                            LETS(lineentry, ADDS(lineentry, ADDS(" ", ADDS(CHR(c), ""))));
                        }
                        else if(INSTR(1, lineentry, "for") && (LEN(lineentry)) == 3)
                        {
                            LETS(lineentry, ADDS(lineentry, ADDS(" ", ADDS(CHR(c), ""))));
                        }
                        else if(INSTR(1, lineentry, "while") && (LEN(lineentry)) == 5)
                        {
                            LETS(lineentry, ADDS(lineentry, ADDS(" ", ADDS(CHR(c), ""))));
                        }
                        else if(INSTR(1, lineentry, "switch") && (LEN(lineentry)) == 6)
                        {
                            LETS(lineentry, ADDS(lineentry, ADDS(" ", ADDS(CHR(c), ""))));
                        }
                        else
                        {
                            if (stcounter[tabcount])
                            {
                                if (INSTR(1, " ()", RIGHT(lineentry, 1)) > 1)
                                {
                                    LETS(lineentry, ADDS(lineentry, ADDS(CHR(c), "")));
                                }
                                else
                                {
                                    LETS(lineentry, ADDS(lineentry, ADDS(ADDS("", CHR(c)), "")));
                                }
                            }
                            else
                            {
                                LETS(lineentry, ADDS(lineentry, ADDS(CHR(c), "")));
                            }
                        }
                    }
                    else
                    {
                        LETS(lineentry, ADDS(lineentry, ADDS(" ", ADDS(CHR(c), ""))));
                    }
                    stcounter[tabcount]++;
                    break;
                case ')':
                    LETS(lineentry, TRIM(lineentry));
                    if (INSTR(1, " ()", RIGHT(lineentry, 1)) > 1)
                    {
                        LETS(lineentry, ADDS(lineentry, ADDS(CHR(c), " ")));
                    }
                    else
                    {
                        LETS(lineentry, ADDS(lineentry, ADDS("", ADDS(CHR(c), " "))));
                    }
                    if (stcounter[tabcount] == 1) if(LEN(lineentry)) LETS(tabstack[tabcount], lineentry);
                    stcounter[tabcount]--;
                    c = 32;
                    break;
                case '{':
                    if ((!normalformatting) && (tabcount > 0) && (!LEN(lineentry)))
                    {
                        if ((!commenttype) && (!commenttype_local_last))
                        {
                            LETS(lineentry, lines[ln]);
                            if (lineentry[LEN(lineentry) - 1] != 32) LETS(lineentry, ADDS(lineentry, " "));
                            LETS(lineentry, ADDS(lineentry, CHR(c)));
                            LETS(lines[ln], lineentry);
                            LETS(lineentry, "");
                            c_last = 0;
                        }
                        else
                        {
                            LETS(lineentry, CHR(c));
                            c_last = 32;
                            if (tabind) posinc = - tabind;
                            else posinc = - 1;
                        }
                    }
                    else
                    {
                        LETS(debugline, "");
                        if (!tabcount)
                        {
                            if (!LEN(TRIM(lineentry)))
                            {
                                if ((!commenttype) && (!commenttype_local_last))
                                {
                                    LETS(lineentry, TRIM(lines[ln]));
                                    ln--;
                                    LETS(debugline, TRIM(lineentry));
                                }
                            }
                            else
                            {
                                if (!commenttype)
                                {
                                    LETS(debugline, TRIM(lineentry));
                                }
                            }
                        }
                        if (LEN(lineentry))
                        {
                            if (lineentry[LEN(lineentry) - 1] != 32) LETS(lineentry, ADDS(lineentry, " "));
                        }
                        if (tabind)
                        {
                            LETS(lineentry, ADDS(SPACE(tabcount *tabind + posinc), lineentry));
                        }
                        else
                        {
                            LETS(lineentry, ADDS(STRING(tabcount + posinc, CHR(9)), lineentry));
                        }
                        if (normalformatting)
                        {
                            if (LEN(TRIM(lineentry)) > 0)
                            {
                                LETS(lines[++ln], lineentry);
                                LETS(lineentry, "");
                                if (tabind)
                                {
                                    LETS(lineentry, ADDS(SPACE(tabcount *tabind + posinc), lineentry));
                                }
                                else
                                {
                                    LETS(lineentry, ADDS(STRING(tabcount + posinc, CHR(9)), lineentry));
                                }
                            }
                        }
                        LETS(lineentry, ADDS(lineentry, CHR(c)));
                        if (debuglinespointer == 1)
                        {
                            //inserts printfs in every procedure-head
                            if (LEN(debugline))
                            {
                                c_last = INSTR(1, debugline, "::");
                                if (c_last)
                                {
                                    MIDP(debugline, c_last, 2, "~~");
                                    //deb1counter++;
                                    LETS(lines[++ln], lineentry);
                                    LETS(lineentry, "printf(");
                                    LETS(lineentry, ADDS(lineentry, CHR(34)));
                                    LETS(debugline, MID(TRIM(debugline), 1, INSTR(1, TRIM(debugline), "(")));
                                    if (LEN(debugline) > 1) LETS(debugline, LEFT(debugline, LEN(debugline) - 1));
                                    LETS(lineentry, ADDS(lineentry, MID(debugline, 1, INSTR(1, debugline, "("))));
                                    //LETS(lineentry,ADDS(lineentry,STR((double)deb1counter,5,0)));
                                    LETS(lineentry, ADDS(lineentry, "\\n"));
                                    LETS(lineentry, ADDS(lineentry, CHR(34)));
                                    LETS(lineentry, ADDS(lineentry, ");"));
                                    printf("+debugline: %s\n", (const char *) lineentry);
                                }
                            }
                        }
                        LETS(lines[++ln], lineentry);
                        LETS(lineentry, "");
                        c_last = 0;
                    }
                    tabcount++;
                    stcounter[tabcount] = 0;
                    break;
                case '}':
                    stcounter[tabcount] = 0;
                    if (LEN(lineentry))
                    {
                        if (tabind)
                        {
                            LETS(lines[++ln], ADDS(SPACE(tabcount *tabind + posinc), lineentry));
                        }
                        else
                        {
                            LETS(lines[++ln], ADDS(STRING(tabcount + posinc, CHR(9)), lineentry));
                        }
                        LETS(lineentry, "");
                    }
                    LETS(lineentry, CHR(c));
                    tabcount--;
                    if (tabcount < 0)
                    {
                        tabcount = 0;
                    }
                    if (normalformatting)
                    {
                        if (tabind)
                        {
                            LETS(lines[++ln], ADDS(SPACE(tabcount *tabind + posinc), lineentry));
                        }
                        else
                        {
                            LETS(lines[++ln], ADDS(STRING(tabcount + posinc, CHR(9)), lineentry));
                        }
                        LETS(lineentry, "");
                    }
                    break;
                case '\\':
                    if (LEN(TRIM(lineentry))== 0)
                    {
                        if (INSTR(1, "{};", RIGHT(TRIM(lines[ln]), 1)))
                        {
                            LETS(lines[ln], ADDS(lines[ln], CHR(c)));
                        }
                        else
                        {
                            LETS(lineentry, ADDS(lineentry, CHR(c)));
                        }
                    }
                    else
                    {
                        LETS(lineentry, ADDS(lineentry, CHR(c)));
                    }
                    break;
                case '/':
                    LETS(lineentry, ADDS(lineentry, CHR(c)));
                    if (c_last == '/')
                    {
                        //linecommentstart:
                        commenttype_local = 2;
                    }
                    break;
                case '*':
                    LETS(lineentry, TRIM(lineentry));
                    if (c_last == '/')
                    {
                        //globalcommentstart:
                        commenttype = 1;
                        commentpos = 1;
                        LETS(lineentry, ADDS(lineentry, CHR(c)));
                    }
                    else
                    {
                        if (c_last != '*')
                        {
                            LETS(lineentry, ADDS(lineentry, ADDS(" ", CHR(c))));
                        }
                        else
                        {
                            LETS(lineentry, ADDS(lineentry, CHR(c)));
                        }
                    }
                    break;
                case '+':
                case '-':
                    LETS(lineentry, TRIM(lineentry));
                    if (INSTR(1, " +-", RIGHT(lineentry, 1)) > 1)
                    {
                        LETS(lineentry, ADDS(lineentry, CHR(c)));
                    }
                    else
                    {
                        LETS(lineentry, ADDS(lineentry, ADDS(" ", ADDS(CHR(c), " "))));
                    }
                    if (LEN(lineentry) > 2)
                    {
                        int p9;
                        p9 = INSTR(1, lineentry, " --");
                        if (!p9) p9 = INSTR(1, lineentry, " ++");
                        if (p9)
                        {
                            LETS(lineentry, ADDS(TRIM(LEFT(lineentry, p9)), MID(lineentry, p9 + 1, 0)));
                        }
                    }
                    c = 32;
                    break;
                case '\r': break;
                default:
                    LETS(lineentry, ADDS(lineentry, CHR(c)));
                    break;
                }
            }
            c_last = c;
            c_last0 = c0[0];
        }
        fclose(listfile);
        SAVE(filename, ln);
    }
    if (LEN(TRIM(lineentry))) LETS(lines[++ln], lineentry);
}

void file_searchandchange(char *filename)
{
    int p, c, c_last;
    char c0[2];
    FILE *listfile;
    printf("exist? ");
    Ps(filename);
    listfile = fopen(filename, "r");
    if (listfile != NULL)
    {
        LETS(searchstring, TRIM(searchstring));
        LETS(changestring, TRIM(changestring));
        printf(" searchstring: %s", searchstring);
        printf(" changestring: %s\n", changestring);
        printf("...search and change - now: ");
        Ps(filename);
        ln = 0;
        LETS(lineentry, "");
        c_last = 0;
        while (!feof(listfile))
        {
            (void) fread(c0, 1, 1, listfile);
            c = c0[0];
            if (c == '\n')
            {
                if (LEN(searchstring) > 0)
                {
                    p = 1;
                    while (p > 0)
                    {
                        p = INSTR(p, lineentry, searchstring);
                        if (p > 0)
                        {
                            printf("--found     : %s\n", lineentry);
                            if (LEN(changestring) > 0)
                            {
                                LETS(lineentry, ADDS(LEFT(lineentry, p - 1),
                                ADDS(changestring, MID(lineentry, p + LEN(searchstring), 0))));
                                printf("--changed to: %s\n", lineentry);
                                p += LEN(changestring);
                            }
                            else p += LEN(searchstring);
                        }
                    }
                }
                LETS(lines[++ln], lineentry);
                LETS(lineentry, "");
            }
            else
            {
                switch (c)
                {
                case '\r':
                default:
                    LETS(lineentry, ADDS(lineentry, CHR(c)));
                    break;
                }
            }
        }
        fclose(listfile);
        c = 0;
        listfile = fopen(filename, "w");
        if (listfile != NULL)
        {
            while (c < ln)
            {
                c++;
                if (c == ln)
                {
                    if (LEN(lines[c]))
                    {
                        (void) fwrite(lines[c], LEN(lines[c]), 1, listfile);
                        (void) fwrite("\n", 1, 1, listfile);
                    }
                }
                else
                {
                    (void) fwrite(lines[c], LEN(lines[c]), 1, listfile);
                    (void) fwrite("\n", 1, 1, listfile);
                }
            }
            fclose(listfile);
        }
    }
}

void file_matchanddelete(char *filename)
{
    int p, c, c_last;
    char c0[2];
    FILE *listfile;
    printf("exist? ");
    Ps(filename);
    listfile = fopen(filename, "r");
    if (listfile != NULL)
    {
        LETS(searchstring, TRIM(searchstring));
        printf(" deletestring: %s", searchstring);
        printf("...search (and delete?) - now: ");
        Ps(filename);
        ln = 0;
        LETS(lineentry, "");
        c_last = 0;
        while (!feof(listfile))
        {
            (void) fread(c0, 1, 1, listfile);
            c = c0[0];
            if (c == '\n')
            {
                p = 1;
                if (LEN(searchstring) > 0)
                {
                    if (searchstring[0] != '#')
                    {
                        p = INSTR(p, lineentry, searchstring);
                        if (p != 1) p = 0;
                    }
                    else
                    {
                        if (LEN(searchstring) == 1)
                        {
                            //fs-spezial fuer diffs
                            p = INSTR(p, lineentry, "< //");
                            if (p != 1) p = INSTR(p, lineentry, "> //");
                            if (p != 1) p = INSTR(p, lineentry, "---");
                            if (p != 1) p = INSTR(p, lineentry, "<  *");
                            if (p != 1) p = INSTR(p, lineentry, ">  *");
                            if (p != 1)
                            {
                                if (ln > 1)
                                {
                                    p = INSTR(p, lineentry, "diff xm");
                                    if (p == 1)
                                    {
                                        p = INSTR(p, lines[ln - 1], "diff xm");
                                        if (p == 1)
                                        {
                                            printf("--deleted: %s\n", LEFT(lines[ln - 1], 65));
                                            printf("--deleted: %s\n", LEFT(lines[ln], 65));
                                            ln -= 2;
                                        }
                                        else
                                        {
                                            p = INSTR(p, lines[ln - 2], "diff xm");
                                            if (p == 1)
                                            {
                                                if (LEN(TRIM(lines[ln])) == 1)
                                                {
                                                    printf("--deleted: %s\n", LEFT(lines[ln - 2], 65));
                                                    printf("--deleted: %s\n", LEFT(lines[ln - 1], 65));
                                                    printf("--deleted: %s\n", LEFT(lines[ln], 65));
                                                    ln -= 3;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            p = 0;
                        }
                        else
                        {
                            p = INSTR(p, lineentry, MID(searchstring, 2, 0));
                        }
                    }
                    if (p > 0)
                    {
                        printf("--deleted: %s\n", LEFT(lineentry, 65));
                        p = - 1;
                    }
                }
                if (p >= 0)
                {
                    LETS(lines[++ln], lineentry);
                }
                LETS(lineentry, "");
            }
            else
            {
                switch (c)
                {
                case '\r':
                default:
                    LETS(lineentry, ADDS(lineentry, CHR(c)));
                    break;
                }
            }
        }
        fclose(listfile);
        c = 0;
        listfile = fopen(filename, "w");
        if (listfile != NULL)
        {
            while (c < ln)
            {
                c++;
                if (c == ln)
                {
                    if (LEN(lines[c]))
                    {
                        (void) fwrite(lines[c], LEN(lines[c]), 1, listfile);
                        (void) fwrite("\n", 1, 1, listfile);
                    }
                }
                else
                {
                    (void) fwrite(lines[c], LEN(lines[c]), 1, listfile);
                    (void) fwrite("\n", 1, 1, listfile);
                }
            }
            fclose(listfile);
        }
    }
}

