// This file is a part of the Dynamic Preferences Library.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This file is dually licensed under the terms of the following licenses:
// * Primary License: OSSAL - Open Source Software Alliance License
//   * See the included License.OSSAL for complete details.
//   * Key points:
//       5.Redistributions of source code in any non-textual form (i.e.
//          binary or object form, etc.) must not be linked to software that is
//          released with a license that requires disclosure of source code
//          (ex: the GPL).
//       6.Redistributions of source code must be licensed under more than one
//          license and must not have the terms of the OSSAL removed.
//
// * Secondary License: Creative Commons Attribution-NoDerivs License v1.0
//   * See the included License.CCANDL for complete details.
//   * Key Points:
//       * You are free:
//           * to copy, distribute, display, and perform the work
//           * to make non-commercial use of the work in its original form
//       * Under the following conditions:
//           * Attribution.You must give the original author credit.
//           * No Derivative Works.You may not alter, transform, or build upon
//             this work.
//
// * Special exceptions:
//   I, Theodore R.Smith, hereby grant, as the sole author of this library,
//   exclusive permission to the xMule Project to distribute and link to this
//   library, specifically voiding clause 5 of the OSSAL for the xMule Project.
//   As a further exclusive permission, when linked to the xMule Project,
//   the terms of the GPL concerning binary distribution must be observed.
//
// For more information on legality, see README.txt.

#ifndef _DYNPREFS_H
#define _DYNPREFS_H

#include "wxTreeMultiCtrl.h"                // Needed for wxTreeMultiCtrl

#include <list>                             // Needed for std::list
#include <map>                              // Needed for std::map
#include <utility>                          // Needed for std::pair
#include <vector>                           // Needed for std::vector

#include <wx/log.h>                         // Needed for wxLogDebug

#if wxCHECK_VERSION(2, 5, 1)
    #include <wx/xml/xml.h>                 // Needed for wxXmlNode
#else
    #include <wx/xrc/xml.h>                 // Needed for wxXmlNode
#endif

class DynamicPreferences
{
public:
    template <typename T>
    T Get(const wxString& preference);

    void Add(const wxString& preference, bool data);
    void Add(const wxString& preference, double data);
    void Add(const wxString& preference, long data);
    void Add(const wxString& preference, wxString data);

    enum
    {
        T_CHECK,
        T_SELECT,
        T_TEXT,
        T_SLIDER,
        T_DTEXT,
        T_LTEXT,
        T_DIR,
        T_LLONG
    };
};

#endif
