//this file is part of xMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef OTHERSTRUCTS_H
#define OTHERSTRUCTS_H

#include <stdint.h>                         // uint32_t
#include <zlib.h>                           // z_stream;

//			SERVER TO CLIENT
#pragma pack(1)
struct Header_Struct{
	int8_t	eDonkeyID;
	int32_t	packetlength;
	int8_t	command;
};
#pragma pack()

#pragma pack(1)
struct UDP_Header_Struct{
	int8_t	eDonkeyID;
	int8_t	command;
};
#pragma pack()

#pragma pack(1)
struct LoginAnswer_Struct {
	uint32_t	clientid;
};
#pragma pack()

#pragma pack(1)
struct Requested_Block_Struct{
	uint32_t	StartOffset;
	uint32_t	EndOffset;
	uint32_t	packedsize;
	unsigned char	FileID[16];
	uint32_t  transferred; // Barry - This counts bytes completed
};
#pragma pack()

#pragma pack(1)
struct Requested_File_Struct{
	unsigned char	  fileid[16];
	uint32_t	  lastasked;
	uint8_t	  badrequests;
};
#pragma pack()

struct Pending_Block_Struct{
	Requested_Block_Struct*	block;
	z_stream               *zStream;       // Barry - Used to unzip packets
	uint32_t                  totalUnzipped; // Barry - This holds the total unzipped bytes for all packets so far
	bool                                    bZStreamError;
};

struct Gap_Struct{
	int32_t start;
	int32_t end;
};
#pragma pack(1)
struct ServerMet_Struct {
	uint32_t	ip;
	uint16_t	port;
	uint32_t	tagcount;
};
#pragma pack()
// BadWolf(Ottavio84) - Accurate speed measurement-
struct TransferredData {
  uint64_t datalen; //modified by sivka [BadWolf63 - Accurate speed measurement-]
  uint32_t timestamp;
};

#endif
