/* Speex Xmms plugin
 * (c) Jens Burkal, license: GPL
 * 
 * fileinfo.c: File information window
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <speex.h>
#include <speex_header.h>
#include <ogg/ogg.h>
#include <sys/stat.h>

#include "libspeex.h"
#include "speexutil.h"
#include "fileinfo.h"

#ifdef USE_UTF8
#include "utf8.h"
#endif

#include "gui/interface.h"
#include "gui/support.h"

static void set_label(GtkWidget *parent, char* labelname, char* text, gboolean freetext)
{
	GtkWidget *widget;
	
	widget = lookup_widget(parent, labelname);
	gtk_label_set_text(GTK_LABEL(widget), text);
	
	if (freetext) g_free(text);
}

static void set_sensitive(GtkWidget *parent, char *widgetname, gboolean value)
{
	GtkWidget *widget;

	widget = lookup_widget(parent, widgetname);
	gtk_widget_set_sensitive(widget, value);
}


void spx_fileinfo(char *filename) {

	char* text;
	gboolean streaming;
	struct stat infostat;

	SpeexHeader *header;
	speex_comment_t comments;

	GtkWidget *infobox;
	GtkWidget *gtklist;
	
	int length;

	streaming = !!strstr(filename, "http://");

	if (streaming) goto show_window;
	
	if (!speex_file_info(filename, &header, &comments, &length))
		return;

	stat(filename, &infostat);

show_window:
	
	infobox = create_infobox();

	if (streaming)
	{
		int i = 0;
		
		char labels[][22] = {
			"speex_version_label",
			"speex_mode_label",
			"speex_rate_label",
			"speex_channels_label",
			"speex_length_label",
			"speex_size_label",
			"speex_vendor_label"};

		for (; i < 7; i++)
			set_label(infobox, labels[i], "", 0);

		set_sensitive(infobox, "infotable", FALSE);
		set_sensitive(infobox, "commentbox", FALSE);

		goto show_final;
	}

	
	// Set window title - FIXME
	text = g_strdup_printf("File info: %s", (char*)generate_title(filename, NULL));
	gtk_window_set_title(GTK_WINDOW(infobox), text);
	g_free(text);

	// Version
	set_label(infobox, "speex_version_label", header->speex_version, 0);

	// Mode
	set_label(infobox, "speex_mode_label", (char*) (speex_mode_list[header->mode])->modeName, 0);

	// Rate
	set_label(infobox, "speex_rate_label", g_strdup_printf("%d Hz", header->rate), 1);

	// Channels
	set_label(infobox, "speex_channels_label", g_strdup_printf("%d", header->nb_channels), 1);

	// File length
	set_label(infobox, "speex_length_label", g_strdup_printf("%d:%02d", length/60, length%60), 1);

	// File size
	set_label(infobox, "speex_size_label", g_strdup_printf("%d B", (int) infostat.st_size), 1);

	// Vendor label
	set_label(infobox, "speex_vendor_label", speex_comment_get_vendor(&comments), 0);
	
	// Comments
	{
	char *s;

	gtklist = lookup_widget(infobox, "commentlist");
	
	for (speex_comment_first(&comments); !speex_comment_isdone(&comments);)
	{
		#ifdef USE_UTF8
		s = convert_from_utf8(speex_comment_get_next(&comments));
		gtk_clist_append(GTK_CLIST(gtklist), &s);
		g_free(s);
		#else
		s = speex_comment_get_next(&comments);
		gtk_clist_append(GTK_CLIST(gtklist), &s);
		#endif

	}
	
	}
	speex_comment_free(&comments);

show_final:
	
	// Show window	
	gtk_widget_show(infobox);
	return;


}
	

