/*
 * xmms-mad - mp3 plugin for xmms
 * Copyright (C) 2001-2002 Sam Clegg - See COPYING
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $superduper: xmms-mad.h,v 1.6 2004/05/27 11:03:47 sam Exp $
 */
#ifndef XMMS_MAD_H
#define XMMS_MAD_H

#define G_LOG_DOMAIN "xmms-mad"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <xmms/plugin.h>
#include <xmms/titlestring.h>
#include <id3tag.h>
#include <mad.h>

#include "xing.h"

struct mad_info_t
{
  /* flags */
  gint stop;
  gint seek;		/**< seek time in seconds */

  /* state */
  guint current_frame;	/**< current mp3 frame */
  mad_timer_t pos;	/**< current play position */

  /* song info */
  guint vbr;		/**< bool: is vbr? */
  guint bitrate;	/**< avg. bitrate */
  guint freq;		/**< sample freq. */
  guint mpeg_layer;	/**< mpeg layer */
  guint mode;		/**< mpeg stereo mode */
  guint channels;
  gint frames;          /**< total mp3 frames or -1 */
  gint fmt;             /**< sample format */
  gint size;            /**< file size in bytes or -1 */
  gchar *title;         /**< title for xmms */
  mad_timer_t duration; /**< total play time */
  struct id3_tag *tag;
  struct id3_file *id3file;
  struct xing xing;

  /* data access */
  gchar *url;
  gchar *filename;
  gint infile;

  gint remote;
  struct streamdata_t *sdata; /**< stream data for remote connections */
};

struct xmmsmad_config_t
{
  gint http_buffer_size;
  gboolean fast_play_time_calc;
  gboolean use_xing;
};

extern void *decode (void *arg);
extern void xmmsmad_error (gchar *fmt, ...);
extern void xmmsmad_configure ();
extern InputPlugin mad_plugin;        /**< the plugin itself */
extern struct xmmsmad_config_t xmmsmad_config;

#endif /* !XMMS_MAD_H */
