<!-- 
    Transform XSL 1.1 extensions to AntennaHouse extensions

    Copyright (c) 2004 Julian F. Reschke (julian.reschke@greenbytes.de)

    placed into the public domain

    change history:

    2004-05-17  julian.reschke@greenbytes.de

    Initial release.
-->

<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               xmlns:fo="http://www.w3.org/1999/XSL/Format"
               xmlns:an="http://www.antennahouse.com/names/XSL/Extensions"
               version="1.0"
>

<!-- transform bookmark elements -->

<xsl:template match="fo:bookmark-tree" />

<!-- for any element that has an ID referenced from the bookmark-tree,
     add an outline attribute -->

<xsl:key name="bookmarkid" match="fo:bookmark" use="@internal-destination"/>
     
<xsl:template match="*[key('bookmarkid',@id)]">
  <xsl:copy>
    <xsl:variable name="bm" select="key('bookmarkid',@id)"/>
    <xsl:for-each select="$bm">
      <xsl:attribute name="an:outline-level"><xsl:value-of select="count(ancestor-or-self::fo:bookmark)"/></xsl:attribute>
    </xsl:for-each>
    <xsl:apply-templates select="node()|@*"/>
  </xsl:copy>
</xsl:template>

<!-- page index -->

<xsl:attribute-set name="internal-link">
  <xsl:attribute name="color">#000080</xsl:attribute>
</xsl:attribute-set>

<xsl:template match="fo:page-index">
  <xsl:variable name="items" select="fo:index-item"/>
  <xsl:variable name="entries" select="//*[@index-key=$items/@ref-index-key]"/>
  <fo:wrapper an:suppress-duplicate-page-number="true">
    <xsl:for-each select="$entries">
      <fo:basic-link internal-destination="{@id}" xsl:use-attribute-sets="internal-link">
        <xsl:if test="contains(@index-key,',primary') and substring-after(@index-key,',primary')=''">
          <xsl:attribute name="font-weight">bold</xsl:attribute>
        </xsl:if>
        <fo:page-number-citation ref-id="{@id}"/>
      </fo:basic-link>
      <xsl:if test="position()!=last()"><xsl:text>, </xsl:text></xsl:if>
    </xsl:for-each>
  </fo:wrapper>
</xsl:template>

<!-- suppress and map-->
<xsl:template match="@index-key" />
<xsl:template match="fo:end-index-range" />
<xsl:template match="fo:begin-index-range">
  <fo:block id="{@id}"/>
</xsl:template>

<!-- XEP document info -->
<xsl:template xmlns:xep="http://www.renderx.com/XSL/Extensions" match="xep:meta-info" priority="9">
  <xsl:for-each select="xep:meta-field">
    <an:document-info name="{@name}" value="{@value}"/>
  </xsl:for-each>
</xsl:template>

<!-- remove third-party extensions -->

<xsl:template match="*[namespace-uri()!='http://www.w3.org/1999/XSL/Format' and namespace-uri()!='http://xml.apache.org/fop/extensions']" priority="0"/>
<xsl:template match="@*[namespace-uri()!='' and namespace-uri()!='http://www.w3.org/1999/XSL/Format' and namespace-uri()!='http://xml.apache.org/fop/extensions']" priority="0"/>

<!-- rules for identity transformations -->

<xsl:template match="node()|@*"><xsl:copy><xsl:apply-templates select="node()|@*" /></xsl:copy></xsl:template>

<xsl:template match="/">
	<xsl:copy><xsl:apply-templates select="node()" /></xsl:copy>
</xsl:template>

</xsl:transform>