/*
  Copyright (C) 2000-2006

  Code contributed by Greg Collecutt, Joseph Hope, Andrew Reid and Paul Cochrane

  This file is part of xmds.
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xsilfield.h 1194 2006-12-18 12:59:46Z paultcochrane $
*/

/*! @file xsilfield.h
  @brief Header which defines classes for xsil
*/

//! Enumerator of output formats
enum outputFormatEnum {
  FORMAT_NONE,
  FORMAT_MATLAB,
  FORMAT_SCILAB,
  FORMAT_MATHEMATICA};

// ******************************************************************************
// ******************************************************************************
//                              xsilField
// ******************************************************************************
// ******************************************************************************

//! xsilField class
class xsilField : public xmdsUtility {

friend bool initialiseFieldFromXSILFile(const char *filename, const char *mgName, 
                                 unsigned long dimension, char **dimNames,
                                 char **componentNames,
								 // output variables
								 char**binaryDataFilename, int *unsignedLongSize, bool *dataEncodingIsNative,
								 bool *isPrecisionDouble, unsigned long *nDataComponents,
								 unsigned long **inputLattice, int **componentIndicesPtr);
public :

  //! Constructor for xsilField object
  xsilField();

  //! Destructor
  ~xsilField();

  //! Processes the element yourElement
  void processElement(
		      const Element *const yourElement);

  //! Writes the output to outfile as format
  void writeAsFormat(
		     FILE *const outfile,
		     const outputFormatEnum& format,
		     const long& iD,
		     const char *datFileNameBase);

private :

  //! Looks like it returns the dimension of the lattice at the given index but am not sure
  unsigned long lattice(
			const unsigned long& index) const;

  //! Looks like it returns the variable name at the given index
  const XMLString* variableName(
				const unsigned long& index) const;

  XMLString           fieldName;             //!< The name of the field
  unsigned long	      nIndependentVariables; //!< The number of independent variables in simulation
  list<XMLString>     variableNamesList;     //!< The list of variable names
  //! The list of lattices
  /*! 
    (which I think is a list of the dimensions of each lattice in the sim)
  */
  list<unsigned long> latticeList;           
  XMLString           streamFormat;    //!< Format of the data stream, either Text or Binary
  XMLString	      data;           //!< A data string
  XMLString	      binDatFname;    //!< The filename of the binary data file
  XMLString           binEncoding;    //!< The binary encoding (i.e. big or little endian)
  XMLString           binPrecision;    //!< The binary data precision (i.e. single or double)
  XMLString           ulongType;    //!< The explicit type for ulong (i.e. ulong, uint32 or uint64)
};

