/*
 Copyright (C) 2000-2006

 Code contributed by Greg Collecutt, Joseph Hope and Paul Cochrane

 This file is part of xmds.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmdsintegratesi.cc 1350 2007-06-03 05:10:03Z grahamdennis $
*/

/*! @file xmdsintegratesi.cc
  @brief Integrate element parsing classes and methods; semi-implicit method

  More detailed explanation...
*/

#include <xmlbasics.h>
#include <dom3.h>
#include <xmdsutils.h>
#include <xmdsclasses.h>

// **************************************************************************
// **************************************************************************
//                              xmdsIntegrateSI public
// **************************************************************************
// **************************************************************************

extern bool debugFlag;

long nxmdsIntegrateSIs=0;   //!< The number of xmds integrate SI objects

// **************************************************************************
xmdsIntegrateSI::xmdsIntegrateSI(
         const xmdsSimulation *const yourSimulation,
         const bool& yourVerboseMode) :
  xmdsIntegrate(yourSimulation,yourVerboseMode,false,false) {
  if(debugFlag) {
    nxmdsIntegrateSIs++;
    printf("xmdsIntegrateSI::xmdsIntegrateSI\n");
    printf("nxmdsIntegrateSIs=%li\n",nxmdsIntegrateSIs);
  }
};

// **************************************************************************
xmdsIntegrateSI::~xmdsIntegrateSI() {
  if(debugFlag) {
    nxmdsIntegrateSIs--;
    printf("xmdsIntegrateSI::~xmdsIntegrateSI\n");
    printf("nxmdsIntegrateSIs=%li\n",nxmdsIntegrateSIs);
  }
};

// **************************************************************************
void xmdsIntegrateSI::processElement(
             const Element *const yourElement) {
  if(debugFlag) {
    printf("xmdsIntegrateSI::processElement\n");
  }

  list<unsigned long> myULongList;

  // ************************************
  // find iterations if present

  getAssignmentULongs(yourElement,"iterations",0,1,myULongList);

  if(myULongList.size()>0) {
    mynIterations = *myULongList.begin();
    if(verbose()) {
      printf("Iterations = %li\n",nIterations());
    }
  }
  else {
    mynIterations = 3;
    printf("Iterations defaulting to 3\n");
  }
};

// **************************************************************************
// **************************************************************************
//                              xmdsIntegrateSI protected
// **************************************************************************
// **************************************************************************

// **************************************************************************
unsigned long xmdsIntegrateSI::nIterations() const {
  if(debugFlag) {
    printf("xmdsIntegrateSI::nIterations\n");
  }

  return mynIterations;
};


/*
 * Local variables:
 * c-indentation-style: bsd
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 *
 * vim: tabstop=2 expandtab shiftwidth=2:
 */
