<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <!--
      This script converts a TTX file (an XML representation of a
      font) into an Xgridfit script *almost* ready to be compiled in
      TTX mode (well, as soon as I make a few more changes in
      Xgridfit).  Run the sed script convert-asm.sed to get it ready
      to run in FF mode.
  -->

  <xsl:output method="xml" encoding="UTF-8"/>

  <xsl:variable name="newline">
    <xsl:text>
</xsl:text>
  </xsl:variable>

  <xsl:variable name="newline-two">
    <xsl:text>
  </xsl:text>
  </xsl:variable>

  <xsl:variable name="newline-four">
    <xsl:text>
    </xsl:text>
  </xsl:variable>

  <xsl:variable name="newline-six">
    <xsl:text>
      </xsl:text>
  </xsl:variable>

  <xsl:variable name="two-space">
    <xsl:text>  </xsl:text>
  </xsl:variable>

  <xsl:variable name="four-space">
    <xsl:text>    </xsl:text>
  </xsl:variable>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="ttFont">
    <xgridfit>
      <xsl:attribute name="xmlns">http://xgridfit.sourceforge.net/Xgridfit2</xsl:attribute>
      <xsl:value-of select="$newline-two"/>
      <xsl:value-of select="$newline-two"/>
      <default type="max-twilight-points">
	<xsl:attribute name="value">
	  <xsl:value-of select="maxp/maxTwilightPoints/@value"/>
	</xsl:attribute>
      </default>
      <xsl:value-of select="$newline-two"/>
      <default type="legacy-storage">
	<xsl:attribute name="value">
	  <xsl:value-of select="number(maxp/maxStorage/@value) + 64"/>
	</xsl:attribute>
      </default>
      <xsl:value-of select="$newline-two"/>
      <default type="max-stack">
	<xsl:attribute name="value">
	  <xsl:value-of select="maxp/maxStackElements/@value"/>
	</xsl:attribute>
      </default>
      <!-- Here are some handy values thrown in for free -->
      <xsl:value-of select="$newline-two"/>
      <constant name="left-sidebearing" value="last + 1"/>
      <xsl:value-of select="$newline-two"/>
      <constant name="right-sidebearing" value="last + 2"/>
      <xsl:value-of select="$newline-two"/>
      <constant name="vertical" value="0"/>
      <xsl:value-of select="$newline-two"/>
      <constant name="horizontal" value="1"/>
      <xsl:value-of select="$newline-two"/>
      <constant name="true" value="1"/>
      <xsl:value-of select="$newline-two"/>
      <constant name="false" value="0"/>
      <xsl:value-of select="$newline-two"/>
      <xsl:value-of select="$newline"/>
      <xsl:value-of select="$newline"/>
      <xsl:apply-templates select="cvt"/>
      <xsl:value-of select="$newline"/>
      <xsl:apply-templates select="fpgm"/>
      <xsl:value-of select="$newline"/>
      <xsl:value-of select="$newline-two"/>
      <pre-program>
	<xsl:apply-templates select="prep"/>
      </pre-program>
      <xsl:value-of select="$newline"/>
      <xsl:apply-templates select="glyf"/>
    </xgridfit>
  </xsl:template>

  <xsl:template match="cvt">
    <xsl:value-of select="$two-space"/>
    <xsl:for-each select="cv">
      <xsl:value-of select="$newline-two"/>
      <control-value>
	<xsl:attribute name="name">
	  <xsl:value-of select="concat('cv-',@index)"/>
	</xsl:attribute>
	<xsl:attribute name="value">
	  <xsl:value-of select="@value"/>
	</xsl:attribute>
      </control-value>
    </xsl:for-each>
    <xsl:value-of select="$newline-two"/>
    <xsl:comment>
      <xsl:text>
	Do not add, subtract or reorder above this point.
	You may change the id but not the value of any of
	these control-value elements.
      </xsl:text>
    </xsl:comment>
    <xsl:value-of select="$newline-two"/>
  </xsl:template>

  <xsl:template match="fpgm">
    <xsl:if test="assembly">
      <xsl:value-of select="$newline-two"/>
      <legacy-functions>
	<xsl:attribute name="max-function-defs">
	  <xsl:value-of select="/ttFont/maxp/maxFunctionDefs/@value"/>
	</xsl:attribute>
	<xsl:value-of select="$newline-six"/>
	<asm>
	  <xsl:value-of select="assembly"/>
	</asm>
	<xsl:value-of select="$newline-two"/>
      </legacy-functions>
      <xsl:value-of select="$newline"/>
      <xsl:value-of select="$newline"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="prep">
    <xsl:if test="assembly">
      <xsl:value-of select="$newline-two"/>
      <asm>
	<xsl:value-of select="assembly"/>
      </asm>
    </xsl:if>
    <xsl:value-of select="$newline"/>
  </xsl:template>

  <xsl:template match="glyf">
    <xsl:for-each select="TTGlyph">
      <xsl:if test="instructions/assembly and
		    string-length(normalize-space(instructions/assembly))">
	<xsl:value-of select="$newline-two"/>
	<xsl:variable name="n">
	  <xsl:value-of select="./@name"/>
	</xsl:variable>
	<glyph>
	  <xsl:attribute name="ps-name">
	    <xsl:value-of select="$n"/>
	  </xsl:attribute>
	  <xsl:attribute name="xml:id">
	    <xsl:choose>
	      <xsl:when test="$n = '.notdef'">
		<xsl:text>notdef-glyph</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
		<xsl:value-of select="$n"/>
	      </xsl:otherwise>
	    </xsl:choose>
	  </xsl:attribute>
	  <xsl:attribute name="init-graphics">
	    <xsl:value-of select="'no'"/>
	  </xsl:attribute>
	  <xsl:value-of select="$newline-four"/>
	  <asm>
	    <xsl:value-of select="instructions/assembly"/>
	  </asm>
	  <xsl:value-of select="$newline-two"/>
	</glyph>
	<xsl:value-of select="$newline"/>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="count-strings">
    <xsl:param name="s"/> <!-- string we're searching for -->
    <xsl:param name="t"/> <!-- string we're searching -->
    <xsl:param name="n" select="0"/>
    <xsl:choose>
      <xsl:when test="contains($t,$s)">
	<xsl:call-template name="count-strings">
	  <xsl:with-param name="s" select="$s"/>
	  <xsl:with-param name="t" select="substring-after($t,$s)"/>
	  <xsl:with-param name="n" select="$n + 1"/>
	</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="$n"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
