<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0"
                xmlns:xgf="http://www.engl.virginia.edu/OE/xgridfit-data"
		xmlns:excom="http://exslt.org/common"
                exclude-result-prefixes="xgf"
		extension-element-prefixes="excom">

  <!--
      xgridfit, an XML-based language for instructing TrueType fonts

      version 1.19

      Copyright (c) 2006-9 by Peter S. Baker

      Issued under the GNU Public License, v. 2.

      No warranty here! Back up your fonts!
  -->
  
  <xsl:output method="text" encoding="UTF-8"/>

  <xsl:param name="glyph-select">
    <xsl:choose>
      <xsl:when test="/xgridfit/glyph-select">
	<xsl:value-of select="/xgridfit/glyph-select"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="''"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <xsl:param name="compile-globals">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type='compile-globals']">
	<xsl:value-of select="/xgridfit/default[@type='compile-globals']/@value"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="'yes'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <xsl:param name="init-graphics">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type='init-graphics']">
	<xsl:value-of select="/xgridfit/default[@type='init-graphics']/@value"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="'yes'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <!-- How many points permitted in the twilight zone. This is generous,
       I think. -->
  <xsl:param name="max-twilight-points">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type='max-twilight-points']">
        <xsl:value-of select="/xgridfit/default[@type=
			      'max-twilight-points']/@value"/>
      </xsl:when>
      <xsl:otherwise>25</xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <!-- How many storage spaces to allocate. These are used for variables.
       Increase the number if you use variables a lot. -->
  <xsl:param name="max-storage">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type='max-storage']">
        <xsl:value-of select="/xgridfit/default[@type=
			      'max-storage']/@value"/>
      </xsl:when>
      <xsl:otherwise>64</xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <xsl:param name="max-stack">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type='max-stack']">
        <xsl:value-of select="/xgridfit/default[@type=
			      'max-stack']/@value"/>
      </xsl:when>
      <xsl:otherwise>256</xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <xsl:param name="delta-break">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type='delta-break']">
        <xsl:value-of select="/xgridfit/default[@type=
			      'delta-break']/@value"/>
      </xsl:when>
      <xsl:otherwise>10</xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <xsl:param name="push-break">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type='push-break']">
        <xsl:value-of select="/xgridfit/default[@type=
			      'push-break']/@value"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="number($delta-break) * 2"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <xsl:param name="color">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type='color']">
        <xsl:value-of select="/xgridfit/default[@type=
			      'color']/@value"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="'gray'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:param name="infile">
    <xsl:choose>
      <xsl:when test="/xgridfit/infile">
        <xsl:value-of select="/xgridfit/infile"/>
      </xsl:when>
      <xsl:otherwise>!!nofile!!</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:param name="outfile">
    <xsl:choose>
      <xsl:when test="/xgridfit/outfile">
        <xsl:value-of select="/xgridfit/outfile"/>
      </xsl:when>
      <xsl:otherwise>!!nofile!!</xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <xsl:param name="outfile-base">
    <xsl:choose>
      <xsl:when test="/xgridfit/outfile-base">
	<xsl:value-of select="/xgridfit/outfile-base"/>
      </xsl:when>
      <xsl:otherwise>!!nofile!!</xsl:otherwise>
    </xsl:choose>
  </xsl:param>

  <xsl:key name="cvt" match="control-value" use="@name"/>
  <xsl:key name="function-index" match="function" use="@name"/>
  <xsl:key name="macro-index" match="macro" use="@name"/>
  <xsl:key name="glyph-index" match="glyph" use="@ps-name"/>

  <!-- We'll do our own formatting of all TT instructions, providing all
       line breaks and spacing. So no space or line breaks kept from source
       file. -->
  <xsl:strip-space elements="*"/>

  <xsl:variable name="newline">
    <xsl:text>
    </xsl:text>
  </xsl:variable>

  <xsl:variable name="inst-newline">
    <xsl:text>
    </xsl:text>
  </xsl:variable>

  <xsl:variable name="push-num-separator">
    <xsl:text>
    </xsl:text>
  </xsl:variable>
  
  <xsl:variable name="text-newline">
    <xsl:text>
</xsl:text>
  </xsl:variable>

  <xsl:variable name="echo-newline">
    <xsl:text>
</xsl:text>
  </xsl:variable>

  <xsl:variable name="file-extension" select="'.debug'"/>

  <!-- These will be found in func-predef.xsl. -->
  <xsl:variable name="predefined-functions" select="4"/>
  
  <xsl:variable name="auto-function-base">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type = 'function-base']">
        <xsl:value-of select="/xgridfit/default[@type = 'function-base-num']/@value"/>
      </xsl:when>
      <xsl:when test="/xgridfit/function[@num]">
        <xsl:variable name="n">
          <xsl:call-template name="get-highest-function-number">
            <xsl:with-param name="current-function"
                            select="/xgridfit/function[@num][1]"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="number($n) + 1"/>
      </xsl:when>
      <xsl:when test="/xgridfit/legacy-functions/@max-function-defs">
	<xsl:value-of select="/xgridfit/legacy-functions/@max-function-defs"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="0"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="var-legacy-storage">
    <xsl:choose>
      <xsl:when test="/xgridfit/default[@type = 'legacy-storage']">
	<xsl:value-of select="/xgridfit/default[@type = 'legacy-storage']/@value"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>0</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  
  <xsl:variable name="function-round-restore"
		select="$auto-function-base"/>
  
  <xsl:variable name="function-glyph-prolog"
		select="number($auto-function-base) + 1"/>
  
  <xsl:variable name="function-push-range"
		select="number($auto-function-base) + 2"/>

  <xsl:variable name="function-order-range"
		select="number($auto-function-base) + 3"/>
  
  <!--
      First in the Storage Area is a block of locations used by legacy
      code (defined as the "legacy-storage" default). Next come some
      reserved locations used by Xgridfit to track state
      information. Next is the global variable area (top-level
      variables and those declared in the <pre-program>).  Finally a
      growable variable frame area.
  -->
  <xsl:variable name="var-round-state"
		select="number($var-legacy-storage)+ 0"/>
  <xsl:variable name="var-sround-info"
		select="number($var-legacy-storage)+ 1"/>
  <xsl:variable name="var-round-state-default"
		select="number($var-legacy-storage)+ 2"/>
  <xsl:variable name="var-sround-info-default"
		select="number($var-legacy-storage)+ 3"/>
  <xsl:variable name="var-return-value"
		select="number($var-legacy-storage)+ 4"/>
  <xsl:variable name="var-minimum-distance"
		select="number($var-legacy-storage)+ 5"/>
  <xsl:variable name="var-minimum-distance-default"
		select="number($var-legacy-storage)+ 6"/>
  <xsl:variable name="var-control-value-cut-in"
		select="number($var-legacy-storage)+ 7"/>
  <xsl:variable name="var-control-value-cut-in-default"
		select="number($var-legacy-storage)+ 8"/>
  <xsl:variable name="var-single-width"
		select="number($var-legacy-storage)+ 9"/>
  <xsl:variable name="var-single-width-cut-in"
		select="number($var-legacy-storage)+ 10"/>
  <xsl:variable name="var-single-width-default"
		select="number($var-legacy-storage)+ 11"/>
  <xsl:variable name="var-single-width-cut-in-default"
		select="number($var-legacy-storage)+ 12"/>
  <xsl:variable name="var-delta-base"
		select="number($var-legacy-storage)+ 13"/>
  <xsl:variable name="var-delta-base-default"
		select="number($var-legacy-storage)+ 14"/>
  <xsl:variable name="var-delta-shift"
		select="number($var-legacy-storage)+ 15"/>
  <xsl:variable name="var-delta-shift-default"
		select="number($var-legacy-storage)+ 16"/>
  <xsl:variable name="var-function-stack-count"
		select="number($var-legacy-storage)+ 17"/>
  <xsl:variable name="var-frame-bottom"
		select="number($var-legacy-storage)+ 18"/>
  <xsl:variable name="var-frame-top"
		select="number($var-legacy-storage)+ 19"/>
  <xsl:variable name="reg0"
		select="number($var-legacy-storage)+ 20"/>
  <xsl:variable name="reg1"
		select="number($var-legacy-storage)+ 21"/>
  <xsl:variable name="reg2"
		select="number($var-legacy-storage)+ 22"/>
  <xsl:variable name="reg3"
		select="number($var-legacy-storage)+ 23"/>

  <!-- This number + 1 is the lowest address of a global variable. -->
  <xsl:variable name="global-variable-base"
		select="number($var-legacy-storage)+ 23"/>
  <!-- This number + 1 is the lowest address of a variable
       in a glyph program or function. -->
  <xsl:variable name="variable-frame-base"
                select="$global-variable-base + count(/xgridfit/variable)"/>

  <xsl:include href="numbers.xsl"/>
  <xsl:include href="expressions.xsl"/>
  <xsl:include href="arithmetic.xsl"/>
  <xsl:include href="points.xsl"/>
  <xsl:include href="flow.xsl"/>
  <xsl:include href="function.xsl"/>
  <xsl:include href="func-predef.xsl"/>
  <xsl:include href="prep.xsl"/>
  <xsl:include href="graphics.xsl"/>
  <xsl:include href="measure.xsl"/>
  <xsl:include href="primitives.xsl"/>
  <xsl:include href="delta.xsl"/>
  <xsl:include href="move-lib.xsl"/>
  <xsl:include href="move-els.xsl"/>
  <xsl:include href="messages.xsl"/>
  <xsl:include href="misc.xsl"/>
  

  <!--

       simple-command

       A very simple, one-line command, with optional modifier.
  -->
  <xsl:template name="simple-command">
    <xsl:param name="cmd"/>
    <xsl:param name="modifier"/>
    <xsl:value-of select="$newline"/>
    <xsl:value-of select="$cmd"/>
    <xsl:if test="$modifier">
      <xsl:text>[</xsl:text>
      <xsl:value-of select="$modifier"/>
      <xsl:text>]</xsl:text>
    </xsl:if>
  </xsl:template>

  <!--

       push-command

       Generates the command for a PUSH instruction.
  -->
  <xsl:template name="push-command">
    <xsl:param name="size" select="'B'"/>
    <xsl:param name="count" select="1"/>
    <xsl:variable name="cmd">
      <xsl:choose>
        <xsl:when test="number($count) &lt;= 8">
          <xsl:value-of select="concat('PUSH',$size,'_',$count)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="number($count) &gt; 255">
            <xsl:call-template name="error-message">
              <xsl:with-param name="msg">
                <xsl:text>You may not push more than 255 numbers at one time.</xsl:text>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:if>
          <xsl:value-of select="concat('NPUSH',$size)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:call-template name="simple-command">
      <xsl:with-param name="cmd" select="$cmd"/>
    </xsl:call-template>
    <xsl:if test="number($count) &gt; 8">
      <xsl:value-of select="$inst-newline"/>
      <xsl:value-of select="$count"/>
    </xsl:if>
  </xsl:template>

  <!-- The following templates are for the bit-flags that accompany
       certain instructions. -->

  <xsl:template name="color-bits">
    <xsl:param name="l-color"/>
    <xsl:choose>
      <xsl:when test="$l-color='black'">
        <xsl:text>black</xsl:text>
      </xsl:when>
      <xsl:when test="$l-color='white'">
        <xsl:text>white</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>gray</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="to-line-bit">
    <xsl:param name="tlb"/>
    <xsl:choose>
      <xsl:when test="$tlb='orthogonal'">
        <xsl:text>orthog</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>parallel</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="axis-bit">
    <xsl:param name="axis"/>
    <xsl:choose>
      <xsl:when test="$axis='x'">
        <xsl:text>x</xsl:text>
      </xsl:when>
      <xsl:when test="$axis='y'">
        <xsl:text>y</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="error-message">
          <xsl:with-param name="msg">
            <xsl:text>When setting a vector, the "axis" </xsl:text>
            <xsl:text>attribute must be either "x" or "y."</xsl:text>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="round-and-cut-in-bit">
    <xsl:param name="b" select="true()"/>
    <xsl:choose>
      <xsl:when test="$b">
        <xsl:text>rnd</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>no-rnd</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="rp0-bit">
    <xsl:param name="set-rp0"/>
    <xsl:choose>
      <xsl:when test="$set-rp0">
        <xsl:text>rp0</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>no-rp0</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="mirp-mdrp-bits">
    <xsl:param name="set-rp0"/>
    <xsl:param name="min-distance"/>
    <xsl:param name="round-cut-in"/>
    <xsl:param name="l-color"/>
    <xsl:if test="$set-rp0">
      <xsl:text>rp0,</xsl:text>
    </xsl:if>
    <xsl:if test="$min-distance">
      <xsl:text>min,</xsl:text>
    </xsl:if>
    <xsl:if test="$round-cut-in">
      <xsl:text>rnd,</xsl:text>
    </xsl:if>
    <xsl:call-template name="color-bits">
      <xsl:with-param name="l-color" select="$l-color"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="ref-ptr-bit">
    <xsl:param name="ref-ptr"/>
    <xsl:choose>
      <xsl:when test="$ref-ptr='1'">
        <xsl:text>rp1</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>rp2</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="grid-fitted-bit">
    <xsl:param name="grid-fitted"/>
    <xsl:choose>
      <xsl:when test="$grid-fitted">
        <xsl:text>grid</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>orig</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="echo-atts">
    <xsl:for-each select="@*">
      <xsl:text> </xsl:text>
      <xsl:value-of select="local-name()"/>
      <xsl:text>="</xsl:text>
      <xsl:value-of select="."/>
      <xsl:text>"</xsl:text>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="debug-start">
    <xsl:variable name="ln" select="local-name()"/>
    <xsl:value-of select="$echo-newline"/>
    <xsl:text>&lt;</xsl:text>
    <xsl:value-of select="$ln"/>
    <xsl:call-template name="echo-atts"/>
    <xsl:text>&gt;</xsl:text>
    <xsl:if test="$ln != 'function' and $ln != 'glyph' and
		  reference|point|contour|zone|range|set|line|param-set|delta-set">
      <xsl:apply-templates select="reference|point|contour|zone|range|set|line|
				   param-set|delta-set"
			   mode="echo"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name="debug-end">
    <xsl:value-of select="$echo-newline"/>
    <xsl:text>&lt;/</xsl:text>
    <xsl:value-of select="local-name()"/>
    <xsl:text>&gt;</xsl:text>
  </xsl:template>

  <xsl:template match="reference|delta-set" mode="echo">
    <xsl:value-of select="$echo-newline"/>
    <xsl:text>&lt;</xsl:text>
    <xsl:value-of select="local-name()"/>
    <xsl:call-template name="echo-atts"/>
    <xsl:choose>
      <xsl:when test="point">
	<xsl:text>&gt;</xsl:text>
	<xsl:apply-templates select="point" mode="echo"/>
	<xsl:value-of select="$echo-newline"/>
	<xsl:text>&lt;/</xsl:text>
	<xsl:value-of select="local-name()"/>
	<xsl:text>&gt;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>/&gt;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="range|line|set" mode="echo">
    <xsl:value-of select="$echo-newline"/>
    <xsl:text>&lt;</xsl:text>
    <xsl:value-of select="local-name()"/>
    <xsl:call-template name="echo-atts"/>
    <xsl:choose>
      <xsl:when test="point">
	<xsl:text>&gt;</xsl:text>
	<xsl:apply-templates select="point" mode="echo"/>
	<xsl:value-of select="$echo-newline"/>
	<xsl:text>&lt;/</xsl:text>
	<xsl:value-of select="local-name()"/>
	<xsl:text>&gt;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>/&gt;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="point|contour|zone" mode="echo">
    <xsl:value-of select="$echo-newline"/>
    <xsl:text>&lt;</xsl:text>
    <xsl:value-of select="local-name()"/>
    <xsl:call-template name="echo-atts"/>
    <xsl:text>/&gt;</xsl:text>
  </xsl:template>

<!-- ========================================================================= -->
<!-- ============== TOP-LEVEL ELEMENTS OF THE INSTRUCTION FILE =============== -->
<!-- ========================================================================= -->
  

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="xgridfit">
    <xsl:param name="all-functions" select="/xgridfit/function"/>
    <xsl:param name="leg"
	       select="/xgridfit/legacy-functions"/>
    <xsl:if test="not(pre-program) and $compile-globals='yes'">
      <xsl:call-template name="error-message">
	<xsl:with-param name="msg">
	  <xsl:text>A &lt;pre-program&gt; element must be present, even if empty.</xsl:text>
	</xsl:with-param>
      </xsl:call-template>
    </xsl:if>
    <xsl:if test="$compile-globals='yes'">
      <xsl:text>&lt;!-- Functions begin here --&gt;</xsl:text>
      <!-- <xsl:value-of select="$newline"/> -->
      <xsl:choose>
	<xsl:when test="$all-functions[@num]">
	  <xsl:apply-templates select="$all-functions[@num]"/>
	</xsl:when>
	<xsl:when test="$leg[@max-function-defs]">
	  <xsl:apply-templates select="$leg"/>
	</xsl:when>
      </xsl:choose>
      <xsl:call-template name="function-zero"/>
      <xsl:call-template name="function-one"/>
      <xsl:call-template name="function-two"/>
      <xsl:call-template name="function-three"/>
      <xsl:apply-templates select="$all-functions[not(@num) and not(variant)]"/>
      <xsl:value-of select="$text-newline"/>
      <xsl:text>&lt;!-- Functions end here --&gt;</xsl:text>
      <xsl:value-of select="$newline"/>
      <xsl:value-of select="$text-newline"/>
      <xsl:apply-templates select="pre-program"/>
      <xsl:value-of select="$text-newline"/>
    </xsl:if>
    <xsl:value-of select="$text-newline"/>
    <xsl:choose>
      <xsl:when test="string-length($glyph-select)">
	<xsl:call-template name="glyph-list">
	  <xsl:with-param name="list" select="$glyph-select"/>
	  <xsl:with-param name="separator">
	    <xsl:choose>
	      <xsl:when test="contains($glyph-select,'+')">
		<xsl:value-of select="'+'"/>
	      </xsl:when>
	      <xsl:otherwise>
		<xsl:value-of select="' '"/>
	      </xsl:otherwise>
	    </xsl:choose>
	  </xsl:with-param>
	</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
	<xsl:choose>
	  <xsl:when test="$outfile-base = '!!nofile!!'">
	    <xsl:apply-templates select="glyph"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:choose>
	      <xsl:when test="element-available('excom:document')">
		<xsl:for-each select="glyph">
		  <xsl:variable name="new-filename"
				select="concat($outfile-base,'_',@ps-name,$file-extension)"/>
		  <xsl:call-template name="display-message">
		    <xsl:with-param name="msg">
		      <xsl:text>Saving to file </xsl:text>
		      <xsl:value-of select="$new-filename"/>
		    </xsl:with-param>
		  </xsl:call-template>
<!--
		  <excom:document excom:href="{$new-filename}" excom:method="text">
-->
		  <excom:document href="{$new-filename}" method="text">
		    <xsl:apply-templates select="."/>
		  </excom:document>
		</xsl:for-each>
	      </xsl:when>
	      <xsl:otherwise>
		<xsl:call-template name="error-message">
		  <xsl:with-param name="msg">
		    <xsl:text>Your XSLT engine does not support -S (outfile-base)</xsl:text>
		  </xsl:with-param>
		</xsl:call-template>
	      </xsl:otherwise>
	    </xsl:choose>
	  </xsl:otherwise>
	</xsl:choose>
<!--
	<xsl:apply-templates select="glyph"/>
-->
      </xsl:otherwise>
    </xsl:choose>
    <xsl:value-of select="$newline"/>
    <xsl:if test="$compile-globals='yes'">
      <xsl:value-of select="$text-newline"/>
      <xsl:text>&lt;maxp&gt;</xsl:text>
      <xsl:value-of select="$newline"/>
      <xsl:text>TwilightPntCnt=</xsl:text>
      <xsl:value-of select="$max-twilight-points"/>
      <xsl:value-of select="$newline"/>
      <xsl:text>StorageCnt=</xsl:text>
      <xsl:choose>
	<xsl:when test="number($max-storage) &gt;= $global-variable-base + 1">
	  <xsl:value-of select="$max-storage"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="$global-variable-base + 1"/>
	</xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="$newline"/>
      <xsl:text>MaxStackDepth=</xsl:text>
      <xsl:value-of select="$max-stack"/>
      <xsl:value-of select="$newline"/>
      <xsl:variable name="v-legacy-functions">
	<xsl:choose>
	  <xsl:when test="legacy-functions">
	    <xsl:value-of select="legacy-functions/@max-function-defs"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:text>0</xsl:text>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:variable>
      <xsl:text>FDEFs=</xsl:text>
      <xsl:value-of select="number($v-legacy-functions) +
			    number($predefined-functions) +
			    count(/xgridfit/function)"/>
      <xsl:value-of select="$echo-newline"/>
      <xsl:text>&lt;/maxp&gt;</xsl:text>
    </xsl:if>
    <xsl:value-of select="$echo-newline"/>
  </xsl:template>

  <xsl:template match="pre-program">
    <xsl:call-template name="debug-start"/>
    <!-- <xsl:value-of select="$text-newline"/> -->
    <xsl:call-template name="pre-program-instructions"/>
    <xsl:call-template name="debug-end"/>
  </xsl:template>

  <xsl:template match="glyph">
    <xsl:value-of select="$text-newline"/>
    <xsl:call-template name="debug-start"/>
    <!-- <xsl:value-of select="$newline"/> -->
    <xsl:variable name="var-string">
      <xsl:text>x</xsl:text>
      <xsl:apply-templates select="." mode="survey-vars"/>
    </xsl:variable>
    <xsl:variable name="need-variable-frame" select="contains($var-string,'v')"/>
    <xsl:variable name="init-g">
      <xsl:choose>
	<xsl:when test="@init-graphics">
	  <xsl:value-of select="@init-graphics"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="$init-graphics"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:call-template name="display-message">
      <xsl:with-param name="msg">
        <xsl:text>Compiling glyph </xsl:text>
        <xsl:value-of select="@ps-name"/>
      </xsl:with-param>
    </xsl:call-template>
    <xsl:if test="$need-variable-frame">
      <xsl:call-template name="set-up-variable-frame"/>
      <xsl:apply-templates select="variable" mode="initialize"/>
    </xsl:if>
    <xsl:if test="$init-g = 'yes'">
      <xsl:call-template name="number-command">
	<xsl:with-param name="num" select="$function-glyph-prolog"/>
	<xsl:with-param name="cmd" select="'CALL'"/>
      </xsl:call-template>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:call-template name="debug-end"/>
  </xsl:template>

  <!-- The following elements are declarations, read only
       by this script and never converted to code. -->

  <xsl:template match="no-compile"></xsl:template>

</xsl:stylesheet>
