#!/bin/bash
#
# Copyright (C) 2002, James A. Crippen <james@unlambda.com>
# This file is in the public domain.  All rights reversed.
#
# Shell script to convert ISO10646-1 fonts to other character subsets.
#

UCS2ANY=./ucs2any.pl
MAPPINGS=../mappings

CHARSETS="ISO8859-1 ISO8859-2 ISO8859-3 ISO8859-4 ISO8859-5 ISO8859-6 \
  ISO8859-7 ISO8859-8 ISO8859-9 ISO8859-10 ISO8859-13 ISO8859-14 ISO8859-15 \
  JISX0201.1976-0 JISX0208.1990-0 JISX0212.1990-0 JISX0213.2000-1 \
  JISX0213.2000-2 KSC5601.1987-0 BIG5-0 GB2312.1980-0"

FONTS="b10 b12 b14 b16 b24 h10 h12 h14 h16 h24"

TYPES="_b _bi _i"

for FNT in ${FONTS}; do
  for CHARSET in ${CHARSETS}; do
    if [ ! -e ${FNT}-${CHARSET}.bdf ]; then
      # Generate base fonts.
      echo ; echo "Generating ${FNT}-${CHARSET}.bdf..."
      ${UCS2ANY} -d ${FNT}.bdf ${MAPPINGS}/${CHARSET}.map ${CHARSET}
      # Generate variant fonts (bold, italic, bold-italic, etc).
      for TYPE in ${TYPES}; do
        if [ ! -e ${FNT}${TYPE}-${CHARSET}.bdf ]; then
          echo ; echo "Generating ${FNT}${TYPE}-iso${CHARSET}.bdf..."
          ${UCS2ANY} -d ${FNT}${TYPE}.bdf ${MAPPINGS}/${CHARSET}.map ${CHARSET}
        fi
      done
    fi
  done
done
