/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFMEDIA_PLUGIN_H__
#define __XFMEDIA_PLUGIN_H__

#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <xfmedia/xfmedia-playlist.h>

G_BEGIN_DECLS

#define XFMEDIA_PLUGIN_API_VERSION "1.1.0"
#define XFMEDIA_PLUGIN_API_MAJOR   1
#define XFMEDIA_PLUGIN_API_MINOR   1
#define XFMEDIA_PLUGIN_API_MICRO   0

/* all plugins must call this macro */
#define XFMEDIA_PLUGIN_DECL \
G_MODULE_EXPORT gboolean \
xfmedia_plugin_check_version(gint api_major, gint api_minor, gint api_micro) \
{ \
	if(api_major != XFMEDIA_PLUGIN_API_MAJOR \
			|| api_minor < XFMEDIA_PLUGIN_API_MINOR) \
	{ \
		return FALSE; \
	} \
	return TRUE; \
}

#define XFMEDIA_TYPE_PLUGIN            (xfmedia_plugin_get_type())
#define XFMEDIA_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), XFMEDIA_TYPE_PLUGIN, XfMediaPlugin))
#define XFMEDIA_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), XFMEDIA_TYPE_PLUGIN, XfMediaPluginClass))
#define XFMEDIA_IS_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), XFMEDIA_TYPE_PLUGIN))
#define XFMEDIA_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), XFMEDIA_TYPE_PLUGIN))
#define XFMEDIA_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), XFMEDIA_TYPE_PLUGIN, XfMediaPluginClass))

typedef struct _XfMediaPlugin      XfMediaPlugin;
typedef struct _XfMediaPluginClass XfMediaPluginClass;
typedef struct _XfMediaPluginPriv  XfMediaPluginPriv;

typedef GtkWidget *(*PluginConfigureFunc)(XfMediaPlugin *plugin);

struct _XfMediaPlugin
{
	GObject parent;
	
	/*< private >*/
	XfMediaPluginPriv *priv;
};

struct _XfMediaPluginClass
{
	GObjectClass parent_class;
	
	/*< signals >*/
	void (*stream_loaded)(XfMediaPlugin *plugin);
	void (*stream_started)(XfMediaPlugin *plugin);
	void (*stream_ended)(XfMediaPlugin *plugin);
	void (*speed_changed)(XfMediaPlugin *plugin);
	void (*unloading)(XfMediaPlugin *plugin);
	
	/*< reserved for future expansion >*/
	void (*_xfmedia_reserved0)();
	void (*_xfmedia_reserved1)();
	void (*_xfmedia_reserved2)();
};

GType          xfmedia_plugin_get_type            () G_GNUC_CONST;

/* should not be called by plugin implementations */
XfMediaPlugin *xfmedia_plugin_new                 ();

void           xfmedia_plugin_set_name            (XfMediaPlugin *plugin,
                                                   const gchar *name);
G_CONST_RETURN gchar *xfmedia_plugin_get_name     (XfMediaPlugin *plugin);

void           xfmedia_plugin_set_description     (XfMediaPlugin *plugin,
                                                   const gchar *description);
G_CONST_RETURN gchar *xfmedia_plugin_get_description
                                                  (XfMediaPlugin *plugin);

void           xfmedia_plugin_set_version         (XfMediaPlugin *plugin,
                                                   const gchar *version);
G_CONST_RETURN gchar *xfmedia_plugin_get_version  (XfMediaPlugin *plugin);

void           xfmedia_plugin_set_icon_file       (XfMediaPlugin *plugin,
                                                   const gchar *icon_file);
G_CONST_RETURN gchar *xfmedia_plugin_get_icon_file(XfMediaPlugin *plugin);

void           xfmedia_plugin_set_icon            (XfMediaPlugin *plugin,
                                                   GdkPixbuf *icon);
GdkPixbuf *    xfmedia_plugin_get_icon            (XfMediaPlugin *plugin);

void           xfmedia_plugin_set_author          (XfMediaPlugin *plugin,
                                                   const gchar *author);
G_CONST_RETURN gchar *xfmedia_plugin_get_author   (XfMediaPlugin *plugin);

void           xfmedia_plugin_set_website         (XfMediaPlugin *plugin,
                                                   const gchar *website);
G_CONST_RETURN gchar *xfmedia_plugin_get_website  (XfMediaPlugin *plugin);

void           xfmedia_plugin_set_license         (XfMediaPlugin *plugin,
                                                   const gchar *license);
G_CONST_RETURN gchar *xfmedia_plugin_get_license  (XfMediaPlugin *plugin);

void           xfmedia_plugin_set_date            (XfMediaPlugin *plugin,
                                                   const gchar *date);
G_CONST_RETURN gchar *xfmedia_plugin_get_date     (XfMediaPlugin *plugin);

void           xfmedia_plugin_set_configure_func  (XfMediaPlugin *plugin,
                                                   PluginConfigureFunc func);
PluginConfigureFunc xfmedia_plugin_get_configure_func
                                                  (XfMediaPlugin *plugin);

void           xfmedia_plugin_set_enabled         (XfMediaPlugin *plugin,
                                                   gboolean enabled);
gboolean       xfmedia_plugin_get_enabled         (XfMediaPlugin *plugin);

XfMediaPlaylist *xfmedia_plugin_get_playlist      (XfMediaPlugin *plugin);

G_END_DECLS

#endif
