/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* this header is essentially full of private functions that've been broken out
 * into separate files to ease clutter.  in no way do they represent any kind
 * of public API. */

#ifndef __XFMEDIA_INTERNAL_H__
#define __XFMEDIA_INTERNAL_H__

#include "xfmedia-common.h"
#include "gtkxine.h"
#include <xfmedia/xfmedia-playlist.h>

G_BEGIN_DECLS

/* mainwin-callbacks.c */
void xfmedia_mainwin_playlist_scrolled_cb(XfMediaPlaylist *plist, gpointer user_data);
void xfmedia_mainwin_playlist_entry_activated_cb(XfMediaPlaylist *plist, gint index, gpointer user_data);
void xfmedia_mainwin_playlist_shuffle_toggled_cb(XfMediaPlaylist *plist, gpointer user_data);
void xfmedia_mainwin_playlist_repeat_toggled_cb(XfMediaPlaylist *plist, gpointer user_data);
void xfmedia_mainwin_playlist_cleared_cb(XfMediaPlaylist *plist, gpointer user_data);
void xfmedia_mainwin_playlist_file_info_cb(GtkWidget *w, gpointer user_data);
void xfmedia_mainwin_playlist_add_autoplay_cb(GtkMenuItem *mi, gpointer user_data);
void xfmedia_mainwin_playlist_add_mm_cb(GtkWidget *w, gpointer user_data);
gboolean xfmedia_position_cb(gpointer user_data);
void xfmedia_position_slider_cb(GtkWidget *w, gpointer user_data);
gboolean xfmedia_pos_slider_btn_press_cb(GtkWidget *w, GdkEventButton *evt, gpointer user_data);
gboolean xfmedia_pos_slider_btn_rls_cb(GtkWidget *w, GdkEventButton *evt, gpointer user_data);
void xfmedia_playpause_cb(GtkWidget *w, gpointer user_data);
void xfmedia_stop_cb(GtkWidget *w, gpointer user_data);
void xfmedia_prev_cb(GtkWidget *w, gpointer user_data);
void xfmedia_next_cb(GtkWidget *w, gpointer user_data);
gboolean xfmedia_pos_lbl_click_cb(GtkWidget *w, GdkEventButton *evt, gpointer user_data);
void xfmedia_shuffle_menu_toggle_cb(GtkCheckMenuItem *mi, gpointer user_data);
void xfmedia_repeat_menu_toggle_cb(GtkCheckMenuItem *mi, gpointer user_data);
void xfmedia_repeat_one_menu_toggle_cb(GtkCheckMenuItem *mi, gpointer user_data);
void xfmedia_show_vis_menu_toggle_cb(GtkCheckMenuItem *mi, gpointer user_data);
gboolean xfmedia_vwin_delete_cb(GtkWidget *w, GdkEvent *evt, gpointer user_data);
void xfmedia_repeat_menu_toggle_cb(GtkCheckMenuItem *mi, gpointer user_data);
gboolean xfmedia_autohidewin_enter_notify(GtkWidget *w, GdkEventCrossing *evt, gpointer user_data);
gboolean xfmedia_mainwin_enterleave_notify_cb(GtkWidget *w, GdkEventCrossing *evt, gpointer user_data);
GdkFilterReturn xfmedia_mainwin_decs_filter(GdkXEvent *gxevt, GdkEvent *evt, gpointer user_data);
gboolean xfmedia_mainwin_configure_cb(GtkWidget *w, GdkEventConfigure *evt, gpointer user_data);
gboolean xfmedia_mainwin_winstate_cb(GtkWidget *w, GdkEventWindowState *evt, gpointer user_data);
void xfmedia_mainwin_expander_activate_cb(GtkExpander *widget, gpointer user_data);
void xfmedia_about_cb(GtkWidget *w, gpointer user_data);
gboolean xfmedia_vwin_button_press_cb(GtkWidget *w, GdkEventButton *evt, gpointer user_data);
gboolean xfmedia_vwin_motion_notify_cb(GtkWidget *w, GdkEventMotion *evt, gpointer user_data);
gboolean xfmedia_vwin_mapunmap_cb(GtkWidget *w, GdkEvent *evt, gpointer user_data);
void xfmedia_gtkxine_stream_ended_cb(GtkXine *gtx, gpointer user_data);
void xfmedia_gtkxine_ui_message_cb(GtkXine *gtx, const gchar *message, gpointer user_data);
void xfmedia_gtkxine_progress_message_cb(GtkXine *gtx, const gchar *message, gint percent, gpointer user_data);
void xfmedia_gtkxine_format_changed_cb(GtkXine *gtx, gint width, gint height, gint aspect_code, gboolean is_pan_scan, gpointer user_data);
void xfmedia_gtkxine_mrl_reference_cb(GtkXine *gtx, const gchar *mrl, gint alternative, gpointer user_data);
void xfmedia_mainwin_quit_mi_cb(GtkMenuItem *mi, gpointer user_data);
gboolean xfmedia_mainwin_map_cb(GtkWidget *w, GdkEvent *evt, gpointer user_data);
gboolean xfmedia_mainwin_unmap_cb(GtkWidget *w, GdkEvent *evt, gpointer user_data);
gboolean xfmedia_mainwin_keypress_cb(GtkWidget *w, GdkEventKey *evt, gpointer user_data);
gboolean xfmedia_mainwin_menu_cb(GtkWidget *w, GdkEventButton *evt, gpointer user_data);
gboolean xfmedia_tray_icon_button_press_cb(GtkWidget *w, GdkEventButton *evt, gpointer user_data);
void xfmedia_mainwin_mediamarks_changed_cb(gpointer data);
void xfmedia_mainwin_sort_title_cb(GtkWidget *w, gpointer user_data);
void xfmedia_mainwin_sort_filename_cb(GtkWidget *w, gpointer user_data);
void xfmedia_mainwin_randomise_playlist_cb(GtkWidget *w, gpointer user_data);

/* settings.c */
void xfmedia_settings_init();
void xfmedia_settings_cleanup();
gboolean xfmedia_settings_load_playlist(XfMediaMainwin *mwin);
gboolean xfmedia_settings_save_playlist(XfMediaMainwin *mwin);
void xfmedia_settings_show_dialog(XfMediaMainwin *mwin);

/* xfmedia-plugins.c */
void xfmedia_plugins_load(gpointer mwin);
GList *xfmedia_plugins_enumerate();
void xfmedia_plugins_forward_signal_VOID(const gchar *signal_name);
void xfmedia_plugins_forward_signal_STRING(const gchar *signal_name, const gchar *string);
void xfmedia_plugins_unload();

G_END_DECLS

#endif
