/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _XFMUSIC__MAINWIN_H_
#define _XFMUSIC__MAINWIN_H_

#include <gtk/gtkwidget.h>

#include "gtkxine.h"

#include "xfmedia-common.h"

G_BEGIN_DECLS

typedef enum
{
    XFMEDIA_INFOBAR_SONG_LABEL = 0,
    XFMEDIA_INFOBAR_PROGRESS_MESSAGE,
    XFMEDIA_INFOBAR_UI_MESSAGE,
    XFMEDIA_INFOBAR_N_TYPES
} XfMediaInfobarType;

XfMediaMainwin *xfmedia_mainwin_new(GtkXine *gtkx, GtkWindow *video_window);
gboolean xfmedia_mainwin_get_file_info(XfMediaMainwin *mwin, const gchar *filename, gchar **title, gint *length);
void xfmedia_mainwin_set_time_label(XfMediaMainwin *mwin, gint time, gboolean is_remaining, const gchar *extra_pango_markup);
void xfmedia_mainwin_set_song_label(XfMediaMainwin *mwin, const gchar *str);
void xfmedia_mainwin_set_infobar_type(XfMediaMainwin *mwin, XfMediaInfobarType type);
void xfmedia_mainwin_activate_systray(XfMediaMainwin *mwin);
void xfmedia_mainwin_deactivate_systray(XfMediaMainwin *mwin);
void xfmedia_mainwin_connect_slider_callback(XfMediaMainwin *mwin);
void xfmedia_mainwin_disconnect_slider_callback(XfMediaMainwin *mwin);
void xfmedia_mainwin_set_play_buttons(XfMediaMainwin *mwin);
void xfmedia_mainwin_set_pause_buttons(XfMediaMainwin *mwin);
gboolean xfmedia_mainwin_do_autohide(XfMediaMainwin *mwin);
void xfmedia_mainwin_destroy(XfMediaMainwin *mwin);

void xfmedia_mainwin_toggle_playpause(XfMediaMainwin *mwin);
void xfmedia_mainwin_stop(XfMediaMainwin *mwin);
void xfmedia_mainwin_next(XfMediaMainwin *mwin);
void xfmedia_mainwin_prev(XfMediaMainwin *mwin);

gboolean xfmedia_mainwin_play_uri(XfMediaMainwin *mwin, const gchar *uri);
gboolean xfmedia_mainwin_play_file_at_index(XfMediaMainwin *mwin, gint index);
gboolean xfmedia_mainwin_play_file_at_index_persistent(XfMediaMainwin *mwin, gint index);

G_END_DECLS
 
#endif
