
static int
SMBparseLookup (int n, void *data)
{
  static char *position[3];
  char *line,*text[3],*atext[3];
  int i;
  /* data is a static memory location */
  if (n)   return TRUE;	
  line = (char *) data;
  if (strstr (line, "Anonymous login successful"))  {
        print_diagnostics(smb_widgets_p,NULL,line,NULL);
  	  return TRUE;
  }   

  if (!samba_server)
  {
     gchar *readable_line=g_strdup(line);
     print_diagnostics(smb_widgets_p,NULL,readable_line,NULL);
     g_free(readable_line);readable_line=NULL;
  } 
  else  print_diagnostics(smb_widgets_p,NULL,line,NULL);
  

  
  if (strstr (line, "Connection") && strstr (line, "failed"))  {
    cual_chingao = LOCATION_SHARES;
    query_result = FAILED;
    position[0] = position[1] = NULL;
    return TRUE;
  }
  /* pre samba 2.2 */
  if (strstr (line, "Access") && strstr (line, "denied"))  {
    cual_chingao = LOCATION_SHARES;
    query_result = CHALLENGED;
    position[0] = position[1] = NULL;
    return TRUE;
  }
  /* post samba 2.2 */
  for (i=0;challenges[i]!=NULL;i++){
      if (strstr (line, challenges[i]))  {
        cual_chingao = LOCATION_SHARES;
        query_result = CHALLENGED;
        position[0] = position[1] = NULL;
        return TRUE;
      }	
  }
  if (strstr(line,"Server=") && strstr(line,"Samba")) samba_server=TRUE;
  /* workgroup */
  if (strstr (line, "Domain=[") || strstr (line, "Workgroup=[")){
        return TRUE;
  }
  
  if (strlen (line) < 3)  return TRUE;
  if (strstr (line, "Sharename") && strstr (line, "Comment"))  {
    position[0] = position[1] = NULL;
    cual_chingao = LOCATION_SHARES;
    return TRUE;
  }
  if (strstr (line, "Server") && strstr (line, "Comment"))  {
    position[0] = position[1] = NULL;
    cual_chingao = LOCATION_SERVERS;
    return TRUE;
  }
  if (strstr (line, "Workgroup") && strstr (line, "Master"))  {
    position[0] = position[1] = NULL;
    cual_chingao = LOCATION_WORKGROUPS;
    return TRUE;
  }
  if (strstr (line, "--------")) {
    char *buf;
    position[0] = strstr (line, "---");
    buf = strtok (position[0], " ");
    if (buf) {
      buf = strtok (NULL, "\n");
      if (buf)
	position[1] = strstr (buf, "---");
    }
    return TRUE;
  }
  if (!position[0]) {
	  /*printf("returning on null line\n");*/
	  return TRUE;
  }
  if (!position[1]) text[1]=g_strdup("-");
  else {
    text[1]=g_strdup(position[1]);
    *position[1]=0;
  }
  text[0]=g_strdup(position[0]);
  for (i=0;i<2;i++) {
	  while (strlen(text[i]) && 
			  (text[i][strlen(text[i])-1]==' ' || 
			   text[i][strlen(text[i])-1]=='\t'||
			   text[i][strlen(text[i])-1]=='\n') )
	  	text[i][strlen(text[i])-1]=0;
  }
  /*text[2]=g_strdup(current_workgroup);*/
  text[2]=NULL;
  TRACE("TRACE:texts =%s, %s, %s\n",text[0],text[1],text[2]);
  switch (cual_chingao) {
    case LOCATION_SHARES:
     {
      share_t *d_share; 
      query_result = SUCCESS; /* something valid came thru */
      d_share=(share_t *)malloc(sizeof(share_t));
      d_share->type=0;
      d_share->share=g_strdup(text[0]);
      if (strncmp("Disk",text[1],strlen("Disk"))==0)
	      SET_XF_NETSHARE(d_share->type);
      else if (strncmp("Printer",text[1],strlen("Printer"))==0)
	      SET_XF_NETPRINT(d_share->type);
      else if (strncmp("IPC",text[1],strlen("IPC"))==0)
	      SET_XF_NETIPC(d_share->type);
      listSHARES = g_list_append (listSHARES,(gpointer)d_share);
     }
     break;
    case LOCATION_SERVERS:
     {
      gchar *real_name;
      GList *tmp;
      gboolean repeat=FALSE;
      atext[0]=text[0];          /* the server */
      /* workaround IS~ stuff */
      if (strncmp(atext[0],"IS~",strlen("IS~"))==0) 
	      real_name=g_strdup(atext[0]+strlen("IS~"));
      else real_name=g_strdup(atext[0]);
      atext[1]=text[2];          /* the work group */
      atext[2]=text[1];          /* the comment */
      for (tmp=listSMB; tmp; tmp=tmp->next){
	      char *c=(char *)tmp->data;
	      if (c && real_name && strcmp(c,real_name)==0){
		      repeat=TRUE;
		      break;
	      }
      }
      if (repeat) g_free(real_name);
      else listSMB = g_list_append (listSMB,(gpointer)(real_name));
      break;
     }
    case LOCATION_WORKGROUPS:
      /* have to turn around values here */
      atext[0]=text[1];          /* the server */
      atext[1]=text[0];          /* the work group */
      atext[2]="Master subnet browser"; /* the comment: there may be more than one MB
					   if there are servers on different subnets */
      listMASTERS = g_list_append (listMASTERS,(gpointer)(g_strdup(atext[0])));
      break;
    default:
      break;
  }
  for (i=0;i<3;i++) {
	  g_free(text[i]);
	  text[i]=NULL;
  }


  return TRUE;
}


