/*
 * Copyright (C) 2002-5 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif
#ifdef HAVE_SYS_UCRED_H
#include <sys/ucred.h>
#endif
#ifdef HAVE_SYS_MOUNT_H
#include <sys/mount.h>
#endif

#include <stdio.h>
#include <errno.h>
#ifdef HAVE_FSTAB_H
#include <fstab.h>
#endif
#include <limits.h>
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "secondary.h"
#include "actions_lib.h"

static
gchar * 
get_desktop_string(const gchar *string, const gchar *file);
/****************   void  functions  ***********************/

G_MODULE_EXPORT
const gchar *
module_name(void){
    return "xffm_apps";
}
G_MODULE_EXPORT
const gchar *
submodule_dir(void){
    return "plugins";
}

G_MODULE_EXPORT
void *
is_root_module(void){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
module_init(void){
    return NULL;
}

G_MODULE_EXPORT
void *
exec_name(void){
    return "xfapps";
}

G_MODULE_EXPORT
void *
plugin_info(void){
    return _("The APPLICATIONS plugin allows you to locate, run, modify and copy applications for which a .desktop file has been installed in the default system location.");
}

void *entry_tip(void *p){
    record_entry_t *en=p;
    static gchar *tip=NULL;
    gchar *comment;
    gchar *base;
    if (!en || !en->path ) return NULL;
    comment=get_desktop_string("Comment",en->path);
    if (!comment) return NULL;
    g_free(tip);
    base=g_path_get_basename(en->path);
    tip=g_strdup_printf("%s\n(%s)\n",my_utf_string(comment),base);
/*    tip=g_strdup_printf("%s:%s",comment,path_info(p));*/
    g_free(comment);
    g_free(base);
    return (tip);
}

/*******************  natural functions **********************/

G_MODULE_EXPORT
void *
get_dnd_path(void *p)
{
    static gchar *desktop=NULL;
    if (!desktop) {
	desktop=g_strdup_printf("%s%c%s%c%s",
		PACKAGE_DATA_DIR,G_DIR_SEPARATOR,
		"applications",G_DIR_SEPARATOR,
		"Xfapps.desktop");
    }
    return (void *)desktop;
}

G_MODULE_EXPORT
void *
module_icon_id(void * p){
    return"run.png";
}

G_MODULE_EXPORT
void *
module_label(void * p){
    return _("Applications");
}

G_MODULE_EXPORT
void *
is_selectable(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (g_file_test(en->path, G_FILE_TEST_EXISTS))
	return (void *)"Yes";
    
    return NULL;
}


G_MODULE_EXPORT
void *
valid_drop_site(void *p){
    return NULL;
}


/*******************  rational functions **********************/
// FIXME: this static function is repeated in gui/deskview/deskview_desktop.i,
// so it could be move to secondary_lib...
#define KEYS_LENGTH 10
static const char *keys [KEYS_LENGTH+1] =
{
    "Name",
    "Comment",
    "Icon",
    "Categories",
    "OnlyShowIn",
    "Exec",
    "Terminal",
    "Type",
    "Encoding",
    "URL",
    NULL
};
static
gchar * 
get_desktop_string(const gchar *string, const gchar *file){
    XfceDesktopEntry * dentry;
    gchar *value=NULL;
    if (!string || !file || !g_file_test(file,G_FILE_TEST_EXISTS)) return NULL;
    dentry = xfce_desktop_entry_new (file, keys, KEYS_LENGTH);
    
    if (xfce_desktop_entry_get_string (dentry, string, TRUE, &value)){
	TRACE("%s: %sstring=%s",string, file,value);
    }
    g_object_unref(G_OBJECT(dentry));
    return value;
}


G_MODULE_EXPORT
void *
get_xfdir(void *p, void *q){
    static xfdir_t xfdir;
    int i;
    /*record_entry_t *en=(record_entry_t *)p;*/
    record_entry_t *en=stat_entry("/usr/share/applications",0);
    SET_ROOT_TYPE(en->type);
    get_xfdir_local(&xfdir, en, "\\.desktop$");
    /* set icon and exec */
    for (i=0; i<xfdir.pathc; i++){
        gchar *name;
	if (g_file_test(xfdir.gl[i].en->path,G_FILE_TEST_IS_DIR)) continue;
	name=get_desktop_string("Name", xfdir.gl[i].en->path);
        if (name) {
	    g_free(xfdir.gl[i].pathv);
	    xfdir.gl[i].pathv=name;
	}
	xfdir.gl[i].en->exec=get_desktop_string("Exec", xfdir.gl[i].en->path);
	xfdir.gl[i].en->icon=get_desktop_string("Icon", xfdir.gl[i].en->path);
	if (xfdir.gl[i].en->icon && !MIME_ICON_check4icon_path(xfdir.gl[i].en->icon)) 
	{
	    g_warning("icon not found: %s",xfdir.gl[i].en->icon);
	    xfdir.gl[i].en->icon=g_strdup("xfce/default");
	} 
    }
    return(&xfdir);
}

