
/*
 *
 * Edscott Wilson Garcia 2001-2005 for xfce project.
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



static xfmime_icon_functions *xfmime_icon_fun=NULL;
static GHashTable *theme_hash = NULL;
static GHashTable *icon_hash = NULL;
static GtkIconFactory *icon_factory = NULL;
static gchar *icon_theme_name=NULL;


/* this checks for the existence of the xxx.mime.xml file, which associates
 * filenames with mimetypes... (may be created with xfmime-edit) */

/* FIXME: create a fallback xml file for iconname/mimetype association
 * (gnome-ish, probably) and use this as well as any user specified
 * file created with xfmime-edit. This is now possible with the xfce-icontheme
 * feature of trying several filenames for rendering an icon...
 * 
 * After doing this, xfmime-edit will probably be broken and need fixing.
 * */

static gboolean is_valid_theme_dir(gchar *theme_dir){
    gchar *b=g_path_get_basename(theme_dir);
    gchar *g=g_strconcat(PACKAGE_DATA_DIR,G_DIR_SEPARATOR_S,
	    "xffm",G_DIR_SEPARATOR_S,
	    b,".mime.xml",NULL);
	/*printf("is_valid_theme_dir --->%s? \n",theme_dir);
	printf("is_valid_theme --->%s? \n",g);*/
    if (!g_file_test(theme_dir,G_FILE_TEST_IS_DIR)) return FALSE;
    if (g_file_test(g,G_FILE_TEST_EXISTS)){
        g_free(g);
	/*printf("is_valid_theme_dir --->%s? yes\n",g);*/
	return TRUE;
    } else {
	g_free(g);
	g=mime_icon_get_local_xml_file(theme_dir);
        if (g_file_test(g,G_FILE_TEST_EXISTS)){
	/*printf("is_valid_theme_dir --->%s? yes\n",g);*/
	  g_free(g); 
	  return TRUE;	   
        }
        g_free(g); 
    }
    return FALSE;
}
static void start_element (GMarkupParseContext *context,
                          const gchar         *element_name,
                          const gchar        **attribute_names,
                          const gchar        **attribute_values,
                          gpointer             user_data,
                          GError             **error){
    int i;
    gchar *name=NULL,*icon=NULL;
      /*printf("start -> %s\n",element_name);*/
      /* here we should have the type and icon attributes set,
       * but they are not :-(
       * */
    if (strcmp(element_name,"mime-type")) return;
    if (attribute_names) {
	for (i=0;attribute_names[i];i++) 
	  if (attribute_names[0] && attribute_values[0]) 
	      name=g_strdup(attribute_values[0]);
	  if (attribute_names[1] && attribute_values[1]) 
	      icon=g_strdup(attribute_values[1]);
	  
          if (name && icon) {
		g_hash_table_insert(icon_hash, name, (gpointer) icon);
	      TRACE("hashing %s=%s\n",name,icon);
	  }
	  else if (name) {	      
	      TRACE("no icon defined for %s\n",name);
	      g_free(name);
	  }

      }
      return;
  }

static gchar **mime_icon_get_inherits(const gchar *theme){
    gchar *theme_path;
    gchar **inherits=NULL;

    theme_path=mime_icon_get_theme_path(theme);
    if (!theme) return NULL;
     
	TRACE("inherit themepath=%s\n",theme_path);
       
    /* inherited paths... */

    {
        XfceRc *themefile;
        gchar *themeindex;
          
	themeindex = g_build_path(G_DIR_SEPARATOR_S, theme_path, "index.theme", NULL);
        themefile = xfce_rc_simple_open(themeindex, TRUE);
        g_free(themeindex);
	if (themefile){
            xfce_rc_set_group(themefile, "Icon Theme");
	    inherits = xfce_rc_read_list_entry(themefile, "Inherits", ",");
	    xfce_rc_close(themefile);
        }
    }
    return inherits;
}


static void clear_iconhash(gpointer key, gpointer value, gpointer user_data)
{
    if (key) g_free(key);
    if (value) g_free(value);
}




static void glib_parser(const gchar *mimefile){
  FILE *f;
  size_t l;
  gchar line[81];
  GMarkupParseContext *context; 
  GError *error=NULL; 
  GMarkupParser parser={
      start_element,
      NULL, 
      NULL, /*text_fun,*/
      NULL,
      NULL
  };
  gpointer user_data=NULL;

  TRACE("parsing %s",mimefile);
  context=g_markup_parse_context_new(&parser,0,user_data,NULL);
  f=fopen(mimefile,"r");
  if (!f){
      printf("sh*t, cannot open %s\n",mimefile);
      return;
  }
  while(!feof(f) && (l=fread(line,1,80,f))!=0) {
      line[l]=0;
      g_markup_parse_context_parse (context,line,l,&error);
  }
  fclose(f);
  
  g_markup_parse_context_free (context);
}

static int create_icon_hash(void){
    gchar *mimefile = NULL;

    theme_info_t *theme_info;  

    TRACE("create_icon_hash...\n");

    /*g_free(icon_theme_name);*/

    
#if GTK_CHECK_VERSION (2,4,0)
    g_object_get (gtk_settings_get_default(), "gtk-icon-theme-name", &icon_theme_name, NULL);
#else /* gtk < 2.4 */
    {
      GtkSettings *gsettings = gtk_settings_get_default ();
      g_object_get (G_OBJECT (gsettings), "gtk-icon-theme-name", &icon_theme_name, NULL);
    }
#endif

    /* test for validity */
    if (icon_theme_name && !strcmp(icon_theme_name,"Rodent")==0 && !strcmp(icon_theme_name,"Gnome")==0 && !strcmp(icon_theme_name,"gnome")==0) icon_theme_name=NULL;
    
#ifndef HAVE_RODENT_ICONS     
    if (icon_theme_name && strcmp(icon_theme_name,"Rodent")==0)
	icon_theme_name=NULL;
#endif  
#ifndef HAVE_GNOME_ICONS     
    if (icon_theme_name && strcmp(icon_theme_name,"Gnome")==0)
	icon_theme_name=NULL;
    if (icon_theme_name && strcmp(icon_theme_name,"gnome")==0)
	icon_theme_name=NULL;
#endif  

    

#ifdef HAVE_RODENT_ICONS     
    if (!icon_theme_name)	icon_theme_name="Rodent";
#else
#ifdef HAVE_GNOME_ICONS
    if (!icon_theme_name)	icon_theme_name="Gnome";
#else
    g_warning
    if (!icon_theme_name)	icon_theme_name="hicolor";
#endif    
#endif    
    TRACE("hey: iconthemename=%s\n",icon_theme_name);

fallback:
    /* we specify the icon size to use the best match cache */
    if (open_theme(icon_theme_name, 48)==-1) {
	TRACE("icon_hash already exists...\n");
	return -1;
    }
    
	

   /* test for user defined mimefile (via xfmime-edit)*/
   mimefile= mime_icon_get_local_xml_file(icon_theme_name);
    TRACE("create_icon_hash from local?...%s\n",mimefile);

   /* test for default mimefile (xfce distributed)  */
   if (!mimefile || !g_file_test(mimefile,G_FILE_TEST_EXISTS)) {
       g_free(mimefile);
	mimefile=mime_icon_get_global_xml_file(icon_theme_name);
      TRACE("no local. create_icon_hash from global?\n");
   }
   
   if (!mimefile || !g_file_test(mimefile,G_FILE_TEST_EXISTS)) {
       TRACE("create_icon_hash: no mime theme found for %s",icon_theme_name);
       g_free(mimefile);
#ifdef HAVE_RODENT_ICONS     
       if (strcmp("Rodent",icon_theme_name)==0) return 1;
       else {
	   icon_theme_name="Rodent";
	   goto fallback;
       }
#else
#ifdef HAVE_GNOME_ICONS
    /* no Rodent, must be gnome lying around... */
       if (strcmp("gnome",icon_theme_name)==0) return 1;
       else {
	   icon_theme_name="gnome";
	   goto fallback;
       }
#endif
#endif      
    }
   
    if (theme_hash==NULL) {
	    TRACE("creating new theme_hash...\n");
	    theme_hash = g_hash_table_new(g_str_hash, g_str_equal);
    }

    theme_info = g_hash_table_lookup(theme_hash,icon_theme_name);
    if (!theme_info){
        TRACE("creating new icon hash and factory for %s\n",icon_theme_name);
	theme_info = (theme_info_t *)malloc(sizeof(theme_info_t));
    	theme_info->icon_hash = icon_hash = g_hash_table_new(g_str_hash, g_str_equal);
    	theme_info->icon_factory = icon_factory = gtk_icon_factory_new();
	g_hash_table_insert(theme_hash, g_strdup(icon_theme_name), (gpointer) theme_info);	
    } 
    else {
	    icon_hash = theme_info->icon_hash;
	    icon_factory = theme_info->icon_factory;
	    g_free(mimefile);
	    return 1;
    }
    
    glib_parser(mimefile);
   
    g_free(mimefile);mimefile=NULL;
	    
    TRACE("theme_hash created for %s!\n",icon_theme_name);
    return 1;
}




/**********************************************************************************************/

