

/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

static time_t initial,deltatime;
static xffind_functions *xffind_fun=NULL;

static xfc_combo_info_t *find_combo_info=NULL;
static xfc_combo_info_t *findpath_combo_info=NULL;
static xfc_combo_info_t *findgrep_combo_info=NULL;


static gint stop_watch;
static short int findCount;	/* how many files found */
static short int fileLimit = 64;
static gboolean cancelled;
static pid_t Gpid;

static GList *type_list = NULL;
static GList *find_results_list = NULL;
static xfdir_t find_xfdir;
/*static char *find_path;*/

static GtkTreeView *find_treeview;
static GtkTreeIter results_iter;

static void on_find_clicked_wrapper(GtkEntry *entry,gpointer data);

static void destroy(GtkWidget * widget, gpointer data);
static void on_find_clicked(GtkButton * button, gpointer user_data);
static void on_find_close(GtkButton * button, gpointer data);
static void on_help_filter(GtkToggleButton * button, gpointer user_data);
static void on_help_grep(GtkToggleButton * button, gpointer user_data);
static char *ftypes[] = {
    N_("Any kind"),
    N_("Regular"),
    N_("Directory"),
    N_("Symlink"),
    N_("Socket"),
    N_("Block device"),
    N_("Character device"),
    N_("FIFO"),
    NULL
};
static char *ft[] = {
    "any",
    "f",
    "d",
    "l",
    "s",
    "b",
    "c",
    "p",
    NULL
};


static void save_ff_text(char *p)
{				
    gchar *fname;
    if (!p || !strlen(p)) return;
    {
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	fname=g_build_filename(xdg_dir,FIND_DBH_FILE,NULL);
	g_free(xdg_dir);
    }
    XFC_save_to_history(fname,p);
    g_free(fname);
}
static void save_fpath_text(char *p)
{				
    gchar *fname;
    TRACE("save_fpath_text-> %s",p);
    if (!p || !strlen(p)) return;
    {
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	fname=g_build_filename(xdg_dir,FIND_PATHS_DBH_FILE,NULL);
	g_free(xdg_dir);
    }
    TRACE("saving to history-> %s",p);
    XFC_save_to_history(fname,p);
    g_free(fname);
}
static void save_fgrep_text(char *p)
{				
    gchar *fname;
    if (!p || !strlen(p)) return;
    {
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	fname=g_build_filename(xdg_dir,FIND_GREP_DBH_FILE,NULL);
	g_free(xdg_dir);
    }
    XFC_save_to_history(fname,p);
    g_free(fname);
}


static void find_over(void)
{
    gint tree_id = (*xffm_details->arbol->get_active_tree_id)();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;

    GtkTreePath *treepath;
    GtkTreeIter iter;
    record_entry_t *en;

    (*xffm_details->arbol->unset_load_wait)();
    (*xffm_details->arbol->get_module_root)(treeview, &iter, &en,"xffm_find");
    (*xffm_details->arbol->erase_dummy_row)(treemodel, &iter,NULL);
    treepath = gtk_tree_model_get_path(treemodel, &iter);
    gtk_tree_view_expand_row(treeview, treepath, FALSE);
    gtk_tree_path_free(treepath);

    (*xffm_details->arbol->erase_dummy_row)(treemodel, &results_iter,NULL);
    if(!findCount){
	TRACE("Nothing found");
	(*xffm_details->arbol->insert_dummy_row)(treemodel,  &results_iter,NULL,NULL,"xfce/info",_("Nothing found"));	
    }
    

    treepath = gtk_tree_model_get_path(treemodel, &results_iter);
    gtk_tree_view_expand_row(treeview, treepath, FALSE);

    /* scroll is in callbacks.c, open_dir(), 
     * but only called if preference enabled */
    gdk_flush();
    gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
    gtk_tree_path_free(treepath);
    
    g_source_remove(stop_watch);
    {
	gchar *g=g_strdup_printf(_("%ld seconds"),(long)(time(NULL) - initial));
	print_status(&(xffm_details->arbol->widgets),"xfce/info","fgr ",g,NULL);
	g_free(g);
    }
} 

static GtkTreeIter add_find_results(GtkTreeView * treeview, char *name)
{
    GtkTreeIter iter;
    record_entry_t *en, *c_en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    gchar *b;

    (*xffm_details->arbol->get_module_root)(treeview, &iter, &en,"xffm_find");

    c_en = mk_entry(en->type);
    c_en->path = g_strdup(name);
    SET_XF_FND(c_en->type);
    b=g_path_get_basename(name);
    if (!(*xffm_details->arbol->add_row)(treemodel,&iter,NULL,&results_iter,c_en,b))
    {
	(*xffm_details->arbol->set_icon)(treemodel, &results_iter);
	(*xffm_details->arbol->insert_dummy_row)(treemodel, &results_iter,NULL,c_en,NULL,NULL);
	g_warning("could not add row");
    }
    g_free(b);
    return results_iter;
}

static void add_find_results_content(void)
{
    GList *tmp;
    int i;
    record_entry_t *en;
    GtkTreeIter iter, child;
    GtkTreePath *treepath;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(find_treeview);


    gtk_tree_model_get(treemodel, &results_iter, ENTRY_COLUMN, &en, -1);

    if(findCount)
    {
	find_xfdir.pathc = findCount;
	find_xfdir.gl = (dir_t *) malloc(findCount * sizeof(dir_t));
	if(!find_xfdir.gl)
	    assert_not_reached();
	for(i = 0; i < find_xfdir.pathc; i++)
	    find_xfdir.gl[i].pathv = NULL;

	tmp = find_results_list;
	for(i = 0; i < find_xfdir.pathc; i++)
	{
	    char *name;
	    if(!tmp)
		assert_not_reached();

	    if(!strchr((char *)tmp->data, '/'))
		assert_not_reached();
	    name = strrchr((char *)tmp->data, '/');
	    if(strlen(name) == 1)
		name = "/";
	    else
		name++;
	    find_xfdir.gl[i].pathv = g_strdup(name);
	    find_xfdir.gl[i].en = stat_entry((char *)tmp->data, en->type);
	    if(!find_xfdir.gl[i].en){
		/* file has dissappeared ! */  
		find_xfdir.pathc--;
		g_free(find_xfdir.gl[i].pathv);
		find_xfdir.gl[i].pathv=NULL;
	        i--;
		/*assert_not_reached();*/
	    }
	    g_free((char *)tmp->data);
	    tmp->data=NULL;
	    tmp = tmp->next;
	}
	if(find_results_list)
	    g_list_free(find_results_list);
	find_results_list = NULL;
	
	hide_stop(&(xffm_details->arbol->widgets));

    	if (find_xfdir.pathc){
	  (*xffm_details->arbol->add_contents_row)(treemodel, &results_iter, &find_xfdir);
	  (*xffm_details->arbol->get_module_root)(find_treeview, &iter, &en,"xffm_find");
	  (*xffm_details->arbol->erase_dummy_row)(treemodel, &iter,NULL);
	  /* collapse all */
	  if(gtk_tree_model_iter_children(treemodel, &child, &iter))
	  {
	    do
	    {
		treepath = gtk_tree_model_get_path(treemodel, &child);
		gtk_tree_view_collapse_row(find_treeview, treepath);
		gtk_tree_path_free(treepath);
	    }
	    while(gtk_tree_model_iter_next(treemodel, &child));
	  }
	}
	
	xfdirfree(&find_xfdir);
    }
}



/****************************************************************/

static void abort_because_of_limit(GtkWidget * widget)
{
    if(xffm_details->arbol->widgets.tubo_object)
    {
	/*gchar *message;*/
	/*gchar *m=g_strdup_printf("%d", Gpid);
	print_diagnostics(&(xffm_details->arbol->widgets),"xfce/stock_no" , strerror(ECANCELLED)," pid=", m,"\n", NULL);
	g_free(m);*/
	
	cancelled = TRUE;
	TuboCancel(xffm_details->arbol->widgets.tubo_object, NULL);
	xffm_details->arbol->widgets.stop = FALSE;
	xffm_details->arbol->widgets.tubo_object = NULL;
	Gpid = 0;
	/*message = g_strdup_printf(_("Results limit reached: %d"), fileLimit);
	print_diagnostics(&(xffm_details->arbol->widgets),"xfce/error", message, "\n",NULL);
	g_free(message);*/
	hide_stop(&(xffm_details->arbol->widgets));
	TRACE("find over by abort limit\n"); 
    }
}

static gint watch_stop(gpointer data)
{

    time_t current=time(NULL);
    if (current - initial != deltatime) {
	gchar *g;
	deltatime = current - initial;
	g=g_strdup_printf(_("%ld seconds"),(long)(deltatime));
	print_status(&(xffm_details->arbol->widgets),"xfce/warning","fgr ",g,NULL);
	g_free(g);
    }

    if(!xffm_details->arbol->widgets.tubo_object) return FALSE;
    if(xffm_details->arbol->widgets.stop)
    {
	char m[32];
	sprintf(m, "%d\n", Gpid);
	print_diagnostics(&(xffm_details->arbol->widgets),"xfce/stock_no", strerror(ECANCELLED), " pid=", m, "\n",NULL);
	cancelled = TRUE;
	TuboCancel(xffm_details->arbol->widgets.tubo_object, NULL);
	xffm_details->arbol->widgets.stop = FALSE;
	xffm_details->arbol->widgets.tubo_object = NULL;
	print_status(&(xffm_details->arbol->widgets),"xfce/info", strerror(ECANCELLED), NULL);
	hide_stop(&(xffm_details->arbol->widgets));
	Gpid = 0;
	return FALSE;
    }
    {
	
    }
    set_progress_generic(&(xffm_details->arbol->widgets),-1, -1,1);
    return TRUE;
}

static int operate_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    print_diagnostics(&(xffm_details->arbol->widgets),"xfce/error", line, NULL);
    return TRUE;
}

static int operate_stdout(int n, void *data)
{
    char *line;
    char *filename;

    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;



    if(xffm_details->arbol->widgets.stop || cancelled)
    {
	return (TRUE);
    }
    TRACE("line=%s\n",line);
    if(line[0] == G_DIR_SEPARATOR)
    {
	if(findCount >= fileLimit){
	    abort_because_of_limit(NULL);
	}
	else
	{
	    char *path, *linecount = NULL;

	    path =line;
	    if(strstr(path, "\n")) path = strtok(path, "\n");
	    if(strstr(path, ":"))
	    {
		/* some filenames with colons exist! */
		if(!g_file_test(path, G_FILE_TEST_EXISTS))
		{
		    /* but not this one */
		    linecount = strrchr(path, ':') + 1;
		    *(strrchr(path, ':')) = 0;
		    if(strcmp(linecount, "0") == 0)
		    {
			linecount = NULL;
			return TRUE;
		    }
		}
	    }


	    findCount++;
	    find_results_list = g_list_append(find_results_list, g_strdup(path));
	    filename = strrchr(path, G_DIR_SEPARATOR) + 1;

	    print_diagnostics(&(xffm_details->arbol->widgets),NULL, path, "\n", NULL);
	}
    }
    else
    {
	print_diagnostics(&(xffm_details->arbol->widgets),NULL, line, NULL);
    }
    return TRUE;
}


static void fork_finished_function(pid_t pid)
{
    /*gchar *m=g_strdup_printf("%d", pid);
    print_diagnostics(&(xffm_details->arbol->widgets),"xfce/stock_no", strerror(ESRCH)," pid=", m,"\n", NULL);
    g_free(m);*/
    xffm_details->arbol->widgets.tubo_object = NULL;
    hide_stop(&(xffm_details->arbol->widgets));
    cursor_reset(xffm_details->arbol->widgets.window);

    
    if(findCount)
    {
	gchar *mess;
	if (findCount >= fileLimit) {
	  gchar *message = g_strdup_printf(_("Results limit reached: %d"), fileLimit);
	  print_diagnostics(&(xffm_details->arbol->widgets),"xfce/error", message, "\n",NULL);
	  g_free(message);
	}
	mess = g_strdup_printf(_("Files found=%d"), findCount);
	print_diagnostics(&(xffm_details->arbol->widgets),"xfce/stock_no",  mess, "\n", NULL);
	g_free(mess);
	add_find_results_content();

    }
    else
    {
	print_diagnostics(&(xffm_details->arbol->widgets), "xfce/stock_no", strerror(ENOENT), "\n",NULL);
	print_status(&(xffm_details->arbol->widgets), "xfce/warning", strerror(ENOENT), NULL);
    }
    TRACE("find over by fork_finished_function\n"); 
    find_over();
}

static gchar *get_combo_entry(GtkEntry * entry, xfc_combo_info_t *combo_info)
{
    const gchar *choice;
    static gchar *s = NULL;
    
    g_free(s);
    s=NULL;
   
    choice = (gchar *)XFC_get_entry(combo_info);

    if (choice) s = g_strdup(choice);
    if (s) s = g_strchug(s);
    if (s) s = g_strchomp(s);
    if (!s) s=g_strdup("");
    
    return s;
}



/******  internal callbacks   *******/

static void destroy(GtkWidget * widget, gpointer data)
{
    TRACE("destroy(find window)\n");
    if(xffm_details->arbol->widgets.tubo_object)
	TuboCancel(xffm_details->arbol->widgets.tubo_object, NULL);
    xffm_details->arbol->widgets.tubo_object = NULL;
    /* kill(Gpid, SIGHUP) is done inside TuboCancel. 
     * What could happen if Gpid is
     * a valid pid when instruction given, but before signal reaches
     * Gpid, the one from TuboCancel kills Gpid first?
     * Where does that signal end up? */
    /* dirty instruction: if(Gpid) kill(Gpid, SIGHUP);*/
    Gpid = 0;
    cursor_reset(xffm_details->arbol->widgets.window);
    gtk_widget_destroy(widget);
}


static void on_find_clicked(GtkButton * button, gpointer data)
{
    short int i, j;
    const gchar *s;
    char *argument[MAX_ARGS];
    GtkWidget *w = (GtkWidget *) button;
    char *find_filter = NULL, *filter = NULL, *path = NULL, *token = NULL;
    gint tree_id = (*xffm_details->arbol->get_active_tree_id)();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;


    if (!GTK_WIDGET_VISIBLE(xffm_details->arbol->widgets.window)){
	gtk_widget_show(xffm_details->arbol->widgets.window);
    }
    gtk_widget_grab_focus((GtkWidget *) treeview);

    if(!(*xffm_details->arbol->set_load_wait)())
    {
	assert_not_reached();
    }
    /* get options */

    cancelled = FALSE;

    if(xffm_details->arbol->widgets.tubo_object)
	TuboCancel(xffm_details->arbol->widgets.tubo_object, NULL);
    xffm_details->arbol->widgets.tubo_object = NULL;
    /* again as above, 
     * dirty instruction:  if(Gpid) kill(Gpid, SIGTERM);
     * */
    Gpid = 0;

    findCount = 0;
/* get the parameters set by the user... *****/

/* limit */
    fileLimit = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(lookup_widget(w, "spinbutton1")));

/* the rest */

    s = get_combo_entry((GtkEntry *) (lookup_widget(w, "path_entry")),findpath_combo_info);
    if(!s || strlen(s) == 0)
	s = "/";
    /* tilde expansion */
    else if(s[strlen(s) - 1] == '~')
	s = "~/";
    /* environment variables */
    else if(s[0] == '$')
    {
	const gchar *p = getenv(s + 1);
	if(p)
	    s = p;
	else
	    s = "/";
    }
    path = g_strdup(s);	
    if (g_file_test(s,G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)){
        save_fpath_text(path);
    }
    s = get_combo_entry((GtkEntry *) lookup_widget(w, "filter_entry"),find_combo_info);
    if(s)
    {
	filter=g_strdup(s);
        save_ff_text(filter);
    }
    

    s = get_combo_entry((GtkEntry *) lookup_widget(w, "grep_entry"),findgrep_combo_info);
    if(s && strlen(s))
    {
	token = g_strdup(s);
	save_fgrep_text(token);
    } else {
	/* if no grep pattern given, its a plain find and
	 * we should show the diagnostics */
	show_text(xffm_details->arbol->widgets.diagnostics);
    }
    /* select list */
    s = string_option_menu_get_selected((GtkOptionMenu *)lookup_widget(w, "file_type_om"));
    
    i = 0;
/*#define USE_FIND   */
#ifdef USE_FIND
    /* special case find: if no grep token needed, best to use FIND */
    if((!token || !strlen(token)) && filter && strlen(filter))
    /*if((!token || !strlen(token)) && (filter && strlen(filter) && !strchr(filter, '?') && !strchr(filter, '*')))*/
    {
 char *find_ft[] = {
    "",
    "f",
    "d",
    "l",
    "s",
    "b",
    "c",
    "p",
    NULL
};
	argument[i++] = FIND;
	/* first argument to FIND must be the path */
	/* but, oho, since symlinks are not followed because of
	 * infinite loop posibilities, if the path is a symlink,
	 * expand to where it points. */
	{
	    struct stat st;
	    lstat(path,&st);
	    if (S_ISLNK(st.st_mode)){
		 static char lpath[_POSIX_PATH_MAX+1];
		 memset(lpath,0,_POSIX_PATH_MAX+1);
		 if (readlink(path, lpath, _POSIX_PATH_MAX)<0) {
		     argument[i++] = path;
		 } else {
		     argument[i++] = lpath;
		     chdir(path); /* the expanded link may be relative... */
		 }
	    } else {
		argument[i++] = path;
	    }
	}
	if(!gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "recursive"))){
	    argument[i++] = "-prune";
	} 
	/* no filter if none specified  */
	if(filter && strlen(filter))
	{
	    if(find_filter){
		g_free(find_filter);
		find_filter=NULL;
	    }
	    if(!gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "case_sensitive"))){
		/*argument[i++] = "-ipath";*/
		argument[i++] = "-iname";
	    } else {
		/*argument[i++] = "-path";*/
		argument[i++] = "-name";
	    }
#if 0
	    find_filter = g_strconcat("*/",filter,NULL);
#endif
	    find_filter = g_strdup(filter);
	    if(!find_filter) assert_not_reached();

	    argument[i++] = find_filter;
	}
	if(gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "xdev")))
	    argument[i++] = "-xdev";

	/* OjO: "any" type is equal to no type specified in FIND 
	 *      so begin with j=1 */
	for(j = 1; ftypes[j] != NULL; j++)
	{
	    if(s && strcmp(s, _(ftypes[j])) == 0 && strlen(find_ft[j]))
	    {
		argument[i++] = "-type";
		argument[i++] = find_ft[j];
		break;
	    }
	}
	{
	  gchar *m=g_strdup_printf(_("Searching for %s at %s"),filter, path);
	  print_diagnostics(&(xffm_details->arbol->widgets),NULL, m, "\n", NULL);
	  g_free(m);
	}
    }
    else
#endif
    {
	argument[i++] = GLOB;

	/*argument[i++] = "-v"; (verbose output from glob for debugging) */
	/*argument[i++] = "-P"; */

	if(gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "recursive"))){
	    if(gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "recursiveH"))){
	      argument[i++] = "-r";
	    } else {
		argument[i++] = "-R";
	    }
		
	} 
	if(!gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "case_sensitive")))
	    argument[i++] = "-i";
	if(gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "xdev")))
	    argument[i++] = "-a";
	if(token)
	{
	    if(gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "ext_regexp")))
		argument[i++] = "-E";
	    else
		argument[i++] = "-e";
	    argument[i++] = token;


	    /* options for grep: ***** */
	    if(gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "no_look_in_binaries")))
		argument[i++] = "-I";
	    /*
	       if (gtk_toggle_button_get_active(
	       (GtkToggleButton *)lookup_widget(w,"output_count")))
	       argument[i++] = "-c"; */
	    /* radio buttons */
	    if(gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "anywhere")))
		;
	    else if(gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "match_words")))
		argument[i++] = "-w";
	    else if(gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "match_lines")))
		argument[i++] = "-x";
	    else if(gtk_toggle_button_get_active((GtkToggleButton *) lookup_widget(w, "match_no_match")))
		argument[i++] = "-L";
	}

	for(j = 0; ftypes[j] != NULL; j++)
	{
	    if(s && strcmp(s, _(ftypes[j])) == 0)
	    {
		argument[i++] = "-t";
		argument[i++] = ft[j];
		break;
	    }
	}


	/* apply wildcard filter if not specified  */
	argument[i++] = "-f";
	if(filter && strlen(filter))
	{
	    argument[i++] = filter;
	}
	else
	{
	    argument[i++] = "*";
	}

	/* last argument to GLOB must be the path */
	argument[i++] = path;
    }
    print_status(&(xffm_details->arbol->widgets),"xfce/warning",strerror(EBUSY), NULL);
    /*{
	GtkTreeIter iter;
	record_entry_t *en;
	GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
	if ((*xffm_details->arbol->get_module_root)(treeview, &iter, &en,"xffm_find")) 
	    (*xffm_details->arbol->reset_dummy_row)(treemodel, &iter,NULL,en,"xfce/info",_("Search begun"));
    }*/

    argument[i] = (char *)0;

    /*for (j=0;j<i;j++) printf ("%s ",argument[j]);printf ("\n"); */


    /* this bugs me:
    show_text(xffm_details->arbol->widgets.diagnostics);
    */
    cursor_wait(xffm_details->arbol->widgets.window);
    /* pango is bugged. Do not print icons if pipe output is to be written
     * to the diagnostics window... */
    print_diagnostics(&(xffm_details->arbol->widgets),"xfce/stock_yes", "$", NULL);
    for(j = 0; j < i; j++)
    {
	print_diagnostics(&(xffm_details->arbol->widgets),NULL, argument[j], " ", NULL);
    }
    print_diagnostics(&(xffm_details->arbol->widgets),NULL, "\n", NULL);

    xffm_details->arbol->widgets.stop = FALSE;

    /*printf("TRACE: show stop at find.c\n"); */

    show_stop(&(xffm_details->arbol->widgets));

    { /* map the find branch if its not shown */
      GtkTreeIter iter;
      record_entry_t *en;
      (*xffm_details->arbol->get_module_root)(treeview, &iter, &en,"xffm_find");
    }
    
    initial=time(NULL);


    xffm_details->arbol->widgets.tubo_object = Tubo(
		    fork_function, 
		    (void *)argument, 
		    fork_finished_function, 
		    NULL, 
		    operate_stdout, operate_stderr,0,
		    TRUE);
    if (!xffm_details->arbol->widgets.tubo_object){
            gtk_widget_destroy(lookup_widget(w, "find_dialog"));
	    print_diagnostics(&(xffm_details->arbol->widgets),"xfce/error",strerror(ECHILD),"\n", NULL);
	    return;
    }
    stop_watch = g_timeout_add_full(0,260, (GtkFunction) watch_stop, (gpointer) treeview,NULL);
    Gpid = TuboPID(xffm_details->arbol->widgets.tubo_object);

    gtk_widget_destroy(lookup_widget(w, "find_dialog"));
    chdir(GETWD); 
    {
	int size = 5;
	char *name;

	size += ((path) ? strlen(path) : 0);
	size += ((filter) ? strlen(filter) : 0);
	size += ((token) ? strlen(token) : 0);

	name = (char *)malloc(size);
	sprintf(name, "%s", path);
	if(strcmp(path, "/") != 0)
	    strcat(name, "/");
	if(filter && strlen(filter))
	    strcat(name, filter);
	if(token && strlen(token))
	{
	    strcat(name, "(");
	    strcat(name, token);
	    strcat(name, ")");
	}
	TRACE("TRACE:size=%d, name=%s\n",size,name); 

	add_find_results(treeview, name);

	g_free(name);
	name=NULL;
    }
    if (token) g_free(token);
    if (filter) g_free(filter);
    if (find_filter) g_free(find_filter);
    if (path) g_free(path);
}

static void on_find_clicked_wrapper(GtkEntry *entry,gpointer data){
      on_find_clicked((GtkButton *)entry, data);
}

static void on_find_close(GtkButton * button, gpointer data)
{
    gtk_widget_hide(lookup_widget((GtkWidget *) button, "find_dialog"));
    while (gtk_events_pending()) gtk_main_iteration();
    destroy(lookup_widget((GtkWidget *) button, "find_dialog"), NULL);
    if (!GTK_WIDGET_VISIBLE(xffm_details->arbol->widgets.window)) exit(1);
}

static void on_help_filter(GtkToggleButton * button, gpointer user_data)
{
    if(gtk_toggle_button_get_active(button))
	showit((GtkWidget *) button, "scrolledwindow8");
    else
	hideit((GtkWidget *) button, "scrolledwindow8");

}

static void on_help_grep(GtkToggleButton * button, gpointer user_data)
{
    if(gtk_toggle_button_get_active(button))
	showit((GtkWidget *) button, "scrolledwindow9");
    else
	hideit((GtkWidget *) button, "scrolledwindow9");

}


