

/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/wait.h>
#include <limits.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#ifdef HAVE_LIBXFCEGUI4
#include <libxfcegui4/libxfcegui4.h>
#endif

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "secondary.h"
#include "actions_lib.h"

#include "tubo.h"

#define HISTORY_LIMIT 20
#define GLOB "fgr"
#define FIND "find"

#include "find-module.h"
#include "find-module_gui.h"
#include "find-module_option_menu.h"
#include "find-module.i"

   
G_MODULE_EXPORT
void do_find_path(GtkWidget * widget,const char *path){
    GtkWidget *find_dialog;
    GtkCombo *combo;
    GtkCombo *combopath;
    GtkCombo *combogrep;
    TRACE("do_find_path now, path is %s",path);
    if (!xffm_details->arbol)  {
	    gchar *argv[3]={"xfglob4",NULL,NULL};
	    argv[1]=(char *)path;
	    xffm_runvwd(&(xffm_details->arbol->widgets),g_get_home_dir(),argv);
	    return;
    }
    else {
	gint tree_id = (*xffm_details->arbol->get_active_tree_id)();
	find_treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    }
     
    find_dialog = create_find_dialog(&(xffm_details->arbol->widgets));
    combo=(GtkCombo *)lookup_widget(find_dialog, "filter_combo");
    combopath=(GtkCombo *)lookup_widget(find_dialog, "path_combo");
    combogrep=(GtkCombo *)lookup_widget(find_dialog, "grep_combo");
    gtk_widget_show(find_dialog);
    gtk_window_set_transient_for(GTK_WINDOW(find_dialog), GTK_WINDOW(xffm_details->arbol->widgets.window));

    g_signal_connect(G_OBJECT(lookup_widget(find_dialog, "find_button")), "clicked", G_CALLBACK(on_find_clicked), (gpointer) find_treeview);
    g_signal_connect(G_OBJECT(lookup_widget(find_dialog, "close_button")), "clicked", G_CALLBACK(on_find_close), (gpointer) find_treeview);    
    g_signal_connect(G_OBJECT(lookup_widget(find_dialog, "togglebutton2")), "toggled", G_CALLBACK(on_help_filter), NULL);
    g_signal_connect(G_OBJECT(lookup_widget(find_dialog, "togglebutton3")), "toggled", G_CALLBACK(on_help_grep), NULL);

    g_signal_connect(G_OBJECT(find_dialog), "destroy_event", G_CALLBACK(destroy), (gpointer) find_treeview);
    g_signal_connect(G_OBJECT(find_dialog), "delete_event", G_CALLBACK(destroy), (gpointer) find_treeview);

    
    if (findgrep_combo_info) findgrep_combo_info=XFC_destroy_combo(findgrep_combo_info);
    {
      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
      gchar *f=g_build_filename(xdg_dir,FIND_GREP_DBH_FILE,NULL);

      g_free(xdg_dir);
      findgrep_combo_info = XFC_init_combo(combogrep);

      findgrep_combo_info->activate_func = on_find_clicked_wrapper;
      findgrep_combo_info->activate_user_data = (gpointer) find_treeview;
      
      XFC_read_history(findgrep_combo_info,f);
      g_free (f);    
    }
    XFC_set_blank(findgrep_combo_info);
    
    if (find_combo_info) find_combo_info=XFC_destroy_combo(find_combo_info);
    {
      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
      gchar *f=g_build_filename(xdg_dir,FIND_DBH_FILE,NULL);

      g_free(xdg_dir);
      find_combo_info = XFC_init_combo(combo);

      find_combo_info->activate_func = on_find_clicked_wrapper;
      find_combo_info->activate_user_data = (gpointer) find_treeview;
      
      XFC_read_history(find_combo_info,f);
      g_free (f);    
    }
    XFC_set_blank(find_combo_info);
    
    if (findpath_combo_info) findpath_combo_info=XFC_destroy_combo(findpath_combo_info);
    {
      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
      gchar *f=g_build_filename(xdg_dir,FIND_PATHS_DBH_FILE,NULL);

      g_free(xdg_dir);
      findpath_combo_info = XFC_init_combo(combopath);

      findpath_combo_info->activate_func = on_find_clicked_wrapper;
      findpath_combo_info->activate_user_data = (gpointer) find_treeview;
      TRACE("apth is %s",path);
      if (path && strlen(path) && g_file_test(path,G_FILE_TEST_EXISTS)){
	  if (!g_file_test(path,G_FILE_TEST_IS_DIR)){
	    gchar *dir=g_path_get_dirname(path);
	    save_fpath_text(dir);
	    TRACE("dir then is %s",dir);
	    g_free(dir);
	  } else {
	    TRACE("path then is %s",path);
	    save_fpath_text((gchar *)path);
	  }
      }
 
      XFC_read_history(findpath_combo_info,f);
      g_free (f);    
    }  
    
    XFC_set_combo (findpath_combo_info,NULL);

    if(!type_list)
    {
	int i;
	for(i = 0; ftypes[i] != NULL; i++)
	{
	    type_list = g_list_append(type_list, _(ftypes[i]));
	}

    }
    fill_string_option_menu ((GtkOptionMenu *) lookup_widget(find_dialog, "file_type_om"), type_list);
#if 0
    gtk_option_menu_set_history ((GtkOptionMenu *) lookup_widget(find_dialog, "file_type_om"), 1); /* preselects "Normal File" */
#endif
    
    gtk_label_set_text((GtkLabel *) lookup_widget(find_dialog, "filter_help"), _("Basic rules:\n" "\n" "*  Will match any character zero or more times.\n" "?  Will match any character exactly one time\n"));
    gtk_label_set_text((GtkLabel *) lookup_widget(find_dialog, "regexp_help"),
		       _("Reserved characters for extended regexp are\n"
			 ". ^ $ [ ] ? * + { } | \\ ( ) : \n"
			 "In  basic regular expressions the metacharacters\n"
			 "?, +, {, |, (, and ) lose their special meaning.\n"
			 "\n"
			 "The  period  .   matches  any  single  character.\n"
			 "The caret ^ matches at the start of line.\n"
			 "The dollar $ matches at the end of line.\n" "\n"
			 "Characters within [ ] matches any single \n"
			 "       character in the list.\n"
			 "Characters within [^ ] matches any single\n"
			 "       character *not* in the list.\n"
			 "Characters inside [ - ] matches a range of\n"
			 "       characters (ie [0-9] or [a-z]).\n" "\n"
			 "A regular expression may be followed by one\n"
			 "       of several repetition operators:\n"
			 "?      The preceding item is optional and matched\n"
			 "       at most once.\n"
			 "*      The preceding item will be matched zero\n"
			 "       or more times.\n"
			 "+      The preceding item will be matched one or\n"
			 "       more times.\n"
			 "{n}    The preceding item is matched exactly n times.\n"
			 "{n,}   The preceding item is matched n or more times.\n" "{n,m}  The preceding item is matched at least n times,\n" "       but not more than m times.\n" "\n" "To match any reserved character, precede it with \\. \n" "\n" "Two regular expressions may be joined by the logical or\n" "       operator |.\n" "Two regular expressions may be concatenated.\n" "\n" "More information is available by typing \"man grep\"\n" "       at the command prompt.\n"));

}


G_MODULE_EXPORT
void do_find(GtkWidget * widget){
    record_entry_t *en;
    gchar *path=NULL;
    GtkTreeIter iter;
    TRACE("do_find now");
    if (!xffm_details->arbol || !xffm_details->arbol->widgets.window)  {
	    gchar *argv[3]={"xfglob4",NULL,NULL};	    
	    xffm_runvwd(&(xffm_details->arbol->widgets),g_get_home_dir(),argv);
	    return;
    }
    if(xffm_details->arbol->widgets.tubo_object)
    {
	if (xffm_details->arbol->widgets.window)
	    print_status(&(xffm_details->arbol->widgets),"xfce/error", strerror(EALREADY), NULL);
	else
	    g_warning(strerror(EALREADY));
	return;
    }
    if (xffm_details->arbol->widgets.window && GTK_WIDGET_VISIBLE(xffm_details->arbol->widgets.window)){
      en = (*xffm_details->arbol->get_selected_entry)(&iter);
      if(en && en->path && g_file_test(en->path,G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)) {
	  if (g_file_test(en->path,G_FILE_TEST_IS_DIR)) path=g_strdup(en->path);
	  else path=g_path_get_dirname(en->path);
      }
    }    
    /* use last path from history */
    /*if (!path) path=g_strdup(g_get_home_dir());
    if (!path) path=g_strdup("/");*/
    do_find_path(widget,(const gchar *)path);
    g_free(path);
}



G_MODULE_EXPORT
xffind_functions *module_init(void){
#ifdef ENABLE_NLS
    /* This is required for UTF-8 at least - Please don't remove it */
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);
#endif
    xffind_fun = g_new0 (xffind_functions,1);
    if (!xffind_fun) g_assert_not_reached();
    xffind_fun->do_find=do_find;
    xffind_fun->do_find_path=do_find_path; 
    return xffind_fun;
}



