/***********************************************************************************/

/***********************************************************************************/

static
void remove_menu_item (GtkWidget *widget, gpointer data){
    TRACE("removing 0x%x",(unsigned)widget);
    gtk_widget_destroy(widget);
}




static
GtkWidget * 
common_mk_popup_menu (	widgets_t *widgets_p, 
			GtkWidget *parent,
			GtkAccelGroup *accel_group,
			void *data)
{
  /*GtkAccelGroup *accel_group;*/
  GtkWidget *w;
  GtkWidget *item22_menu;
  GtkWidget *sort1_menu;
  icon_view_t *icon_view_p=(icon_view_t *)data;
  

  /* shift mask: */
    /*add_to_keylist(accel_key, accel_mask,  callback,  callback_data);*/
    gui_add_to_keylist(GDK_Home, GDK_SHIFT_MASK,  gridview_home_activate);
    gui_add_to_keylist(GDK_Down, GDK_SHIFT_MASK,  gridview_jump_to_activate);
    gui_add_to_keylist(GDK_Left, GDK_SHIFT_MASK,  gridview_back_activate);
    gui_add_to_keylist(GDK_Up, GDK_SHIFT_MASK,  gridview_up_activate);
  

#ifdef USE_ACCEL_LABELS
  if (!accel_group) {
    accel_group = gtk_accel_group_new ();
    gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);
  }
#endif
  
  item22_menu=gui_mk_menu(
	  widgets_p,
	  "item22", /* label */
	  "item22",   /* name */
	  parent, 	  /* parent */
	  NULL,NULL); /* callback (or NULL)*/
  w=gui_mk_menu(
	  widgets_p,
	  "", /* label */
	  "module1",   /* name */
	  item22_menu, 	  /* parent */
	  NULL,	/* callback (or NULL)*/
	  NULL); /* iconfile (or NULL)*/

  /* common menu items */

   {
    gchar *string[5]={N_("Go back"),N_("Reload"),N_("Go to"),NULL};
    gchar *iconfile[5]={"xfce/stock_go-back","xfce/stock_refresh","xfce/stock_jump-to",NULL};
    gchar *id[5]={"go_back_menuitem","refresh3","goto2",NULL};
    void *callback[5]={gridview_back_activate,gridview_refresh_activate,gridview_jump_to_activate,NULL};
    guint akey[5]={GDK_Left,GDK_z,GDK_Down,0};
    int i;

    for (i=0; string[i]; i++){
 	gui_add_menu_item(widgets_p,
		    item22_menu,
		    _(string[i]),
		    iconfile[i],
		    id[i],
		    callback[i],
		    data,
		    ((akey[i])?accel_group:NULL),akey[i], GDK_CONTROL_MASK);
    }
   }

    gui_add_menu_item(widgets_p,item22_menu,
		OUR_HOST_NAME(&(icon_view_p->widgets)), 
		"xfce/stock_system","host2", 
		gridview_host_activate, 
		data,
		accel_group, GDK_End, GDK_CONTROL_MASK);
		
    gui_add_menu_item(widgets_p,item22_menu,
		_("Home"), 
		"xfce/stock_home","home2", 
		gridview_home_activate, 
		data,
		accel_group, GDK_Begin, GDK_CONTROL_MASK);
    
   {
    gchar *string[3]={N_("Detailed view"),N_("Icon view"),NULL};
    gchar *iconfile[3]={"xfce/stock_indent","xfce/b-iconview",NULL};
    gchar *id[3]={"opentreeview","openiconview",NULL};
    void *callback[3]={on_treeview_activate,on_iconview_activate,NULL};
    guint akey[3]={GDK_n,0,0};
    int i;

    for (i=0; string[i]; i++){
 	gui_add_menu_item(widgets_p,item22_menu,
		    _(string[i]),
		    iconfile[i],
		    id[i],
		    callback[i],
		    data,
		    ((akey[i])?accel_group:NULL),akey[i], GDK_CONTROL_MASK);
    }
   }

   w=gui_add_menu_separator(item22_menu);
   GLADE_HOOKUP_OBJECT (widgets_p->window, w, "iv_separator00");

  w = gtk_check_menu_item_new_with_mnemonic (_("Show hidden"));
  gtk_widget_show (w);
  gtk_container_add (GTK_CONTAINER (item22_menu), w);
  GLADE_HOOKUP_OBJECT (widgets_p->window, w, "show_hidden_menuitem");
  g_signal_connect ((gpointer) w, "toggled",
                    G_CALLBACK (gridview_hidden_toggled),
                    data);

  w = gtk_check_menu_item_new_with_mnemonic (_("Preview images"));
  gtk_container_add (GTK_CONTAINER (item22_menu), w);
  GLADE_HOOKUP_OBJECT (widgets_p->window, w, "preview_images_menuitem");
#if 0
  if (data){
      if (!icon_view_p->en || 
	      (icon_view_p->en && icon_view_p->en->type &__SHOW_IMAGES)){
	gtk_check_menu_item_set_active((GtkCheckMenuItem *)w,TRUE);
      }
  }
#endif
  gtk_widget_show (w);
  g_signal_connect ((gpointer) w, "toggled",
                    G_CALLBACK (gridview_preview_toggled),
                    data);

   {
    gchar *string[4]={N_("Open with ..."),"","",NULL};
    gchar *iconfile[4]={"xfce/stock_open","xfce/stock_run","xfce/stock_run",NULL};
    gchar *id[4]={"open_with_menuitem","autotype_R","autotype_Prun",NULL};
    void *callback[4]={on_open_with_activate,on_autotype_R,NULL,NULL};
    guint akey[4]={GDK_o,0,0,0};
    int i;

    for (i=0; string[i]; i++){
 	gui_add_menu_item(widgets_p,item22_menu,
		    _(string[i]),
		    iconfile[i],
		    id[i],
		    callback[i],
		    data,
		    ((akey[i])?accel_group:NULL),akey[i], GDK_CONTROL_MASK);
    }
   }

   
    w=gui_add_menu_separator(item22_menu);
    GLADE_HOOKUP_OBJECT (widgets_p->window, w, "iv_separator_cut");
    
    /* abstract menu items */
    
   {
    gchar *string[7]={N_("Cut"),N_("Copy"),N_("Paste"),N_("Paste link"),N_("Remove"),N_("Properties"),NULL};
    gchar *iconfile[7]={"xfce/stock_cut","xfce/stock_copy","xfce/stock_paste","xfce/stock_pastelink","xfce/stock_delete","xfce/stock_properties",NULL};
    gchar *id[7]={"cut_menuitem","copy_menuitem","paste_menuitem","pastelink_menuitem","remove_menuitem","properties2",NULL};
    void *callback[7]={gridview_cut_activate,gridview_copy_activate,gridview_paste_activate,gridview_pastelink_activate,gridview_remove_activate,gridview_on_prop_activate,NULL};
    guint akey[7]={GDK_x,GDK_c,GDK_v,0,GDK_Delete,GDK_i,0};
    guint amask[7]={GDK_CONTROL_MASK, GDK_CONTROL_MASK, GDK_CONTROL_MASK,0,0, GDK_CONTROL_MASK,0};
    int i;

    for (i=0; string[i]; i++){
 	gui_add_menu_item(widgets_p,item22_menu,
		    _(string[i]),
		    iconfile[i],
		    id[i],
		    callback[i],
		    data,
		    ((akey[i])?accel_group:NULL),akey[i], amask[i]);
    }
   }
   

   
   w=gui_add_menu_separator(item22_menu);
   GLADE_HOOKUP_OBJECT (widgets_p->window, w, "iv_separator_single_selections");

   /* file group of menu items */
  {
    gchar *string[8]={N_("Print"),N_("Duplicate"),N_("Symlink"),N_("Touch"),N_("Rename"),N_("Scramble"),N_("Unscramble"),NULL};
    gchar *iconfile[8]={"xfce/stock_print","xfce/stock_dnd-multiple","xfce/stock_convert","xfce/stock_index","xfce/stock_save-as","xfce/stock_no","xfce/stock_yes",NULL};
    gchar *id[8]={"print_menuitem","duplicate_menuitem","symlink_menuitem","touch_menuitem","rename_menuitem","scramble_menuitem","unscramble_menuitem",NULL};
    void *callback[8]={gridview_print_activate,gridview_duplicate_activate,gridview_symlink_activate,gridview_touch_activate,gridview_rename_activate,NULL,NULL,NULL};
    guint akey[8]={GDK_p,GDK_d,GDK_s,GDK_m,GDK_r,0,0,0};
    int i;

    for (i=0; callback[i]; i++){
	gui_add_menu_item(widgets_p,item22_menu,
		    _(string[i]),
		    iconfile[i],
		    id[i],
		    callback[i],
		    data,
		    ((akey[i])?accel_group:NULL),akey[i], GDK_CONTROL_MASK);
    }
  }
 

  /* sort group of menuitems and submenu */
  
  sort1_menu=gui_mk_menu(
	  widgets_p,
	  _("Sort"), /* label */
	  "sort1",   /* name */
	  item22_menu, 	  /* parent */
	  NULL,	/* callback (or NULL)*/
	  "xfce/convert"); /* iconfile (or NULL)*/


 
  gui_add_menu_item(widgets_p,sort1_menu,
		_("Sort"),
		"xfce/stock_sort-descending",
		"descending1",
		on_descending,
		    data,
		NULL,0,0);
  gui_add_menu_item(widgets_p,sort1_menu,
		_("Sort"),
		"xfce/stock_sort-ascending",
		"ascending1",
		on_ascending,
		    data,
		NULL,0,0);

  {
    GSList *radiogroup=NULL;
    GtkWidget *unsorted6,*name6,*size6,*date6,*owner6,*group6,*mode6;
  
    unsorted6=gui_mk_radio_button(widgets_p,_("Unsorted"),"unsorted6",sort1_menu,&radiogroup);
    name6=gui_mk_radio_button(widgets_p,_("Name"),"name6",sort1_menu,&radiogroup);
    size6=gui_mk_radio_button(widgets_p,_("Size"),"size6",sort1_menu,&radiogroup);
    date6=gui_mk_radio_button(widgets_p,_("Date"),"date6",sort1_menu,&radiogroup);
    owner6=gui_mk_radio_button(widgets_p,_("Owner"),"owner6",sort1_menu,&radiogroup);
    group6=gui_mk_radio_button(widgets_p,_("Group"),"group6",sort1_menu,&radiogroup);
    mode6=gui_mk_radio_button(widgets_p,_("Mode"),"mode6",sort1_menu,&radiogroup);
    if (data) {
	icon_view_t *icon_view_p=(icon_view_t *)data;
	if (icon_view_p->sortcolumn == GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)unsorted6,TRUE);
	else if (icon_view_p->sortcolumn == NAME_COLUMN) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)name6,TRUE);
	else if (icon_view_p->sortcolumn == SIZE_COLUMN) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)size6,TRUE);
	else if (icon_view_p->sortcolumn == DATE_COLUMN) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)date6,TRUE);
	else if (icon_view_p->sortcolumn == OWNER_COLUMN) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)owner6,TRUE);
	else if (icon_view_p->sortcolumn == GROUP_COLUMN) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)group6,TRUE);
	else if (icon_view_p->sortcolumn == MODE_COLUMN) 
	    gtk_check_menu_item_set_active ((GtkCheckMenuItem *)mode6,TRUE);

	g_signal_connect ((gpointer) unsorted6, "toggled", G_CALLBACK (gridview_on_radio), 
	    GINT_TO_POINTER(GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID));
	g_object_set_data(G_OBJECT(unsorted6),"gui_data",data);
	
	g_signal_connect ((gpointer) name6, "toggled", G_CALLBACK (gridview_on_radio), 
	    GINT_TO_POINTER(NAME_COLUMN));
	g_object_set_data(G_OBJECT(name6),"gui_data",data);
	
	g_signal_connect ((gpointer) size6, "toggled", G_CALLBACK (gridview_on_radio), 
	    GINT_TO_POINTER(SIZE_COLUMN));
	g_object_set_data(G_OBJECT(size6),"gui_data",data);
	
	g_signal_connect ((gpointer) date6, "toggled", G_CALLBACK (gridview_on_radio), 
	    GINT_TO_POINTER(DATE_COLUMN));
	g_object_set_data(G_OBJECT(date6),"gui_data",data);
	
	g_signal_connect ((gpointer) owner6, "toggled", G_CALLBACK (gridview_on_radio), 
	    GINT_TO_POINTER(OWNER_COLUMN));
	g_object_set_data(G_OBJECT(owner6),"gui_data",data);
	
	g_signal_connect ((gpointer) group6, "toggled", G_CALLBACK (gridview_on_radio), 
	    GINT_TO_POINTER(GROUP_COLUMN));
	g_object_set_data(G_OBJECT(group6),"gui_data",data);
	
	g_signal_connect ((gpointer) mode6, "toggled", G_CALLBACK (gridview_on_radio), 
	    GINT_TO_POINTER(MODE_COLUMN));
	if (data) g_object_set_data(G_OBJECT(mode6),"gui_data",data);
    }
    
  }

  /* operations group of menu items */
  {
    gchar *string[5]={N_("Mount"),N_("Unmount"),N_("New file"),N_("New directory"),NULL};
    gchar *iconfile[5]={"xfce/stock_yes","xfce/stock_no","xfce/stock_new-tab","xfce/stock_new-dir",NULL};
    gchar *id[5]={"mountP","unmountP","newfile_menuitem","newdirectory_menuitem",NULL};
    void *callback[5]={NULL,NULL,on_newfile_activate,on_newdir_activate,NULL};
    guint akey[5]={0,0,GDK_Insert,GDK_Insert,0};
    guint amask[6]={0, 0, GDK_CONTROL_MASK, GDK_MOD1_MASK, 0};
    int i;

    for (i=0; string[i]; i++){
	gui_add_menu_item(widgets_p,item22_menu,
		    _(string[i]),
		    iconfile[i],
		    id[i],
		    callback[i],
		    data,
		    ((akey[i])?accel_group:NULL),akey[i], amask[i]);
    }
  }
 
 
  /* execution group of menuitems */
  
    w=gui_add_menu_separator(item22_menu);
    GLADE_HOOKUP_OBJECT (widgets_p->window, w, "iv_separator0");

  {
    gchar *string[5]={N_("Terminal"),N_("Run"),N_("Find"),N_("Differences"),NULL};
    gchar *iconfile[5]={"xfce/stock_terminal","xfce/stock_run","xfce/b-find","xfce/xfdiff",NULL};
    gchar *id[5]={"terminal2","run2","find2","differences2",NULL};
    void *callback[5]={gridview_open_in_terminal_activate,gridview_run_activate,gridview_glob_activate,gridview_differences_activate,NULL};
    guint akey[5]={GDK_t, GDK_e, GDK_f, GDK_h, 0};
    int i;

    for (i=0; string[i]; i++){
	gui_add_menu_item(widgets_p,item22_menu,
		    _(string[i]),
		    iconfile[i],
		    id[i],
		    callback[i],
		    data,
		    ((akey[i])?accel_group:NULL),akey[i], GDK_CONTROL_MASK);
    }
  }
    
    w=gui_add_menu_separator(item22_menu);
    GLADE_HOOKUP_OBJECT (widgets_p->window, w, "iv_separator1");
    
    /* select group of menuitems: */
  {
    gchar *string[4]={N_("Select all"),N_("Select by filter"),N_("Unselect all"),NULL};
    gchar *iconfile[4]={"xfce/stock_add","xfce/stock_apply","xfce/stock_remove",NULL};
    gchar *id[4]={"select_all_menuitem", "select_byfilter_menuitem", "unselect_all_menuitem",NULL};
    void *callback[4]={gridview_select_all_activate, gridview_select_by_filter, gridview_unselect_all_activate, NULL};
    guint akey[4]={GDK_a, 0, GDK_u, 0};
    int i;

    for (i=0; string[i]; i++){
	gui_add_menu_item(widgets_p,item22_menu,
		    _(string[i]),
		    iconfile[i],
		    id[i],
		    callback[i],
		    data,
		    ((akey[i])?accel_group:NULL),akey[i], GDK_CONTROL_MASK);
    }
  }

  
   w=gui_add_menu_separator(item22_menu);
    GLADE_HOOKUP_OBJECT (widgets_p->window, w, "iv_separator2");
    
    /* general group of menuitems: */

#ifdef HAVE_LIBXFCE4MCS_CLIENT
    gui_add_menu_item(widgets_p,item22_menu,
		    _("Global Configuration"),
		    "xfce/xfce-setting-show",
		    "settings2",
		    on_xfce_setting_show,
		    data,
		    accel_group, GDK_c, GDK_MOD1_MASK);
#endif
    
    gui_add_menu_item(widgets_p,item22_menu,
		    _("About"),
		    "xfce/stock_about",
		    "about2",
		    gui_on_about_activate,
		    data,
		    accel_group, GDK_i, GDK_MOD1_MASK);
    
    gui_add_menu_item(widgets_p,item22_menu,
		    _("Exit"),
		    "xfce/stock_quit",
		    "exit2",
		    gui_on_close_activate,
		    data,
		    accel_group, GDK_q, GDK_CONTROL_MASK);


  GLADE_HOOKUP_OBJECT (widgets_p->window, item22_menu, "item22_menu");
  return item22_menu;

}

