/* Copyright 2005 Edscott Wilson Garca. 
 * Distributed with GPL licence.*/
/*
This is a private header file for internal use
of gridview library. Do not include this in any
 file which does not belong to the gridview
 library... You have been warned...*/

#ifndef XFFM_GRIDVIEW_H
#define XFFM_GRIDVIEW_H


#define BACKGROUND_COLOR 0
#define TEXT_COLOR 1
#define SATURATE_TEXT_COLOR 2
#define SATURATE_LABEL_COLOR 3
#define SELECT_TEXT_COLOR 4
#define INVALID_UTF8_TEXT_COLOR 5
#define ICON_SIZE 48
#define DEFAULT_ICON_COLUMNS 3
#define DEFAULT_VISIBLE_ROWS 1
#define TEXTSPACING 5
#define CELLSPACING (3*ICON_SIZE/5)
#define CELLSIZE (ICON_SIZE+(2*CELLSPACING))
#define PIXMAP_SIZE (2*CELLSIZE)

typedef struct iconview_geometry_t {
    gdouble scrollX;
    int x;
    int y;
    int w;
    int h;
} iconview_geometry_t;
typedef struct iconview_preferences_t {
    int preferences;
    int sortcolumn;
} iconview_preferences_t;
    

/* headers */
static void
done_with_rename (gpointer data);

 
void 
mk_text_entry(icon_view_t *icon_view_p, population_t *population_p, int caso);

static 
population_t *
find_in_labels(		icon_view_t *icon_view_p,
			gdouble x, 
			gdouble y);

static 
population_t *
create_population_t(	icon_view_t *icon_view_p,
			record_entry_t *en,
			int element,
			const gchar *icon_id,
			const gchar *label);

static
void
destroy_population(	icon_view_t *icon_view_p);

static 
population_t *
find_in_population(	icon_view_t *icon_view_p,
			gdouble x, 
			gdouble y);

static
void
init_icon_view(icon_view_t *icon_view_p, record_entry_t *en, int pathc);

    

static
void
enter_drag_state(icon_view_t *icon_view_p);
static
void
setup_drag_state(icon_view_t *icon_view_p,GdkEventButton *event,
	int x, int y, int drag_button);
static 
void 
saturate_pixbuf(	icon_view_t *icon_view_p,
			population_t *population_p);
static 
void 
unsaturate_pixbuf(	icon_view_t *icon_view_p);
static 
void 
select_pixbuf(	icon_view_t *icon_view_p,
			population_t *population_p);
static 
void 
unselect_pixbuf(	icon_view_t *icon_view_p,
			population_t *population_p);
static 
void 
unselect_all_pixbuf(	icon_view_t *icon_view_p);

static 
void
process_double_click(	icon_view_t *icon_view_p,
			population_t *population_p, 
			gboolean control);
static
void 
select_pen(		icon_view_t *icon_view_p,
			int p);


#endif


