#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <X11/Xlib.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "secondary.h"
#include "actions_lib.h"

#include "deskview.h"
#include "deskview_lib.h"



/******************** common menu configuration ******************************/
#include "deskview_popup-callbacks.i"
#include "deskview_popup.i"

/************** shared symbols (not to be used by other than gridview_lib ****/

G_MODULE_EXPORT
GtkWidget * 
deskview_mk_popup_menu (	GtkWidget *parent,
				GtkAccelGroup *accel_group,
				desk_view_t *desk_view_p)
{
    return (common_mk_popup_menu(&(desk_view_p->widgets),parent,accel_group,(void *)desk_view_p));
}

G_MODULE_EXPORT
void 
do_deskview_popup(	desk_view_t *desk_view_p, 
			desk_population_t *desk_population_p, 
			GdkEventButton *event)
{
    if (!desk_view_p) return;
    if (!desk_view_p->selection_list || !desk_view_p->selection_list->data)
	return;
    /* only need to destroy and recreate if module fiddles around with it */
    if (!desk_view_p->popup){
	desk_view_p->popup = deskview_mk_popup_menu(NULL,NULL,desk_view_p);
    }    
    gtk_widget_hide_all(desk_view_p->popup);
	TRACE("do_deskview_popup");

    if (desk_population_p && desk_population_p->en && desk_population_p->en->module && 
	function_rational("plugins",desk_population_p->en->module,(void *)(desk_population_p->en),&(desk_view_p->widgets),"private_popup"))
    {
	TRACE("private module popup menu here.");
	return;
    }

      
    gui_autostuff(&(desk_view_p->widgets),desk_view_p, desk_view_p->popup,desk_population_p->en,deskview_autotype_C, deskview_mount, deskview_unmount);
    
    mount_item(desk_view_p);
    refresh_item(desk_view_p);
    remove_item(desk_view_p);
    open_item(desk_view_p);    
    properties_item(desk_view_p);    
    print_item(desk_view_p); 

    gtk_menu_popup(GTK_MENU(desk_view_p->popup), NULL, NULL, NULL, NULL, 3, event->time);
}


