#define TIMERVAL 2500
#define MAX_LOAD_TIME 2

static 
gboolean 
watch_root ( gpointer data){
    Pixmap root_pix;
    Atom prop;
    Atom prop_e;
    desk_view_t *desk_view_p=(desk_view_t *)data;
    static gchar *desktop_color=NULL;
    static gchar *desktop_bg_file=NULL;
    gboolean reload=FALSE;

#ifdef HAVE_LIBXFCEGUI4
	if (getenv("USE_DESKTOP_MENU") && strlen(getenv("USE_DESKTOP_MENU")))
	{
	    xfdesktop_menu_t *xfdesktop_menu_p;
	    if (!desk_view_p->xfdesktop_menu_p) 
	    {
		desk_view_p->xfdesktop_menu_p = (void *)start_menu_module();
	    }
	    xfdesktop_menu_p = (xfdesktop_menu_t *)desk_view_p->xfdesktop_menu_p;
	    if(xfdesktop_menu_p->desktop_menu) 
	    {
		if (getenv("USE_DESKTOP_MENU_ICONS") && strlen(getenv("USE_DESKTOP_MENU_ICONS"))) 
		    XDM_set_show_icons(xfdesktop_menu_p->desktop_menu, TRUE);
		else 
		    XDM_set_show_icons(xfdesktop_menu_p->desktop_menu, FALSE);
	    }
	} 
	else if (desk_view_p->xfdesktop_menu_p)
	{
	    stop_menu_module((xfdesktop_menu_t *)desk_view_p->xfdesktop_menu_p);
	    desk_view_p->xfdesktop_menu_p=NULL;
	}
#endif


    if (getenv("DESKTOP_COLOR") && strlen(getenv("DESKTOP_COLOR")) )
    {
        if (!desktop_color || strcmp(desktop_color,getenv("DESKTOP_COLOR")))
        {
	    TRACE("now reloading");
	    desktop_color=g_strdup(getenv("DESKTOP_COLOR"));
	    reload=TRUE;
	}
    }
    
    prop = XInternAtom(GDK_DISPLAY(), "_XROOTPMAP_ID", False);
    /* for eterms (maybe someone still uses them): */
    prop_e = XInternAtom(GDK_DISPLAY(), "ESETROOT_PMAP_ID", False);
    if (prop != None) { 
      root_pix = mb_util_get_root_pixmap(GDK_DISPLAY());
      /*TRACE("root pix 0x%x == 0x%x",(unsigned)root_pix, (unsigned)desk_view_p->root_pxm);*/
      if (root_pix != desk_view_p->background) {
	  
	gint root_w, root_h, root_d;	
	gdk_window_get_geometry  (gdk_get_default_root_window(),
				    NULL,NULL,&root_w,&root_h,&root_d);
	TRACE("root_pix != desk_view_p->root_pxm 0x%x!=0x%x",
		(unsigned)root_pix,(unsigned)desk_view_p->root_pxm);
	XSetWindowBackgroundPixmap(GDK_DISPLAY(), GDK_ROOT_WINDOW(), root_pix);
	XClearWindow(GDK_DISPLAY(), GDK_ROOT_WINDOW());
	
	/* we shall use a private Pixmap to avoid crashing
	 * because of termination of xffm-root, and define
	 * a new one each time in case root geometry changes...*/
	desk_view_p->background=desk_view_p->root_pxm;
	desk_view_p->root_pxm = XCreatePixmap(GDK_DISPLAY(),GDK_ROOT_WINDOW(), root_w, root_h, root_d);
	if (desk_view_p->background)XFreePixmap(GDK_DISPLAY(),desk_view_p->background);
	desk_view_p->background=root_pix;
	
	XCopyArea(GDK_DISPLAY(), 
		root_pix, 
		desk_view_p->root_pxm,
		GDK_GC_XGC(desk_view_p->penGC),
		0,0,root_w, root_h,0,0);
	TRACE("setting desk_view_p->root_pxm to 0x%x",(unsigned)desk_view_p->root_pxm);
	
#if 0
	/* setting these properties invites other apps to terminate us. */
	/* not what we have in mind...*/
	XChangeProperty(GDK_DISPLAY(), GDK_ROOT_WINDOW(), prop, 
			XA_PIXMAP, 32, PropModeReplace,
			(unsigned char *) &(desk_view_p->root_pxm), 1);
	XChangeProperty(GDK_DISPLAY(), GDK_ROOT_WINDOW(), prop_e, 
			XA_PIXMAP, 32, PropModeReplace,
			(unsigned char *) &(desk_view_p->root_pxm), 1);*/
#endif
#if 0
	/* using remotely defined pixmap links remote crashes to us.
	 * not really what we want... */
	desk_view_p->root_pxm=root_pix;
#endif



	
	/*XSetWindowBackgroundPixmap(GDK_DISPLAY(), GDK_WINDOW_XID(GTK_WIDGET(desk_view_p->widgets.window)->window), root_pix);
	XClearWindow(GDK_DISPLAY(), GDK_WINDOW_XID(GTK_WIDGET(desk_view_p->widgets.window)->window));*/

	reload=TRUE;
      }
    }
    if (reload) {
	reload_deskview(desk_view_p);
	return TRUE;
    }
    if (getenv("DESKTOP_BACKGROUND_IMAGE") && strlen(getenv("DESKTOP_BACKGROUND_IMAGE"))){
	if (!desktop_bg_file || strcmp(desktop_bg_file,getenv("DESKTOP_BACKGROUND_IMAGE")))
	{
	    g_free(desktop_bg_file);
	    desktop_bg_file=g_strdup(getenv("DESKTOP_BACKGROUND_IMAGE"));
	    if (!g_file_test(desktop_bg_file,G_FILE_TEST_EXISTS)){
		g_warning("%s does not exist",desktop_bg_file);
	    } else {
		GError *error=NULL;
		gchar *command=g_strdup_printf("xffm-root %s",desktop_bg_file);
		if (!g_spawn_command_line_async (command, &error))
		{
		    g_warning("%s:%s",error->message,command);
		}
		g_free(command);
	    }
	}
    }
    
    return TRUE;
}


    
static
gint deskview_monitor(gpointer data)
{
    long v1,v2;
    struct stat st;
    desk_view_t *desk_view_p=(desk_view_t *)data;
    if (!data) return FALSE;
    if(!xffm_details->timer)
    {
	xffm_details->timer = g_timeout_add (TIMERVAL,deskview_monitor, data);
	goto end;
    }
    if (desk_view_p->redlight) {
	TRACE("desk_view_p->redlight");
	goto end;
    }
    /* dragging? */
    if (desk_view_p->doing_drag_p) goto end;
    if (stat(desk_view_p->en->path,&st)<0) goto end;
    v1=desk_view_p->en->st->st_mtime + desk_view_p->en->st->st_ctime + desk_view_p->en->st->st_dev;
    v2=st.st_mtime + st.st_ctime + st.st_dev;
    if (v1 == v2) goto end;
    TRACE("update necessary for %s deskview=0x%x (%ld == %ld",desk_view_p->en->path,(unsigned)desk_view_p,v1,v2);
    if (!reload_deskview(desk_view_p)){
        g_warning("cannot reload deskview");
    } else {
	TRACE("reloading deskview");
    }
end:
    /*watch_root(desk_view_p);*/
    return TRUE;
}

