/**********************************************************************/
/* Copywrite Edscott Wilson Garcia 2005 
 * See attached GPL licence for further information.
 * 
 * ********************************************************************/

/*******************************************************************/
#define X_OFFSET 5
#define Y_OFFSET 60


static
desk_view_t *
create_deskview(int size){
	gint root_w,root_h;
    desk_view_t *desk_view_p=(desk_view_t *)malloc(sizeof(desk_view_t));
    g_return_val_if_fail(desk_view_p!=NULL,NULL);

    desk_view_p->dentry=NULL;
    desk_view_p->population_list=NULL;
    desk_view_p->selection_list=NULL;
    desk_view_p->paper=NULL;
    desk_view_p->popup=NULL;
    desk_view_p->root_pxm=None;
    desk_view_p->background=None;
    desk_view_p->penGC=NULL;
    desk_view_p->pixmap=NULL;
    desk_view_p->offset_x=desk_view_p->offset_y=desk_view_p->initial_x=desk_view_p->initial_y=0;
    desk_view_p->restore_pixbuf=FALSE;
    desk_view_p->serial=1;
    desk_view_p->cmap=NULL;
    desk_view_p->doing_drag_p=NULL;
    desk_view_p->saturated=NULL;
    desk_view_p->widgets.window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_decorated ((GtkWindow *)desk_view_p->widgets.window,FALSE);

    desk_view_p->widgets.status = desk_view_p->widgets.diagnostics = desk_view_p->widgets.progress = desk_view_p->widgets.vpane = desk_view_p->widgets.remove = desk_view_p->widgets.stop_button = desk_view_p->widgets.clear_button = NULL;
    desk_view_p->widgets.stop=FALSE;
    desk_view_p->widgets.type = DESKVIEW_TYPE;
    gtk_window_set_title (GTK_WINDOW (desk_view_p->widgets.window), "xffm-deskview");
#if 0
    desk_view_p->scrolled_window=(GtkScrolledWindow *)gtk_scrolled_window_new (NULL,NULL);
    gtk_scrolled_window_set_policy  (desk_view_p->scrolled_window,GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
    gtk_container_add (GTK_CONTAINER (desk_view_p->widgets.window),GTK_WIDGET(desk_view_p->scrolled_window));
    gtk_widget_show (GTK_WIDGET(desk_view_p->scrolled_window));
#endif

    desk_view_p->paper = gtk_drawing_area_new ();
    if(GTK_WIDGET_DOUBLE_BUFFERED(desk_view_p->paper))
	gtk_widget_set_double_buffered(desk_view_p->paper, FALSE);
    gtk_widget_show (desk_view_p->paper);
    
#if 0
    gtk_scrolled_window_add_with_viewport (desk_view_p->scrolled_window,desk_view_p->paper);
#else
    gtk_container_add (GTK_CONTAINER (desk_view_p->widgets.window),GTK_WIDGET(desk_view_p->paper));
#endif

    {
	int rows=size/DEFAULT_ICON_COLUMNS;
	if (rows > MAXIMUM_DEFAULT_ICON_ROWS) rows=MAXIMUM_DEFAULT_ICON_ROWS;
	gdk_window_get_geometry  (gdk_get_default_root_window(),
				    NULL,NULL,&root_w,&root_h,NULL);	
	gtk_window_set_default_size ((GtkWindow *)desk_view_p->widgets.window, 	     root_w,root_h);

	/*gtk_window_set_default_size ((GtkWindow *)desk_view_p->widgets.window, 
	    DEFAULT_ICON_COLUMNS*ICON_SIZE*2, 
	    rows*ICON_SIZE*2);*/
	
    }
    gtk_window_set_resizable ((GtkWindow *)desk_view_p->widgets.window, FALSE);

/*    desk_view_p->paperX = (DEFAULT_ICON_COLUMNS+1)*ICON_SIZE*2;
    desk_view_p->paperY = (size/DEFAULT_ICON_COLUMNS+1)*ICON_SIZE*2;*/
    
    desk_view_p->paperX = root_w+ICON_SIZE*2;
    desk_view_p->paperY = root_h+ICON_SIZE*2;
    
	
    TRACE("paperX=%d",desk_view_p->paperX);
    TRACE("paperY=%d (%d rows)",desk_view_p->paperY,size/DEFAULT_ICON_COLUMNS);
    gtk_widget_set_size_request (desk_view_p->paper, desk_view_p->paperX,desk_view_p->paperY);
    
    do_atoms(desk_view_p);

    gtk_widget_add_events (desk_view_p->paper,
	  GDK_POINTER_MOTION_MASK|
	  GDK_BUTTON_MOTION_MASK|
	  GDK_BUTTON_PRESS_MASK|
	  GDK_BUTTON_RELEASE_MASK|
	  GDK_ENTER_NOTIFY_MASK|
	  GDK_LEAVE_NOTIFY_MASK|
	  GDK_SCROLL_MASK |
	  GDK_EXPOSURE_MASK);

     g_signal_connect(G_OBJECT(desk_view_p->paper), "scroll-event",
				G_CALLBACK(scroll_cb), NULL);
     g_signal_connect (G_OBJECT (desk_view_p->paper), 
	      "configure-event", G_CALLBACK (on_configure), desk_view_p);    
      g_signal_connect (G_OBJECT (desk_view_p->paper), 
	      "size-allocate", G_CALLBACK (on_size), desk_view_p);
    
    g_signal_connect (G_OBJECT (desk_view_p->paper), "expose-event", 
		  GTK_SIGNAL_FUNC (on_expose), desk_view_p);
    g_signal_connect (G_OBJECT (desk_view_p->paper), "configure-event", 
		  GTK_SIGNAL_FUNC (on_expose),desk_view_p);
    g_signal_connect (G_OBJECT (desk_view_p->paper), "button-press-event",
		  GTK_SIGNAL_FUNC (on_button_press),desk_view_p);
    g_signal_connect (G_OBJECT (desk_view_p->paper), "button-release-event",
		  GTK_SIGNAL_FUNC (on_button_release), desk_view_p);
    g_signal_connect (G_OBJECT (desk_view_p->paper),"enter-notify-event",
		  GTK_SIGNAL_FUNC (on_enter),desk_view_p);
    g_signal_connect (G_OBJECT (desk_view_p->paper),"leave-notify-event",
		  GTK_SIGNAL_FUNC (on_leave),desk_view_p);
    g_signal_connect (G_OBJECT (desk_view_p->paper),"motion-notify-event",
		  GTK_SIGNAL_FUNC (on_motion),desk_view_p);
  
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag_data_received", 
	  G_CALLBACK(drag_data), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag_data_get", 
	    G_CALLBACK(drag_data_get), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag_motion", 
	    G_CALLBACK(drag_motion), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag_end", 
	    G_CALLBACK(drag_end), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag_begin", 
	    G_CALLBACK(drag_begin), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag-leave",
	    G_CALLBACK(drag_leave), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag-data-delete",
	    G_CALLBACK(drag_delete), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "drag-drop",
	    G_CALLBACK(drag_drop), desk_view_p);
  
    g_signal_connect(G_OBJECT(desk_view_p->widgets.window), "destroy_event", 
	    G_CALLBACK(destroy_event), desk_view_p);
    g_signal_connect(G_OBJECT(desk_view_p->widgets.window), "delete_event", 
	    G_CALLBACK(destroy_event), desk_view_p);
   
    if (!target_list) target_list = gtk_target_list_new   (target_table,NUM_TARGETS);
  
    gtk_drag_source_set((GtkWidget *) desk_view_p->paper, 
	  GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, target_table, NUM_TARGETS, 
	  GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);
    gtk_drag_dest_set((GtkWidget *) desk_view_p->paper, 
	  GTK_DEST_DEFAULT_DROP , target_table, NUM_TARGETS, 
	  GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);
#if 0
    {
	TRACE("hscrollbar=%d",desk_view_p->scrolled_window->hscrollbar->allocation.height);
	TRACE("vscrollbar=%d",desk_view_p->scrolled_window->vscrollbar->allocation.width);
    }
#endif
    
    gtk_widget_show_all (desk_view_p->widgets.window);
    clean_paper(desk_view_p);
    screen_set_selection(desk_view_p);
    /* get around fvwm margins: */
    gtk_window_move((GtkWindow *)(desk_view_p->widgets.window),0,0);
    
#if 0
    /* Make the root window send events to me */
    gdk_window_set_user_data (GDK_ROOT_PARENT (), desk_view_p->paper);
    XSelectInput (GDK_DISPLAY (), GDK_ROOT_WINDOW (), PropertyChangeMask);
    g_signal_connect(G_OBJECT(desk_view_p->paper), "property-notify-event", 
	    G_CALLBACK(handle_property_notify), desk_view_p);
#endif
    TRACE("create_deskview done----------------------------");
    
    return desk_view_p;
}

static
void
destroy_deskview(desk_view_t *desk_view_p){
    GList *tmp;
    if (!desk_view_p) return;
    for (tmp=desk_view_p->population_list; tmp; tmp=tmp->next){
	destroy_desk_population_p(desk_view_p, (desk_population_t *)tmp->data);
    }
    g_list_free(desk_view_p->population_list);
    gtk_widget_destroy(desk_view_p->widgets.window);
    destroy_entry(desk_view_p->en);
    g_free(desk_view_p);
}

/*********************************************************************/
static void
insert_desktop_icon(	desk_view_t *desk_view_p, 
			dir_t *gl,
			int *x, int *y, int *page,
			gchar *exec,
			gchar *icon_id
			)
{
	deskview_geometry_t *deskview_geometry_p;
	gboolean nonuser_geometry=TRUE;
	gint root_w,root_h;
	gchar *key;
	desk_population_t *desk_population_p;
	if (!gl->pathv){
	    g_warning("!gl->pathv");
	    return;
	}
	gdk_window_get_geometry  (gdk_get_default_root_window(),NULL,NULL,&root_w,&root_h,NULL);	
	
	desk_population_p=create_desk_population_t(desk_view_p,gl->en, *x, *y);
	if (!gl->en) key="ROOT_XFFM";
	else key=gl->en->path;
	if ((deskview_geometry_p = get_deskview_geometry_p(key))!=NULL)
	{
	    if (deskview_geometry_p->x < root_w && deskview_geometry_p->y < root_h)
	    {
		desk_population_p->x = deskview_geometry_p->x;
		desk_population_p->y = deskview_geometry_p->y;
		nonuser_geometry=FALSE;
	    }
	}
	
	desk_population_p->exec=exec;
	desk_population_p->icon_id=icon_id;

	if (gl->en && strrchr(key,'.') && strcmp(strrchr(key,'.'),".desktop")==0){
	    gchar *name=get_desktop_string("Name", gl->en->path);
	    if (name) {
		g_free(gl->pathv);
		gl->pathv=name;
	    }
	    desk_population_p->URL=get_desktop_string("URL", gl->en->path);
	    desk_population_p->exec=get_desktop_string("Exec", gl->en->path);
	    desk_population_p->icon_id=get_desktop_string("Icon", gl->en->path);
	}
	    
	if (desk_population_p->icon_id){
		GdkPixbuf *pixbuf;
		pixbuf =icon_tell(&(desk_view_p->widgets), REAL_BIG,desk_population_p->icon_id);
		if (pixbuf) {
		    g_object_unref(G_OBJECT(desk_population_p->pixbuf));
		    desk_population_p->pixbuf = pixbuf;
		}
	}
	if (strcmp("..Wastebasket",gl->pathv)==0){
	    g_free(gl->pathv);
	    gl->pathv=g_strdup(_("Wastebasket"));
	}
	insert_pixbuf(desk_view_p,desk_population_p);
	insert_text(desk_view_p,desk_population_p,gl->pathv);
	desk_population_p->en = gl->en;
	if (nonuser_geometry) {
	  int font_height = desk_population_p->logical_rect.height;
	  (*y) += (ICON_SIZE + font_height);
	  /* not too close to the bottom, panel rules here */
	  if ((*y) + ICON_SIZE*4 >= desk_view_p->paper->allocation.height){
	    (*y)=Y_OFFSET;
	    (*x) += (ICON_SIZE*2);
	    if (desk_view_p->paper->allocation.width - (*x) - ICON_SIZE*3 < 0 ){
		g_warning("screen too small");
		(*x)=X_OFFSET * (*page+1);
	    }
	  }
	}
}

static 
void
load_xffm_icons(desk_view_t *desk_view_p, int *x, int *y, int *page){
    dir_t gl;

    
    gl.en=mk_entry(0);
    gl.pathv = g_strdup(OUR_HOST_NAME(&(desk_view_p->widgets)));
    gl.en->path=g_strdup(gl.pathv);
    SET_ROOT_TYPE(gl.en->type);
    insert_desktop_icon(desk_view_p, &gl, x, y, page, g_strdup("xffm-iconview"), g_strdup("xfce/stock_system"));

    gl.en=mk_entry(0);
    gl.pathv = g_strdup(_("Home"));
    gl.en->path=g_strdup(gl.pathv);
    SET_ROOT_TYPE(gl.en->type);
    insert_desktop_icon(desk_view_p, &gl, x, y, page,
	    g_strdup_printf("xffm-iconview \"%s\"",g_get_home_dir()), 
	    g_strdup("xfce/b-home"));
    
    gl.en=mk_entry(0);
    gl.pathv = g_strdup(_("Run"));
    gl.en->path=g_strdup(gl.pathv);
    SET_ROOT_TYPE(gl.en->type);
    insert_desktop_icon(desk_view_p, &gl, x, y, page, g_strdup("xffm-run"), g_strdup("xfce/stock_execute"));
    return;
    
}

static
void load_xfdir_icons(desk_view_t *desk_view_p,xfdir_t *xfdir_p){
	int j,x=X_OFFSET,y=Y_OFFSET,page=0;
    
    // add entry for each desk_population_t
    load_xffm_icons(desk_view_p, &x, &y, &page);
   
    TRACE("pathc=%d",xfdir_p->pathc);
    for(j = 0; j < xfdir_p->pathc; j++)
    {
	insert_desktop_icon(desk_view_p, (xfdir_p->gl)+j, &x, &y, &page,NULL, NULL);
    }
}


