/**********************************************************************/
/* Copywrite Edscott Wilson Garcia 2005 
 * See attached GPL licence for further information.
 * 
 * ********************************************************************/

#define XFFM_DESKVIEW_C
#include "deskview.h"


/* static headers: */
static void
destroy_deskview(desk_view_t *desk_view_p);

static gint population_compare (gconstpointer a, gconstpointer b);
static desk_population_t *find_in_population(desk_view_t *desk_view_p,gdouble x, gdouble y);
static void update_population_list(desk_view_t *desk_view_p,desk_population_t *desk_population_p);
static void redraw_text (desk_view_t *desk_view_p, desk_population_t *desk_population_p,int color);
static void erase_text (desk_view_t *desk_view_p, desk_population_t *desk_population_p);
static void unsaturate(	desk_view_t *desk_view_p);
static void redraw_pixbuf(desk_view_t *desk_view_p,desk_population_t *desk_population_p, gdouble x, gdouble y);
static void select_pixbuf(desk_view_t *desk_view_p,desk_population_t *desk_population_p, gdouble x, gdouble y);
static void saturate_pixbuf(desk_view_t *desk_view_p,desk_population_t *desk_population_p, gdouble x, gdouble y);
static void redraw_background(desk_view_t *desk_view_p,desk_population_t *desk_population_p);
static void unselect_all_population (desk_view_t *desk_view_p);
static void select_desk_population_p (desk_view_t *desk_view_p, desk_population_t *desk_population_p);
static void set_population_offset(desk_view_t *desk_view_p, desk_population_t *desk_population_p, gdouble x, gdouble y);


/* static code */
#ifdef HAVE_LIBXFCEGUI4
#include "deskview_menu.i"
#endif
#include "deskview_mb.i"
#include "deskview_desktop.i"
#include "deskview_graphics.i"
#include "deskview_callbacks.i"
#include "deskview_population.i"
#include "deskview_main.i"
#include "deskview_monitor.i"


/* exportable symbols: */

G_MODULE_EXPORT
GtkWidget *create_desktop(	int argc, gchar *argv[])
{
  xfdir_t xfdir;
  desk_view_t *desk_view_p;
  record_entry_t *en;
  const gchar *deskdir=NULL;
  int i;
  
  for (i=0; i<argc; i++)
    if (strcmp("--id",argv[i])==0 || strcmp("-id",argv[i])==0) {
      zap_if_running(TRUE);
      g_warning("%s not running",argv[0]);
      exit(0);
  }

  desktop_main(argc, argv);
  
  for (i=1; i < argc; i++){
      if (g_file_test(argv[i],G_FILE_TEST_EXISTS)){
	  deskdir=argv[i];
	  break;
      }
  }
  if (!deskdir){
      deskdir = g_build_filename(g_get_home_dir(),"Desktop",NULL);
  }
      
  
  if (!g_file_test(deskdir,G_FILE_TEST_EXISTS)){
      if (mkdir(deskdir, 0777) < 0) {
	g_warning("desktop directory does not exist: %s",deskdir);
	return NULL;
      }
  }
    en=stat_entry(deskdir,__LOCAL_TYPE|__ROOT_TYPE);
    if (xffm_details->preferences & IMAGE_PREVIEW) SET_SHOWS_IMAGES(en->type);
    if (xffm_details->preferences & SHOW_DOT) SET_SHOWS_HIDDEN(en->type);

    if (!en){
      g_warning("en==NULL");
      return NULL;
  }
  if (!get_xfdir_local(&xfdir, (en), NULL)){
      g_warning("cannot load %s",en->path);
      return NULL;
  }

 TRACE("size is %d", xfdir.pathc);
  desk_view_p=create_deskview(xfdir.pathc);
  desk_view_p->en=en;

  /* this should be an option, maybe
  SET_SHOWS_HIDDEN(en->type);*/

  if (!get_xfdir_local(&xfdir, (desk_view_p->en), NULL)){
      g_warning("cannot load %s",desk_view_p->en->path);
      return NULL;
  }
  load_xfdir_icons(desk_view_p, &xfdir);
  xfdirfree(&xfdir);
  desk_view_p->redlight=FALSE;
  deskview_monitor(desk_view_p);
  g_timeout_add(160, (GtkFunction) watch_root, desk_view_p);
#ifdef HAVE_LIBXFCEGUI4
  if (getenv("USE_DESKTOP_MENU") && strlen(getenv("USE_DESKTOP_MENU")))
  {
      desk_view_p->xfdesktop_menu_p = (void *)start_menu_module();
  }
#endif
  return desk_view_p->widgets.window;
}

G_MODULE_EXPORT
int 
reload_deskview(desk_view_t *desk_view_p){
  GList *tmp;
  xfdir_t xfdir;
  desk_view_p->redlight=TRUE;
  if (!get_xfdir_local(&xfdir, (desk_view_p->en), NULL)){
      g_warning("cannot load %s",desk_view_p->en->path);
      desk_view_p->redlight=FALSE;
      return FALSE;
  }
  
  for (tmp=desk_view_p->population_list; tmp; tmp=tmp->next){
    destroy_desk_population_p(desk_view_p, (desk_population_t *)tmp->data);
  }
  g_list_free(desk_view_p->population_list);
  desk_view_p->population_list=NULL;
  clean_paper(desk_view_p);

  load_xfdir_icons(desk_view_p, &xfdir);
  xfdirfree(&xfdir);
  stat(desk_view_p->en->path,desk_view_p->en->st);
  desk_view_p->redlight=FALSE;

  return TRUE;
}

#ifdef HAVE_LIBXFCEGUI4
/* this is for the xfdesktop menu only: */
extern
SessionClient *session_client;

G_MODULE_EXPORT
void
quit(gboolean force)
{
    if(session_client) logout_session(session_client);
    /*else gtk_main_quit();*/
}
#endif

