
#ifndef __REG_H__
#define __REG_H__

#define USE_NEW_CODE

#ifdef USE_NEW_CODE

typedef struct reg_t
{
    char *app;			/* program name */
    char *arg;			/* arguments/options */
    char *sfx;			/* suffix */
}
reg_t;

const char *reg_duplicate_app(char *path,int i);
char *reg_app_by_file(char *file);
reg_t *reg_prog_by_file(char *file);
int reg_save(void);
void reg_add_suffix(char *sfx, char *program, char *args);
GList *reg_app_list(void);


#else
/* this is pre 4.0 and should be erased soon */

typedef struct
{
    char *app;			/* program name */
    char *arg;			/* arguments/options */
    char *sfx;			/* suffix */
    int len;			/* suffix length */
}
reg, reg_t;

void reg_build_list(void);

const char *reg_duplicate_app(char *path,int i);
void reg_add_suffix(char *sfx, char *prog, char *args);
char *reg_app_by_file(char *file);
reg_t *reg_prog_by_file(char *file);
GList *reg_app_list(void);
GList *reg_app_list_free(GList *);
int reg_save(void);


#endif

#endif
