/*
 * Copywrite 2005 Edscott Wilson Garcia
 */


#define __XFFM_MAIN_C__
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <glob.h>
#include <limits.h>
#include <memory.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gmodule.h>
#include <dbh.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>


#include "xffm.h"

#ifdef XFFM_TREEVIEW_BINARY
#include "treeview_lib.h"
#endif
#ifdef XFFM_ICONVIEW_BINARY
#include "gridview_lib.h"
#endif
#ifdef XFFM_DESKVIEW_BINARY
#include "deskview_lib.h"
#endif



#define FORCE_CORE
#ifdef FORCE_CORE
#include <sys/time.h>
#include <sys/resource.h>
#endif



extern
gchar *xffm_iconpath;

static
int restore_old_histories(void){
    int result=0;
    gchar *old_dir=NULL, *new_dir=NULL;
    /* cache */
    old_dir=g_build_filename(xdg_cache_dir(),OLD_CACHE,NULL);
    new_dir=g_build_filename(xdg_cache_dir(),NEW_CACHE,NULL);
    if (g_file_test(old_dir,G_FILE_TEST_EXISTS) && !g_file_test(new_dir,G_FILE_TEST_EXISTS)){
	TRACE("moving old cache files: %s -> %s",old_dir, new_dir);
	rename(old_dir, new_dir);
	result=1;
    }
    g_free(old_dir);
    g_free(new_dir);

    /* config */
    old_dir=g_build_filename(xdg_config_dir(),OLD_CONFIG,NULL);
    new_dir=g_build_filename(xdg_config_dir(),NEW_CONFIG,NULL);
    if (g_file_test(old_dir,G_FILE_TEST_EXISTS) && !g_file_test(new_dir,G_FILE_TEST_EXISTS)){
	TRACE("moving old config files: %s -> %s",old_dir, new_dir);
	rename(old_dir, new_dir);
	result=1;
    }
    g_free(old_dir);
    g_free(new_dir);

    /* modules */

    old_dir=g_build_filename(xdg_cache_dir(),OLD_MODULES,NULL);
    new_dir=g_build_filename(xdg_cache_dir(),NEW_MODULES,NULL);
    if (g_file_test(old_dir,G_FILE_TEST_EXISTS) && !g_file_test(new_dir,G_FILE_TEST_EXISTS)){
	TRACE("moving old module files: %s -> %s",old_dir, new_dir);
	rename(old_dir, new_dir);
	result=1;
    }
    g_free(old_dir);
    g_free(new_dir);

    
    return result;
}


static void
dont_care(GtkButton *button, gpointer data){
    GtkWidget *dialog=(GtkWidget *)data;
    gtk_widget_hide(dialog);
    while (gtk_events_pending())gtk_main_iteration();
    gtk_widget_destroy(dialog);
}
static void
yea_restart(GtkButton *button, gpointer data){
    GtkWidget *dialog=(GtkWidget *)data;
    gtk_widget_hide(dialog);
    while (gtk_events_pending())gtk_main_iteration();
    gtk_widget_destroy(dialog);
    execvp(xffm_details->argv[0],xffm_details->argv);
    exit(1);    
}


static void finishit(int sig)
{
    TRACE("got signal %d (SIGUSR1=%d,SIGUSR2=%d)",sig,SIGUSR1,SIGUSR2);
    fflush(NULL);
    if(sig == SIGUSR1)
    {
	if (xffm_details && xffm_details->widget){
	    GtkWidget *widget=(GtkWidget *)xffm_details->widget;
	    gtk_widget_show_all(widget);
	    g_object_set_data(G_OBJECT(xffm_details->widget),"dismissed",NULL);
	}
	return;
    }
    else if(sig == SIGUSR2)
    {
	gchar *g=g_strdup_printf(_("Icon cache has changed. \nSome icons may not display correctly unless %s is restarted"),xffm_details->argv[0]);
	GtkWidget *dialog=xffm_confirm_dialog (NULL, g, _("I don't care"),_("Yes, restart"));
	GtkWidget *false_button=g_object_get_data(G_OBJECT(dialog),"action_false_button");
	GtkWidget *true_button=g_object_get_data(G_OBJECT(dialog),"action_true_button");
	g_signal_connect(false_button,"clicked",GTK_SIGNAL_FUNC(dont_care),dialog);
	g_signal_connect(true_button,"clicked",GTK_SIGNAL_FUNC(yea_restart),dialog);
	if (!dialog){
	    execvp(xffm_details->argv[0],xffm_details->argv);
	    exit(1);
	}
	g_free(g);
	return;
    }
    else
    {
	g_warning("xffm: signal %d received. Cleaning up before exiting\n", sig);
	cleanup_tmpfiles();
	function_void("mcs-shm","xffmsettings","mcs_shm_stop");
	exit(1);
    }
}

static gboolean setup_dir(gchar *path){
	struct stat st;
	if(stat(path, &st) < 0)
	{
	    if(mkdir(path, 0770) < 0)
	    {
		printf("xffm: cannot write to %s\n", path);
		assert_not_reached();
	    }
	    g_warning ("%s created\n", path);
	    return TRUE;
	}
	return FALSE;
}

static void verify_directories(void){
    gchar *path;
    path=g_build_filename(xdg_config_dir(),"xffm",NULL);
    setup_dir(path);
    g_free(path);
        
    path=g_build_filename(xdg_cache_dir(),"xffm",NULL);
    setup_dir(path);
    g_free(path);
    
    path=g_build_filename(xdg_cache_dir(),"xffm","books",NULL);
    setup_dir(path);
    g_free(path);
    
    path=g_build_filename(xdg_cache_dir(),"xffm","histories",NULL);
    setup_dir(path);
    g_free(path);
    
    path=g_build_filename(xdg_cache_dir(),"xffm","modules",NULL);
    setup_dir(path);
    g_free(path);

     return ;
}

static void signal_connections(void)
{
#ifdef HAVE_SIGACTION
	struct sigaction act;
	act.sa_handler = finishit;
	sigemptyset(&act.sa_mask);
#ifdef SA_RESTART
	act.sa_flags = SA_RESTART;
#else
	act.sa_flags = 0;
#endif
	sigaction(SIGHUP,&act,NULL);
	sigaction(SIGTERM,&act,NULL);
#ifndef DEBUG
	sigaction(SIGINT,&act,NULL);
	sigaction(SIGQUIT,&act,NULL);
	sigaction(SIGABRT,&act,NULL);
	sigaction(SIGBUS,&act,NULL);
#ifndef FORCE_CORE
	sigaction(SIGSEGV,&act,NULL);
#endif
	sigaction(SIGFPE,&act,NULL);
	
	sigaction(SIGUSR1,&act,NULL);
	sigaction(SIGUSR2,&act,NULL);
#endif
#else
	signal(SIGHUP, finishit);
	signal(SIGTERM, finishit);
#ifndef DEBUG
	signal(SIGINT, finishit);
	signal(SIGQUIT, finishit);
	signal(SIGABRT, finishit);
	signal(SIGBUS, finishit);
#ifndef FORCE_CORE
	signal(SIGSEGV, finishit);
#endif
	signal(SIGFPE, finishit);
	signal(SIGUSR1, finishit);
	signal(SIGUSR2, finishit);
#endif	
#endif
}

static void xffm_details_init(int argc, char *argv[]) {
    int i;
    if (xffm_details) return;
    xffm_details = (xffm_details_t *) malloc(sizeof(xffm_details_t));
    memset(xffm_details,0,sizeof(xffm_details_t));
    xffm_details->argv=(char **)malloc((argc+3)*sizeof(char *));
    memset(xffm_details->argv,0,(argc+3)*sizeof(char *));
    
    xffm_details->argv[0] = g_path_get_basename(argv[0]);
    for (i=1; i<argc; i++) {
	xffm_details->argv[i] = g_strdup(argv[i]);
    }
    xffm_details->argc = argc;
    xffm_details->preferences = DEFAULT_PREFERENCES;
}

static gboolean version_query(int argc, char *argv[]){
    int i;
    for(i = 0; i < argc; i++){
        if(strcmp(argv[i], "--version") == 0)  {
	    g_print ("\tThis is %s version %s\n", 
                    PACKAGE, VERSION);
	    g_print ("\tbuilt with GTK+-%d.%d.%d, ", 
                    GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION);
	    g_print ("linked with GTK+-%d.%d.%d.\n", 
                    gtk_major_version, gtk_minor_version, gtk_micro_version);
	    g_print ("\tDBH version-%s, ",DBH_VERSION); 
#ifdef HAVE_RODENT_ICONS
	    g_print ("using Rodent icons as default.\n");
#else
#ifdef HAVE_GNOME_ICONS
	    g_print ("using Gnome icons as default.\n");
#endif
#endif
	    exit (0);
	}
    }
    return FALSE;
}

static gboolean disable_desktop=FALSE;

static void
process_arg(int *argc, char ***argv){
    int i;
    int out_argc=0;
    static char **out_argv;

    out_argv=(char **)malloc((*argc+1) * sizeof(char *));
    out_argv[*argc]=NULL;
    if (*argc-1 > 0) out_argv[*argc-1]=NULL;
    for (i=0; i < *argc; i++){
	if (strcmp(*((*argv)+i),"$HOME")==0) *((*argv)+i) = (char *)g_get_home_dir();
	if (strcmp(*((*argv)+i),"--disable-desktop") == 0
	    || 	strcmp(*((*argv)+i),"--no-desktop") == 0) {
		disable_desktop=TRUE;
	} else {
	    out_argv[out_argc] = *((*argv)+i);
	    TRACE("out_argcv[%d]=%s",out_argc,out_argv[out_argc]);
	    out_argc++;
	}
	if (strcmp(*((*argv)+i),"--sm-client-id") == 0 &&
	    strstr(*((*argv)),"xffm-run") ) exit(1);
    }
    *argv=out_argv;
    *argc=out_argc;
}

int main(int argc, char *argv[])
{
#ifdef FORCE_CORE
    struct rlimit rlim;
    //g_warning("Development version, enabling core dumps...");
    rlim.rlim_cur=RLIM_INFINITY;
    rlim.rlim_max=RLIM_INFINITY;
    setrlimit(RLIMIT_CORE, &rlim);
#endif
    /* do the following before allowing any dynamic library
     * to be loaded to memory (except glib)... */
    xffm_sanity_check(argc,argv,LIBXFFM_SERIAL);
    if (version_query(argc, argv)) exit(1);
#ifdef XFFM_ICONVIEW_BINARY
    if (strcmp(argv[0],"xffm")==0) argv[0]="xffm-iconview"; 
    else if (strcmp(argv[0],"xfce4-fm")==0) argv[0]="xffm-iconview"; 
#endif
   
    process_arg(&argc, &argv);
   if (!g_module_supported()){
	    g_error("g_module_supported() != TRUE\n");
	    exit(1);
    }
    restore_old_histories();
    signal_connections();
    TRACE("call to xffm_details_init");
    
    xffm_details_init(argc, argv);
	
    
    /***************************************************/
    /* start loading required dynamic libraries here... */  
    verify_directories(); 
#ifdef ENABLE_NLS
    /* this binds xffm domain: */
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bindlibxffm();
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
#endif
    textdomain(GETTEXT_PACKAGE);
#endif
    TRACE("call to gtk_set_locale");
    gtk_set_locale();
    TRACE("call to gtk_init");
    gtk_init(&argc, &argv);


    TRACE("call to init_xffm_env");
    init_xffm_env(); /* allocate memory for dynamic environment variables */
    xffm_setenv("PWD",(gchar *)GETWD,FALSE);
 
   
#ifdef XFFM_TREEVIEW_BINARY
    config_treeview();
#endif
    
#ifdef XFFM_DESKVIEW_BINARY
    if (argc < 2 || (strcmp(argv[1],"--id") && strcmp(argv[1],"-id")))
#endif
        function_void("mcs-shm","xffmsettings","mcs_shm_start"); 
    /* read in shm settings */

    {
	gchar *name=NULL;
	if (getenv("XFFM_ICON_THEME") && strlen(getenv("XFFM_ICON_THEME"))) name=getenv("XFFM_ICON_THEME");
	if (!ICON_load_theme(name)) g_warning("cannot load mime_icon theme: %s",(name?name:"null"));
    }

    
    TRACE("argv[0]=%s",argv[0]);
	DBG("disable_desktop=%d",disable_desktop);
    if (!disable_desktop && strstr(argv[0],"xffm-iconview") ) {
            GError *error=NULL;
	    if (getenv("DISABLE_DESKTOP") && strlen(getenv("DISABLE_DESKTOP"))) 
	    {
		DBG("Deskview disabled");
	    } else {
		Window xid;
		Atom selection_atom=XInternAtom(GDK_DISPLAY(), "XFFM_DESKVIEW_SELECTION", False);
		if((xid = XGetSelectionOwner(GDK_DISPLAY(), selection_atom))){
		    DBG("xffm-deskview already running");
		} else if (!g_spawn_command_line_async ("xffm-deskview", &error))
		{
		    g_warning(error->message);
		}

	    }
    } 
    
    if (strstr(argv[0],"xffm-run") || strstr(argv[0],"xffm-find")){
	smc_connect(argc, argv, SmRestartNever);
    }
    else {
#ifdef XFFM_ICONVIEW_BINARY
	smc_connect(argc, argv, SmRestartIfRunning);
#endif
#ifdef XFFM_DESKVIEW_BINARY
	smc_connect(argc, argv, SmRestartImmediately);
#endif
#ifdef XFFM_TREEVIEW_BINARY
	smc_connect(argc, argv, SmRestartIfRunning);
#endif
    }
    argv[0]="foo";
    TRACE("opening GUI now...");
#ifdef XFFM_ICONVIEW_BINARY
    create_gridview();
#endif
	
#ifdef XFFM_DESKVIEW_BINARY
    create_desktop();
#endif
	
#ifdef XFFM_TREEVIEW_BINARY
    
    fireup_treeview();
#endif
	
    chdir(GETWD);
    gtk_main();
    /* free reference to shm settings */
    function_void("mcs-shm","xffmsettings","mcs_shm_stop");
    cleanup_tmpfiles();
    return 0;
}


