#ifndef MESSAGEBOX_H
#define MESSAGEBOX_H

// Message box buttons
enum {
		BOX_OK                   = 0x10000000, // Message box has a only an OK button
		BOX_OK_CANCEL            = 0x20000000, // Message box has OK and CANCEL buttons
		BOX_YES_NO               = 0x30000000, // Message box has YES and NO buttons
		BOX_YES_NO_CANCEL        = 0x40000000, // Message box has YES, NO, and CANCEL buttons
		BOX_QUIT_CANCEL          = 0x50000000, // Message box has QUIT and CANCEL buttons
		BOX_QUIT_SAVE_CANCEL     = 0x60000000, // Message box has QUIT, SAVE, and CANCEL buttons
		BOX_OK_SU 			     = 0x70000000  // Message box has OK and SU buttons
};
enum {
		BOX_CLICKED_YES      = 1,            // The YES button was clicked
		BOX_CLICKED_NO       = 2,            // The NO button was clicked
		BOX_CLICKED_OK       = 3,            // The OK button was clicked
		BOX_CLICKED_CANCEL   = 4,            // The CANCEL button was clicked
		BOX_CLICKED_QUIT     = 5,            // The QUIT button was clicked
		BOX_CLICKED_SAVE     = 6,            // The SAVE button was clicked
		BOX_CLICKED_SU       = 7             // The SU button was clicked
 };
  
  
// Message box
class FXAPI MessageBox : public FXDialogBox
{
    FXDECLARE(MessageBox)
protected:
    MessageBox()
    {}
private:
    MessageBox(const MessageBox&);
    MessageBox &operator=(const MessageBox&);
    void initialize(const FXString& text,FXIcon* ic,FXuint whichbuttons);
public:
    long onCmdClicked(FXObject*,FXSelector,void*);
    long onCmdCancel(FXObject*,FXSelector,void*);
	long onCmdSu(FXObject*,FXSelector sel,void*);
public:
    enum {
        ID_CLICKED_YES=FXDialogBox::ID_LAST,
        ID_CLICKED_NO,
        ID_CLICKED_OK,
        ID_CLICKED_CANCEL,
        ID_CLICKED_QUIT,
        ID_CLICKED_SAVE,
        ID_CLICKED_SU,
        ID_LAST
    };
public:

    // Construct message box with given caption, icon, and message text
    MessageBox(FXWindow* owner,const FXString& caption,const FXString& text,FXIcon* ic=NULL,FXuint opts=0,FXint x=0,FXint y=0);

    // Construct free floating message box with given caption, icon, and message text
    MessageBox(FXApp* a,const FXString& caption,const FXString& text,FXIcon* ic=NULL,FXuint opts=0,FXint x=0,FXint y=0);

    // Show a modal error message.
    // The text message may contain printf-tyle formatting commands.
    static FXuint error(FXWindow* owner,FXuint opts,const char* caption,const char* message,...) FX_PRINTF(4,5) ;
    static FXuint error(FXApp* app,FXuint opts,const char* caption,const char* message,...) FX_PRINTF(4,5) ;

    // Show a modal warning message
    // The text message may contain printf-tyle formatting commands.
    static FXuint warning(FXWindow* owner,FXuint opts,const char* caption,const char* message,...) FX_PRINTF(4,5) ;
    static FXuint warning(FXApp* app,FXuint opts,const char* caption,const char* message,...) FX_PRINTF(4,5) ;

    // Show a modal question dialog
    // The text message may contain printf-tyle formatting commands.
    static FXuint question(FXWindow* owner,FXuint opts,const char* caption,const char* message,...) FX_PRINTF(4,5) ;
    static FXuint question(FXApp* app,FXuint opts,const char* caption,const char* message,...) FX_PRINTF(4,5) ;

    // Show a modal information dialog
    // The text message may contain printf-tyle formatting commands.
    static FXuint information(FXWindow* owner,FXuint opts,const char* caption,const char* message,...) FX_PRINTF(4,5) ;
    static FXuint information(FXApp* app,FXuint opts,const char* caption,const char* message,...) FX_PRINTF(4,5) ;

};

#endif
