#include <fox/fx.h>
#include <stdio.h>
#include <string.h>

class XFileQuery : public FXMainWindow
{
    FXDECLARE(XFileQuery)
protected:
    FXMenubar			*menubar;			// Menu bar
    FXMenuPane			*filemenu;			// File menu
    FXMenuPane			*helpmenu;			// Help menu
    FXHorizontalFrame	*contents;			// Sunken border for text widget
    FXHorizontalFrame	*toolbar;			// Toolbar
    FXString 			filename;			// Current package name
    FXTreeList 			*list;				// File list
    FXText 				*description;		// Package description
    FXbool 				desc_clean;			// Clean description flag
    FXbool 				list_clean;			// Clean list flag
	FXIcon				*folder_open;		// Folder icon for file list
	FXIcon				*folder_closed;		// Folder icon for file list
	FXIcon				*doc;				// Document icon for file list
    XFileQuery()
    {}
public:
    enum{
        ID_DESCRIPTION=FXMainWindow::ID_LAST,
        ID_FILELIST,
        ID_UNINSTALL,
        ID_UPGRADE,
		ID_ABOUT,
		ID_OPEN,
        ID_QUIT,
        ID_LAST
    };
    void create();
    XFileQuery(FXApp *a, char *file);
    long onCmdUninstall(FXObject*,FXSelector,void*);
    long onCmdUpgrade(FXObject*,FXSelector,void*);
	long onCmdAbout(FXObject*,FXSelector,void*);
	long onCmdOpen(FXObject*,FXSelector,void*);
    long onUpdDescription(FXObject*,FXSelector,void*);
    long onUpdFileList(FXObject*,FXSelector,void*);
	void saveConfig();
    long onCmdQuit(FXObject*,FXSelector,void*);
};
