#ifndef HISTDIALOG_H
#define HISTDIALOG_H

#include "DialogBox.h"

class XComApp;

class MyComboBox : public FXComboBox
{
    FXDECLARE(MyComboBox)
    MyComboBox()
    {
        ;
    }
public:
    FXTextField *getTextEntry()
    {
        return field;
    }
    void CursorEnd()
    {
		field->onCmdCursorEnd(0,0,0);
        field->setFocus();
    }
    MyComboBox(FXComposite *p,FXint cols,FXint nvis,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0);
};

class HistInputDialog : public DialogBox
{
    FXDECLARE(HistInputDialog)
protected:
    FXVerticalFrame* contents;
    FXHorizontalFrame* buttons;
    FXHorizontalFrame* checkbutton;
    MyComboBox *input;
    FXLabel*           label;
    FXDataTarget*      string_target;
private:
    HistInputDialog()
    {
        ;
    }
public:
    HistInputDialog(FXWindow*,FXString& ,FXString,FXString,FXString label="",FXIcon *ic=NULL, int option=0, FXString=NULL);
    virtual void create();
    long onCmdKeyPress(FXObject*,FXSelector,void*);
    FXString getText()
    {
        return input->getText();
    }
    void CursorEnd();
    void SelectAll();
    void appendItem(char *str)
    {
        input->appendItem(str);
    };
    FXString getHistoryItem(int pos)
    {
        return input->getItemText(pos);
    }
    int getHistorySize()
    {
        return input->getNumItems();
    }
};
#endif
