/* $Id: xdg-pattern.h,v 1.2 2004/08/04 10:13:22 bmeurer Exp $ */
/*-
 * Copyright (c) 2004 os-cillation
 * All rights reserved.
 *
 * Written by Benedikt Meurer <bm@os-cillation.de>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __XDG_PATTERN_H__
#define __XDG_PATTERN_H__

#include "xdg-desktop-support.h"

G_BEGIN_DECLS;

#define XDG_PATTERN_TYPE(val) ((XdgPatternType) (val))
#define XDG_PATTERN(obj)      ((XdgPattern *)(obj))


typedef enum   _XdgPatternType XdgPatternType;
typedef struct _XdgPattern     XdgPattern;


enum _XdgPatternType
{
  XDG_PATTERN_OR,
  XDG_PATTERN_AND,
  XDG_PATTERN_NOT,
  XDG_PATTERN_ALL,
  XDG_PATTERN_CATEGORY,
  XDG_PATTERN_FILENAME,
};


struct _XdgPattern
{
  XdgPatternType  type;
  XdgPattern     *parent;

  union
  {
    /* OR, AND, NOT */
    GList *children;  /* FIXME: GSList ? */

    /* CATEGORY, FILENAME */
    gchar *name;
  };
};


XdgPattern  *xdg_pattern_new   (XdgPatternType           type,
                                const gchar             *name);

XdgPattern  *xdg_pattern_copy  (const XdgPattern      *source);

XdgPattern  *xdg_pattern_merge  (XdgPattern *first,
                                 XdgPattern *second);

gboolean     xdg_pattern_match (const XdgPattern      *pattern,
                                const XdgDesktopEntry *entry);

void         xdg_pattern_free  (XdgPattern            *pattern);

void         xdg_pattern_append (XdgPattern *parent,
                                 XdgPattern *pattern);

G_END_DECLS;

#endif /* !__XDG_PATTERN_H__ */
