/* window.c generated by valac 0.56.14, the Vala compiler
 * generated from window.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "libnotes.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>

#define XNP_WINDOW_ui_string "\n" \
"<ui>\n" \
"  <accelerator action=\"close-window\" />\n" \
"  <accelerator action=\"new-window\" />\n" \
"  <accelerator action=\"delete-window\" />\n" \
"  <accelerator action=\"rename-window\" />\n" \
"  <accelerator action=\"new-note\" />\n" \
"  <accelerator action=\"delete-note\" />\n" \
"  <accelerator action=\"rename-note\" />\n" \
"  <accelerator action=\"cancel\" />\n" \
"  <accelerator action=\"next-note\" />\n" \
"  <accelerator action=\"prev-note\" />\n" \
"</ui>\n"

enum  {
	XNP_WINDOW_0_PROPERTY,
	XNP_WINDOW_NAME_PROPERTY,
	XNP_WINDOW_CURRENT_NOTE_PROPERTY,
	XNP_WINDOW_N_PAGES_PROPERTY,
	XNP_WINDOW_EMPTY_PROPERTY,
	XNP_WINDOW_SHOW_TABS_PROPERTY,
	XNP_WINDOW_TABS_POSITION_PROPERTY,
	XNP_WINDOW_ABOVE_PROPERTY,
	XNP_WINDOW_STICKY_PROPERTY,
	XNP_WINDOW_SHOW_REFRESH_BUTTON_PROPERTY,
	XNP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* xnp_window_properties[XNP_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef void (*XnpWindowCallback) (gpointer user_data);
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
enum  {
	XNP_WINDOW_ACTION_SIGNAL,
	XNP_WINDOW_SAVE_DATA_SIGNAL,
	XNP_WINDOW_NOTE_INSERTED_SIGNAL,
	XNP_WINDOW_NOTE_DELETED_SIGNAL,
	XNP_WINDOW_NOTE_RENAMED_SIGNAL,
	XNP_WINDOW_NOTE_MOVED_SIGNAL,
	XNP_WINDOW_NUM_SIGNALS
};
static guint xnp_window_signals[XNP_WINDOW_NUM_SIGNALS] = {0};

struct _XnpWindowPrivate {
	XnpApplication* app;
	gint width;
	gint height;
	GtkMenu* menu;
	GtkCheckMenuItem* mi_above;
	GtkCheckMenuItem* mi_sticky;
	GtkImage* menu_image;
	GtkLabel* title_label;
	XnpTitleBarButton* refresh_button;
	XnpTitleBarButton* left_arrow_button;
	XnpTitleBarButton* right_arrow_button;
	XnpTitleBarButton* close_button;
	GtkBox* content_box;
	GtkNotebook* notebook;
	GtkUIManager* ui;
	GtkActionGroup* action_group;
	gint CORNER_MARGIN;
	GdkCursor* CURSOR_TOP_LC;
	GdkCursor* CURSOR_TOP;
	GdkCursor* CURSOR_TOP_RC;
	GdkCursor* CURSOR_RIGHT;
	GdkCursor* CURSOR_LEFT;
	GdkCursor* CURSOR_BOTTOM_RC;
	GdkCursor* CURSOR_BOTTOM;
	GdkCursor* CURSOR_BOTTOM_LC;
	gchar* _name;
	gint _tabs_position;
	gboolean _above;
	gboolean _sticky;
	gboolean _show_refresh_button;
};

struct _Block3Data {
	int _ref_count_;
	XnpWindow* self;
	GtkEventBox* menu_evbox;
};

struct _Block4Data {
	int _ref_count_;
	XnpWindow* self;
	XnpWindowCallback callback;
	gpointer callback_target;
};

struct _Block5Data {
	int _ref_count_;
	XnpWindow* self;
	XnpWindowCallback callback;
	gpointer callback_target;
};

struct _Block6Data {
	int _ref_count_;
	XnpWindow* self;
	XnpNote* note;
};

static gint XnpWindow_private_offset;
static gpointer xnp_window_parent_class = NULL;

static void _xnp_window_hide_gcallback (GtkAction* action,
                                 gpointer self);
static void xnp_window_action_new_window (XnpWindow* self);
static void _xnp_window_action_new_window_gcallback (GtkAction* action,
                                              gpointer self);
static void xnp_window_action_delete_window (XnpWindow* self);
static void _xnp_window_action_delete_window_gcallback (GtkAction* action,
                                                 gpointer self);
static void xnp_window_action_rename_window (XnpWindow* self);
static void _xnp_window_action_rename_window_gcallback (GtkAction* action,
                                                 gpointer self);
static void xnp_window_action_new_note (XnpWindow* self);
static void _xnp_window_action_new_note_gcallback (GtkAction* action,
                                            gpointer self);
static void xnp_window_action_delete_note (XnpWindow* self);
static void _xnp_window_action_delete_note_gcallback (GtkAction* action,
                                               gpointer self);
static void xnp_window_action_rename_note (XnpWindow* self);
static void _xnp_window_action_rename_note_gcallback (GtkAction* action,
                                               gpointer self);
static void xnp_window_action_cancel (XnpWindow* self);
static void _xnp_window_action_cancel_gcallback (GtkAction* action,
                                          gpointer self);
static void xnp_window_action_next_note (XnpWindow* self);
static void _xnp_window_action_next_note_gcallback (GtkAction* action,
                                             gpointer self);
static void xnp_window_action_prev_note (XnpWindow* self);
static void _xnp_window_action_prev_note_gcallback (GtkAction* action,
                                             gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static GtkMenu* xnp_window_build_menu (XnpWindow* self);
static gboolean __lambda31_ (Block3Data* _data3_);
static gboolean ___lambda31__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda32_ (Block3Data* _data3_);
static gboolean ___lambda32__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean xnp_window_menu_evbox_pressed_cb (XnpWindow* self,
                                           GtkWidget* widget,
                                           GdkEventButton* event);
static gboolean _xnp_window_menu_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                          GdkEventButton* event,
                                                                          gpointer self);
static void xnp_window_action_refresh_notes (XnpWindow* self);
static void _xnp_window_action_refresh_notes_xnp_icon_button_clicked (XnpIconButton* _sender,
                                                               gpointer self);
static void _xnp_window_action_prev_note_xnp_icon_button_clicked (XnpIconButton* _sender,
                                                           gpointer self);
static void _xnp_window_action_next_note_xnp_icon_button_clicked (XnpIconButton* _sender,
                                                           gpointer self);
static void __lambda33_ (XnpWindow* self);
static void ___lambda33__xnp_icon_button_clicked (XnpIconButton* _sender,
                                           gpointer self);
static gboolean __lambda34_ (XnpWindow* self);
static gboolean ___lambda34__gtk_widget_delete_event (GtkWidget* _sender,
                                               GdkEventAny* event,
                                               gpointer self);
static void __lambda35_ (XnpWindow* self);
static void xnp_window_update_navigation_sensitivity (XnpWindow* self,
                                               gint page_num);
static void xnp_window_save_current_note (XnpWindow* self);
static void ___lambda35__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean xnp_window_window_leaved_cb (XnpWindow* self,
                                      GdkEventCrossing* event);
static gboolean _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                     GdkEventCrossing* event,
                                                                     gpointer self);
static gboolean xnp_window_window_motion_cb (XnpWindow* self,
                                      GdkEventMotion* event);
static gboolean _xnp_window_window_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                      GdkEventMotion* event,
                                                                      gpointer self);
static gboolean xnp_window_window_pressed_cb (XnpWindow* self,
                                       GdkEventButton* event);
static gboolean _xnp_window_window_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                      GdkEventButton* event,
                                                                      gpointer self);
static gboolean xnp_window_window_state_cb (XnpWindow* self,
                                     GdkEventWindowState* event);
static gboolean _xnp_window_window_state_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                    GdkEventWindowState* event,
                                                                    gpointer self);
static gboolean xnp_window_title_evbox_pressed_cb (XnpWindow* self,
                                            GtkWidget* widget,
                                            GdkEventButton* event);
static gboolean _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                           GdkEventButton* event,
                                                                           gpointer self);
static gboolean xnp_window_title_evbox_scrolled_cb (XnpWindow* self,
                                             GtkWidget* widget,
                                             GdkEventScroll* event);
static gboolean _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                      GdkEventScroll* event,
                                                                      gpointer self);
static gboolean xnp_window_notebook_tab_scroll_cb (XnpWindow* self,
                                            GdkEventScroll* event);
static gboolean _xnp_window_notebook_tab_scroll_cb_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                     GdkEventScroll* event,
                                                                     gpointer self);
static void __lambda36_ (XnpWindow* self,
                  GtkNotebook* n,
                  GtkWidget* c,
                  guint p);
static void ___lambda36__gtk_notebook_page_added (GtkNotebook* _sender,
                                           GtkWidget* child,
                                           guint page_num,
                                           gpointer self);
static void __lambda37_ (XnpWindow* self,
                  GtkNotebook* n,
                  GtkWidget* c,
                  guint p);
static void ___lambda37__gtk_notebook_page_removed (GtkNotebook* _sender,
                                             GtkWidget* child,
                                             guint page_num,
                                             gpointer self);
static void __lambda38_ (XnpWindow* self,
                  GtkNotebook* n,
                  GtkWidget* c,
                  guint p);
static void xnp_window_update_title (XnpWindow* self,
                              const gchar* note_name);
static XnpNote* xnp_window_get_note (XnpWindow* self,
                              gint p);
static void ___lambda38__gtk_notebook_switch_page (GtkNotebook* _sender,
                                            GtkWidget* page,
                                            guint page_num,
                                            gpointer self);
static void __lambda39_ (XnpWindow* self);
static void ___lambda39__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda40_ (XnpWindow* self);
static void ___lambda40__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean __lambda41_ (XnpWindow* self,
                      GdkDragContext* c,
                      gint x,
                      gint y,
                      guint t);
static gboolean ___lambda41__gtk_widget_drag_drop (GtkWidget* _sender,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            guint time_,
                                            gpointer self);
static void __lambda42_ (XnpWindow* self,
                  GdkDragContext* c);
static void ___lambda42__gtk_widget_drag_data_received (GtkWidget* _sender,
                                                 GdkDragContext* context,
                                                 gint x,
                                                 gint y,
                                                 GtkSelectionData* selection_data,
                                                 guint info,
                                                 guint time_,
                                                 gpointer self);
static void xnp_window_unshade (XnpWindow* self);
static void xnp_window_shade (XnpWindow* self);
static void xnp_window_note_notify_name_cb (XnpWindow* self,
                                     GObject* object,
                                     GParamSpec* pspec);
static void _xnp_window_notebook_update_tabs_angle (XnpWindow* self);
static gboolean xnp_window_tab_evbox_pressed_cb (XnpWindow* self,
                                          GdkEventButton* event,
                                          XnpNote* note);
static void xnp_window_menu_position (XnpWindow* self,
                               GtkMenu* menu,
                               gint* x,
                               gint* y,
                               gboolean* push_in);
static void _xnp_window_menu_position_gtk_menu_position_func (GtkMenu* menu,
                                                       gint* x,
                                                       gint* y,
                                                       gboolean* push_in,
                                                       gpointer self);
static void xnp_window_menu_add_icon_item (XnpWindow* self,
                                    GtkMenu* menu,
                                    const gchar* text,
                                    const gchar* icon,
                                    const gchar* accel,
                                    XnpWindowCallback callback,
                                    gpointer callback_target);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda25_ (Block4Data* _data4_);
static void ___lambda25__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static GtkCheckMenuItem* xnp_window_menu_add_check_item (XnpWindow* self,
                                                  GtkMenu* menu,
                                                  const gchar* text,
                                                  gboolean active,
                                                  XnpWindowCallback callback,
                                                  gpointer callback_target);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda26_ (Block5Data* _data5_);
static void ___lambda26__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                               gpointer self);
static void xnp_window_menu_add_separator (XnpWindow* self,
                                    GtkMenu* menu);
static void xnp_window_update_menu_go (XnpWindow* self,
                                GtkWidget* widget);
static void _xnp_window_update_menu_go_gtk_widget_show (GtkWidget* _sender,
                                                 gpointer self);
static void _xnp_window_action_new_note_xnp_window_callback (gpointer self);
static void _xnp_window_action_delete_note_xnp_window_callback (gpointer self);
static void _xnp_window_action_rename_note_xnp_window_callback (gpointer self);
static void _xnp_window_action_cancel_xnp_window_callback (gpointer self);
static void __lambda27_ (XnpWindow* self);
static void ___lambda27__xnp_window_callback (gpointer self);
static void __lambda28_ (XnpWindow* self);
static void ___lambda28__xnp_window_callback (gpointer self);
static void __lambda29_ (XnpWindow* self);
static void ___lambda29__xnp_window_callback (gpointer self);
static void __lambda30_ (XnpWindow* self);
static void ___lambda30__xnp_window_callback (gpointer self);
static void __lambda22_ (XnpWindow* self,
                  GtkWidget* w);
static void ___lambda22__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void ________lambda23_ (XnpWindow* self,
                        GtkMenuItem* i);
static void _________lambda23__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                gpointer self);
static void _____lambda24_ (XnpWindow* self,
                     GtkMenuItem* i);
static void ______lambda24__gtk_menu_item_activate (GtkMenuItem* _sender,
                                             gpointer self);
static void _xnp_window_action_rename_window_xnp_window_callback (gpointer self);
static void _xnp_window_action_delete_window_xnp_window_callback (gpointer self);
static void _xnp_window_action_new_window_xnp_window_callback (gpointer self);
static gboolean xnp_window_note_name_exists (XnpWindow* self,
                                      const gchar* name);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _xnp_window_note_notify_name_cb_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void __lambda6_ (XnpWindow* self,
                 XnpNote* note);
static void ___lambda6__xnp_note_save_data (XnpNote* _sender,
                                     gpointer self);
static gboolean __lambda7_ (Block6Data* _data6_,
                     GdkEventButton* e);
static gboolean ___lambda7__gtk_widget_button_press_event (GtkWidget* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT_OBJECT (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data);
static GObject * xnp_window_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static void xnp_window_finalize (GObject * obj);
static GType xnp_window_get_type_once (void);
static void _vala_xnp_window_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_xnp_window_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);

static const GtkActionEntry XNP_WINDOW_action_entries[10] = {{"close-window", NULL, NULL, "Escape", NULL, (GCallback) _xnp_window_hide_gcallback}, {"new-window", NULL, NULL, "<Ctrl><Shift>n", NULL, (GCallback) _xnp_window_action_new_window_gcallback}, {"delete-window", NULL, NULL, "<Ctrl><Shift>w", NULL, (GCallback) _xnp_window_action_delete_window_gcallback}, {"rename-window", NULL, NULL, "<Shift>F2", NULL, (GCallback) _xnp_window_action_rename_window_gcallback}, {"new-note", NULL, NULL, "<Ctrl>n", NULL, (GCallback) _xnp_window_action_new_note_gcallback}, {"delete-note", NULL, NULL, "<Ctrl>w", NULL, (GCallback) _xnp_window_action_delete_note_gcallback}, {"rename-note", NULL, NULL, "F2", NULL, (GCallback) _xnp_window_action_rename_note_gcallback}, {"cancel", NULL, NULL, "<Ctrl>z", NULL, (GCallback) _xnp_window_action_cancel_gcallback}, {"next-note", NULL, NULL, "<Ctrl>Page_Down", NULL, (GCallback) _xnp_window_action_next_note_gcallback}, {"prev-note", NULL, NULL, "<Ctrl>Page_Up", NULL, (GCallback) _xnp_window_action_prev_note_gcallback}};

static inline gpointer
xnp_window_get_instance_private (XnpWindow* self)
{
	return G_STRUCT_MEMBER_P (self, XnpWindow_private_offset);
}

static void
_xnp_window_hide_gcallback (GtkAction* action,
                            gpointer self)
{
	xnp_window_hide ((XnpWindow*) self);
}

static void
_xnp_window_action_new_window_gcallback (GtkAction* action,
                                         gpointer self)
{
	xnp_window_action_new_window ((XnpWindow*) self);
}

static void
_xnp_window_action_delete_window_gcallback (GtkAction* action,
                                            gpointer self)
{
	xnp_window_action_delete_window ((XnpWindow*) self);
}

static void
_xnp_window_action_rename_window_gcallback (GtkAction* action,
                                            gpointer self)
{
	xnp_window_action_rename_window ((XnpWindow*) self);
}

static void
_xnp_window_action_new_note_gcallback (GtkAction* action,
                                       gpointer self)
{
	xnp_window_action_new_note ((XnpWindow*) self);
}

static void
_xnp_window_action_delete_note_gcallback (GtkAction* action,
                                          gpointer self)
{
	xnp_window_action_delete_note ((XnpWindow*) self);
}

static void
_xnp_window_action_rename_note_gcallback (GtkAction* action,
                                          gpointer self)
{
	xnp_window_action_rename_note ((XnpWindow*) self);
}

static void
_xnp_window_action_cancel_gcallback (GtkAction* action,
                                     gpointer self)
{
	xnp_window_action_cancel ((XnpWindow*) self);
}

static void
_xnp_window_action_next_note_gcallback (GtkAction* action,
                                        gpointer self)
{
	xnp_window_action_next_note ((XnpWindow*) self);
}

static void
_xnp_window_action_prev_note_gcallback (GtkAction* action,
                                        gpointer self)
{
	xnp_window_action_prev_note ((XnpWindow*) self);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		XnpWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->menu_evbox);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda31_ (Block3Data* _data3_)
{
	XnpWindow* self;
	GtkImage* _tmp0_;
	GdkWindow* _tmp1_;
	gboolean result;
	self = _data3_->self;
	_tmp0_ = self->priv->menu_image;
	gtk_image_set_from_icon_name (_tmp0_, "org.xfce.notes.menu-active", (GtkIconSize) GTK_ICON_SIZE_MENU);
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) _data3_->menu_evbox);
	gdk_window_invalidate_rect (_tmp1_, NULL, FALSE);
	result = FALSE;
	return result;
}

static gboolean
___lambda31__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda31_ (self);
	return result;
}

static gboolean
__lambda32_ (Block3Data* _data3_)
{
	XnpWindow* self;
	GtkImage* _tmp0_;
	GdkWindow* _tmp1_;
	gboolean result;
	self = _data3_->self;
	_tmp0_ = self->priv->menu_image;
	gtk_image_set_from_icon_name (_tmp0_, "org.xfce.notes.menu", (GtkIconSize) GTK_ICON_SIZE_MENU);
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) _data3_->menu_evbox);
	gdk_window_invalidate_rect (_tmp1_, NULL, FALSE);
	result = FALSE;
	return result;
}

static gboolean
___lambda32__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda32_ (self);
	return result;
}

static gboolean
_xnp_window_menu_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                 GdkEventButton* event,
                                                                 gpointer self)
{
	gboolean result;
	result = xnp_window_menu_evbox_pressed_cb ((XnpWindow*) self, _sender, event);
	return result;
}

static void
_xnp_window_action_refresh_notes_xnp_icon_button_clicked (XnpIconButton* _sender,
                                                          gpointer self)
{
	xnp_window_action_refresh_notes ((XnpWindow*) self);
}

static void
_xnp_window_action_prev_note_xnp_icon_button_clicked (XnpIconButton* _sender,
                                                      gpointer self)
{
	xnp_window_action_prev_note ((XnpWindow*) self);
}

static void
_xnp_window_action_next_note_xnp_icon_button_clicked (XnpIconButton* _sender,
                                                      gpointer self)
{
	xnp_window_action_next_note ((XnpWindow*) self);
}

static void
__lambda33_ (XnpWindow* self)
{
	xnp_window_hide (self);
}

static void
___lambda33__xnp_icon_button_clicked (XnpIconButton* _sender,
                                      gpointer self)
{
	__lambda33_ ((XnpWindow*) self);
}

static gboolean
__lambda34_ (XnpWindow* self)
{
	gboolean result;
	xnp_window_hide (self);
	result = TRUE;
	return result;
}

static gboolean
___lambda34__gtk_widget_delete_event (GtkWidget* _sender,
                                      GdkEventAny* event,
                                      gpointer self)
{
	gboolean result;
	result = __lambda34_ ((XnpWindow*) self);
	return result;
}

static void
__lambda35_ (XnpWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_object_get ((GtkWindow*) self, "is-active", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkImage* _tmp2_;
		XnpTitleBarButton* _tmp3_;
		XnpTitleBarButton* _tmp4_;
		GtkNotebook* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp2_ = self->priv->menu_image;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
		_tmp3_ = self->priv->refresh_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
		_tmp4_ = self->priv->close_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
		_tmp5_ = self->priv->notebook;
		g_object_get (_tmp5_, "page", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		xnp_window_update_navigation_sensitivity (self, _tmp7_);
	} else {
		GtkImage* _tmp8_;
		XnpTitleBarButton* _tmp9_;
		XnpTitleBarButton* _tmp10_;
		XnpTitleBarButton* _tmp11_;
		XnpTitleBarButton* _tmp12_;
		_tmp8_ = self->priv->menu_image;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
		_tmp9_ = self->priv->refresh_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
		_tmp10_ = self->priv->left_arrow_button;
		xnp_icon_button_set_enabled ((XnpIconButton*) _tmp10_, FALSE);
		_tmp11_ = self->priv->right_arrow_button;
		xnp_icon_button_set_enabled ((XnpIconButton*) _tmp11_, FALSE);
		_tmp12_ = self->priv->close_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, FALSE);
		xnp_window_save_current_note (self);
	}
}

static void
___lambda35__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda35_ ((XnpWindow*) self);
}

static gboolean
_xnp_window_window_leaved_cb_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                            GdkEventCrossing* event,
                                                            gpointer self)
{
	gboolean result;
	result = xnp_window_window_leaved_cb ((XnpWindow*) self, event);
	return result;
}

static gboolean
_xnp_window_window_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                             GdkEventMotion* event,
                                                             gpointer self)
{
	gboolean result;
	result = xnp_window_window_motion_cb ((XnpWindow*) self, event);
	return result;
}

static gboolean
_xnp_window_window_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                             GdkEventButton* event,
                                                             gpointer self)
{
	gboolean result;
	result = xnp_window_window_pressed_cb ((XnpWindow*) self, event);
	return result;
}

static gboolean
_xnp_window_window_state_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                           GdkEventWindowState* event,
                                                           gpointer self)
{
	gboolean result;
	result = xnp_window_window_state_cb ((XnpWindow*) self, event);
	return result;
}

static gboolean
_xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                  GdkEventButton* event,
                                                                  gpointer self)
{
	gboolean result;
	result = xnp_window_title_evbox_pressed_cb ((XnpWindow*) self, _sender, event);
	return result;
}

static gboolean
_xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event (GtkWidget* _sender,
                                                             GdkEventScroll* event,
                                                             gpointer self)
{
	gboolean result;
	result = xnp_window_title_evbox_scrolled_cb ((XnpWindow*) self, _sender, event);
	return result;
}

static gboolean
_xnp_window_notebook_tab_scroll_cb_gtk_widget_scroll_event (GtkWidget* _sender,
                                                            GdkEventScroll* event,
                                                            gpointer self)
{
	gboolean result;
	result = xnp_window_notebook_tab_scroll_cb ((XnpWindow*) self, event);
	return result;
}

static void
__lambda36_ (XnpWindow* self,
             GtkNotebook* n,
             GtkWidget* c,
             guint p)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->notebook;
	g_object_set (_tmp0_, "page", (gint) p, NULL);
	xnp_window_update_navigation_sensitivity (self, (gint) p);
}

static void
___lambda36__gtk_notebook_page_added (GtkNotebook* _sender,
                                      GtkWidget* child,
                                      guint page_num,
                                      gpointer self)
{
	__lambda36_ ((XnpWindow*) self, _sender, child, page_num);
}

static void
__lambda37_ (XnpWindow* self,
             GtkNotebook* n,
             GtkWidget* c,
             guint p)
{
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	xnp_window_update_navigation_sensitivity (self, (gint) p);
}

static void
___lambda37__gtk_notebook_page_removed (GtkNotebook* _sender,
                                        GtkWidget* child,
                                        guint page_num,
                                        gpointer self)
{
	__lambda37_ ((XnpWindow*) self, _sender, child, page_num);
}

static void
__lambda38_ (XnpWindow* self,
             GtkNotebook* n,
             GtkWidget* c,
             guint p)
{
	XnpNote* _tmp0_;
	XnpNote* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	xnp_window_save_current_note (self);
	_tmp0_ = xnp_window_get_note (self, (gint) p);
	_tmp1_ = _tmp0_;
	_tmp2_ = xnp_note_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	xnp_window_update_title (self, _tmp3_);
	_g_object_unref0 (_tmp1_);
	xnp_window_update_navigation_sensitivity (self, (gint) p);
}

static void
___lambda38__gtk_notebook_switch_page (GtkNotebook* _sender,
                                       GtkWidget* page,
                                       guint page_num,
                                       gpointer self)
{
	__lambda38_ ((XnpWindow*) self, _sender, page, page_num);
}

static void
__lambda39_ (XnpWindow* self)
{
	XnpNote* current_note = NULL;
	XnpNote* _tmp0_;
	XnpNote* _tmp1_;
	XnpNote* _tmp2_;
	XnpNote* _tmp3_;
	GtkLabel* _tmp8_;
	_tmp0_ = xnp_window_get_current_note (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	current_note = _tmp2_;
	_tmp3_ = current_note;
	if (_tmp3_ != NULL) {
		XnpNote* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = current_note;
		_tmp5_ = xnp_note_get_name (_tmp4_);
		_tmp6_ = _tmp5_;
		xnp_window_update_title (self, _tmp6_);
	} else {
		const gchar* _tmp7_;
		_tmp7_ = self->priv->_name;
		gtk_window_set_title ((GtkWindow*) self, _tmp7_);
	}
	_tmp8_ = self->priv->title_label;
	if (gtk_widget_get_mapped ((GtkWidget*) _tmp8_)) {
		GtkLabel* _tmp9_;
		GdkWindow* _tmp10_;
		_tmp9_ = self->priv->title_label;
		_tmp10_ = gtk_widget_get_window ((GtkWidget*) _tmp9_);
		gdk_window_invalidate_rect (_tmp10_, NULL, FALSE);
	}
	_g_object_unref0 (current_note);
}

static void
___lambda39__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda39_ ((XnpWindow*) self);
}

static void
__lambda40_ (XnpWindow* self)
{
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = self->priv->title_label;
	_tmp1_ = gtk_window_get_title ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_markup_printf_escaped ("<b>%s</b>", _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_label_set_markup (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
}

static void
___lambda40__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda40_ ((XnpWindow*) self);
}

static gboolean
__lambda41_ (XnpWindow* self,
             GdkDragContext* c,
             gint x,
             gint y,
             guint t)
{
	GtkNotebook* src_notebook = NULL;
	GtkWidget* _tmp0_;
	GtkNotebook* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkNotebook* _tmp3_;
	XnpWindow* src_win = NULL;
	GtkNotebook* _tmp6_;
	GtkWidget* _tmp7_;
	XnpWindow* _tmp8_;
	XnpWindow* _tmp9_;
	XnpWindow* _tmp10_;
	XnpNote* _tmp11_;
	XnpNote* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean result;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = gtk_drag_get_source_widget (c);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_notebook_get_type ()) ? ((GtkNotebook*) _tmp0_) : NULL);
	src_notebook = _tmp1_;
	_tmp3_ = src_notebook;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GtkNotebook* _tmp4_;
		GtkNotebook* _tmp5_;
		_tmp4_ = src_notebook;
		_tmp5_ = self->priv->notebook;
		_tmp2_ = _tmp4_ == _tmp5_;
	}
	if (_tmp2_) {
		result = FALSE;
		_g_object_unref0 (src_notebook);
		return result;
	}
	_tmp6_ = src_notebook;
	_tmp7_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp6_);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, XNP_TYPE_WINDOW, XnpWindow));
	src_win = _tmp8_;
	_tmp9_ = src_win;
	_tmp10_ = src_win;
	_tmp11_ = xnp_window_get_current_note (_tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_NOTE_MOVED_SIGNAL], 0, _tmp9_, _tmp12_, &_tmp13_);
	if (_tmp13_) {
		result = FALSE;
		_g_object_unref0 (src_win);
		_g_object_unref0 (src_notebook);
		return result;
	}
	gtk_drag_finish (c, FALSE, FALSE, (guint32) t);
	result = TRUE;
	_g_object_unref0 (src_win);
	_g_object_unref0 (src_notebook);
	return result;
}

static gboolean
___lambda41__gtk_widget_drag_drop (GtkWidget* _sender,
                                   GdkDragContext* context,
                                   gint x,
                                   gint y,
                                   guint time_,
                                   gpointer self)
{
	gboolean result;
	result = __lambda41_ ((XnpWindow*) self, context, x, y, time_);
	return result;
}

static void
__lambda42_ (XnpWindow* self,
             GdkDragContext* c)
{
	GtkNotebook* src_notebook = NULL;
	GtkWidget* _tmp0_;
	GtkNotebook* _tmp1_;
	GtkNotebook* _tmp2_;
	XnpWindow* src_win = NULL;
	GtkNotebook* _tmp3_;
	GtkWidget* _tmp4_;
	XnpWindow* _tmp5_;
	XnpWindow* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (c != NULL);
	_tmp0_ = gtk_drag_get_source_widget (c);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_notebook_get_type ()) ? ((GtkNotebook*) _tmp0_) : NULL);
	src_notebook = _tmp1_;
	_tmp2_ = src_notebook;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (src_notebook);
		return;
	}
	_tmp3_ = src_notebook;
	_tmp4_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, XNP_TYPE_WINDOW, XnpWindow));
	src_win = _tmp5_;
	_tmp6_ = src_win;
	_tmp7_ = xnp_window_get_n_pages (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 0) {
		XnpWindow* _tmp9_;
		_tmp9_ = src_win;
		g_signal_emit (_tmp9_, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "delete");
	}
	_g_object_unref0 (src_win);
	_g_object_unref0 (src_notebook);
}

static void
___lambda42__gtk_widget_drag_data_received (GtkWidget* _sender,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            GtkSelectionData* selection_data,
                                            guint info,
                                            guint time_,
                                            gpointer self)
{
	__lambda42_ ((XnpWindow*) self, context);
}

XnpWindow*
xnp_window_construct (GType object_type,
                      XnpApplication* app)
{
	XnpWindow * self = NULL;
	Block3Data* _data3_;
	XnpApplication* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkUIManager* _tmp3_;
	GtkUIManager* _tmp4_;
	GtkActionGroup* _tmp5_;
	GtkMenu* _tmp11_;
	GtkMenu* _tmp12_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp13_;
	GtkRcStyle* style = NULL;
	GtkRcStyle* _tmp14_;
	GtkRcStyle* _tmp15_;
	GtkBox* vbox_frame = NULL;
	GtkBox* _tmp16_;
	GtkBox* title_box = NULL;
	GtkBox* _tmp17_;
	GtkEventBox* _tmp18_;
	GtkImage* _tmp19_;
	GtkImage* _tmp20_;
	GtkEventBox* title_evbox = NULL;
	GtkEventBox* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	XnpTitleBarButton* _tmp31_;
	XnpTitleBarButton* _tmp32_;
	XnpTitleBarButton* _tmp33_;
	XnpTitleBarButton* _tmp34_;
	XnpTitleBarButton* _tmp35_;
	XnpTitleBarButton* _tmp36_;
	XnpTitleBarButton* _tmp37_;
	XnpTitleBarButton* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	XnpTitleBarButton* _tmp41_;
	XnpTitleBarButton* _tmp42_;
	XnpTitleBarButton* _tmp43_;
	XnpTitleBarButton* _tmp44_;
	XnpTitleBarButton* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	XnpTitleBarButton* _tmp48_;
	XnpTitleBarButton* _tmp49_;
	XnpTitleBarButton* _tmp50_;
	XnpTitleBarButton* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	XnpTitleBarButton* _tmp56_;
	GtkBox* _tmp57_;
	GtkBox* _tmp58_;
	GtkBox* _tmp59_;
	GtkNotebook* _tmp60_;
	GtkNotebook* _tmp61_;
	GtkNotebook* _tmp62_;
	GtkNotebook* _tmp63_;
	GtkNotebook* _tmp64_;
	GtkNotebook* _tmp65_;
	GtkNotebook* _tmp66_;
	GtkNotebook* _tmp67_;
	GtkNotebook* _tmp68_;
	GtkBox* _tmp69_;
	GtkNotebook* _tmp70_;
	XnpTitleBarButton* _tmp71_;
	XnpTitleBarButton* _tmp72_;
	XnpTitleBarButton* _tmp73_;
	XnpTitleBarButton* _tmp74_;
	XnpTitleBarButton* _tmp75_;
	XnpTitleBarButton* _tmp76_;
	GtkNotebook* _tmp77_;
	GtkNotebook* _tmp78_;
	GtkNotebook* _tmp79_;
	GtkNotebook* _tmp80_;
	GtkNotebook* _tmp81_;
	GtkNotebook* _tmp82_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	self = (XnpWindow*) g_object_new (object_type, NULL);
	_data3_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (app);
	_g_object_unref0 (self->priv->app);
	self->priv->app = _tmp0_;
	gtk_widget_add_events ((GtkWidget*) self, (gint) (GDK_POINTER_MOTION_MASK | GDK_BUTTON_PRESS_MASK));
	_tmp1_ = gtk_action_group_new ("XNP");
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp1_;
	_tmp2_ = self->priv->action_group;
	gtk_action_group_add_actions (_tmp2_, XNP_WINDOW_action_entries, (guint) G_N_ELEMENTS (XNP_WINDOW_action_entries), self);
	_tmp3_ = gtk_ui_manager_new ();
	_g_object_unref0 (self->priv->ui);
	self->priv->ui = _tmp3_;
	_tmp4_ = self->priv->ui;
	_tmp5_ = self->priv->action_group;
	gtk_ui_manager_insert_action_group (_tmp4_, _tmp5_, 0);
	{
		GtkUIManager* _tmp6_;
		GtkUIManager* _tmp7_;
		GtkAccelGroup* _tmp8_;
		_tmp6_ = self->priv->ui;
		gtk_ui_manager_add_ui_from_string (_tmp6_, XNP_WINDOW_ui_string, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->ui;
		_tmp8_ = gtk_ui_manager_get_accel_group (_tmp7_);
		gtk_window_add_accel_group ((GtkWindow*) self, _tmp8_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("window.vala:220: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp11_ = xnp_window_build_menu (self);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp11_;
	_tmp12_ = self->priv->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp12_);
	_tmp13_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp13_);
	frame = _tmp13_;
	gtk_frame_set_shadow_type (frame, GTK_SHADOW_NONE);
	_tmp14_ = gtk_widget_get_modifier_style ((GtkWidget*) frame);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	style = _tmp15_;
	style->xthickness = 1;
	style->ythickness = 3;
	gtk_widget_modify_style ((GtkWidget*) frame, style);
	gtk_widget_show ((GtkWidget*) frame);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) frame);
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp16_);
	vbox_frame = _tmp16_;
	gtk_box_set_spacing (vbox_frame, 1);
	gtk_widget_show ((GtkWidget*) vbox_frame);
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) vbox_frame);
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp17_);
	title_box = _tmp17_;
	gtk_widget_set_name ((GtkWidget*) title_box, "titlebar");
	_tmp18_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp18_);
	_data3_->menu_evbox = _tmp18_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _data3_->menu_evbox, _ ("Menu"));
	gtk_event_box_set_visible_window (_data3_->menu_evbox, FALSE);
	_tmp19_ = (GtkImage*) gtk_image_new_from_icon_name ("org.xfce.notes.menu", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->menu_image);
	self->priv->menu_image = _tmp19_;
	_tmp20_ = self->priv->menu_image;
	gtk_container_add ((GtkContainer*) _data3_->menu_evbox, (GtkWidget*) _tmp20_);
	g_signal_connect_data ((GtkWidget*) _data3_->menu_evbox, "enter-notify-event", (GCallback) ___lambda31__gtk_widget_enter_notify_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	g_signal_connect_data ((GtkWidget*) _data3_->menu_evbox, "leave-notify-event", (GCallback) ___lambda32__gtk_widget_leave_notify_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	gtk_box_pack_start (title_box, (GtkWidget*) _data3_->menu_evbox, FALSE, FALSE, (guint) 2);
	_tmp21_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp21_);
	title_evbox = _tmp21_;
	gtk_widget_add_events ((GtkWidget*) title_evbox, (gint) GDK_SCROLL_MASK);
	gtk_event_box_set_visible_window (title_evbox, FALSE);
	_tmp22_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp22_;
	_tmp23_ = self->priv->title_label;
	_tmp24_ = gtk_window_get_title ((GtkWindow*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_markup_printf_escaped ("<b>%s</b>", _tmp25_);
	_tmp27_ = _tmp26_;
	gtk_label_set_markup (_tmp23_, _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = self->priv->title_label;
	gtk_label_set_ellipsize (_tmp28_, PANGO_ELLIPSIZE_END);
	_tmp29_ = self->priv->title_label;
	gtk_label_set_xalign (_tmp29_, (gfloat) 0.0);
	_tmp30_ = self->priv->title_label;
	gtk_container_add ((GtkContainer*) title_evbox, (GtkWidget*) _tmp30_);
	gtk_box_pack_start (title_box, (GtkWidget*) title_evbox, TRUE, TRUE, (guint) 6);
	_tmp31_ = xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_REFRESH);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->refresh_button);
	self->priv->refresh_button = _tmp31_;
	_tmp32_ = self->priv->refresh_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp32_, _ ("Refresh notes"));
	_tmp33_ = self->priv->refresh_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp33_, TRUE);
	_tmp34_ = self->priv->refresh_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp34_, FALSE);
	_tmp35_ = self->priv->refresh_button;
	gtk_box_pack_start (title_box, (GtkWidget*) _tmp35_, FALSE, FALSE, (guint) 2);
	_tmp36_ = xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW);
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->left_arrow_button);
	self->priv->left_arrow_button = _tmp36_;
	_tmp37_ = self->priv->left_arrow_button;
	gtk_widget_add_events ((GtkWidget*) _tmp37_, (gint) GDK_SCROLL_MASK);
	_tmp38_ = self->priv->left_arrow_button;
	_tmp39_ = gtk_accelerator_get_label (GDK_KEY_Page_Up, GDK_CONTROL_MASK);
	_tmp40_ = _tmp39_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp38_, _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = self->priv->left_arrow_button;
	xnp_icon_button_set_enabled ((XnpIconButton*) _tmp41_, FALSE);
	_tmp42_ = self->priv->left_arrow_button;
	gtk_box_pack_start (title_box, (GtkWidget*) _tmp42_, FALSE, FALSE, (guint) 2);
	_tmp43_ = xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW);
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->right_arrow_button);
	self->priv->right_arrow_button = _tmp43_;
	_tmp44_ = self->priv->right_arrow_button;
	gtk_widget_add_events ((GtkWidget*) _tmp44_, (gint) GDK_SCROLL_MASK);
	_tmp45_ = self->priv->right_arrow_button;
	_tmp46_ = gtk_accelerator_get_label (GDK_KEY_Page_Down, GDK_CONTROL_MASK);
	_tmp47_ = _tmp46_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp45_, _tmp47_);
	_g_free0 (_tmp47_);
	_tmp48_ = self->priv->right_arrow_button;
	xnp_icon_button_set_enabled ((XnpIconButton*) _tmp48_, FALSE);
	_tmp49_ = self->priv->right_arrow_button;
	gtk_box_pack_start (title_box, (GtkWidget*) _tmp49_, FALSE, FALSE, (guint) 2);
	_tmp50_ = xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_CLOSE);
	g_object_ref_sink (_tmp50_);
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp50_;
	_tmp51_ = self->priv->close_button;
	_tmp52_ = gtk_accelerator_get_label (GDK_KEY_Escape, 0);
	_tmp53_ = _tmp52_;
	_tmp54_ = g_strdup_printf (_ ("Hide (%s)"), _tmp53_);
	_tmp55_ = _tmp54_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp51_, _tmp55_);
	_g_free0 (_tmp55_);
	_g_free0 (_tmp53_);
	_tmp56_ = self->priv->close_button;
	gtk_box_pack_start (title_box, (GtkWidget*) _tmp56_, FALSE, FALSE, (guint) 2);
	gtk_widget_show_all ((GtkWidget*) title_box);
	gtk_box_pack_start (vbox_frame, (GtkWidget*) title_box, FALSE, FALSE, (guint) 0);
	_tmp57_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->content_box);
	self->priv->content_box = _tmp57_;
	_tmp58_ = self->priv->content_box;
	gtk_widget_show ((GtkWidget*) _tmp58_);
	_tmp59_ = self->priv->content_box;
	gtk_box_pack_start (vbox_frame, (GtkWidget*) _tmp59_, TRUE, TRUE, (guint) 0);
	_tmp60_ = (GtkNotebook*) gtk_notebook_new ();
	g_object_ref_sink (_tmp60_);
	_g_object_unref0 (self->priv->notebook);
	self->priv->notebook = _tmp60_;
	_tmp61_ = self->priv->notebook;
	gtk_widget_add_events ((GtkWidget*) _tmp61_, (gint) GDK_SCROLL_MASK);
	_tmp62_ = self->priv->notebook;
	gtk_widget_set_name ((GtkWidget*) _tmp62_, "notes-notebook");
	_tmp63_ = self->priv->notebook;
	gtk_notebook_set_group_name (_tmp63_, "notes");
	_tmp64_ = self->priv->notebook;
	gtk_notebook_set_show_border (_tmp64_, TRUE);
	_tmp65_ = self->priv->notebook;
	gtk_notebook_set_show_tabs (_tmp65_, FALSE);
	_tmp66_ = self->priv->notebook;
	gtk_notebook_set_tab_pos (_tmp66_, GTK_POS_TOP);
	_tmp67_ = self->priv->notebook;
	gtk_notebook_set_scrollable (_tmp67_, TRUE);
	_tmp68_ = self->priv->notebook;
	gtk_widget_show ((GtkWidget*) _tmp68_);
	_tmp69_ = self->priv->content_box;
	_tmp70_ = self->priv->notebook;
	gtk_box_pack_start (_tmp69_, (GtkWidget*) _tmp70_, TRUE, TRUE, (guint) 0);
	g_signal_connect_object ((GtkWidget*) _data3_->menu_evbox, "button-press-event", (GCallback) _xnp_window_menu_evbox_pressed_cb_gtk_widget_button_press_event, self, 0);
	_tmp71_ = self->priv->refresh_button;
	g_signal_connect_object ((XnpIconButton*) _tmp71_, "clicked", (GCallback) _xnp_window_action_refresh_notes_xnp_icon_button_clicked, self, 0);
	_tmp72_ = self->priv->left_arrow_button;
	g_signal_connect_object ((XnpIconButton*) _tmp72_, "clicked", (GCallback) _xnp_window_action_prev_note_xnp_icon_button_clicked, self, 0);
	_tmp73_ = self->priv->right_arrow_button;
	g_signal_connect_object ((XnpIconButton*) _tmp73_, "clicked", (GCallback) _xnp_window_action_next_note_xnp_icon_button_clicked, self, 0);
	_tmp74_ = self->priv->close_button;
	g_signal_connect_object ((XnpIconButton*) _tmp74_, "clicked", (GCallback) ___lambda33__xnp_icon_button_clicked, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda34__gtk_widget_delete_event, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::is-active", (GCallback) ___lambda35__g_object_notify, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _xnp_window_window_motion_cb_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _xnp_window_window_pressed_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _xnp_window_window_state_cb_gtk_widget_window_state_event, self, 0);
	g_signal_connect_object ((GtkWidget*) title_evbox, "button-press-event", (GCallback) _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) title_evbox, "scroll-event", (GCallback) _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event, self, 0);
	_tmp75_ = self->priv->left_arrow_button;
	g_signal_connect_object ((GtkWidget*) _tmp75_, "scroll-event", (GCallback) _xnp_window_notebook_tab_scroll_cb_gtk_widget_scroll_event, self, 0);
	_tmp76_ = self->priv->right_arrow_button;
	g_signal_connect_object ((GtkWidget*) _tmp76_, "scroll-event", (GCallback) _xnp_window_notebook_tab_scroll_cb_gtk_widget_scroll_event, self, 0);
	_tmp77_ = self->priv->notebook;
	g_signal_connect_object (_tmp77_, "page-added", (GCallback) ___lambda36__gtk_notebook_page_added, self, 0);
	_tmp78_ = self->priv->notebook;
	g_signal_connect_object (_tmp78_, "page-removed", (GCallback) ___lambda37__gtk_notebook_page_removed, self, 0);
	_tmp79_ = self->priv->notebook;
	g_signal_connect_object (_tmp79_, "switch-page", (GCallback) ___lambda38__gtk_notebook_switch_page, self, 0);
	_tmp80_ = self->priv->notebook;
	g_signal_connect_object ((GtkWidget*) _tmp80_, "scroll-event", (GCallback) _xnp_window_notebook_tab_scroll_cb_gtk_widget_scroll_event, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::name", (GCallback) ___lambda39__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::title", (GCallback) ___lambda40__g_object_notify, self, 0);
	_tmp81_ = self->priv->notebook;
	g_signal_connect_object ((GtkWidget*) _tmp81_, "drag-drop", (GCallback) ___lambda41__gtk_widget_drag_drop, self, 0);
	_tmp82_ = self->priv->notebook;
	g_signal_connect_object ((GtkWidget*) _tmp82_, "drag-data-received", (GCallback) ___lambda42__gtk_widget_drag_data_received, self, G_CONNECT_AFTER);
	_g_object_unref0 (title_evbox);
	_g_object_unref0 (title_box);
	_g_object_unref0 (vbox_frame);
	_g_object_unref0 (style);
	_g_object_unref0 (frame);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return self;
}

XnpWindow*
xnp_window_new (XnpApplication* app)
{
	return xnp_window_construct (XNP_TYPE_WINDOW, app);
}

/**
 * hide:
 *
 * Save position before hidding.
 */
void
xnp_window_hide (XnpWindow* self)
{
	gint winx = 0;
	gint winy = 0;
	XnpWindow* new_focus = NULL;
	XnpApplication* _tmp0_;
	XnpWindow* _tmp1_;
	XnpWindow* _tmp2_;
	XnpWindow* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	XnpWindow* _tmp6_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->app;
	_tmp1_ = xnp_application_get_next_focus (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	new_focus = _tmp3_;
	gtk_window_get_position ((GtkWindow*) self, &_tmp4_, &_tmp5_);
	winx = _tmp4_;
	winy = _tmp5_;
	_tmp6_ = new_focus;
	if (_tmp6_ != NULL) {
		XnpWindow* _tmp7_;
		XnpWindow* _tmp8_;
		XnpWindow* _tmp9_;
		XnpApplication* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp7_ = new_focus;
		gtk_window_set_skip_taskbar_hint ((GtkWindow*) _tmp7_, FALSE);
		_tmp8_ = new_focus;
		gtk_window_present ((GtkWindow*) _tmp8_);
		GTK_WIDGET_CLASS (xnp_window_parent_class)->hide ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_tmp9_ = new_focus;
		_tmp10_ = self->priv->app;
		_tmp11_ = xnp_application_get_skip_taskbar_hint (_tmp10_);
		_tmp12_ = _tmp11_;
		gtk_window_set_skip_taskbar_hint ((GtkWindow*) _tmp9_, _tmp12_);
	} else {
		GTK_WIDGET_CLASS (xnp_window_parent_class)->hide ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	}
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "hide");
	gtk_window_deiconify ((GtkWindow*) self);
	xnp_window_unshade (self);
	gtk_window_move ((GtkWindow*) self, winx, winy);
	_tmp13_ = xnp_window_get_above (self);
	_tmp14_ = _tmp13_;
	gtk_window_set_keep_above ((GtkWindow*) self, _tmp14_);
	_g_object_unref0 (new_focus);
}

/**
 * window_leaved_cb:
 *
 * Reset the mouse cursor.
 */
static gboolean
xnp_window_window_leaved_cb (XnpWindow* self,
                             GdkEventCrossing* event)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean outside = FALSE;
	GdkWindow* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	if (event->x <= ((gdouble) 0)) {
		_tmp3_ = TRUE;
	} else {
		GtkAllocation _tmp4_;
		_tmp4_ = allocation;
		_tmp3_ = event->x >= ((gdouble) _tmp4_.width);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = event->y <= ((gdouble) 0);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GtkAllocation _tmp5_;
		_tmp5_ = allocation;
		_tmp1_ = event->y >= ((gdouble) _tmp5_.height);
	}
	outside = _tmp1_;
	if (!outside) {
		result = TRUE;
		return result;
	}
	_tmp6_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_cursor (_tmp6_, NULL);
	result = TRUE;
	return result;
}

/**
 * window_motion_cb:
 *
 * Update mouse cursor.
 */
static gboolean
xnp_window_window_motion_cb (XnpWindow* self,
                             GdkEventMotion* event)
{
	GtkAllocation allocation = {0};
	GdkCursor* cursor = NULL;
	void* widget = NULL;
	GdkWindow* _tmp0_;
	void* _tmp1_ = NULL;
	void* _tmp2_;
	GtkAllocation _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkNotebook* _tmp30_;
	gboolean _tmp31_ = FALSE;
	GdkWindow* _tmp32_;
	GdkCursor* _tmp33_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->window;
	gdk_window_get_user_data (_tmp0_, &_tmp1_);
	widget = _tmp1_;
	_tmp2_ = widget;
	if (_tmp2_ != self) {
		GdkWindow* _tmp3_;
		_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_cursor (_tmp3_, NULL);
		result = FALSE;
		_g_object_unref0 (cursor);
		return result;
	}
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp4_);
	allocation = _tmp4_;
	if (event->x > ((gdouble) 4)) {
		_tmp7_ = event->y > ((gdouble) 4);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GtkAllocation _tmp8_;
		_tmp8_ = allocation;
		_tmp6_ = event->x < ((gdouble) (_tmp8_.width - 4));
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkAllocation _tmp9_;
		_tmp9_ = allocation;
		_tmp5_ = event->y < ((gdouble) (_tmp9_.height - 4));
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GdkWindow* _tmp10_;
		_tmp10_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_cursor (_tmp10_, NULL);
		result = FALSE;
		_g_object_unref0 (cursor);
		return result;
	}
	if (event->y <= ((gdouble) self->priv->CORNER_MARGIN)) {
		if (event->x <= ((gdouble) self->priv->CORNER_MARGIN)) {
			GdkCursor* _tmp11_;
			GdkCursor* _tmp12_;
			_tmp11_ = self->priv->CURSOR_TOP_LC;
			_tmp12_ = _g_object_ref0 (_tmp11_);
			_g_object_unref0 (cursor);
			cursor = _tmp12_;
		} else {
			GtkAllocation _tmp13_;
			_tmp13_ = allocation;
			if (event->x >= ((gdouble) (_tmp13_.width - self->priv->CORNER_MARGIN))) {
				GdkCursor* _tmp14_;
				GdkCursor* _tmp15_;
				_tmp14_ = self->priv->CURSOR_TOP_RC;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				_g_object_unref0 (cursor);
				cursor = _tmp15_;
			} else {
				GdkCursor* _tmp16_;
				GdkCursor* _tmp17_;
				_tmp16_ = self->priv->CURSOR_TOP;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				_g_object_unref0 (cursor);
				cursor = _tmp17_;
			}
		}
	} else {
		GtkAllocation _tmp18_;
		_tmp18_ = allocation;
		if (event->y > ((gdouble) (_tmp18_.height - self->priv->CORNER_MARGIN))) {
			if (event->x <= ((gdouble) self->priv->CORNER_MARGIN)) {
				GdkCursor* _tmp19_;
				GdkCursor* _tmp20_;
				_tmp19_ = self->priv->CURSOR_BOTTOM_LC;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				_g_object_unref0 (cursor);
				cursor = _tmp20_;
			} else {
				GtkAllocation _tmp21_;
				_tmp21_ = allocation;
				if (event->x >= ((gdouble) (_tmp21_.width - self->priv->CORNER_MARGIN))) {
					GdkCursor* _tmp22_;
					GdkCursor* _tmp23_;
					_tmp22_ = self->priv->CURSOR_BOTTOM_RC;
					_tmp23_ = _g_object_ref0 (_tmp22_);
					_g_object_unref0 (cursor);
					cursor = _tmp23_;
				} else {
					GdkCursor* _tmp24_;
					GdkCursor* _tmp25_;
					_tmp24_ = self->priv->CURSOR_BOTTOM;
					_tmp25_ = _g_object_ref0 (_tmp24_);
					_g_object_unref0 (cursor);
					cursor = _tmp25_;
				}
			}
		} else {
			if (event->x <= ((gdouble) self->priv->CORNER_MARGIN)) {
				GdkCursor* _tmp26_;
				GdkCursor* _tmp27_;
				_tmp26_ = self->priv->CURSOR_LEFT;
				_tmp27_ = _g_object_ref0 (_tmp26_);
				_g_object_unref0 (cursor);
				cursor = _tmp27_;
			} else {
				GdkCursor* _tmp28_;
				GdkCursor* _tmp29_;
				_tmp28_ = self->priv->CURSOR_RIGHT;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				_g_object_unref0 (cursor);
				cursor = _tmp29_;
			}
		}
	}
	_tmp30_ = self->priv->notebook;
	g_signal_emit_by_name ((GtkWidget*) _tmp30_, "motion-notify-event", event, &_tmp31_);
	_tmp32_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp33_ = cursor;
	gdk_window_set_cursor (_tmp32_, _tmp33_);
	result = TRUE;
	_g_object_unref0 (cursor);
	return result;
}

/**
 * window_pressed_cb:
 *
 * Start a window resize depending on mouse pointer location.
 */
static gboolean
xnp_window_window_pressed_cb (XnpWindow* self,
                              GdkEventButton* event)
{
	GdkCursor* cursor = NULL;
	GdkWindow* _tmp0_;
	GdkCursor* _tmp1_;
	GdkCursor* _tmp2_;
	GdkWindowEdge edge = 0;
	GdkCursor* _tmp3_;
	GdkCursor* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = gdk_window_get_cursor (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	cursor = _tmp2_;
	_tmp3_ = cursor;
	_tmp4_ = self->priv->CURSOR_TOP;
	if (_tmp3_ == _tmp4_) {
		edge = GDK_WINDOW_EDGE_NORTH;
	} else {
		GdkCursor* _tmp5_;
		GdkCursor* _tmp6_;
		_tmp5_ = cursor;
		_tmp6_ = self->priv->CURSOR_BOTTOM;
		if (_tmp5_ == _tmp6_) {
			edge = GDK_WINDOW_EDGE_SOUTH;
		} else {
			GdkCursor* _tmp7_;
			GdkCursor* _tmp8_;
			_tmp7_ = cursor;
			_tmp8_ = self->priv->CURSOR_LEFT;
			if (_tmp7_ == _tmp8_) {
				edge = GDK_WINDOW_EDGE_WEST;
			} else {
				GdkCursor* _tmp9_;
				GdkCursor* _tmp10_;
				_tmp9_ = cursor;
				_tmp10_ = self->priv->CURSOR_RIGHT;
				if (_tmp9_ == _tmp10_) {
					edge = GDK_WINDOW_EDGE_EAST;
				} else {
					GdkCursor* _tmp11_;
					GdkCursor* _tmp12_;
					_tmp11_ = cursor;
					_tmp12_ = self->priv->CURSOR_TOP_LC;
					if (_tmp11_ == _tmp12_) {
						edge = GDK_WINDOW_EDGE_NORTH_WEST;
					} else {
						GdkCursor* _tmp13_;
						GdkCursor* _tmp14_;
						_tmp13_ = cursor;
						_tmp14_ = self->priv->CURSOR_TOP_RC;
						if (_tmp13_ == _tmp14_) {
							edge = GDK_WINDOW_EDGE_NORTH_EAST;
						} else {
							GdkCursor* _tmp15_;
							GdkCursor* _tmp16_;
							_tmp15_ = cursor;
							_tmp16_ = self->priv->CURSOR_BOTTOM_LC;
							if (_tmp15_ == _tmp16_) {
								edge = GDK_WINDOW_EDGE_SOUTH_WEST;
							} else {
								GdkCursor* _tmp17_;
								GdkCursor* _tmp18_;
								_tmp17_ = cursor;
								_tmp18_ = self->priv->CURSOR_BOTTOM_RC;
								if (_tmp17_ == _tmp18_) {
									edge = GDK_WINDOW_EDGE_SOUTH_EAST;
								} else {
									result = FALSE;
									_g_object_unref0 (cursor);
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	gtk_window_begin_resize_drag ((GtkWindow*) self, edge, (gint) event->button, (gint) event->x_root, (gint) event->y_root, event->time);
	result = TRUE;
	_g_object_unref0 (cursor);
	return result;
}

/**
 * window_state_cb:
 *
 * Watch window manager actions always on top and sticky
 * window.
 */
static gboolean
xnp_window_window_state_cb (XnpWindow* self,
                            GdkEventWindowState* event)
{
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if ((gboolean) (event->changed_mask & GDK_WINDOW_STATE_ABOVE)) {
		GtkCheckMenuItem* _tmp0_;
		_tmp0_ = self->priv->mi_above;
		gtk_check_menu_item_set_active (_tmp0_, (gboolean) (event->new_window_state & GDK_WINDOW_STATE_ABOVE));
	}
	if ((gboolean) (event->changed_mask & GDK_WINDOW_STATE_STICKY)) {
		_tmp1_ = gtk_widget_get_visible ((GtkWidget*) self);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		xnp_window_set_sticky (self, (gboolean) ((event->new_window_state & GDK_WINDOW_STATE_STICKY) != 0));
	}
	result = FALSE;
	return result;
}

/**
 * title_evbox_pressed_cb:
 *
 * Raise/lower the window and popup window menu.
 */
static gboolean
xnp_window_title_evbox_pressed_cb (XnpWindow* self,
                                   GtkWidget* widget,
                                   GdkEventButton* event)
{
	GdkWindow* _tmp0_;
	GdkCursor* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->type != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = gdk_window_get_cursor (_tmp0_);
	if (_tmp1_ != NULL) {
		result = FALSE;
		return result;
	}
	if (event->button == ((guint) GDK_BUTTON_PRIMARY)) {
		GdkWindow* _tmp2_;
		gint winx = 0;
		gint winy = 0;
		gint curx = 0;
		gint cury = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_show (_tmp2_);
		gtk_window_get_position ((GtkWindow*) self, &_tmp3_, &_tmp4_);
		winx = _tmp3_;
		winy = _tmp4_;
		gtk_widget_get_pointer ((GtkWidget*) self, &_tmp5_, &_tmp6_);
		curx = _tmp5_;
		cury = _tmp6_;
		winx += curx;
		winy += cury;
		gtk_window_begin_move_drag ((GtkWindow*) self, 1, winx, winy, gtk_get_current_event_time ());
	} else {
		if (event->button == ((guint) GDK_BUTTON_MIDDLE)) {
			GdkWindow* _tmp7_;
			_tmp7_ = gtk_widget_get_window ((GtkWidget*) self);
			gdk_window_lower (_tmp7_);
		} else {
			if (event->button == ((guint) GDK_BUTTON_SECONDARY)) {
				GtkMenu* _tmp8_;
				_tmp8_ = self->priv->menu;
				gtk_menu_popup (_tmp8_, NULL, NULL, NULL, NULL, (guint) 0, gtk_get_current_event_time ());
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * title_evbox_scrolled_cb:
 *
 * Shade/unshade the window and set transparency by holding ALT.
 */
static gboolean
xnp_window_title_evbox_scrolled_cb (XnpWindow* self,
                                    GtkWidget* widget,
                                    GdkEventScroll* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if ((gboolean) (event->state & GDK_MOD1_MASK)) {
		if (event->direction == GDK_SCROLL_UP) {
			gdouble _tmp0_;
			gdouble _tmp1_;
			_tmp0_ = gtk_widget_get_opacity ((GtkWidget*) self);
			_tmp1_ = _tmp0_;
			gtk_widget_set_opacity ((GtkWidget*) self, _tmp1_ + 0.1);
		} else {
			if (event->direction == GDK_SCROLL_DOWN) {
				gdouble _tmp2_;
				gdouble _tmp3_;
				_tmp2_ = gtk_widget_get_opacity ((GtkWidget*) self);
				_tmp3_ = _tmp2_;
				if ((_tmp3_ - 0.1) >= 0.1) {
					gdouble _tmp4_;
					gdouble _tmp5_;
					_tmp4_ = gtk_widget_get_opacity ((GtkWidget*) self);
					_tmp5_ = _tmp4_;
					gtk_widget_set_opacity ((GtkWidget*) self, _tmp5_ - 0.1);
				}
			}
		}
	} else {
		if (event->direction == GDK_SCROLL_UP) {
			xnp_window_shade (self);
		} else {
			if (event->direction == GDK_SCROLL_DOWN) {
				xnp_window_unshade (self);
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * notebook_tab_scroll_cb:
 *
 * Switch tabs with mouse scroll wheel.
 */
static gboolean
xnp_window_notebook_tab_scroll_cb (XnpWindow* self,
                                   GdkEventScroll* event)
{
	XnpNote* current_note = NULL;
	XnpNote* _tmp0_;
	XnpNote* _tmp1_;
	XnpNote* _tmp2_;
	XnpNote* _tmp3_;
	GtkWidget* event_widget = NULL;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkWidget* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = xnp_window_get_current_note (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	current_note = _tmp2_;
	_tmp3_ = current_note;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_g_object_unref0 (current_note);
		return result;
	}
	_tmp4_ = gtk_get_event_widget ((GdkEvent*) event);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	event_widget = _tmp5_;
	_tmp8_ = event_widget;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		GtkWidget* _tmp9_;
		XnpNote* _tmp10_;
		_tmp9_ = event_widget;
		_tmp10_ = current_note;
		_tmp7_ = _tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget);
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		GtkWidget* _tmp11_;
		XnpNote* _tmp12_;
		_tmp11_ = event_widget;
		_tmp12_ = current_note;
		_tmp6_ = gtk_widget_is_ancestor (_tmp11_, (GtkWidget*) _tmp12_);
	}
	if (_tmp6_) {
		result = FALSE;
		_g_object_unref0 (event_widget);
		_g_object_unref0 (current_note);
		return result;
	}
	if ((event->state & gtk_accelerator_get_default_mod_mask ()) != 0) {
		result = FALSE;
		_g_object_unref0 (event_widget);
		_g_object_unref0 (current_note);
		return result;
	}
	switch (event->direction) {
		case GDK_SCROLL_RIGHT:
		case GDK_SCROLL_DOWN:
		{
			GtkNotebook* _tmp13_;
			_tmp13_ = self->priv->notebook;
			gtk_notebook_next_page (_tmp13_);
			break;
		}
		case GDK_SCROLL_LEFT:
		case GDK_SCROLL_UP:
		{
			GtkNotebook* _tmp14_;
			_tmp14_ = self->priv->notebook;
			gtk_notebook_prev_page (_tmp14_);
			break;
		}
		default:
		{
			result = FALSE;
			_g_object_unref0 (event_widget);
			_g_object_unref0 (current_note);
			return result;
		}
	}
	result = TRUE;
	_g_object_unref0 (event_widget);
	_g_object_unref0 (current_note);
	return result;
}

/**
 * note_notify_name_cb:
 *
 */
static void
xnp_window_note_notify_name_cb (XnpWindow* self,
                                GObject* object,
                                GParamSpec* pspec)
{
	XnpNote* note = NULL;
	XnpNote* _tmp0_;
	GtkEventBox* tab_evbox = NULL;
	XnpNote* _tmp1_;
	GtkEventBox* _tmp2_;
	GtkLabel* label = NULL;
	GtkEventBox* _tmp3_;
	GtkWidget* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	XnpNote* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	XnpNote* _tmp10_;
	XnpNote* _tmp11_;
	XnpNote* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = _g_object_ref0 (XNP_IS_NOTE (object) ? ((XnpNote*) object) : NULL);
	note = _tmp0_;
	_tmp1_ = note;
	_tmp2_ = xnp_window_get_tab_evbox (self, _tmp1_);
	tab_evbox = _tmp2_;
	_tmp3_ = tab_evbox;
	_tmp4_ = gtk_bin_get_child ((GtkBin*) _tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp4_) : NULL);
	label = _tmp5_;
	_tmp6_ = label;
	_tmp7_ = note;
	_tmp8_ = xnp_note_get_name (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_label_set_text (_tmp6_, _tmp9_);
	_xnp_window_notebook_update_tabs_angle (self);
	_tmp10_ = note;
	_tmp11_ = xnp_window_get_current_note (self);
	_tmp12_ = _tmp11_;
	if (_tmp10_ == _tmp12_) {
		XnpNote* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = note;
		_tmp14_ = xnp_note_get_name (_tmp13_);
		_tmp15_ = _tmp14_;
		xnp_window_update_title (self, _tmp15_);
	}
	_g_object_unref0 (label);
	_g_object_unref0 (tab_evbox);
	_g_object_unref0 (note);
}

/**
 * tab_evbox_pressed_cb:
 *
 * Handle mouse click events on notebook tabs.
 */
static gboolean
xnp_window_tab_evbox_pressed_cb (XnpWindow* self,
                                 GdkEventButton* event,
                                 XnpNote* note)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (note != NULL, FALSE);
	if (event->type == GDK_DOUBLE_BUTTON_PRESS) {
		_tmp0_ = event->button == ((guint) GDK_BUTTON_PRIMARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		xnp_window_action_rename_note (self);
	} else {
		if (event->button == ((guint) GDK_BUTTON_MIDDLE)) {
			GtkNotebook* _tmp1_;
			GtkNotebook* _tmp2_;
			_tmp1_ = self->priv->notebook;
			_tmp2_ = self->priv->notebook;
			g_object_set (_tmp1_, "page", gtk_notebook_page_num (_tmp2_, (GtkWidget*) note), NULL);
			xnp_window_delete_current_note (self);
		} else {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

static void
xnp_window_action_new_window (XnpWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "create-new-window");
}

static void
xnp_window_action_delete_window (XnpWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "delete");
}

static void
xnp_window_action_rename_window (XnpWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "rename");
}

static void
xnp_window_action_new_note (XnpWindow* self)
{
	XnpNote* _tmp0_;
	XnpNote* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xnp_window_insert_note (self, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}

static void
xnp_window_action_delete_note (XnpWindow* self)
{
	g_return_if_fail (self != NULL);
	xnp_window_delete_current_note (self);
}

static void
xnp_window_action_rename_note (XnpWindow* self)
{
	g_return_if_fail (self != NULL);
	xnp_window_rename_current_note (self);
}

static void
xnp_window_action_cancel (XnpWindow* self)
{
	XnpNote* current_note = NULL;
	XnpNote* _tmp0_;
	XnpNote* _tmp1_;
	XnpNote* _tmp2_;
	XnpNote* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xnp_window_get_current_note (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	current_note = _tmp2_;
	_tmp3_ = current_note;
	if (_tmp3_ != NULL) {
		XnpNote* _tmp4_;
		XnpHypertextView* _tmp5_;
		_tmp4_ = current_note;
		_tmp5_ = _tmp4_->text_view;
		xnp_hypertext_view_undo (_tmp5_);
	}
	_g_object_unref0 (current_note);
}

static void
xnp_window_action_refresh_notes (XnpWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "refresh-notes");
}

static void
xnp_window_action_next_note (XnpWindow* self)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_next_page (_tmp0_);
}

static void
xnp_window_action_prev_note (XnpWindow* self)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_prev_page (_tmp0_);
}

/**
 * menu_evbox_pressed_cb:
 *
 * Popup the window menu.
 */
static void
_xnp_window_menu_position_gtk_menu_position_func (GtkMenu* menu,
                                                  gint* x,
                                                  gint* y,
                                                  gboolean* push_in,
                                                  gpointer self)
{
	xnp_window_menu_position ((XnpWindow*) self, menu, x, y, push_in);
	g_object_unref (self);
}

static gboolean
xnp_window_menu_evbox_pressed_cb (XnpWindow* self,
                                  GtkWidget* widget,
                                  GdkEventButton* event)
{
	GtkMenu* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->menu;
	gtk_menu_popup (_tmp0_, NULL, NULL, _xnp_window_menu_position_gtk_menu_position_func, g_object_ref (self), (guint) 0, gtk_get_current_event_time ());
	result = FALSE;
	return result;
}

/**
 * menu_position:
 *
 * Menu position function for the window menu.
 */
static void
xnp_window_menu_position (XnpWindow* self,
                          GtkMenu* menu,
                          gint* x,
                          gint* y,
                          gboolean* push_in)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	gint winx = 0;
	gint winy = 0;
	gint width = 0;
	gint height = 0;
	GtkRequisition requisition = {0};
	GtkAllocation allocation = {0};
	GdkWindow* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkRequisition _tmp5_ = {0};
	GdkWindow* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GtkBox* _tmp9_;
	GtkAllocation _tmp10_ = {0};
	GtkAllocation _tmp11_;
	GtkRequisition _tmp12_;
	GtkRequisition _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_geometry (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	winx = _tmp1_;
	winy = _tmp2_;
	width = _tmp3_;
	height = _tmp4_;
	gtk_widget_get_preferred_size ((GtkWidget*) menu, &_tmp5_, NULL);
	requisition = _tmp5_;
	_tmp6_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_origin (_tmp6_, &_tmp7_, &_tmp8_);
	_vala_x = _tmp7_;
	_vala_y = _tmp8_;
	_vala_push_in = FALSE;
	_tmp9_ = self->priv->content_box;
	gtk_widget_get_allocation ((GtkWidget*) _tmp9_, &_tmp10_);
	allocation = _tmp10_;
	_tmp11_ = allocation;
	_tmp12_ = requisition;
	if (((_vala_y + _tmp11_.y) + _tmp12_.height) > gdk_screen_height ()) {
		GtkRequisition _tmp13_;
		_tmp13_ = requisition;
		_vala_y = _vala_y - _tmp13_.height;
	} else {
		GtkAllocation _tmp14_;
		_tmp14_ = allocation;
		_vala_y = _vala_y + _tmp14_.y;
	}
	_tmp15_ = requisition;
	if ((_vala_x + _tmp15_.width) > gdk_screen_width ()) {
		gint menu_width = 0;
		gint _tmp16_ = 0;
		GtkAllocation _tmp17_;
		gtk_widget_get_preferred_width ((GtkWidget*) menu, &_tmp16_, NULL);
		menu_width = _tmp16_;
		_tmp17_ = allocation;
		_vala_x = (_vala_x - menu_width) + _tmp17_.y;
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		XnpWindow* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda25_ (Block4Data* _data4_)
{
	XnpWindow* self;
	self = _data4_->self;
	_data4_->callback (_data4_->callback_target);
}

static void
___lambda25__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda25_ (self);
}

static void
xnp_window_menu_add_icon_item (XnpWindow* self,
                               GtkMenu* menu,
                               const gchar* text,
                               const gchar* icon,
                               const gchar* accel,
                               XnpWindowCallback callback,
                               gpointer callback_target)
{
	Block4Data* _data4_;
	GtkImageMenuItem* mi = NULL;
	GtkImageMenuItem* _tmp0_;
	GtkImage* image = NULL;
	GtkImage* _tmp1_;
	GtkImageMenuItem* _tmp2_;
	GtkImage* _tmp3_;
	GtkImageMenuItem* _tmp8_;
	GtkImageMenuItem* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (icon != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->callback = callback;
	_data4_->callback_target = callback_target;
	_tmp0_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (text);
	g_object_ref_sink (_tmp0_);
	mi = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name (icon, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	image = _tmp1_;
	_tmp2_ = mi;
	_tmp3_ = image;
	gtk_image_menu_item_set_image (_tmp2_, (GtkWidget*) _tmp3_);
	if (accel != NULL) {
		GtkImageMenuItem* _tmp4_;
		GtkActionGroup* _tmp5_;
		GtkAction* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = mi;
		_tmp5_ = self->priv->action_group;
		_tmp6_ = gtk_action_group_get_action (_tmp5_, accel);
		_tmp7_ = gtk_action_get_accel_path (_tmp6_);
		gtk_menu_item_set_accel_path ((GtkMenuItem*) _tmp4_, _tmp7_);
	}
	_tmp8_ = mi;
	g_signal_connect_data ((GtkMenuItem*) _tmp8_, "activate", (GCallback) ___lambda25__gtk_menu_item_activate, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp9_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkMenuItem*) _tmp9_);
	_g_object_unref0 (image);
	_g_object_unref0 (mi);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		XnpWindow* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda26_ (Block5Data* _data5_)
{
	XnpWindow* self;
	self = _data5_->self;
	_data5_->callback (_data5_->callback_target);
}

static void
___lambda26__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                          gpointer self)
{
	__lambda26_ (self);
}

static GtkCheckMenuItem*
xnp_window_menu_add_check_item (XnpWindow* self,
                                GtkMenu* menu,
                                const gchar* text,
                                gboolean active,
                                XnpWindowCallback callback,
                                gpointer callback_target)
{
	Block5Data* _data5_;
	GtkCheckMenuItem* mi = NULL;
	GtkCheckMenuItem* _tmp0_;
	GtkCheckMenuItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (menu != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->callback = callback;
	_data5_->callback_target = callback_target;
	_tmp0_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (text);
	g_object_ref_sink (_tmp0_);
	mi = _tmp0_;
	gtk_check_menu_item_set_active (mi, active);
	g_signal_connect_data (mi, "toggled", (GCallback) ___lambda26__gtk_check_menu_item_toggled, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkMenuItem*) mi);
	result = mi;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

static void
xnp_window_menu_add_separator (XnpWindow* self,
                               GtkMenu* menu)
{
	GtkSeparatorMenuItem* mi = NULL;
	GtkSeparatorMenuItem* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp0_);
	mi = _tmp0_;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkMenuItem*) mi);
	_g_object_unref0 (mi);
}

/**
 * build_menu:
 *
 * Build the window menu.
 */
static void
_xnp_window_update_menu_go_gtk_widget_show (GtkWidget* _sender,
                                            gpointer self)
{
	xnp_window_update_menu_go ((XnpWindow*) self, _sender);
}

static void
_xnp_window_action_new_note_xnp_window_callback (gpointer self)
{
	xnp_window_action_new_note ((XnpWindow*) self);
}

static void
_xnp_window_action_delete_note_xnp_window_callback (gpointer self)
{
	xnp_window_action_delete_note ((XnpWindow*) self);
}

static void
_xnp_window_action_rename_note_xnp_window_callback (gpointer self)
{
	xnp_window_action_rename_note ((XnpWindow*) self);
}

static void
_xnp_window_action_cancel_xnp_window_callback (gpointer self)
{
	xnp_window_action_cancel ((XnpWindow*) self);
}

static void
__lambda27_ (XnpWindow* self)
{
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->mi_above;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	xnp_window_set_above (self, _tmp2_);
}

static void
___lambda27__xnp_window_callback (gpointer self)
{
	__lambda27_ ((XnpWindow*) self);
}

static void
__lambda28_ (XnpWindow* self)
{
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->mi_sticky;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	xnp_window_set_sticky (self, _tmp2_);
}

static void
___lambda28__xnp_window_callback (gpointer self)
{
	__lambda28_ ((XnpWindow*) self);
}

static void
__lambda29_ (XnpWindow* self)
{
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "properties");
}

static void
___lambda29__xnp_window_callback (gpointer self)
{
	__lambda29_ ((XnpWindow*) self);
}

static void
__lambda30_ (XnpWindow* self)
{
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "about");
}

static void
___lambda30__xnp_window_callback (gpointer self)
{
	__lambda30_ ((XnpWindow*) self);
}

static GtkMenu*
xnp_window_build_menu (XnpWindow* self)
{
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GtkUIManager* _tmp1_;
	GtkAccelGroup* _tmp2_;
	GtkMenuItem* mi = NULL;
	GtkMenuItem* _tmp3_;
	GtkMenu* menu_go = NULL;
	GtkMenu* _tmp4_;
	GtkUIManager* _tmp5_;
	GtkAccelGroup* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GtkCheckMenuItem* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GtkCheckMenuItem* _tmp12_;
	GtkMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	menu = _tmp0_;
	_tmp1_ = self->priv->ui;
	_tmp2_ = gtk_ui_manager_get_accel_group (_tmp1_);
	gtk_menu_set_accel_group (menu, _tmp2_);
	_tmp3_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Groups"));
	g_object_ref_sink (_tmp3_);
	mi = _tmp3_;
	gtk_menu_shell_append ((GtkMenuShell*) menu, mi);
	_tmp4_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp4_);
	menu_go = _tmp4_;
	_tmp5_ = self->priv->ui;
	_tmp6_ = gtk_ui_manager_get_accel_group (_tmp5_);
	gtk_menu_set_accel_group (menu_go, _tmp6_);
	g_signal_connect_object ((GtkWidget*) menu_go, "show", (GCallback) _xnp_window_update_menu_go_gtk_widget_show, self, 0);
	gtk_menu_item_set_submenu (mi, menu_go);
	xnp_window_menu_add_separator (self, menu);
	xnp_window_menu_add_icon_item (self, menu, _ ("_New"), "gtk-new", "new-note", _xnp_window_action_new_note_xnp_window_callback, self);
	xnp_window_menu_add_icon_item (self, menu, _ ("_Delete"), "gtk-delete", "delete-note", _xnp_window_action_delete_note_xnp_window_callback, self);
	xnp_window_menu_add_icon_item (self, menu, _ ("_Rename"), "gtk-edit", "rename-note", _xnp_window_action_rename_note_xnp_window_callback, self);
	xnp_window_menu_add_icon_item (self, menu, _ ("_Undo"), "gtk-undo", "cancel", _xnp_window_action_cancel_xnp_window_callback, self);
	xnp_window_menu_add_separator (self, menu);
	_tmp7_ = xnp_window_get_above (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = xnp_window_menu_add_check_item (self, menu, _ ("Always on top"), _tmp8_, ___lambda27__xnp_window_callback, self);
	_g_object_unref0 (self->priv->mi_above);
	self->priv->mi_above = _tmp9_;
	_tmp10_ = xnp_window_get_sticky (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = xnp_window_menu_add_check_item (self, menu, _ ("Sticky window"), _tmp11_, ___lambda28__xnp_window_callback, self);
	_g_object_unref0 (self->priv->mi_sticky);
	self->priv->mi_sticky = _tmp12_;
	xnp_window_menu_add_separator (self, menu);
	xnp_window_menu_add_icon_item (self, menu, _ ("_Properties"), "gtk-properties", NULL, ___lambda29__xnp_window_callback, self);
	xnp_window_menu_add_icon_item (self, menu, _ ("_About"), "gtk-about", NULL, ___lambda30__xnp_window_callback, self);
	result = menu;
	_g_object_unref0 (menu_go);
	_g_object_unref0 (mi);
	return result;
}

/**
 * update_menu_go:
 *
 * Update the menu Go when it is shown.
 */
static void
__lambda22_ (XnpWindow* self,
             GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	gtk_widget_destroy (w);
}

static void
___lambda22__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda22_ ((XnpWindow*) self, widget);
}

static void
________lambda23_ (XnpWindow* self,
                   GtkMenuItem* i)
{
	GtkNotebook* _tmp0_;
	gconstpointer _tmp1_;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = g_object_get_data ((GObject*) i, "page");
	g_object_set (_tmp0_, "page", (gint) ((gintptr) _tmp1_), NULL);
}

static void
_________lambda23__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self)
{
	________lambda23_ ((XnpWindow*) self, _sender);
}

static void
_____lambda24_ (XnpWindow* self,
                GtkMenuItem* i)
{
	XnpWindow* w = NULL;
	gconstpointer _tmp0_;
	XnpWindow* _tmp1_;
	g_return_if_fail (i != NULL);
	_tmp0_ = g_object_get_data ((GObject*) i, "window");
	_tmp1_ = _g_object_ref0 ((XnpWindow*) _tmp0_);
	w = _tmp1_;
	gtk_window_present ((GtkWindow*) w);
	_g_object_unref0 (w);
}

static void
______lambda24__gtk_menu_item_activate (GtkMenuItem* _sender,
                                        gpointer self)
{
	_____lambda24_ ((XnpWindow*) self, _sender);
}

static void
_xnp_window_action_rename_window_xnp_window_callback (gpointer self)
{
	xnp_window_action_rename_window ((XnpWindow*) self);
}

static void
_xnp_window_action_delete_window_xnp_window_callback (gpointer self)
{
	xnp_window_action_delete_window ((XnpWindow*) self);
}

static void
_xnp_window_action_new_window_xnp_window_callback (gpointer self)
{
	xnp_window_action_new_window ((XnpWindow*) self);
}

static void
xnp_window_update_menu_go (XnpWindow* self,
                           GtkWidget* widget)
{
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GtkMenuItem* mi = NULL;
	GtkImage* image = NULL;
	GtkMenu* _tmp1_;
	XnpApplication* _tmp2_;
	GSList* _tmp3_;
	GtkMenu* _tmp44_;
	GtkMenu* _tmp45_;
	GtkMenu* _tmp46_;
	GtkMenu* _tmp47_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_menu_get_type ()) ? ((GtkMenu*) widget) : NULL);
	menu = _tmp0_;
	_tmp1_ = menu;
	gtk_container_foreach ((GtkContainer*) _tmp1_, ___lambda22__gtk_callback, self);
	_tmp2_ = self->priv->app;
	_tmp3_ = xnp_application_get_window_list (_tmp2_);
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp3_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp4_;
			XnpWindow* win = NULL;
			_tmp4_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp4_;
			{
				XnpWindow* _tmp5_;
				_tmp5_ = win;
				if (_tmp5_ == self) {
					XnpWindow* _tmp6_;
					const gchar* _tmp7_;
					GtkMenuItem* _tmp8_;
					GtkMenuItem* _tmp9_;
					GtkMenu* _tmp10_;
					GtkMenuItem* _tmp11_;
					XnpNote* current_note = NULL;
					XnpNote* _tmp12_;
					XnpNote* _tmp13_;
					XnpNote* _tmp14_;
					gint n_pages = 0;
					gint _tmp15_;
					gint _tmp16_;
					GtkMenu* _tmp34_;
					_tmp6_ = win;
					_tmp7_ = _tmp6_->priv->_name;
					_tmp8_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp7_);
					g_object_ref_sink (_tmp8_);
					_g_object_unref0 (mi);
					mi = _tmp8_;
					_tmp9_ = mi;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
					_tmp10_ = menu;
					_tmp11_ = mi;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp10_, _tmp11_);
					_tmp12_ = xnp_window_get_current_note (self);
					_tmp13_ = _tmp12_;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					current_note = _tmp14_;
					_tmp15_ = xnp_window_get_n_pages (self);
					_tmp16_ = _tmp15_;
					n_pages = _tmp16_;
					{
						gint p = 0;
						p = 0;
						{
							gboolean _tmp17_ = FALSE;
							_tmp17_ = TRUE;
							while (TRUE) {
								XnpNote* note = NULL;
								XnpNote* _tmp19_;
								XnpNote* _tmp20_;
								const gchar* _tmp21_;
								const gchar* _tmp22_;
								GtkImageMenuItem* _tmp23_;
								XnpNote* _tmp24_;
								XnpNote* _tmp25_;
								GtkMenuItem* _tmp29_;
								void* _tmp30_;
								GtkMenuItem* _tmp31_;
								GtkMenu* _tmp32_;
								GtkMenuItem* _tmp33_;
								if (!_tmp17_) {
									gint _tmp18_;
									_tmp18_ = p;
									p = _tmp18_ + 1;
								}
								_tmp17_ = FALSE;
								if (!(p < n_pages)) {
									break;
								}
								_tmp19_ = xnp_window_get_note (self, p);
								note = _tmp19_;
								_tmp20_ = note;
								_tmp21_ = xnp_note_get_name (_tmp20_);
								_tmp22_ = _tmp21_;
								_tmp23_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_tmp22_);
								g_object_ref_sink (_tmp23_);
								_g_object_unref0 (mi);
								mi = (GtkMenuItem*) _tmp23_;
								_tmp24_ = note;
								_tmp25_ = current_note;
								if (_tmp24_ == _tmp25_) {
									GtkImage* _tmp26_;
									GtkMenuItem* _tmp27_;
									GtkImage* _tmp28_;
									_tmp26_ = (GtkImage*) gtk_image_new_from_icon_name ("gtk-go-forward", (GtkIconSize) GTK_ICON_SIZE_MENU);
									g_object_ref_sink (_tmp26_);
									_g_object_unref0 (image);
									image = _tmp26_;
									_tmp27_ = mi;
									_tmp28_ = image;
									gtk_image_menu_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_image_menu_item_get_type (), GtkImageMenuItem), (GtkWidget*) _tmp28_);
								}
								_tmp29_ = mi;
								_tmp30_ = GINT_TO_POINTER (p);
								g_object_set_data_full ((GObject*) _tmp29_, "page", _tmp30_, NULL);
								_tmp31_ = mi;
								g_signal_connect_object (_tmp31_, "activate", (GCallback) _________lambda23__gtk_menu_item_activate, self, 0);
								_tmp32_ = menu;
								_tmp33_ = mi;
								gtk_menu_shell_append ((GtkMenuShell*) _tmp32_, _tmp33_);
								_g_object_unref0 (note);
							}
						}
					}
					_tmp34_ = menu;
					xnp_window_menu_add_separator (self, _tmp34_);
					_g_object_unref0 (current_note);
				} else {
					XnpWindow* _tmp35_;
					const gchar* _tmp36_;
					GtkMenuItem* _tmp37_;
					GtkMenuItem* _tmp38_;
					XnpWindow* _tmp39_;
					GtkMenuItem* _tmp40_;
					GtkMenu* _tmp41_;
					GtkMenuItem* _tmp42_;
					GtkMenu* _tmp43_;
					_tmp35_ = win;
					_tmp36_ = _tmp35_->priv->_name;
					_tmp37_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp36_);
					g_object_ref_sink (_tmp37_);
					_g_object_unref0 (mi);
					mi = _tmp37_;
					_tmp38_ = mi;
					_tmp39_ = win;
					g_object_set_data_full ((GObject*) _tmp38_, "window", (void*) _tmp39_, NULL);
					_tmp40_ = mi;
					g_signal_connect_object (_tmp40_, "activate", (GCallback) ______lambda24__gtk_menu_item_activate, self, 0);
					_tmp41_ = menu;
					_tmp42_ = mi;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp41_, _tmp42_);
					_tmp43_ = menu;
					xnp_window_menu_add_separator (self, _tmp43_);
				}
				_g_object_unref0 (win);
			}
		}
	}
	_tmp44_ = menu;
	xnp_window_menu_add_icon_item (self, _tmp44_, _ ("_Rename group"), "gtk-edit", "rename-window", _xnp_window_action_rename_window_xnp_window_callback, self);
	_tmp45_ = menu;
	xnp_window_menu_add_icon_item (self, _tmp45_, _ ("_Delete group"), "gtk-remove", "delete-window", _xnp_window_action_delete_window_xnp_window_callback, self);
	_tmp46_ = menu;
	xnp_window_menu_add_icon_item (self, _tmp46_, _ ("_Add a new group"), "gtk-add", "new-window", _xnp_window_action_new_window_xnp_window_callback, self);
	_tmp47_ = menu;
	gtk_widget_show_all ((GtkWidget*) _tmp47_);
	_g_object_unref0 (image);
	_g_object_unref0 (mi);
	_g_object_unref0 (menu);
}

/**
 * get_geometry:
 *
 * Returns the X,Y position and width/height.
 */
void
xnp_window_get_geometry (XnpWindow* self,
                         gint* winx,
                         gint* winy,
                         gint* width,
                         gint* height)
{
	gint _vala_winx = 0;
	gint _vala_winy = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	GtkBox* _tmp0_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	if (!gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		gint _tmp1_ = 0;
		gtk_window_get_size ((GtkWindow*) self, &_tmp1_, NULL);
		self->priv->width = _tmp1_;
	} else {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
		self->priv->width = _tmp2_;
		self->priv->height = _tmp3_;
	}
	gtk_window_get_position ((GtkWindow*) self, &_tmp4_, &_tmp5_);
	_vala_winx = _tmp4_;
	_vala_winy = _tmp5_;
	_vala_width = self->priv->width;
	_vala_height = self->priv->height;
	if (winx) {
		*winx = _vala_winx;
	}
	if (winy) {
		*winy = _vala_winy;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

/**
 * compare_func:
 *
 * Compare function for the window name to use with GLib.CompareFunc delegates.
 */
gint
xnp_window_compare_func (XnpWindow* self,
                         XnpWindow* win2)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (win2 != NULL, 0);
	_tmp0_ = self->priv->_name;
	_tmp1_ = win2->priv->_name;
	result = g_utf8_collate (_tmp0_, _tmp1_);
	return result;
}

/**
 * get_current_page:
 *
 * Get the current page in the notebook.
 */
gint
xnp_window_get_current_page (XnpWindow* self)
{
	GtkNotebook* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->notebook;
	g_object_get (_tmp0_, "page", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
 * set_current_page:
 *
 * Set the current page in the notebook.
 */
void
xnp_window_set_current_page (XnpWindow* self,
                             gint page)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	g_object_set (_tmp0_, "page", page, NULL);
}

/**
 * shade:
 *
 * Shade the window (roll up) to show only the title bar.
 */
static void
xnp_window_shade (XnpWindow* self)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		GtkBox* _tmp1_;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp1_ = self->priv->content_box;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
		gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
		self->priv->width = _tmp2_;
		self->priv->height = _tmp3_;
		gtk_window_resize ((GtkWindow*) self, self->priv->width, 1);
	}
}

/**
 * unshade:
 *
 * Unshade the window (roll down).
 */
static void
xnp_window_unshade (XnpWindow* self)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	if (!gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		GtkBox* _tmp1_;
		gint _tmp2_ = 0;
		_tmp1_ = self->priv->content_box;
		gtk_widget_show ((GtkWidget*) _tmp1_);
		gtk_window_get_size ((GtkWindow*) self, &_tmp2_, NULL);
		self->priv->width = _tmp2_;
		gtk_window_resize ((GtkWindow*) self, self->priv->width, self->priv->height);
	}
}

/**
 * update_title:
 *
 * Updates the window title.
 */
static void
xnp_window_update_title (XnpWindow* self,
                         const gchar* note_name)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note_name != NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strconcat (_tmp0_, " - ", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, note_name, NULL);
	_tmp4_ = _tmp3_;
	gtk_window_set_title ((GtkWindow*) self, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}

/**
 * update_navigation_sensitivity:
 *
 * Update the goleft/right sensitivities.
 */
static void
xnp_window_update_navigation_sensitivity (XnpWindow* self,
                                          gint page_num)
{
	gint n_pages = 0;
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xnp_window_get_n_pages (self);
	_tmp1_ = _tmp0_;
	n_pages = _tmp1_;
	if (n_pages <= 1) {
		XnpTitleBarButton* _tmp2_;
		XnpTitleBarButton* _tmp3_;
		_tmp2_ = self->priv->left_arrow_button;
		xnp_icon_button_set_enabled ((XnpIconButton*) _tmp2_, FALSE);
		_tmp3_ = self->priv->right_arrow_button;
		xnp_icon_button_set_enabled ((XnpIconButton*) _tmp3_, FALSE);
	} else {
		XnpTitleBarButton* _tmp4_;
		XnpTitleBarButton* _tmp5_;
		_tmp4_ = self->priv->left_arrow_button;
		xnp_icon_button_set_enabled ((XnpIconButton*) _tmp4_, page_num > 0);
		_tmp5_ = self->priv->right_arrow_button;
		xnp_icon_button_set_enabled ((XnpIconButton*) _tmp5_, (page_num + 1) < n_pages);
	}
}

/**
 * popup_error:
 *
 * Show a pop-up error message.
 */
void
xnp_window_popup_error (XnpWindow* self,
                        const gchar* message)
{
	GtkMessageDialog* error_dialog = NULL;
	GtkMessageDialog* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", message);
	g_object_ref_sink (_tmp0_);
	error_dialog = _tmp0_;
	gtk_window_set_icon_name ((GtkWindow*) error_dialog, "gtk-dialog-error");
	_tmp1_ = self->priv->_name;
	gtk_window_set_title ((GtkWindow*) error_dialog, _tmp1_);
	gtk_dialog_run ((GtkDialog*) error_dialog);
	xnp_window_dialog_destroy (self, (GtkDialog*) error_dialog);
	_g_object_unref0 (error_dialog);
}

/**
 * dialog_hide:
 *
 * Hide dialog window and stay focused.
 */
void
xnp_window_dialog_hide (XnpWindow* self,
                        GtkDialog* dialog)
{
	XnpApplication* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, FALSE);
	gtk_widget_hide ((GtkWidget*) dialog);
	_tmp0_ = self->priv->app;
	_tmp1_ = xnp_application_get_skip_taskbar_hint (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, _tmp2_);
}

/**
 * dialog_destroy:
 *
 * Destroy dialog window and stay focused.
 */
void
xnp_window_dialog_destroy (XnpWindow* self,
                           GtkDialog* dialog)
{
	XnpApplication* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, FALSE);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_tmp0_ = self->priv->app;
	_tmp1_ = xnp_application_get_skip_taskbar_hint (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, _tmp2_);
}

/**
 * get_note:
 *
 * Get note from page.
 */
static XnpNote*
xnp_window_get_note (XnpWindow* self,
                     gint p)
{
	GtkNotebook* _tmp0_;
	GtkWidget* _tmp1_;
	XnpNote* _tmp2_;
	XnpNote* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_nth_page (_tmp0_, p);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, XNP_TYPE_NOTE, XnpNote));
	result = _tmp2_;
	return result;
}

/**
 * insert_note:
 *
 * Create a new note and insert it inside the notebook after
 * the current position.
 */
XnpNote*
xnp_window_insert_note (XnpWindow* self,
                        const gchar* name)
{
	gchar* note_name = NULL;
	gchar* _tmp0_;
	XnpNote* note = NULL;
	const gchar* _tmp8_;
	XnpNote* _tmp9_;
	XnpNote* _tmp10_;
	XnpNote* _tmp11_;
	XnpNote* _tmp12_;
	GtkEventBox* tab_evbox = NULL;
	GtkEventBox* _tmp13_;
	GtkEventBox* _tmp14_;
	GtkLabel* label = NULL;
	const gchar* _tmp15_;
	GtkLabel* _tmp16_;
	GtkEventBox* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	XnpNote* _tmp20_;
	GtkEventBox* _tmp21_;
	GtkNotebook* _tmp22_;
	XnpNote* _tmp23_;
	GtkEventBox* _tmp24_;
	GtkNotebook* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GtkNotebook* _tmp28_;
	XnpNote* _tmp29_;
	GtkNotebook* _tmp30_;
	XnpNote* _tmp31_;
	XnpNote* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	note_name = _tmp0_;
	if (name == NULL) {
		gint len = 0;
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = xnp_window_get_n_pages (self);
		_tmp2_ = _tmp1_;
		len = _tmp2_;
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gchar* _tmp5_;
					const gchar* _tmp6_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					if (!(i <= (len + 1))) {
						break;
					}
					_tmp5_ = g_strdup_printf (_ ("Note %d"), i);
					_g_free0 (note_name);
					note_name = _tmp5_;
					_tmp6_ = note_name;
					if (!xnp_window_note_name_exists (self, _tmp6_)) {
						break;
					}
				}
			}
		}
	} else {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (name);
		_g_free0 (note_name);
		note_name = _tmp7_;
	}
	_tmp8_ = note_name;
	_tmp9_ = xnp_note_new (_tmp8_);
	g_object_ref_sink (_tmp9_);
	note = _tmp9_;
	_tmp10_ = note;
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_NOTE_INSERTED_SIGNAL], 0, _tmp10_);
	_tmp11_ = note;
	if (!_tmp11_->backed) {
		result = note;
		_g_free0 (note_name);
		return result;
	}
	_tmp12_ = note;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	_tmp13_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp13_);
	tab_evbox = _tmp13_;
	_tmp14_ = tab_evbox;
	gtk_widget_add_events ((GtkWidget*) _tmp14_, (gint) (GDK_POINTER_MOTION_MASK | GDK_SCROLL_MASK));
	_tmp15_ = note_name;
	_tmp16_ = (GtkLabel*) gtk_label_new (_tmp15_);
	g_object_ref_sink (_tmp16_);
	label = _tmp16_;
	_tmp17_ = tab_evbox;
	_tmp18_ = label;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = label;
	gtk_widget_show ((GtkWidget*) _tmp19_);
	_tmp20_ = note;
	_tmp21_ = tab_evbox;
	xnp_window_connect_note_signals (self, _tmp20_, _tmp21_);
	_tmp22_ = self->priv->notebook;
	_tmp23_ = note;
	_tmp24_ = tab_evbox;
	_tmp25_ = self->priv->notebook;
	g_object_get (_tmp25_, "page", &_tmp26_, NULL);
	_tmp27_ = _tmp26_;
	gtk_notebook_insert_page (_tmp22_, (GtkWidget*) _tmp23_, (GtkWidget*) _tmp24_, _tmp27_ + 1);
	_tmp28_ = self->priv->notebook;
	_tmp29_ = note;
	gtk_notebook_set_tab_reorderable (_tmp28_, (GtkWidget*) _tmp29_, TRUE);
	_tmp30_ = self->priv->notebook;
	_tmp31_ = note;
	gtk_notebook_set_tab_detachable (_tmp30_, (GtkWidget*) _tmp31_, TRUE);
	_xnp_window_notebook_update_tabs_angle (self);
	result = note;
	_g_object_unref0 (label);
	_g_object_unref0 (tab_evbox);
	_g_free0 (note_name);
	return result;
}

/**
 * connect_note_signals:
 *
 * Connect note signals.
 */
static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		XnpWindow* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->note);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_xnp_window_note_notify_name_cb_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	xnp_window_note_notify_name_cb ((XnpWindow*) self, _sender, pspec);
}

static void
__lambda6_ (XnpWindow* self,
            XnpNote* note)
{
	g_return_if_fail (note != NULL);
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_SAVE_DATA_SIGNAL], 0, note);
}

static void
___lambda6__xnp_note_save_data (XnpNote* _sender,
                                gpointer self)
{
	__lambda6_ ((XnpWindow*) self, _sender);
}

static gboolean
__lambda7_ (Block6Data* _data6_,
            GdkEventButton* e)
{
	XnpWindow* self;
	gboolean result;
	self = _data6_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	result = xnp_window_tab_evbox_pressed_cb (self, e, _data6_->note);
	return result;
}

static gboolean
___lambda7__gtk_widget_button_press_event (GtkWidget* _sender,
                                           GdkEventButton* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda7_ (self, event);
	return result;
}

void
xnp_window_connect_note_signals (XnpWindow* self,
                                 XnpNote* note,
                                 GtkEventBox* tab_evbox)
{
	Block6Data* _data6_;
	XnpNote* _tmp0_;
	gulong _tmp1_;
	gulong _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note != NULL);
	g_return_if_fail (tab_evbox != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (note);
	_g_object_unref0 (_data6_->note);
	_data6_->note = _tmp0_;
	g_signal_connect_object ((GObject*) _data6_->note, "notify::name", (GCallback) _xnp_window_note_notify_name_cb_g_object_notify, self, 0);
	_tmp1_ = g_signal_connect_object (_data6_->note, "save-data", (GCallback) ___lambda6__xnp_note_save_data, self, 0);
	_data6_->note->save_handler_id = _tmp1_;
	_tmp2_ = g_signal_connect_data ((GtkWidget*) tab_evbox, "button-press-event", (GCallback) ___lambda7__gtk_widget_button_press_event, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_data6_->note->tab_handler_id = _tmp2_;
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

/**
 * disconnect_note_signals:
 *
 * Disconnect note signals.
 */
void
xnp_window_disconnect_note_signals (XnpWindow* self,
                                    XnpNote* note,
                                    GtkEventBox* tab_evbox)
{
	guint _tmp0_;
	GQuark _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note != NULL);
	g_return_if_fail (tab_evbox != NULL);
	g_signal_parse_name ("notify::name", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) note, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _xnp_window_note_notify_name_cb_g_object_notify, self);
	g_signal_handler_disconnect ((GObject*) tab_evbox, note->tab_handler_id);
	g_signal_handler_disconnect ((GObject*) note, note->save_handler_id);
}

/**
 * move_note:
 *
 * Moves the note named @note_name to position @page.
 */
void
xnp_window_move_note (XnpWindow* self,
                      const gchar* note_name,
                      gint page)
{
	gint n_pages = 0;
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note_name != NULL);
	_tmp0_ = xnp_window_get_n_pages (self);
	_tmp1_ = _tmp0_;
	n_pages = _tmp1_;
	{
		gint p = 0;
		p = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				XnpNote* note = NULL;
				XnpNote* _tmp4_;
				XnpNote* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = p;
					p = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(p < n_pages)) {
					break;
				}
				_tmp4_ = xnp_window_get_note (self, p);
				note = _tmp4_;
				_tmp5_ = note;
				_tmp6_ = xnp_note_get_name (_tmp5_);
				_tmp7_ = _tmp6_;
				if (g_strcmp0 (_tmp7_, note_name) == 0) {
					GtkNotebook* _tmp8_;
					XnpNote* _tmp9_;
					_tmp8_ = self->priv->notebook;
					_tmp9_ = note;
					gtk_notebook_reorder_child (_tmp8_, (GtkWidget*) _tmp9_, page);
					xnp_window_update_navigation_sensitivity (self, page);
					_g_object_unref0 (note);
					break;
				}
				_g_object_unref0 (note);
			}
		}
	}
}

/**
 * get_note_names:
 *
 * Returns a string list of the note names in the order they are currently displayed
 * in the notebook.
 */
static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
xnp_window_get_note_names (XnpWindow* self,
                           gint* result_length1)
{
	gchar** note_names = NULL;
	gint note_names_length1;
	gint _note_names_size_;
	gint n_pages = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	note_names = NULL;
	note_names_length1 = 0;
	_note_names_size_ = note_names_length1;
	_tmp0_ = xnp_window_get_n_pages (self);
	_tmp1_ = _tmp0_;
	n_pages = _tmp1_;
	{
		gint p = 0;
		p = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				XnpNote* _tmp4_;
				XnpNote* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = p;
					p = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(p < n_pages)) {
					break;
				}
				_tmp4_ = xnp_window_get_note (self, p);
				_tmp5_ = _tmp4_;
				_tmp6_ = xnp_note_get_name (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strdup (_tmp7_);
				_vala_array_add1 (&note_names, &note_names_length1, &_note_names_size_, _tmp8_);
				_g_object_unref0 (_tmp5_);
			}
		}
	}
	_tmp9_ = note_names;
	_tmp9__length1 = note_names_length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}

/**
 * get_tab_evbox:
 *
 * Get tab event box for note.
 */
GtkEventBox*
xnp_window_get_tab_evbox (XnpWindow* self,
                          XnpNote* note)
{
	GtkNotebook* _tmp0_;
	GtkWidget* _tmp1_;
	GtkEventBox* _tmp2_;
	GtkEventBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (note != NULL, NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_tab_label (_tmp0_, (GtkWidget*) note);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_event_box_get_type ()) ? ((GtkEventBox*) _tmp1_) : NULL);
	result = _tmp2_;
	return result;
}

/**
 * delete_current_note:
 *
 * Delete the current note.
 */
void
xnp_window_delete_current_note (XnpWindow* self)
{
	XnpNote* note = NULL;
	XnpNote* _tmp0_;
	XnpNote* _tmp1_;
	XnpNote* _tmp2_;
	gint page = 0;
	GtkNotebook* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	XnpNote* _tmp6_;
	XnpNote* _tmp9_;
	XnpHypertextView* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	XnpNote* _tmp26_;
	XnpNote* _tmp27_;
	GtkNotebook* _tmp28_;
	GtkNotebook* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	XnpNote* _tmp32_;
	gboolean _tmp33_ = FALSE;
	GtkNotebook* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp42_;
	gint _tmp43_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xnp_window_get_current_note (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	note = _tmp2_;
	_tmp3_ = self->priv->notebook;
	g_object_get (_tmp3_, "page", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	page = _tmp5_;
	_tmp6_ = note;
	if (_tmp6_ == NULL) {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = xnp_window_get_n_pages (self);
		_tmp8_ = _tmp7_;
		if (_tmp8_ == 0) {
			g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "delete");
		}
		_g_object_unref0 (note);
		return;
	}
	_tmp9_ = note;
	_tmp10_ = _tmp9_->text_view;
	_tmp11_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp10_);
	_tmp12_ = _tmp11_;
	if (gtk_text_buffer_get_char_count (_tmp12_) > 0) {
		GtkMessageDialog* dialog = NULL;
		GtkMessageDialog* _tmp13_;
		GtkMessageDialog* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		XnpNote* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		GtkMessageDialog* _tmp23_;
		gint res = 0;
		GtkMessageDialog* _tmp24_;
		GtkMessageDialog* _tmp25_;
		_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "%s", _ ("Are you sure you want to delete this note?"));
		g_object_ref_sink (_tmp13_);
		dialog = _tmp13_;
		_tmp14_ = dialog;
		_tmp15_ = self->priv->_name;
		_tmp16_ = g_strconcat (_tmp15_, " - ", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = note;
		_tmp19_ = xnp_note_get_name (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp17_, _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		gtk_window_set_title ((GtkWindow*) _tmp14_, _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp17_);
		_tmp23_ = dialog;
		gtk_window_set_icon_name ((GtkWindow*) _tmp23_, "gtk-delete");
		_tmp24_ = dialog;
		res = gtk_dialog_run ((GtkDialog*) _tmp24_);
		_tmp25_ = dialog;
		xnp_window_dialog_destroy (self, (GtkDialog*) _tmp25_);
		if (res != ((gint) GTK_RESPONSE_YES)) {
			_g_object_unref0 (dialog);
			_g_object_unref0 (note);
			return;
		}
		_g_object_unref0 (dialog);
	}
	_tmp26_ = note;
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_NOTE_DELETED_SIGNAL], 0, _tmp26_);
	_tmp27_ = note;
	if (_tmp27_->backed) {
		_g_object_unref0 (note);
		return;
	}
	_tmp28_ = self->priv->notebook;
	_tmp29_ = self->priv->notebook;
	g_object_get (_tmp29_, "page", &_tmp30_, NULL);
	_tmp31_ = _tmp30_;
	gtk_notebook_remove_page (_tmp28_, _tmp31_);
	_tmp32_ = note;
	gtk_widget_destroy ((GtkWidget*) _tmp32_);
	_tmp34_ = self->priv->notebook;
	g_object_get (_tmp34_, "page", &_tmp35_, NULL);
	_tmp36_ = _tmp35_;
	if (_tmp36_ > 0) {
		gint _tmp37_;
		gint _tmp38_;
		_tmp37_ = xnp_window_get_n_pages (self);
		_tmp38_ = _tmp37_;
		_tmp33_ = page != _tmp38_;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		GtkNotebook* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		_tmp39_ = self->priv->notebook;
		g_object_get (_tmp39_, "page", &_tmp40_, NULL);
		_tmp41_ = _tmp40_;
		g_object_set (_tmp39_, "page", _tmp41_ - 1, NULL);
	}
	_tmp42_ = xnp_window_get_n_pages (self);
	_tmp43_ = _tmp42_;
	if (_tmp43_ == 0) {
		g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "delete");
	}
	_g_object_unref0 (note);
}

/**
 * rename_current_note:
 *
 * Rename the current note.
 */
void
xnp_window_rename_current_note (XnpWindow* self)
{
	XnpNote* note = NULL;
	XnpNote* _tmp0_;
	XnpNote* _tmp1_;
	XnpNote* _tmp2_;
	XnpNote* _tmp3_;
	GtkDialog* dialog = NULL;
	GtkWidget* _tmp4_;
	GtkDialog* _tmp5_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp10_;
	GtkDialog* _tmp11_;
	GtkDialog* _tmp12_;
	GtkBox* _tmp13_;
	GtkEntry* entry = NULL;
	GtkEntry* _tmp14_;
	GtkEntry* _tmp15_;
	XnpNote* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GtkEntry* _tmp19_;
	GtkBox* _tmp20_;
	GtkEntry* _tmp21_;
	GtkBox* _tmp22_;
	gint res = 0;
	GtkDialog* _tmp23_;
	GtkDialog* _tmp24_;
	gboolean _tmp25_ = FALSE;
	GtkDialog* _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xnp_window_get_current_note (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	note = _tmp2_;
	_tmp3_ = note;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (note);
		return;
	}
	_tmp4_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp5_ = (GtkDialog*) gtk_dialog_new_with_buttons (_ ("Rename note"), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow), GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, "gtk-cancel", GTK_RESPONSE_CANCEL, "gtk-ok", GTK_RESPONSE_OK, NULL);
	g_object_ref_sink (_tmp5_);
	dialog = _tmp5_;
	_tmp6_ = dialog;
	_tmp7_ = gtk_dialog_get_content_area (_tmp6_);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_box_get_type (), GtkBox));
	content_area = _tmp8_;
	_tmp9_ = dialog;
	gtk_dialog_set_default_response (_tmp9_, (gint) GTK_RESPONSE_OK);
	_tmp10_ = dialog;
	gtk_window_set_resizable ((GtkWindow*) _tmp10_, FALSE);
	_tmp11_ = dialog;
	gtk_window_set_icon_name ((GtkWindow*) _tmp11_, "gtk-edit");
	_tmp12_ = dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp12_, (guint) 4);
	_tmp13_ = content_area;
	gtk_container_set_border_width ((GtkContainer*) _tmp13_, (guint) 6);
	_tmp14_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp14_);
	entry = _tmp14_;
	_tmp15_ = entry;
	_tmp16_ = note;
	_tmp17_ = xnp_note_get_name (_tmp16_);
	_tmp18_ = _tmp17_;
	gtk_entry_set_text (_tmp15_, _tmp18_);
	_tmp19_ = entry;
	gtk_entry_set_activates_default (_tmp19_, TRUE);
	_tmp20_ = content_area;
	_tmp21_ = entry;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp22_);
	_tmp23_ = dialog;
	res = gtk_dialog_run (_tmp23_);
	_tmp24_ = dialog;
	xnp_window_dialog_hide (self, _tmp24_);
	if (res == ((gint) GTK_RESPONSE_OK)) {
		GtkEntry* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		XnpNote* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		_tmp26_ = entry;
		_tmp27_ = gtk_entry_get_text (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = note;
		_tmp30_ = xnp_note_get_name (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp25_ = g_strcmp0 (_tmp28_, _tmp31_) != 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gchar* name = NULL;
		GtkEntry* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp32_ = entry;
		_tmp33_ = gtk_entry_get_text (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strdup (_tmp34_);
		name = _tmp35_;
		_tmp36_ = name;
		if (xnp_window_note_name_exists (self, _tmp36_)) {
			GtkMessageDialog* error_dialog = NULL;
			const gchar* _tmp37_;
			GtkMessageDialog* _tmp38_;
			GtkMessageDialog* _tmp39_;
			GtkMessageDialog* _tmp40_;
			GtkMessageDialog* _tmp41_;
			GtkMessageDialog* _tmp42_;
			_tmp37_ = name;
			_tmp38_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _ ("The name %s is already in use"), _tmp37_);
			g_object_ref_sink (_tmp38_);
			error_dialog = _tmp38_;
			_tmp39_ = error_dialog;
			gtk_window_set_icon_name ((GtkWindow*) _tmp39_, "gtk-dialog-error");
			_tmp40_ = error_dialog;
			gtk_window_set_title ((GtkWindow*) _tmp40_, _ ("Error"));
			_tmp41_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp41_);
			_tmp42_ = error_dialog;
			xnp_window_dialog_destroy (self, (GtkDialog*) _tmp42_);
			_g_object_unref0 (error_dialog);
		} else {
			XnpNote* _tmp43_;
			const gchar* _tmp44_;
			_tmp43_ = note;
			_tmp44_ = name;
			g_signal_emit (self, xnp_window_signals[XNP_WINDOW_NOTE_RENAMED_SIGNAL], 0, _tmp43_, _tmp44_);
		}
		_g_free0 (name);
	}
	_tmp45_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp45_);
	_g_object_unref0 (entry);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	_g_object_unref0 (note);
}

/**
 * note_name_exists:
 *
 * Verify if the given name already exists in the notebook.
 */
static gboolean
xnp_window_note_name_exists (XnpWindow* self,
                             const gchar* name)
{
	gint n_pages = 0;
	gint _tmp0_;
	gint _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = xnp_window_get_n_pages (self);
	_tmp1_ = _tmp0_;
	n_pages = _tmp1_;
	{
		gint p = 0;
		p = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				XnpNote* _tmp4_;
				XnpNote* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = p;
					p = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(p < n_pages)) {
					break;
				}
				_tmp4_ = xnp_window_get_note (self, p);
				_tmp5_ = _tmp4_;
				_tmp6_ = xnp_note_get_name (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strcmp0 (_tmp7_, name) == 0;
				_g_object_unref0 (_tmp5_);
				if (_tmp8_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * save_notes:
 *
 * Save notes.
 */
void
xnp_window_save_notes (XnpWindow* self)
{
	gint n_pages = 0;
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xnp_window_get_n_pages (self);
	_tmp1_ = _tmp0_;
	n_pages = _tmp1_;
	{
		gint p = 0;
		p = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				XnpNote* _tmp4_;
				XnpNote* _tmp5_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = p;
					p = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(p < n_pages)) {
					break;
				}
				_tmp4_ = xnp_window_get_note (self, p);
				_tmp5_ = _tmp4_;
				xnp_note_save (_tmp5_);
				_g_object_unref0 (_tmp5_);
			}
		}
	}
}

static void
xnp_window_save_current_note (XnpWindow* self)
{
	XnpNote* note = NULL;
	XnpNote* _tmp0_;
	XnpNote* _tmp1_;
	XnpNote* _tmp2_;
	XnpNote* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xnp_window_get_current_note (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	note = _tmp2_;
	_tmp3_ = note;
	if (_tmp3_ != NULL) {
		XnpNote* _tmp4_;
		_tmp4_ = note;
		xnp_note_save (_tmp4_);
	}
	_g_object_unref0 (note);
}

/**
 * _notebook_update_tabs_angle:
 *
 * Set the angle of each label in the tab.
 */
static void
_xnp_window_notebook_update_tabs_angle (XnpWindow* self)
{
	gint angle = 0;
	gint n_pages = 0;
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	angle = 0;
	if (self->priv->_tabs_position == 2) {
		angle = 270;
	} else {
		if (self->priv->_tabs_position == 4) {
			angle = 90;
		}
	}
	_tmp0_ = xnp_window_get_n_pages (self);
	_tmp1_ = _tmp0_;
	n_pages = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GtkEventBox* tab_evbox = NULL;
				XnpNote* _tmp4_;
				XnpNote* _tmp5_;
				GtkEventBox* _tmp6_;
				GtkEventBox* _tmp7_;
				GtkEventBox* _tmp8_;
				GtkLabel* label = NULL;
				GtkEventBox* _tmp9_;
				GtkWidget* _tmp10_;
				GtkLabel* _tmp11_;
				GtkLabel* _tmp12_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < n_pages)) {
					break;
				}
				_tmp4_ = xnp_window_get_note (self, i);
				_tmp5_ = _tmp4_;
				_tmp6_ = xnp_window_get_tab_evbox (self, _tmp5_);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp5_);
				tab_evbox = _tmp7_;
				_tmp8_ = tab_evbox;
				if (_tmp8_ == NULL) {
					_g_object_unref0 (tab_evbox);
					continue;
				}
				_tmp9_ = tab_evbox;
				_tmp10_ = gtk_bin_get_child ((GtkBin*) _tmp9_);
				_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp10_) : NULL);
				label = _tmp11_;
				_tmp12_ = label;
				if (_tmp12_ != NULL) {
					GtkLabel* _tmp13_;
					_tmp13_ = label;
					gtk_label_set_angle (_tmp13_, (gdouble) angle);
				}
				_g_object_unref0 (label);
				_g_object_unref0 (tab_evbox);
			}
		}
	}
}

const gchar*
xnp_window_get_name (XnpWindow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
xnp_window_set_name (XnpWindow* self,
                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = xnp_window_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_NAME_PROPERTY]);
	}
}

XnpNote*
xnp_window_get_current_note (XnpWindow* self)
{
	XnpNote* result;
	GtkNotebook* _tmp0_;
	GtkNotebook* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkWidget* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = self->priv->notebook;
	g_object_get (_tmp1_, "page", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_notebook_get_nth_page (_tmp0_, _tmp3_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, XNP_TYPE_NOTE, XnpNote);
	return result;
}

gint
xnp_window_get_n_pages (XnpWindow* self)
{
	gint result;
	GtkNotebook* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->notebook;
	result = gtk_notebook_get_n_pages (_tmp0_);
	return result;
}

gboolean
xnp_window_get_empty (XnpWindow* self)
{
	gboolean result;
	gint n_pages = 0;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = xnp_window_get_n_pages (self);
	_tmp1_ = _tmp0_;
	n_pages = _tmp1_;
	if (n_pages == 1) {
		XnpNote* _tmp3_;
		XnpNote* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = xnp_window_get_note (self, 0);
		_tmp4_ = _tmp3_;
		_tmp5_ = xnp_note_get_text (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp2_ = g_strcmp0 (_tmp7_, "") == 0;
		_g_free0 (_tmp7_);
		_g_object_unref0 (_tmp4_);
	} else {
		_tmp2_ = n_pages == 0;
	}
	result = _tmp2_;
	return result;
}

gboolean
xnp_window_get_show_tabs (XnpWindow* self)
{
	gboolean result;
	GtkNotebook* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_show_tabs (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
xnp_window_set_show_tabs (XnpWindow* self,
                          gboolean value)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_set_show_tabs (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_SHOW_TABS_PROPERTY]);
}

gint
xnp_window_get_tabs_position (XnpWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_tabs_position;
	return result;
}

void
xnp_window_set_tabs_position (XnpWindow* self,
                              gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tabs_position = value;
	if (self->priv->_tabs_position == 0) {
		xnp_window_set_show_tabs (self, FALSE);
	} else {
		xnp_window_set_show_tabs (self, TRUE);
		_xnp_window_notebook_update_tabs_angle (self);
		if (self->priv->_tabs_position == 1) {
			GtkNotebook* _tmp0_;
			_tmp0_ = self->priv->notebook;
			gtk_notebook_set_tab_pos (_tmp0_, GTK_POS_TOP);
		} else {
			if (self->priv->_tabs_position == 2) {
				GtkNotebook* _tmp1_;
				_tmp1_ = self->priv->notebook;
				gtk_notebook_set_tab_pos (_tmp1_, GTK_POS_RIGHT);
			} else {
				if (self->priv->_tabs_position == 3) {
					GtkNotebook* _tmp2_;
					_tmp2_ = self->priv->notebook;
					gtk_notebook_set_tab_pos (_tmp2_, GTK_POS_BOTTOM);
				} else {
					if (self->priv->_tabs_position == 4) {
						GtkNotebook* _tmp3_;
						_tmp3_ = self->priv->notebook;
						gtk_notebook_set_tab_pos (_tmp3_, GTK_POS_LEFT);
					} else {
						xnp_window_set_show_tabs (self, FALSE);
						g_warning ("window.vala:134: Bad value for tabs-position");
					}
				}
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_TABS_POSITION_PROPERTY]);
}

gboolean
xnp_window_get_above (XnpWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_above;
	return result;
}

void
xnp_window_set_above (XnpWindow* self,
                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_above = value;
	gtk_window_set_keep_above ((GtkWindow*) self, value);
	g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_ABOVE_PROPERTY]);
}

gboolean
xnp_window_get_sticky (XnpWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_sticky;
	return result;
}

void
xnp_window_set_sticky (XnpWindow* self,
                       gboolean value)
{
	GtkCheckMenuItem* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_sticky = value;
	if (value == TRUE) {
		gtk_window_stick ((GtkWindow*) self);
	} else {
		gtk_window_unstick ((GtkWindow*) self);
	}
	_tmp0_ = self->priv->mi_sticky;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_check_menu_item_get_type ())) {
		GtkCheckMenuItem* _tmp1_;
		_tmp1_ = self->priv->mi_sticky;
		gtk_check_menu_item_set_active (_tmp1_, self->priv->_sticky);
	}
	g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_STICKY_PROPERTY]);
}

gboolean
xnp_window_get_show_refresh_button (XnpWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_refresh_button;
	return result;
}

void
xnp_window_set_show_refresh_button (XnpWindow* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_refresh_button = value;
	if (value == TRUE) {
		XnpTitleBarButton* _tmp0_;
		_tmp0_ = self->priv->refresh_button;
		gtk_widget_show ((GtkWidget*) _tmp0_);
	} else {
		XnpTitleBarButton* _tmp1_;
		_tmp1_ = self->priv->refresh_button;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_SHOW_REFRESH_BUTTON_PROPERTY]);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_BOOLEAN__OBJECT_OBJECT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}

static GObject *
xnp_window_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XnpWindow * self;
	parent_class = G_OBJECT_CLASS (xnp_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_WINDOW, XnpWindow);
	gtk_widget_set_name (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "notes-window");
	gtk_window_set_title ((GtkWindow*) self, _ ("Notes"));
	gtk_window_set_deletable ((GtkWindow*) self, FALSE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	g_object_set ((GtkWindow*) self, "default-height", 380, NULL);
	g_object_set ((GtkWindow*) self, "default-width", 300, NULL);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_window_set_icon_name ((GtkWindow*) self, "org.xfce.notes");
	xnp_window_set_sticky (self, TRUE);
	gtk_widget_set_opacity ((GtkWidget*) self, 0.9);
	return obj;
}

static void
xnp_window_class_init (XnpWindowClass * klass,
                       gpointer klass_data)
{
	xnp_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XnpWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_xnp_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xnp_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_NAME_PROPERTY, xnp_window_properties[XNP_WINDOW_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_CURRENT_NOTE_PROPERTY, xnp_window_properties[XNP_WINDOW_CURRENT_NOTE_PROPERTY] = g_param_spec_object ("current-note", "current-note", "current-note", XNP_TYPE_NOTE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_N_PAGES_PROPERTY, xnp_window_properties[XNP_WINDOW_N_PAGES_PROPERTY] = g_param_spec_int ("n-pages", "n-pages", "n-pages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_EMPTY_PROPERTY, xnp_window_properties[XNP_WINDOW_EMPTY_PROPERTY] = g_param_spec_boolean ("empty", "empty", "empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_SHOW_TABS_PROPERTY, xnp_window_properties[XNP_WINDOW_SHOW_TABS_PROPERTY] = g_param_spec_boolean ("show-tabs", "show-tabs", "show-tabs", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_TABS_POSITION_PROPERTY, xnp_window_properties[XNP_WINDOW_TABS_POSITION_PROPERTY] = g_param_spec_int ("tabs-position", "tabs-position", "tabs-position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_ABOVE_PROPERTY, xnp_window_properties[XNP_WINDOW_ABOVE_PROPERTY] = g_param_spec_boolean ("above", "above", "above", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_STICKY_PROPERTY, xnp_window_properties[XNP_WINDOW_STICKY_PROPERTY] = g_param_spec_boolean ("sticky", "sticky", "sticky", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_SHOW_REFRESH_BUTTON_PROPERTY, xnp_window_properties[XNP_WINDOW_SHOW_REFRESH_BUTTON_PROPERTY] = g_param_spec_boolean ("show-refresh-button", "show-refresh-button", "show-refresh-button", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL] = g_signal_new ("action", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	xnp_window_signals[XNP_WINDOW_SAVE_DATA_SIGNAL] = g_signal_new ("save-data", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	xnp_window_signals[XNP_WINDOW_NOTE_INSERTED_SIGNAL] = g_signal_new ("note-inserted", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	xnp_window_signals[XNP_WINDOW_NOTE_DELETED_SIGNAL] = g_signal_new ("note-deleted", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	xnp_window_signals[XNP_WINDOW_NOTE_RENAMED_SIGNAL] = g_signal_new ("note-renamed", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING, G_TYPE_NONE, 2, XNP_TYPE_NOTE, G_TYPE_STRING);
	xnp_window_signals[XNP_WINDOW_NOTE_MOVED_SIGNAL] = g_signal_new ("note-moved", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__OBJECT_OBJECT, G_TYPE_BOOLEAN, 2, XNP_TYPE_WINDOW, XNP_TYPE_NOTE);
}

static void
xnp_window_instance_init (XnpWindow * self,
                          gpointer klass)
{
	GdkDisplay* _tmp0_;
	GdkCursor* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkCursor* _tmp3_;
	GdkDisplay* _tmp4_;
	GdkCursor* _tmp5_;
	GdkDisplay* _tmp6_;
	GdkCursor* _tmp7_;
	GdkDisplay* _tmp8_;
	GdkCursor* _tmp9_;
	GdkDisplay* _tmp10_;
	GdkCursor* _tmp11_;
	GdkDisplay* _tmp12_;
	GdkCursor* _tmp13_;
	GdkDisplay* _tmp14_;
	GdkCursor* _tmp15_;
	gchar* _tmp16_;
	self->priv = xnp_window_get_instance_private (self);
	self->priv->CORNER_MARGIN = 20;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_cursor_new_for_display (_tmp0_, GDK_TOP_LEFT_CORNER);
	self->priv->CURSOR_TOP_LC = _tmp1_;
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = gdk_cursor_new_for_display (_tmp2_, GDK_TOP_SIDE);
	self->priv->CURSOR_TOP = _tmp3_;
	_tmp4_ = gdk_display_get_default ();
	_tmp5_ = gdk_cursor_new_for_display (_tmp4_, GDK_TOP_RIGHT_CORNER);
	self->priv->CURSOR_TOP_RC = _tmp5_;
	_tmp6_ = gdk_display_get_default ();
	_tmp7_ = gdk_cursor_new_for_display (_tmp6_, GDK_RIGHT_SIDE);
	self->priv->CURSOR_RIGHT = _tmp7_;
	_tmp8_ = gdk_display_get_default ();
	_tmp9_ = gdk_cursor_new_for_display (_tmp8_, GDK_LEFT_SIDE);
	self->priv->CURSOR_LEFT = _tmp9_;
	_tmp10_ = gdk_display_get_default ();
	_tmp11_ = gdk_cursor_new_for_display (_tmp10_, GDK_BOTTOM_RIGHT_CORNER);
	self->priv->CURSOR_BOTTOM_RC = _tmp11_;
	_tmp12_ = gdk_display_get_default ();
	_tmp13_ = gdk_cursor_new_for_display (_tmp12_, GDK_BOTTOM_SIDE);
	self->priv->CURSOR_BOTTOM = _tmp13_;
	_tmp14_ = gdk_display_get_default ();
	_tmp15_ = gdk_cursor_new_for_display (_tmp14_, GDK_BOTTOM_LEFT_CORNER);
	self->priv->CURSOR_BOTTOM_LC = _tmp15_;
	_tmp16_ = g_strdup (_ ("Notes"));
	self->priv->_name = _tmp16_;
}

static void
xnp_window_finalize (GObject * obj)
{
	XnpWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_WINDOW, XnpWindow);
	_g_object_unref0 (self->priv->app);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->mi_above);
	_g_object_unref0 (self->priv->mi_sticky);
	_g_object_unref0 (self->priv->menu_image);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->refresh_button);
	_g_object_unref0 (self->priv->left_arrow_button);
	_g_object_unref0 (self->priv->right_arrow_button);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->content_box);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->ui);
	_g_object_unref0 (self->priv->action_group);
	_g_object_unref0 (self->priv->CURSOR_TOP_LC);
	_g_object_unref0 (self->priv->CURSOR_TOP);
	_g_object_unref0 (self->priv->CURSOR_TOP_RC);
	_g_object_unref0 (self->priv->CURSOR_RIGHT);
	_g_object_unref0 (self->priv->CURSOR_LEFT);
	_g_object_unref0 (self->priv->CURSOR_BOTTOM_RC);
	_g_object_unref0 (self->priv->CURSOR_BOTTOM);
	_g_object_unref0 (self->priv->CURSOR_BOTTOM_LC);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (xnp_window_parent_class)->finalize (obj);
}

static GType
xnp_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnpWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpWindow), 0, (GInstanceInitFunc) xnp_window_instance_init, NULL };
	GType xnp_window_type_id;
	xnp_window_type_id = g_type_register_static (gtk_window_get_type (), "XnpWindow", &g_define_type_info, 0);
	XnpWindow_private_offset = g_type_add_instance_private (xnp_window_type_id, sizeof (XnpWindowPrivate));
	return xnp_window_type_id;
}

GType
xnp_window_get_type (void)
{
	static volatile gsize xnp_window_type_id__once = 0;
	if (g_once_init_enter (&xnp_window_type_id__once)) {
		GType xnp_window_type_id;
		xnp_window_type_id = xnp_window_get_type_once ();
		g_once_init_leave (&xnp_window_type_id__once, xnp_window_type_id);
	}
	return xnp_window_type_id__once;
}

static void
_vala_xnp_window_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	XnpWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_WINDOW, XnpWindow);
	switch (property_id) {
		case XNP_WINDOW_NAME_PROPERTY:
		g_value_set_string (value, xnp_window_get_name (self));
		break;
		case XNP_WINDOW_CURRENT_NOTE_PROPERTY:
		g_value_set_object (value, xnp_window_get_current_note (self));
		break;
		case XNP_WINDOW_N_PAGES_PROPERTY:
		g_value_set_int (value, xnp_window_get_n_pages (self));
		break;
		case XNP_WINDOW_EMPTY_PROPERTY:
		g_value_set_boolean (value, xnp_window_get_empty (self));
		break;
		case XNP_WINDOW_SHOW_TABS_PROPERTY:
		g_value_set_boolean (value, xnp_window_get_show_tabs (self));
		break;
		case XNP_WINDOW_TABS_POSITION_PROPERTY:
		g_value_set_int (value, xnp_window_get_tabs_position (self));
		break;
		case XNP_WINDOW_ABOVE_PROPERTY:
		g_value_set_boolean (value, xnp_window_get_above (self));
		break;
		case XNP_WINDOW_STICKY_PROPERTY:
		g_value_set_boolean (value, xnp_window_get_sticky (self));
		break;
		case XNP_WINDOW_SHOW_REFRESH_BUTTON_PROPERTY:
		g_value_set_boolean (value, xnp_window_get_show_refresh_button (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_xnp_window_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	XnpWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_WINDOW, XnpWindow);
	switch (property_id) {
		case XNP_WINDOW_NAME_PROPERTY:
		xnp_window_set_name (self, g_value_get_string (value));
		break;
		case XNP_WINDOW_SHOW_TABS_PROPERTY:
		xnp_window_set_show_tabs (self, g_value_get_boolean (value));
		break;
		case XNP_WINDOW_TABS_POSITION_PROPERTY:
		xnp_window_set_tabs_position (self, g_value_get_int (value));
		break;
		case XNP_WINDOW_ABOVE_PROPERTY:
		xnp_window_set_above (self, g_value_get_boolean (value));
		break;
		case XNP_WINDOW_STICKY_PROPERTY:
		xnp_window_set_sticky (self, g_value_get_boolean (value));
		break;
		case XNP_WINDOW_SHOW_REFRESH_BUTTON_PROPERTY:
		xnp_window_set_show_refresh_button (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

