/*
 *  Xeukleides  version 1.0.1
 *  Copyright (c) Christian Obrecht 2000-2004
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define EPSILON 1e-8
#define OMEGA 1e8
#define RAD(x) M_PI*(x)/180
#define DEG(x) 180*(x)/M_PI
#define LENG(x,y) sqrt((x)*(x)+(y)*(y))
#define ZERO(x) (((x) < EPSILON) && ((x) > - EPSILON))

int Snd_degree(double*, double*, double, double, double);

double Pow(double, double);

double Sin(double);

double Cos(double);

double Tan(double);

double Asin(double);

double Acos(double);

double Atan(double);

double PP_distance(_point*, _point*);

double PL_distance(_point*, _line*);

double V_length(_vector*);

double S_length(_segment*);

double excentricity(_conic*);

double height(_point*, _point*, _point*);

double angle(double, double);

double V_angle(_vector*);

double S_angle(_segment*);

double Co_angle(_conic*);

double VV_angle(_vector*, _vector*);

double T_angle(_point*, _point*, _point*);

double C_argument(_circle*, _point*);

double Co_argument(_conic*, _point*);

double scalar(_vector*, _vector*);

double eccentricity (_conic*);


void P_assignment(symrec *, _point*);

_point*	P_new(double, double);

_point*	P_polar(double, double);

_point* P_line(_line*, double);

_point* P_segment(_segment*, double);

_point*	P_circle(_circle*, double);

_point*	P_conic(_conic*, double);

_point*	P_translation(_point*, _vector*);

_point*	P_reflection(_point*, _line*);

_point*	P_rotation(_point*, _point*, double);

_point*	P_L_projection(_point*, _line*);

_point*	P_LL_projection(_point*, _line*, _line*);

_point*	P_homothecy(_point*, _point*, double);

_point*	P_2_barycenter(_point*, double, _point*, double);

_point*	P_3_barycenter(_point*, double, _point*, double, _point*, double);

_point*	P_4_barycenter(_point*, double, _point*, double, _point*, double, _point*, double);

_point*	P_LL_intersection(_line*, _line*);

_point*	P_abscissa(_line*, double);

_point*	P_ordinate(_line*, double);

_point*	P_midpoint(_segment*);

_point*	P_begin(_segment*);

_point*	P_end(_segment*);

_point*	P_center(_circle*);

_point*	P_Co_center(_conic*);

_point*	P_orthocenter(_point*, _point*, _point*);


void V_assignment(symrec*, _vector*);

_vector* V_NN_new(double, double);

_vector* V_NA_new(double, double);

_vector* V_PP_new(_point*, _point*);

_vector* V_L_new(_line*);

_vector* V_S_new(_segment*);

_vector* V_rotation(_vector*, double);

_vector* V_add(_vector*, _vector*);

_vector* V_sub(_vector*, _vector*);

_vector* V_mult(double, _vector*);


void L_assignment(symrec*, _line*);

_line* L_PP_new(_point*, _point*);

_line* L_PA_new(_point*, double);

_line* L_PV_new(_point*, _vector*);

_line* L_S_new(_segment*);

_line* L_CA_new(_circle*, double);

_line* L_Co_new(_conic*, double);

_line* L_translation(_line*, _vector*);

_line* L_reflection(_line*, _line*);

_line* L_rotation(_line*, _point*, double);

_line* L_homothecy(_line*, _point*, double);

_line* L_L_parallel(_line*, _point*);

_line* L_S_parallel(_segment*, _point*);

_line* L_L_perpendicular(_line*, _point*);

_line* L_S_perpendicular(_segment*, _point*);

_line* L_S_bisector(_segment*);

_line* L_P_bisector(_point*, _point*, _point*);

_line* L_LL_bisector(_line*, _line*);

_line* L_altitude(_point*, _point*, _point*);

_line* L_median(_point*, _point*, _point*);

_line* L_invert(_line*);


void S_assignment(symrec *, _segment*);

_segment* S_P_new(_point*, _point*);

_segment* S_V_new(_point*, _vector*);

_segment* S_NA_new(_point*, double, double);

_segment* S_CA_new(_circle*, double);

_segment* S_translation(_segment*, _vector*);

_segment* S_reflection(_segment*, _line*);

_segment* S_rotation(_segment*, _point*, double);

_segment* S_homothecy(_segment*, _point*, double);

_segment* S_invert(_segment*);


void C_assignment(symrec *, _circle*);

_circle* C_PP_new(_point*, _point*);

_circle* C_PPP_new(_point*, _point*, _point*);

_circle* C_PN_new(_point*, double);

_circle* C_translation(_circle*, _vector*);

_circle* C_reflection(_circle*, _line*);

_circle* C_rotation(_circle*, _point*, double);

_circle* C_homothecy(_circle*, _point*, double);

_circle* C_incircle(_point*, _point*, _point*);


void Co_assignment(symrec *, _conic*);

_conic* Co_N_new(double, double, double, double, double, int);

_conic* Co_new(_point*, _line*, double);

_conic* Pa_new(_point*, _line*);

_conic* Co_PP_new(_point*, _point*, double);

_conic* Co_translation(_conic*, _vector*);

_conic* Co_reflection(_conic*, _line*);

_conic* Co_rotation(_conic*, _point*, double);

_conic* Co_homothecy(_conic*, _point*, double);


void LC_intersection(symrec *, symrec *, _line*, _circle*);

void CC_intersection(symrec *, symrec *, _circle*, _circle*);

void LCo_intersection(symrec *, symrec *, _line*, _conic*);

void vertices(symrec *, symrec *, _conic*);

void foci(symrec *, symrec *, _conic*);

void T_scalenes(symrec *, symrec *, symrec *, double, double);

void T_3N_triangle(symrec *, symrec *, symrec *, double, double, double, double);

void T_2N_triangle(symrec *, symrec *, symrec *, double, double);

void T_2A_triangle(symrec *, symrec *, symrec *, double, double, double, double);

void T_A_triangle(symrec *, symrec *, symrec *, double, double);

void T_2N_right(symrec *, symrec *, symrec *, double, double, double);

void T_N_right(symrec *, symrec *, symrec *, double);

void T_NA_isosceles(symrec *, symrec *, symrec *, double, double, double);

void T_A_isosceles(symrec *, symrec *, symrec *, double);

void T_2N_isosceles(symrec *, symrec *, symrec *, double, double, double);

void T_N_isosceles(symrec *, symrec *, symrec *, double);

void T_E_equilateral(symrec *, symrec *, symrec *);

void T_equilateral(symrec *, symrec *, symrec *, double, double);

void Q_E_parallelogram(symrec *, symrec *, symrec *, symrec *);

void Q_S_parallelogram(symrec *, symrec *, symrec *, symrec *, double, double);

void Q_parallelogram(symrec *, symrec *, symrec *, symrec *, double, double, double, double);

void Q_V_parallelogram(symrec *, symrec *, symrec *, symrec *, _vector*, _vector*);

void Q_E_rectangle(symrec *, symrec *, symrec *, symrec *);

void Q_S_rectangle(symrec *, symrec *, symrec *, symrec *, double);

void Q_square(symrec *, symrec *, symrec *, symrec *);

void pentagon(symrec *, symrec *, symrec *, symrec *, symrec *, _point*, double, double);

void hexagon(symrec *, symrec *, symrec *, symrec *, symrec *, symrec *, _point*, double, double);

interrec * I_assignment(double, double, double, double, char, int, int);
