#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>

#include "daemon.h"

/* ----------------------------------------------------------- */

char  *pidfile   = NULL;
int   debug      = 0;
int   dontdetach = 0;

static FILE *logfile    = NULL;
static int   have_tty   = 1;

/* ----------------------------------------------------------- */

static void pidfile_cleanup(void)
{
    unlink(pidfile);
}

void daemonize(void)
{
    char mypid[16];
    int detach = 1;
    int pid = 0;

    if (pidfile) {
	if (-1 == (pid = open(pidfile, O_WRONLY | O_CREAT | O_EXCL, 0600))) {
	    fprintf(stderr,"open %s: %s\n",pidfile,strerror(errno));
	    exit(1);
	}
    }

    if (dontdetach)
	detach = 0;
    if (debug && !logfile)
	detach = 0;
    if (detach) {
	/* detach from terminal */
	switch (fork()) {
	case -1:
	    perror("fork");
	    if (pidfile)
		pidfile_cleanup();
	    exit(1);
	case 0:
	    close(0); close(1); close(2);
	    setsid();
	    open("/dev/null",O_RDWR); dup(0); dup(0);
	    have_tty = 0;
	    break;
	default:
	    exit(0);
	}
    }

    if (pidfile) {
	atexit(pidfile_cleanup);
	sprintf(mypid,"%d",getpid());
	write(pid,mypid,strlen(mypid));
	close(pid);
    }
}

/* ----------------------------------------------------------- */

int log_setfile(char *filename)
{
    logfile = fopen(filename, "w");
    if (NULL == logfile)
	fprintf(stderr, "open %s: %s\n", filename, strerror(errno));
    return logfile ? 0 : -1;
}

void log_printf(int msglevel, char *fmt, ...)
{
    va_list args;
    FILE *fp = logfile ? logfile : stderr;

    if (msglevel > debug)
	return;
    if (!logfile && !have_tty)
	return;
    va_start(args, fmt);
    vfprintf(fp, fmt, args);
    fflush(fp);
    va_end(args);
}
