;; debug-toolbar.el --- A toolbar for gdb.

;; Copyright (C) 2002 Steve Youngs

;; RCS: $Id: debug-toolbar.el,v 1.1 2002/04/30 15:27:57 youngs Exp $
;; Author:        Steve Youngs <youngs@xemacs.org>
;; Maintainer:    Steve Youngs <youngs@xemacs.org>
;; Created:       2002-05-01
;; Last-Modified: <2002-05-01 00:33:22 (steve)>
;; Keywords:      toolbar

;; This file is part of XEmacs

;; XEmacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; XEmacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA


;;; Commentary:

;; This was ripped straight out of `sun-eos-toolbar.el'.  I did this
;; so that people using the debug package (gdb, gdbsrc, and friends)
;; wouldn't need to install the Sun package.

;;; Code:

(defvar debug::toolbar-icon-directory
  (file-name-as-directory (locate-data-directory "eos")))

(defvar debug::toolbar-run-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	s FgColor c #000000000000\",
\"X	c #0000FFFF0000\",
\"+	c #000077770000\",
\"@	c #000044440000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                 .......    \",
\"                            \",
\"     .....                  \",
\"     .X+@.       .......    \",
\"     .X+@.                  \",
\"  ......@....               \",
\"   .XXX++++.     .......    \",
\"    .XX++@.                 \",
\"     .@+@.                  \",
\"      .@.        .......    \",
\"       .                    \",
\"                            \",
\"                 .......    \",
\"                            \",
\"                            \",
\"                 .......    \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-run.xbm" debug::toolbar-icon-directory)))
  "A Run icon pair.")

(defvar debug::toolbar-stop-at-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #4B4B4B4B4B4B\",
\"X	c #FFFFFFFFFFFF\",
\"o	c #AFAFAFAFAFAF\",
\"O	c #FFFF00000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"          ........          \",
\"         .XXXXXXXX.         \",
\"        .XoOOOOOOoX.        \",
\"       .XoOOOOOOOOoX.       \",
\"      .XoOOOOOOOOOOoX.      \",
\"     .XoOOOOOOOOOOOOoX.     \",
\"    .XoOOOOOOOOXOOOOOoX.    \",
\"    .XOOOOOOOOOXXOOOOOX.    \",
\"    .XOOOOXXXXXXXXOOOOX.    \",
\"    .XOOOOXXXXXXXXXOOOX.    \",
\"    .XOOOOXXXXXXXXOOOOX.    \",
\"    .XOOOOOOOOOXXOOOOOX.    \",
\"    .XOOOOOOOOOXOOOOOOX.    \",
\"    .XoOOOOOOOOOOOOOOoX.    \",
\"     .XoOOOOOOOOOOOOOX.     \",
\"      .XoOOOOOOOOOOoX.      \",
\"       .XoOOOOOOOOoX.       \",
\"        .XoOOOOOOoX.        \",
\"         .XXXXXXXX.         \",
\"          ........          \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-stop.xbm" debug::toolbar-icon-directory)))
  "A Stop At icon pair.")

(defvar debug::toolbar-clear-at-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #4B4B4B4B4B4B\",
\"X	c #FFFFFFFFFFFF\",
\"o	c #AFAFAFAFAFAF\",
\"O	c #FFFF00000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"          ........          \",
\"         .XXXXXXXX.         \",
\"        .XoOOOOOOoX.        \",
\"       .XoOOOOOOOOoX.       \",
\"      .XoOOOOOOOOOOoX.      \",
\"     .XoOOOOOOOOOOOOoX.     \",
\"    .XoOOOXXOOOOXXOOOoX.    \",
\"    .XOOOOOXXOOXXOOOOOX.    \",
\"    .XOOOOOOXXXXOOOOOOX.    \",
\"    .XOOOOOOOXXOOOOOOOX.    \",
\"    .XOOOOOOXXXXOOOOOOX.    \",
\"    .XOOOOOXXOOXXOOOOOX.    \",
\"    .XOOOOXXOOOOXXOOOOX.    \",
\"    .XoOOOXOOOOOOXOOOoX.    \",
\"     .XoOOOOOOOOOOOOoX.     \",
\"      .XoOOOOOOOOOOoX.      \",
\"       .XoOOOOOOOOoX.       \",
\"        .XoOOOOOOoX.        \",
\"         .XXXXXXXX.         \",
\"          ........          \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-clear-at.xbm" debug::toolbar-icon-directory)))
  "A Clear At icon pair.")

(defvar debug::toolbar-stop-in-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #4B4B4B4B4B4B\",
\"X	c #FFFFFFFFFFFF\",
\"o	c #AFAFAFAFAFAF\",
\"O	c #FFFF00000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"          ........          \",
\"         .XXXXXXXX.         \",
\"        .XoOOOOOOoX.        \",
\"       .XoOOOOOOOOoX.       \",
\"      .XoOOOOOOOOOOoX.      \",
\"     .XoOOOOOOOOOOOOoX.     \",
\"    .XoOOOOOOOOOXOXOOoX.    \",
\"    .XOOOXXXXOOXOOOXOOX.    \",
\"    .XOOOXOOOOOXOOOXOOX.    \",
\"    .XOOOXOOOOOXOOOXOOX.    \",
\"    .XOOOXXXOOXOOOOOXOX.    \",
\"    .XOOOXOOOOOXOOOXOOX.    \",
\"    .XOOOXOOOOOXOOOXOOX.    \",
\"    .XoOOXOOOOOXOOOXOoX.    \",
\"     .XoOOOOOOOOXOXOoX.     \",
\"      .XoOOOOOOOOOOoX.      \",
\"       .XoOOOOOOOOoX.       \",
\"        .XoOOOOOOoX.        \",
\"         .XXXXXXXX.         \",
\"          ........          \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-stop-in.xbm" debug::toolbar-icon-directory)))
    "A Stop in icon pair.")

(defvar debug::toolbar-step-into-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #000000000000\",
\"O	c #0000FFFF0000\",
\"+	c #000077770000\",
\"@	c #000044440000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"      .....   .......       \",
\"     .OOOO.                 \",
\"    .O++++.                 \",
\"    .O+....   ........      \",
\"    .O+.                    \",
\"    .O+. .                  \",
\"    .O+. ..                 \",
\"    .O+. .O.                \",
\"    .O+...O@.    .......    \",
\"    .O++OOO+@.              \",
\"    .O+++++++@.             \",
\"     .++++++@.   .......    \",
\"      ....O@.               \",
\"         .O.                \",
\"         ..      .......    \",
\"         .                  \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-step-into.xbm" debug::toolbar-icon-directory)))
  "A Step Into icon pair.")

(defvar debug::toolbar-step-over-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 5 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #000000000000\",
\"X	c #0000FFFF0000\",
\"+	c #000077770000\",
\"@	c #000044440000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"      .....                 \",
\"     .XXXX.      .......    \",
\"    .X++++.                 \",
\"    .X+....                 \",
\"    .X+.         .......    \",
\"    .X+. .                  \",
\"    .X+. ..                 \",
\"    .X+. .X.     .......    \",
\"    .X+...X@.               \",
\"    .X++XXX+@.              \",
\"    .X+++++++@.  .......    \",
\"     .++++++@.              \",
\"      ....X@.               \",
\"         .X.     .......    \",
\"         ..                 \",
\"         .                  \",
\"                 .......    \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-step-over.xbm" debug::toolbar-icon-directory)))
  "A Step Over icon pair.")

(defvar debug::toolbar-evaluate-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 2 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #000000000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"         ....               \",
\"         .. ..  ......      \",
\"         .. ..  ......      \",
\"         .. ..              \",
\"         .. ..  ......      \",
\"         .. ..  ......      \",
\"         ....               \",
\"         ..                 \",
\"         ..                 \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-evaluate.xbm" debug::toolbar-icon-directory)))
  "A Evaluate icon pair.")

(defvar debug::toolbar-evaluate-star-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 2 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\"X	c #000000000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"     XX XX                  \",
\"      XXX                   \",
\"    XXXXXXX                 \",
\"      XXX   XXXX            \",
\"     XX XX  XX XX XXXXXX    \",
\"            XX XX XXXXXX    \",
\"            XX XX           \",
\"            XX XX XXXXXX    \",
\"            XX XX XXXXXX    \",
\"            XXXX            \",
\"            XX              \",
\"            XX              \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-evaluate-star.xbm" debug::toolbar-icon-directory)))
  "A Evaluate Star icon pair.")

(defvar debug::toolbar-fix-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 8 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #7D7D7D7D7D7D\",
\"X	c #000000000000\",
\"o	c #FFFFFFFF0000\",
\"O	c #FFFF99990000\",
\"+	c #FFFFCCCC3333\",
\"@	c #CCCC9999FFFF\",
\"#	c #99996666CCCC\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"         .XX.               \",
\"         XoOXX.             \",
\"        .Xo+OOXXX.          \",
\"        Xo++++OOOXXX        \",
\"       .Xo+++++++OOOX.      \",
\"       Xo++++++OOOXX.       \",
\"      .Xo++++OOXXX.         \",
\"      Xo++OOOXX.            \",
\"     .XoOOOXXXXXXXXXXXX     \",
\"     XoOXXX@@@@@@@@@@@X     \",
\"     XXX##############X     \",
\"      X@##############X     \",
\"      XXXXXXXXXXXXXXXXX     \",
\"      X@@@@X     X@@@@X     \",
\"      X@###X     X@###X     \",
\"      X@###X     X@###X     \",
\"      X@###X     X@###X     \",
\"      X@###X     X@###X     \",
\"      XXXXXX     XXXXXX     \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-fix.xbm" debug::toolbar-icon-directory)))
  "A Fix icon pair.")

(defvar debug::toolbar-cont-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 6 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #000000000000\",
\"O	c #0000FFFF0000\",
\"+	c #000077770000\",
\"@	c #000044440000\",
\"o	c #FFFF00000000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"      .....   .......       \",
\"     .OOOO.                 \",
\"    .O++++.                 \",
\"    .O+....   ........      \",
\"    .O+.                    \",
\"    .O+. .                  \",
\"    .O+. ..                 \",
\"    .O+. .O.                \",
\"    .O+...O@.     ..        \",
\"    .O++OOO+@.   .oo.       \",
\"    .O+++++++@. .oooo.      \",
\"     .++++++@.  .oooo.      \",
\"      ....O@.    .oo.       \",
\"         .O.      ..        \",
\"         ..                 \",
\"         .                  \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-cont.xbm" debug::toolbar-icon-directory)))
  "A Cont icon pair.")	  
		      

(defvar debug::toolbar-up-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 8 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	s FgColor c #000000000000\",
\"X	c #CCCC9999FFFF\",
\"o	c #99996666CCCC\",
\"O	c #FFFFFFFF0000\",
\"+	c #FFFFCCCC3333\",
\"@	c #0000FFFF0000\",
\"#	c #000077770000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                  .         \",
\"                 ...        \",
\"      ........  .....       \",
\"      .XXXXXX. .......      \",
\"      .Xooooo.   ...        \",
\"      .Xooooo.   ...        \",
\"      .Xooooo.   ...        \",
\"      .Xooooo.   ...        \",
\"      .O+++++.   ...        \",
\"      .O+++++.   ...        \",
\"      .O+++++.              \",
\"      .O+++++.              \",
\"      .O+++++.              \",
\"      .@#####.              \",
\"      .@#####.              \",
\"      .@#####.              \",
\"      .@#####.              \",
\"      .@#####.              \",
\"      ........              \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-up.xbm" debug::toolbar-icon-directory)))
  "A Up icon pair.")

(defvar debug::toolbar-down-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 8 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	s FgColor c #000000000000\",
\"X	c #CCCC9999FFFF\",
\"o	c #99996666CCCC\",
\"O	c #FFFFFFFF0000\",
\"+	c #FFFFCCCC3333\",
\"@	c #0000FFFF0000\",
\"#	c #000077770000\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"      ........              \",
\"      .XXXXXX.              \",
\"      .Xooooo.              \",
\"      .Xooooo.              \",
\"      .Xooooo.              \",
\"      .Xooooo.              \",
\"      .O+++++.    ...       \",
\"      .O+++++.    ...       \",
\"      .O+++++.    ...       \",
\"      .O+++++.    ...       \",
\"      .O+++++.    ...       \",
\"      .@#####.    ...       \",
\"      .@#####.  .......     \",
\"      .@#####.   .....      \",
\"      .@#####.    ...       \",
\"      .@#####.     .        \",
\"      ........              \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-down.xbm" debug::toolbar-icon-directory)))
  "A Down icon pair.")

(defvar debug::toolbar-build-icon
  (if (featurep 'xpm)
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"28 28 8 1\",
\" 	c #C8C8C8C8C8C8 s backgroundToolBarColor\",
\".	c #000000000000\",
\"X	c #CCCC9999FFFF\",
\"o	c #99996666CCCC\",
\"O	c #FFFFFFFF0000\",
\"+	c #FFFFCCCC3333\",
\"@	c #FFFF99990000\",
\"#	c #FFFF66666666\",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                ......      \",
\"                .XXXX.      \",
\"                .Xooo.      \",
\"                .Xooo.      \",
\"                .Xooo.      \",
\"                .Xooo.      \",
\"           .    .Xooo.      \",
\"          .O.   .Xooo.      \",
\"         .O+@.  .Xooo.      \",
\"        .O+++@. .Xooo.      \",
\"       .O+++++@..Xooo.      \",
\"      .O+++++++@.Xooo.      \",
\"     .O+++..............    \",
\"    .O@@@@.            .    \",
\"    ....... ###########.    \",
\"          . ###########.    \",
\"          . ###########.    \",
\"          ..............    \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \",
\"                            \"};")
    (toolbar-make-button-list
     (expand-file-name "eos-build.xbm" debug::toolbar-icon-directory)))
  "A Build icon pair.")

(provide 'debug-toolbar)

;;; debug-toolbar.el ends here

;Local Variables:
;time-stamp-start: "Last-Modified:[ 	]+\\\\?[\"<]+"
;time-stamp-end: "\\\\?[\">]"
;time-stamp-line-limit: 10
;time-stamp-format: "%4y-%02m-%02d %02H:%02M:%02S (%u)"
;End:
