#include "molinfodialog.h"
#include "helpwindow.h"
#include "defs.h"

// defined in main.cpp
extern QString RingDir;

MolInfoDialog::MolInfoDialog(QWidget *parent, QString name):
        QDialog(parent, name, TRUE)
{
  QGridLayout *grid = new QGridLayout(this, 7, 2);
  setCaption( tr("Molecule Info") );
  QPushButton *ok, *dismiss, *help;
  name_label = new QLabel(tr("Name: "), this);
  name_label->setText(tr("Name: "));
  grid->addMultiCellWidget(name_label, 1, 1, 1, 2);
  cas_label = new QLabel(tr("CAS: "), this);
  cas_label->setText(tr("CAS: "));
  grid->addMultiCellWidget(cas_label, 2, 2, 1, 2);
  mw = tr("Molecular weight = ");
  mw_check = new QCheckBox(mw, this);
  grid->addMultiCellWidget(mw_check, 3, 3, 1, 2);
  ef = tr("Formula = ");
  ef_check = new QCheckBox(ef, this);
  grid->addMultiCellWidget(ef_check, 4, 4, 1, 2);
  //ea = tr("Analysis = ");
  //ea_label = new QLabel(ea, this);
  //grid->addMultiCellWidget(ea_label, 5, 5, 1, 2);
  ok = new QPushButton(tr("OK"), this);
  ok->setPalette(QPalette(lightGray));
  connect(ok, SIGNAL(clicked()), SLOT(accept()) );
  grid->addWidget(ok, 7, 1);
  help = new QPushButton(tr("Help"), this);
  help->setPalette(QPalette(lightGray));
  connect(help, SIGNAL(clicked()), SLOT(SendHelp()) );
  grid->addWidget(help, 7, 2);
  dismiss = new QPushButton(tr("Cancel"), this);
  dismiss->setPalette(QPalette(lightGray));
  connect(dismiss, SIGNAL(clicked()), SLOT(reject()) );
  grid->addMultiCellWidget(dismiss, 6, 6, 1, 2);
}

void MolInfoDialog::SendHelp() {
  QString home, topic;
  topic = "molinfo.html";
#ifdef UNIX
  home = RingDir + "doc/" + topic;
#else
  home = RingDir + "doc\\" + topic;
#endif
  HelpWindow *help = new HelpWindow(home, ".", 0, "help viewer");
  help->setCaption(QString(XDC_VERSION) + " - Help viewer");
  help->show();
}
