#ifndef MIDIALOG_H
#define MIDIALOG_H

#include <qdialog.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

class MolInfoDialog:public QDialog {
  Q_OBJECT
public:
  MolInfoDialog(QWidget *parent, QString name);
  bool isMWChecked() { return mw_check->isChecked(); }
  bool isEFChecked() { return ef_check->isChecked(); }
  void setMW(QString s1) { 
    mw_check->setText(s1); 
  }
  void setEF(QString s1) { 
    ef = tr("Formula = ");
    ef += s1;
    ef_check->setText(ef); 
  }
  void setEA(QString s1) { ea_label->setText(s1); }

  public slots:
    void SendHelp();

 private:
  QCheckBox *mw_check, *ef_check, *dg_check;
  QLabel *ea_label;
  QString mw, ea, ef, dg;
};

#endif
