#ifndef socket_h
#define socket_h

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <pthread.h>

#include "globals.h"

#define MAX_SOCKET_BUFFER 50000
#define MAX_SERVER_SIZE 1024

extern pthread_mutex_t gethostbynameMutex;

class Socket {

 public:
  Socket();
  Socket(int fd);
  ~Socket();
  void reset();
  bool bind(int port);
  bool connect(char *host, int port);
  bool listen(int backlog);
  Socket* accept();
  int recvBytes(char *str, int n);
  int sendBytes(char *str, int n);
  
  int sockfd; // socket descriptor
  char *start; // pointer to start of data in the buffer
  int length; // length of the data in bytes

 private:
  char buffer[MAX_SOCKET_BUFFER+1]; // buffer for incoming data

};

#endif socket_h
