/* -*-Mode: C;-*-
 * $Id: xdapply.c 1.2 Tue, 13 Jun 2000 12:19:56 +0400 jmacd $
 *
 * Copyright (C) 1997, 1998, 1999, 2000, Joshua P. MacDonald
 * <jmacd@CS.Berkeley.EDU> and The Regents of the University of
 * California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>
#include <stdlib.h>

#include "xdelta.h"
#include "xdeltapriv.h"

/* This code used to be more general, but implemented a very
 * inefficient algorithm.  It is sufficient (and efficient) for the
 * special case below, though, so I'm leaving it. */
static gboolean
xdp_copy_delta_region    (XdeltaControl     *cont,
			  XdeltaOutStream   *output_stream)
{
  gint i, l = cont->inst_len;
  guint save_written = 0;

  for (i = 0; i < l; i += 1)
    {
      const XdeltaInstruction *inst = cont->inst + i;
      XdeltaSourceInfo* info;

      if (inst->index >= cont->source_info_len)
	{
	  xd_generate_int_event (EC_XdOutOfRangeSourceIndex, inst->index);
	  return FALSE;
	}

      info = cont->source_info[inst->index];

      if (! handle_copy (info->in, output_stream, inst->offset, inst->length))
	return FALSE;

      save_written += inst->length;
    }

  return TRUE;
}

gboolean
xdp_apply_delta (XdeltaControl     *cont,
		 XdeltaOutStream   *res)
{
  if (! xdp_copy_delta_region (cont, res))
    return FALSE;

  if (! handle_close (res))
    return FALSE;

  if (! check_stream_integrity (res, cont->to_md5, cont->to_len))
    {
      int i;

      /* to better report errors, check if the inputs were invalid now
       */
      for (i = 0; i < cont->source_info_len; i += 1)
	{
	  check_stream_integrity (cont->source_info[i]->in,
				  cont->source_info[i]->md5,
				  cont->source_info[i]->len);
	}

      return FALSE;
    }

  return TRUE;
}
