/* -*-Mode: C;-*-
 * $Id: xdeltapriv.h,v 1.10 2001/12/08 03:17:21 jmacd Exp $
 *
 * Copyright (C) 1997, 1998, 1999, 2000, Joshua P. MacDonald
 * <jmacd@CS.Berkeley.EDU> and The Regents of the University of
 * California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _XDELTAPRIV_H_
#define _XDELTAPRIV_H_

#if 0
#define DEBUG_CKSUM_UPDATE
#define DEBUG_MATCH_PRINT
#define DEBUG_CKSUM
#define DEBUG_HASH
#define DEBUG_INST
#define CLOBBER_ALGORITHM_C
#define DEBUG_MD5
#define DEBUG_CONT
#define DEBUG_COPY
#define DEBUG_FIND
#define DEBUG_RSYNC_REQUEST
#define DEBUG_CONT
#define DEBUG_CONT2
#define DEBUG_CHECK_CONTROL
#endif

typedef struct _XdeltaPos         XdeltaPos;
typedef struct _RsyncHash         RsyncHash;

#define XPOS(p) (((p).page * (p).page_size) + (p).off)

struct _XdeltaPos {
  guint page;
  guint page_size;
  guint off;

  const guint8* mem;
  guint mem_page;
  guint mem_rem;
};

struct _XdeltaGenerator
{
  GPtrArray *sources;
  GPtrArray *out_sources;

  const guint32 *table;
  guint          table_size;

  guint          to_output_pos;
  guint          data_output_pos;

  XdeltaOutStream  *data_out;
  XdeltaOutStream  *control_out;

  XdeltaSourceType  src_types[MAX_XDELTA_SOURCES+1];

  XdeltaControl    *control;

  XdeltaSource     *data_source;

#ifdef DEBUG_HASH
  gint hash_conflicts;           /* bucket already used. */
  gint hash_real_conflicts;      /* bucket had different checksum. */
  gint hash_real_real_conflicts; /* bucket had same checksum, different region */
  gint hash_fill;
  gint hash_entries;
#endif
};

struct _XdeltaSource
{
  XdeltaStream    *source_in;
  XdeltaPos        source_pos;

  gint                   ck_count; /* number of elts in cksums. */
  const XdeltaChecksum  *cksums;   /* array of cksums. */

  void* data;
  XdeltaSourceType type;

  gint             source_index;
  guint32          copies;
  gboolean         used;
};

#define CHEW(x) (single_hash[(guint)x])
#define FLIP_FORWARD(p)  if ((p).off == (p).page_size) { (p).page += 1; (p).off = 0; }

extern const guint16 single_hash[256];

void           init_pos               (XdeltaStream* str, XdeltaPos* pos);
gboolean       unmap_page             (XdeltaStream* stream, XdeltaPos* pos);
gboolean       map_page               (XdeltaStream* stream, XdeltaPos* pos);
gboolean       check_stream_integrity (XdeltaStream* str, const guint8* md5, guint len);
XdeltaControl* control_new            (void);

guint          c_hash                 (const XdeltaChecksum* c);

#endif /* _XDELTAPRIV_H_ */
