#!/usr/bin/perl -w
#
# Deprecated. Reason: we don't want to maintain our separate hw-database
#
# Package: Xdebconfigurator
# This script will resolve the X-driver for card-ID (input) from a table
# (pcitable.map) based on kudzu-knoppix (pcitable), discover-data (pci.lst)
# and SaX2 (Identity.map)
#
# This table was made using table_converter.pl and has the syntax of
# kudzu-knoppix
#
# ex: 
# 0x1002  0x0084  "Card:ATI Mach64"       "ATI|Mach64"
# 0x1002  0x0088  "Card:ATI Mach64"       "ATI|Mach64 (SuSE Econ)"
# 0x1002  0x4158  "Server:XFree86(ati)"   "Mach64 68800AX [Mach32]"
# 0x1002  0x4354  "Server:XFree86(ati)"   "Mach64 215CT [Mach64 CT]"
# 0x1002  0x4759  "Server:XFree86(ati)"   "Mach64 3D Rage IIC 3D Rage IIC"

# establish variables
$TABLE_MAP = "/usr/share/xdebconfigurator/pcitable.map";
$driver_info = "unknown";
$LOCK_EX = 2; $LOCK_UN = 8; 

# check argument
if ($#ARGV < 0)
	{
		#print "Syntax: Xdriver2.pl [Card ID]\n";
		die "Syntax: Xdriver2.pl [Card ID]";
	}
elsif ($#ARGV == 0)
	{
		#print "Getting driver for card-ID: $ARGV[0]\n";
		$CARDID = "$ARGV[0]";
	}
# end if

if(!$CARDID =~ /\S{4}/ig)
{
	die "The Card ID is not 4 letter hex. Ex: 474f\n";
}

open (FIL, "<$TABLE_MAP") or die "Uhoh.. can't read from $TABLE_MAP\n";
flock(FIL, $LOCK_EX);
seek(FIL, 0, 0);
SWITCH: {
	while (<FIL>) 
	{
		chop $_;
		
		# 0x1002  0x4759  "Server:XFree86(ati)"   "Mach64 3D Rage IIC 3D Rage IIC"
		if($_ =~ /0x\S{4}\t0x$CARDID\t\"(.+)\"\t\".+\"/)
		{
			$driver_info = $1;
			last SWITCH;
		}
	}
}
flock(FIL, $LOCK_UN);
close (FIL);


# $driver is now either "unknown" or something like "Server:XFree86(ati)"
print "$driver_info\n";
