#!/usr/bin/perl -w
# This script provides the debconf functionality for xdebconfigurator
#

sub usage()
{
    print STDERR << "EOF";
usage: $0 [-h] -s xserver -f dbfile

-h 					: this (help) message
-s xserver 	: xserver to use (xfree86, svga, mach64..)
-f dbfile		: absolute path to dbfile created by xdebconfigurator

example: $0 -s xfree86 -f /usr/share/xdebconfigurator/xdebc.db
EOF
}

use Getopt::Std; # command line options processing
my $opt_string = 'hs:f:';
getopts( "$opt_string", \my %opt ) or usage() and exit;

usage() and exit if $opt{h};
usage() and exit if !$opt{s} or !$opt{f};

die "$opt{f} does not exist" unless -e $opt{f};

my $xserver = $opt{s};
my $xdebc = $opt{f};


use Debian::DebConf::Client::ConfModule ':all';
use DB_File;

# Establish the preliminaries.
my $THIS_PACKAGE="xserver-xfree86";
my $THIS_SERVER="/usr/bin/X11/XFree86";

# get machine architecture
#$ARCH= 'dpkg --print-installation-architecture'; # ex: i386 #uncomment for debconf

my $version=version;
my $capb=capb('backup');
title('X Configuration');

my %xdebc_map = (); # hash to hold debconf Q and A's - imported from DB file





sub set_debconf_ng($)
{
    $xserver = 'xserver-' . $_[0]; # xfree86, svga, ...

    # Load hash from DB
    tie %xdebc_map, "DB_File", $xdebc or die "Failed to open $xdebc:$!\n"; # open database

    # printout DB contents - uncomment for debugging
    #foreach $key (keys %xdebc_map) {
    #	warn "$key => $xdebc_map{$key}\n";
    #}

    # populate debconf
    set('shared/default-x-server', "$xserver"); #select x-server, xserver-xfree86 for version 4
    set('shared/clobber_x-server_symlink', 'true'); #boolean xserver-link already exists..; let's re-link it

    if($xserver !~ /xserver-xfree86/) {
	$xserver = 'shared/xfree86v3'; # does all v3 servers use this? or just svga?
    }
    # do the loop
    # we can probably make this work for version 3 servers by substing xserver-xfree86 with xserver shared/xfree86v3/
    foreach $key (keys %xdebc_map) {
   	set($xserver.'/'.$key, $xdebc_map{$key});
	fset($xserver.'/'.$key, 'true'); # seen
    }

    untie %xdebc_map;
}

set_debconf_ng($xserver);

# Done getting info, now update the db
# Handle xserver 3 versions
# we are moving this to Xdebset.pl
#	$xdebpkg = "xserver-\L$xserver";
#	$xdebpkg =~ s/-xf86_/-/;
#	install_xserver3($xserver);
	# this line is only reached if exec() fails or server is installed
	# set_debconf_v3();

#	$xdebpkg = "xserver-xfree86";
# my $set_ok = set_debconf();
