#include "alternatives.ih"

Alternatives::ViableResult Alternatives::globFrom(string initial)
{
    GlobContext context = {*this};

    if (not d_options.all())
    {
        for 
        (
            auto iters = d_options.ignore();
            auto &line: ranger(iters.first, iters.second)
        )
            addIgnored(line, context.ignore);
    }

    ViableResult (Alternatives::*globFun)(string dir, GlobContext &context) =
        (
            d_options.generalized() and not d_options.traditional() ?
                &Alternatives::generalizedGlob
            :
                &Alternatives::glob
        );

    ViableResult vr = (this->*globFun)(initial, context);

    if (d_addRoot == ALWAYS || (size() == 0 && d_addRoot == IF_EMPTY))
        vr = (this->*globFun)("/", context);

    if (vr == ONLY_CD)
        cout << initial << endl;

    return vr;
}




