 /*
 *  file      : translate.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */
 
 
#ifdef HAVE_CONFIG_H
	#include "../config.h"
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <string.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"



void translate_xcfa (void)
{
	typedef struct {
		gchar	*string;
	} TRANS;
TRANS trans[] = {

{ _("Fichier") },
{ _("Quitter") },
{ _("Outils") },
{ _("Visibilite des champs") },
{ _("Aide") },
{ _("A propos") },
{ _("Lecture") },
{ _(" <b>Choix du peripherique / Lecture du DVD</b> ") },
{ _("<b> Destination des fichiers </b>") },
{ _("<b> Eject </b>") },
{ _("<b> Normaliser </b>") },
{ _("Deplier") },
{ _("Replier") },
{ _("<b> Vers 2CH: Sub / Ambiance </b>") },
{ _("Extraire") },
{ _(" DVD ") },
{ _("Lecture") },
{ _(" <b>Choix du peripherique / Lecture du CD</b> ") },
{ _("<b> Destination des fichiers </b>") },
{ _("<b> Eject </b>") },
{ _("<i>Titre:</i>") },
{ _("<i>Album:</i>") },
{ _("<i>Artiste:</i>") },
{ _(" <i>Annee:</i>") },
{ _(" <i>Genre:</i>") },
{ _(" <i>Piste:</i>") },
{ _(" <i>*.m3u et xspf:</i> ") },
{ _("<i>Commentaire:</i>") },
{ _(" Modification des tags Freedb ") },
{ _("%a [ %a=\"Artist\" ]\n\n%b [ %b=\"Album\" ]\n\n%Tl - Tetsumaki lower\n\nTransforme la chaine en minuscule sauf le premier caractere.\n\nDans le champs 'Titre' depuis [ Modification des tags FreeDB ],\nle ou les caracteres devant etre conserves doivent etre precedes par le caractere  %") },
{ _("<b>%a</b>  -  artiste                                   <b>%b</b>  -  titre de l'album        <b>%c</b>   -  numero de la piste\n<b>%d</b>  -  titre de la chanson                <b>%e</b>  -  annee                     <b>%g</b>   -  genre\n<b>%f</b>   -  creation d'un fichier *.m3u et *.xspf                               <b>%na</b> -  <b>n</b>o <b>a</b>ccent\n<b>%u</b>  -  remplacement de caracteres: <b>%u(AB=C) %u( =_)         %Tl</b>  -  <b>T</b>etsumaki <b>l</b>ower") },
{ _(" Arrangement des titres du CD ") },
{ _("Creation d'un fichier unique au format:  ") },
{ _("     et dont le nom sera:  ") },
{ _("Ecriture du fichier cue") },
{ _("<b> Au moins deux selections colonne Wav </b>") },
{ _("Creation d'un fichier cue\nunique depuis une lecture\ndu cd audio") },
{ _("Creation fichier cue uniquement") },
{ _("<b> Creation Cue cd </b>") },
{ _(" Creation d'un fichier unique ") },
{ _("<b>Gestion des tags, titres et fichiers cue</b>") },
{ _("<b> Normaliser </b>") },
{ _("definit le serveur a contacter pour les recherches titre") },
{ _("Parametres par defaut") },
{ _("<b> Serveur </b>") },
{ _("Extraire") },
{ _(" CD ") },
{ _("<b> Importer </b>") },
{ _("<b> Destination des conversions </b>") },
{ _("<b> Nettoyer </b>") },
{ _("Appliquer les modifications") },
{ _("<b> Normalise: </b>") },
{ _("<b> Choix niveau dBFS: </b>") },
{ _(" Fichiers ") },
{ _("<b>Quantification</b>") },
{ _("<b>Voie</b>") },
{ _("<b> Frequence - Hertz </b>") },
{ _("Appliquer les modifications") },
{ _(" Wav ") },
{ _(" <b> Lame (fichier mp3): </b> ") },
{ _("<b> Oggenc  (fichier ogg): </b> ") },
{ _("Appliquer") },
{ _("Effacer") },
{ _(" Mp3-Ogg ") },
{ _("Titre:") },
{ _("Album:") },
{ _("Artiste:") },
{ _("Commentaire:") },
{ _(" Annee:") },
{ _(" Genre:") },
{ _(" Piste:") },
{ _(" Modif.:") },
{ _("<b>0</b>") },
{ _("Appliquer") },
{ _(" Tags ") },
{ _(" Fichiers ") },
{ _("<b> Importer </b>") },
{ _("<b> Destination des fichiers </b>") },
{ _("Lecture de 5 secondes apres le marqueur de debut") },
{ _("Index de debut") },
{ _("00h00m00s") },
{ _("lecture") },
{ _("Pause") },
{ _("Index de lecture") },
{ _("label") },
{ _("Lecture de 5 secondes avant le marqueur de fin") },
{ _("Index de fin") },
{ _("00h00m00s") },
{ _("Plage") },
{ _("Duree de la plage active") },
{ _("00h00m00s") },
{ _("Suprimer tous les marqueurs pour les remplacer par un marqueur unique") },
{ _("Le fichier CUE sera enregistre vers 'Destination des fichiers'.") },
{ _("Production fichier Cue") },
{ _("Le resultat du Split sera dirige vers 'Destination des fichiers'.") },
{ _("Split") },
{ _(" Split ") },
{ _("Importation du titre du CD.") },
{ _("<b>Titre CD</b>") },
{ _("Choix d'une nouvelle police.") },
{ _("Texte gras.") },
{ _("Texte italique.") },
{ _("Ajouter du texte editable.") },
{ _("<b>Texte</b>") },
{ _("Saisissez ici un critere de recherche d'images.") },
{ _("Importation des images depuis le Web.") },
{ _("<b>Import images web</b>") },
{ _("Supprimer l'image en selection") },
{ _("AJouter de nouvelles images.") },
{ _("Ouvre un fichier") },
{ _("Enregistrer la page au format png.") },
{ _("Sauvegarde le fichier") },
{ _("Diminution de l'echelle.") },
{ _("Reduit l'agrandissement") },
{ _("Echelle a 100%.") },
{ _("Remet l'echelle a 100%") },
{ _("Augmentation de l'echelle.") },
{ _("Augmente l'agrandissement") },
{ _("Echelle compatible avec la taille de la fenetre.") },
{ _("Adapte l'echelle a la taille de la fenetre") },
{ _("Emplacement de sauvegarde des fichiers.") },
{ _("Nom (sans extention)  du fichier a sauvegarder.") },
{ _("label") },
{ _(" Pochette ") },
{ _("Nice") },
{ _(" <b>Priorite systeme</b> ") },
{ _("<i><b>Indiquez</b> ici le dossier sur votre systeme qui servira de lieu\nde stockage provisoire pendant les differentes conversions.</i>\n") },
{ _(" <b>Dossier provisoire des conversions</b> ") },
{ _("button") },
{ _(" <b>Jouer une musique en fin de tache</b> ") },
{ _(" General ") },
{ _("cdparanoia") },
{ _("cdda2wav / icedax") },
{ _("cdparanoia mode expert") },
{ _("<b> Extraction cd-audio avec:  </b>") },
{ _("<b>HomePage</b>") },
{ _("<b>ManPage</b>  ") },
{ _(" <b>Web cdparanoia</b> ") },
{ _("<b>%a</b>  -  artiste                                   <b>%b</b>  -  titre de l'album        <b>%c</b>  -  numero de la piste\n<b>%d</b>  -  titre de la chanson                <b>%e</b>  -  annee                     <b>%g</b>  -  genre") },
{ _(" <b>Dossier de stockage</b> ") },
{ _(" CD  ") },
{ _("ABR / CBR / VBR / VBR-NEW") },
{ _("Debit") },
{ _("Mode") },
{ _(" <b> Lame (fichier mp3): </b> ") },
{ _("Par defaut") },
{ _(" <b>Options LAME</b> ") },
{ _("<b>Site officiel</b>") },
{ _("<b>Wiki mp3</b>   ") },
{ _("<b>Wiki  </b>            ") },
{ _("<b>ManPage</b>     ") },
{ _(" <b>Web Lame</b> ") },
{ _("<b>[</b>") },
{ _("<b>string option interne</b>") },
{ _("<b>]</b>") },
{ _("<b> Options experts, definies par l'utilisateur - lame (wav -> mp3) </b>") },
{ _(" Mp3 ") },
{ _(" Mode") },
{ _(" Mode flux (streaming)") },
{ _(" Debit") },
{ _("<b> Oggenc  (fichier ogg): </b> ") },
{ _("Par defaut") },
{ _(" <b>Options OGGENC</b> ") },
{ _("<b>Wiki</b>             ") },
{ _("<b>ManPage</b>") },
{ _(" <b>Web Oggenc</b> ") },
{ _("<b>[</b>") },
{ _("<b>string option interne</b>") },
{ _("<b>]</b>") },
{ _("<b> Options experts, definies par l'utilisateur - oggenc (wav -> ogg) </b>") },
{ _(" Oggenc ") },
{ _("Taux de compression") },
{ _("<b> Flac  (fichier flac): </b> ") },
{ _("Par defaut") },
{ _(" <b>Options FLAC</b> ") },
{ _("<b>Site officiel</b>") },
{ _("<b>Framasoft</b> ") },
{ _("<b>ManPage</b>   ") },
{ _(" <b>Web Flac</b> ") },
{ _("<b>[</b>") },
{ _("<b>string option interne</b>") },
{ _("<b>]</b>") },
{ _("<b> Options experts, definies par l'utilisateur - flac (wav -> flac) </b>") },
{ _(" Flac ") },
{ _(" Qualite") },
{ _("<b> Mac (fichier ape): </b> ") },
{ _("Par defaut") },
{ _(" <b>Options MAC</b> ") },
{ _("<b>Wiki</b>") },
{ _(" <b>Web Mac</b> ") },
{ _("<b>[</b>") },
{ _("<b>string option interne</b>") },
{ _("<b>]</b>") },
{ _("<b> Options experts, definies par l'utilisateur - mac (wav -> ape) </b>") },
{ _(" Mac ") },
{ _("Compression") },
{ _("Son") },
{ _("Mode hybride") },
{ _("Fichier de correction") },
{ _("Compression maximum") },
{ _("Signature MD5") },
{ _("Extra encode processing") },
{ _("<b> WavPack  (fichier wv): </b> ") },
{ _("Par defaut") },
{ _(" <b>Options WAVPACK</b> ") },
{ _("<b>Wiki</b>         ") },
{ _("<b>ManPage</b>") },
{ _(" <b>Web Wavpack</b> ") },
{ _("<b>[</b>") },
{ _("<b>string option interne</b>") },
{ _("<b>]</b>") },
{ _("<b> Options experts, definies par l'utilisateur - wavpack (wav -> wv) </b>") },
{ _(" Wavpack ") },
{ _("<b> MusePack  (fichier mpc): </b> ") },
{ _("Par defaut") },
{ _(" <b>Options MUSEPACK</b> ") },
{ _("<b>Site officiel</b>") },
{ _("<b>Framasoft</b> ") },
{ _(" <b>Web Musepack</b> ") },
{ _("<b>[</b>") },
{ _("<b>string option interne</b>") },
{ _("<b>]</b>") },
{ _("<b> Options experts, definies par l'utilisateur - musepack (wav -> mpc) </b>") },
{ _(" Musepack ") },
{ _(" Qualite VBR / Debit ABR") },
{ _("  VBR / ABR") },
{ _(" Conteneur") },
{ _("<b> Faac  (fichier .m4a): </b> ") },
{ _("Par defaut") },
{ _(" <b>Options FAAC</b> ") },
{ _("<b>Site officiel</b> ") },
{ _("<b>Web Info</b> ") },
{ _("<b>ManPage</b>") },
{ _(" <b>Web Faac</b> ") },
{ _("<b>[</b>") },
{ _("<b>string option interne</b>") },
{ _("<b>]</b>") },
{ _("<b> Options experts, definies par l'utilisateur - faac (wav -> m4a) </b>") },
{ _(" Faac ") },
{ _(" Stereo:  Qualite en kbit/s") },
{ _(" Mono:    Qualite en kbit/s") },
{ _("<b> AacplusEnc  (fichier .aac): </b> ") },
{ _("Par defaut") },
{ _(" <b>Options AacPlusEnc</b> ") },
{ _("<b>Site officiel</b> ") },
{ _("<b>Web Info</b> ") },
{ _("<b>ManPage</b>") },
{ _(" <b>Web AacPlusEnc</b> ") },
{ _(" AacplusEnc ") },
{ _("Artiste") },
{ _("Titre") },
{ _("Album") },
{ _("Numero") },
{ _("Genre") },
{ _("Annee") },
{ _("Commentaire") },
{ _("<b> Exportation de </b>") },
{ _(" Tags ") },
{ _(" Preferences  ") },
{ _("SCAN") },
{ _("<b> Installation </b>") },
{ _("<b> Votre systeme utilise ... </b>") },
{ _("\n<b><i>Pour installer les programmes externes requis,\nveuillez utiliser l'installateur de votre distribution Gnu/Linux.</i></b>\n") },
{ _("Le programme XCFA_INSTALL_ALL ecrit en Perl vous sera utile en ligne de commande pour une installation des programmes complementaire.") },
{ _("<b> Informations </b>") },
{ _(" Application externes ") },
{ _("<i>parametres:</i>") },
{ _("<b>Navigateur</b>") },
{ _("<i>parametres:</i>") },
{ _("<b>Lecteurs audio</b>") },
{ _(" Navigateurs / Lecteurs audio ") },
{ _(" Applications externes ") },
{ _("Scan en cours ...") },
{ _("<b>Scan du support en cours ...</b>") },
{ _("Detail extraction mode expert") },
{ _("Modification des champs") },
{ _("\n<b>Modification des champs</b>\n") },
{ _("Titre") },
{ _("Play") },
{ _("Temps") },
{ _("Format") },
{ _("Choix") },
{ _("Normalise") },
{ _("Nom") },
{ _("<b> Visibilite </b>") },
{ _("Nom a gauche") },
{ _("Nom au centre") },
{ _("Nom a droite") },
{ _("DVD") },
{ _("Play") },
{ _("Wav") },
{ _("Flac") },
{ _("Ape") },
{ _("Wavpack") },
{ _("Ogg") },
{ _("M4a") },
{ _("Aac") },
{ _("Musepack") },
{ _("Mp3") },
{ _("Num") },
{ _("Time") },
{ _("Normalise") },
{ _("Nom") },
{ _("<b> Visibilite </b>") },
{ _("Nom a gauche") },
{ _("Nom au centre") },
{ _("Nom a droite") },
{ _("CD") },
{ _("Play") },
{ _("Trash") },
{ _("Type") },
{ _("Wav") },
{ _("Flac") },
{ _("Ape") },
{ _("Wavpack") },
{ _("Ogg") },
{ _("M4a") },
{ _("Aac") },
{ _("Musepack") },
{ _("Mp3") },
{ _("Time") },
{ _("Normalise") },
{ _("Replaygain") },
{ _("Nom") },
{ _("<b> Visibilite </b>") },
{ _("Nom a gauche") },
{ _("Nom au centre") },
{ _("Nom a droite") },
{ _("CONVERSIONS") },
{ _("Hertz") },
{ _("New Hertz") },
{ _("Voie") },
{ _("New Voie") },
{ _("Bits") },
{ _("New Bits") },
{ _("Nom") },
{ _("<b> Visibilite </b>") },
{ _("Nom a gauche") },
{ _("Nom au centre") },
{ _("Nom a droite") },
{ _("WAV") },
{ _("Type") },
{ _("Bitrate") },
{ _("New Bitrate") },
{ _("Size") },
{ _("Time") },
{ _("Nom") },
{ _("<b> Visibilite </b>") },
{ _("Nom a gauche") },
{ _("Nom au centre") },
{ _("Nom a droite") },
{ _("MP3-OGG") },
{ _("Type") },
{ _("Time") },
{ _("Nom") },
{ _("<b> Visibilite </b>") },
{ _("Nom a gauche") },
{ _("Nom au centre") },
{ _("Nom a droite") },
{ _("TAGS") },
{ _("Selection globale") },
{ _("Deselection globale") },
{ _("Retour") },
{ _("About X Convert File Audio") },
{ _("<b>Author</b>") },
{ _("<b>Licence</b>") },
{ _(" Informations ") },
{ _(" Machine ") },
{ _("<b>Ingenieurs du son</b>\n") },
{ _("\n<b>Graphisme</b>\n") },
{ _("<b>Traduction Anglaise</b>\n\n\n") },
{ _("\n<b>Traduction Allemande</b>") },
{ _("\n<b>Codeur Xcfa</b>") },
{ _("\n<b>ElementSpeak pour Xcfa</b>  ") },
{ _("\n<b>Codeur pages Web</b>") },
{ _("\n<b>Traduction Italienne</b>") },
{ _("\n\n<b>Pages  a  visiter</b>\n") },
{ _("Linux On The Root") },
{ _("Frugalware") },
{ _("Road2Mayotte") },
{ _("La Linuxerie") },
{ _("Audioptimisation by Dzef") },
{ _("Tuxfamily") },
{ _("Framasoft") },
{ _("Ekd (EnKoDeur-Mixeur)") },
{ _("Bishop's page") },
{ _("Je suis libre") },
{ _("Debian Multimedia") },
{ _("\n<b>Forum</b>\n") },
{ _("XCFA  Vorstellung ") },
{ _("XCFA  LinuxForen.de") },
{ _("Forum Xcfa") },
{ _("\n<b>Documentation</b>\n") },
{ _("Wiki Xcfa par Shankarius") },
{ _("Doc Xcfa par Patachon") },
{ _("Ogg Vorbis explique par Shankarius") },
{ _("La normalisation expliquee par Dzef") },
{ _("Xcfa sur Linux On The Root") },
{ _(" Contributions ") },
{ _(" License ") },
{ _("OK") }

};


	if (*trans [ 0 ] . string);
}











